#now it is implemented the same function at C++ level
proc BackupFileGetProjectNameAndVersion { filebkp } {
    set projectname "UNNAMED"
    set gid_version "" 
    if { [file exists $filebkp] } {
        set fp [open $filebkp r]
        fconfigure $fp -encoding utf-8
        gets $fp projectname
        if {![eof $fp] } {
            gets $fp gid_version
        }
        close $fp
    }
    return [list $projectname $gid_version]
}

#e.g. in our develop environment it could be gid_64.exe or gid_32.exe, not only gid.exe
proc IsGidExe { exefile } {
    set tail_name [string tolower [file rootname [file tail $exefile]]]
    if { $tail_name == "gid" || $tail_name == "gid_64" || $tail_name == "gid_32"  } {
        return 1
    } elseif { $tail_name == "gid_offscreen" || $tail_name == "gid_offscreen_64" || $tail_name == "gid_offscreen_32"  } {
        return 1
    } elseif { ( $tail_name == "run_gid") || ( $tail_name == "run_gid_offscreen")} {
        return 1
    } else {
        return 0        
    }    
}

proc RecoverBackupIfCrash { currentgidtmpdir } {
    #currentgidtmpdir can be for example .../tmp/gid8  or for Linux /tmp/gidULvXf5
    #normalize to compare after with $dir
    set currentgidtmpdir [file normalize $currentgidtmpdir]
    set backupfile ""
    set tmpdir [file dirname $currentgidtmpdir]
    foreach dir [glob -nocomplain [file join $tmpdir gid*]] {
        if { [file isdirectory $dir] && [ file owned $dir] && [file normalize $dir] != $currentgidtmpdir } {
            foreach i [glob -nocomplain [file join $dir backup-*]] {
                if { [regexp {backup-([0-9]+)} $i {} pid] } { 
                    package require gid_cross_platform
                    if { [gid_cross_platform::process_exists $pid] } {
                        set program [gid_cross_platform::get_process_name $pid]
                        if { [IsGidExe $program] } {
                            #is another live-gid backup
                            continue
                        }
                    }
                    set filebackupgeo [file join $i [file root [file tail $i]].geo]
                    if { [file exists $filebackupgeo] && [file size $filebackupgeo] > 155 } {
                        #ignore a backap *.geo without entities (size<=155)
                        set backupfile $i
                        break
                    }                    
                }
            }
        }
    }
    
    set projectname "UNNAMED"
    set recoverbackup 0
    if { $backupfile != "" } {
        set filebkp [file join $backupfile [file root [file tail $backupfile]].bkp]                
        if { [file exists $filebkp] } {
            lassign [BackupFileGetProjectNameAndVersion $filebkp] projectname gid_version
            if { $gid_version != [GiD_Info GiDVersion] } {
                #the backup is of other GiD version, ignore it
                set recoverbackup 0 ;#to no try to read it
                set backupfile "" ;#to not try to delete it
            } else {
                if { $projectname == "UNNAMED" } {
                    #the project is not saved
                    set recoverbackup 1
                } else {
                    set filelastgeo [file join $projectname.gid [file tail $projectname].geo]
                    if { ![file exists $filelastgeo] ||
                        [file mtime $filelastgeo] < [file mtime $filebkp] } {
                        #the backup is more recent that the last saved project
                        set recoverbackup 1
                    }
                }
            }
        }
    }
    
    if { $recoverbackup } {
        set filemtime [clock format [file mtime $backupfile] -format "%d %b %Y %H:%M:%S"]
        set strmes [_ "The program finished abnormally."]
        append strmes " " [_ "Do you want to recover the last backup file (date %s)?" $filemtime]
        set Ret [MessageBoxOptionsButtons [_ "backup recover"] $strmes \
                {0 1} [list [_ "Yes"] [_ "No#C#I don't want to do that"]] question ""]
        if { $Ret == 0 } {
            if { [info exists ::GID_BACKUP_NEW_FAST_FORMAT] && $::GID_BACKUP_NEW_FAST_FORMAT } {
                # new backup format
                GiD_Project backup read  [file rootname $backupfile]
                GiD_Redraw
            } else {
                # normal model format
                GiD_Process escape escape escape escape files read $backupfile escape
                GiD_SetModelName $projectname 
            }
        }
    }
    
    if { $backupfile != "" } {
        if { [catch { file delete -force $backupfile } msg] } {
            WarnWinText [concat [_ "Error deleting file %s" $backupfile]: $msg]
        }
    }
}
