proc GetResultQuality { criteria from to num_divisions } {
    #criteria is a list of result name and component (0 for scalar)
    lassign $criteria result_name result_component
    set result_analysis [GiD_Info postprocess get cur_analysis]
    set result_step [GiD_Info postprocess get cur_step]
    set data [GiD_Result get -ignore_no_result -array [list $result_name $result_analysis $result_step]]
    set values_component [lindex [lindex [lindex $data 3] 1] $result_component]
    set span [expr {$to-$from}]
    if { $span == 0 } {
        #calculate min and max
        set min_value [objarray minimum $values_component]
        set max_value [objarray maximum $values_component]
    } else {
        set min_value $from
        set max_value $to
    }
    set span [expr {$max_value-$min_value}]
    if { $span == 0 } {
        set res [list]
        set num_items [llength $values]
        set v [expr $num_items/$num_divisions]
        for {set i 0} {$i < $num_divisions } {incr i} {
            lappend res $v
        }
        lappend res $min_value $max_value
    } else {
        for {set i 0} {$i < $num_divisions } {incr i} {
            set num_items($i) 0
        }
        set k [expr {$num_divisions/$span}]
        objarray foreach value $values_component {
            if { $value >= $min_value && $value <= $max_value } {
                incr num_items([expr {int(($value-$min_value)*$k)}])
            }
        }
        set res [list]
        for {set i 0} {$i < $num_divisions } {incr i} {
            lappend res $num_items($i)
        }
        lappend res $min_value $max_value
    }
    return $res
}

proc GetSelectionResultQuality { criteria filter_value } {
    lassign $criteria result_name result_component
    set result_analysis [GiD_Info postprocess get cur_analysis]
    set result_step [GiD_Info postprocess get cur_step]
    set data [GiD_Result get -ignore_no_result [list $result_name $result_analysis $result_step]]
    set header [lindex $data 0]
    set over [lindex $header 5] ;# "OnNodes"
    set type [lindex $header 4] ;# "Scalar" "Vector"
    # look for first entry with values:
    # i.e. skip first entries like {ComponentNames ....}
    # because if value == "ComponentNames"
    # the condition $value <= $filter_value is true!
    set ini_values 2
    while { true} {
        set value_entry [lindex $data $ini_values]
        set id_value [lindex $value_entry 0]
        if { ( $id_value != "") && [string is integer $id_value]} {
            set values [lrange $data $ini_values end]
            break
        }
        incr ini_values
    }
    set ids [list]
    foreach item $values {
        lassign $item id value
        set value [lindex $value $result_component]
        if { $value <= $filter_value } {
            lappend ids $id
        }
    }

    if { $over == "OnNodes" } {
        set selection [concat Nodes [GidUtils::CompactNumberList $ids]]
    } else {
        set selection [concat Elements [GidUtils::CompactNumberList $ids]]
    }
    return $selection
}

proc ResultQualitySelectEntities { w x y } {
    upvar #0 [winfo name $w] data
    global ResultQualityPriv

    set c $w.f.c
    set fr $w.f2

    $c delete lineselect
    set from [$fr.f1.e1 get]
    set to [$fr.f1.e2 get]

    set xmax [winfo width $c]
    set ymax [winfo height $c]
    set xm $ResultQualityPriv(xmargin)
    set ym $ResultQualityPriv(ymargin)
    set value [expr ($x-$xm)/($xmax-2.0*$xm)*($to-$from)+$from]
    if { $value < $from } {
        set value $from
        set x [expr ($value-$from)/($to-$from)*($xmax-2.0*$xm)+$xm]
    } elseif { $value > $to } {
        set value $to
        set x [expr ($value-$from)/($to-$from)*($xmax-2.0*$xm)+$xm]
    }
    $c create line $x $ym $x [expr $ymax-$ym] -tags lineselect -fill red

    if { [GiD_Info Project ViewMode] == "GRAPHUSE" } {
        GiD_Process Mescape Results Graphs OptionsGraph ShowGraphs No escape
    }

    set criteria $::ResultQualityPriv(qualitytype)
    set selection [GetSelectionResultQuality $criteria $value]
    # make a redraw before selecting to clean the image and avoid confussion
    GiD_Redraw
    GiD_Process 'SelectEntities {*}$selection
}

proc ResultQualitySendSelectionToNewSetAutomaticName { } {
    set selection [SendSelectionToGetSelection]
    if { [llength $selection] } {
        set name [Sets_GetAutomaticName ""]
        #it doesn't work doing a single GiD_Process, is necessary do it in two steps!!
        GiD_Process MEscape Select {*}$selection escape MoveToNewSet $name escape escape
        GiD_Redraw
    }
}

#name must be a non-existent set (because post don't allow to create a new empty set)
proc ResultQualitySendSelectionToOldSet { name } {
    set selection [SendSelectionToGetSelection]
    if { [llength $selection] } {
        if { ![GetSetExists $name] } {
            WarnWin [_ "Set %s does not exists" $name]
        } else {
            #it doesn't work doing a single GiD_Process, is necessary do it in two steps!!
            GiD_Process MEscape Select {*}$selection escape MoveToOldSet $name escape escape
            GiD_Redraw
        }
    }
}

proc OnChangeQualityResult { w } {
    #reset from and to to have all range
    set fr $w.f2
    $fr.f1.e1 delete 0 end
    $fr.f1.e1 insert end 0.0
    $fr.f1.e2 delete 0 end
    $fr.f1.e2 insert end 0.0

    DrawResultQualityCurrentValues $w
}

proc DrawResultQualityCurrentValues { w } {
    global ResultQualityPriv

    set c $w.f.c
    set fr $w.f2

    set from [$fr.f1.e1 get]
    set to [$fr.f1.e2 get]
    set numdivisions [$fr.f2.e1 get]

    set criteria $::ResultQualityPriv(qualitytype)

    set listb [GetResultQuality $criteria $from $to $numdivisions]

    set from [lindex $listb end-1]
    set to [lindex $listb end]

    $fr.f1.e1 delete 0 end
    $fr.f1.e1 insert end [format "%3.3g" $from]
    $fr.f1.e2 delete 0 end
    $fr.f1.e2 insert end [format "%3.3g" $to]

    set distributiontype $::ResultQualityPriv(distributiontype)

    lassign $criteria result_name result_component
    set result_analysis [GiD_Info postprocess get cur_analysis]
    set result_step [GiD_Info postprocess get cur_step]
    set data [GiD_Result get -info [list $result_name $result_analysis $result_step]]
    set header [lindex $data 0]
    set over [lindex $header 5] ;# "OnNodes"
    set type [lindex $header 4] ;# "Scalar" "Vector"

    set labelx [_ $result_name]
    if { $over == "OnNodes" } {
        set labely [_ "Number of nodes"]
    } else {
        set labely [_ "Number of elements"]
    }

    set margins [MQDrawGraphCanvas $c $from $to $numdivisions $listb $distributiontype $labelx $labely]
    lassign $margins ::ResultQualityPriv(xmargin) ::ResultQualityPriv(ymargin)
}

proc PostResultQuality { { w .gid.resq } } {
    global ResultQualityPriv
    if { [GetCurrentPrePostMode] != "POST" } {
        WarnWin [_ "Result Quality: This function is only valid in postprocess"]
        return 1
    }
    InitWindow2 $w -title [_ "Result distribution"] \
        -geometryvariable PostResultQualityWindowGeom \
        -initcommand PostResultQuality -ontop
    if { ![winfo exists $w] } { return 1 };# windows disabled || UseMoreWindows == 0

    set all_results [GiD_Info postprocess get cur_results_list contour_fill]
    if { ![llength $all_results] } {
        WarnWin [_ "Result Quality: There are no results"]
        DestroyResultQuality $w $w
        destroy $w
        return 1
    }

    ttk::frame $w.buts  -style BottomFrame.TFrame
    ttk::button $w.buts.cn -text [_ "Close"] -style BottomFrame.TButton -command [list destroy $w]

    grid $w.buts.cn -row 1 -column 1 -padx 5 -pady 6

    ttk::frame $w.f
    canvas $w.f.c -background white -relief ridge -borderwidth 2
    grid $w.f.c -sticky nsew

    set fr [ttk::frame $w.f2]
    ttk::frame $fr.f1
    ttk::label $fr.f1.l1 -text [_ "From"]:
    ttk::entry $fr.f1.e1
    $fr.f1.e1 insert end 0.0
    ttk::label $fr.f1.l2 -text [_ "To"]:
    ttk::entry $fr.f1.e2
    $fr.f1.e2 insert end 0.0
    #ttk::label $fr.f1.l3 -text "units"
    grid $fr.f1.l1 $fr.f1.e1 $fr.f1.l2 $fr.f1.e2 -sticky w
    grid configure $fr.f1.e1 $fr.f1.e2 -sticky ew
    grid columnconfigure $fr.f1 "1 3" -weight 1

    ttk::frame $fr.f2
    ttk::label $fr.f2.l1 -text [_ "Num divisions"]:
    ttk::entry $fr.f2.e1
    $fr.f2.e1 insert end 100
    ttk::label $fr.f2.l2 -text [_ "Distribution"]:
    if { ![info exists ::ResultQualityPriv(distributiontype) ] } {
        set ::ResultQualityPriv(distributiontype) Accumulated
    }
    [TTKMB_CreateOrConfigure $fr.f2.m] $fr.f2.m -textvariable ::ResultQualityPriv(distributiontype) \
        -labels [list [_ "Accumulated"] [_  "Frequency"]] \
        -values {Accumulated Frequency}
    grid $fr.f2.l1 $fr.f2.e1 $fr.f2.l2 $fr.f2.m -sticky w
    grid configure $fr.f2.e1 -sticky ew
    grid columnconf $fr.f2 "1 3" -weight 1
    ttk::frame $fr.type
    ttk::label $fr.type.l -anchor w -text [_ "Result"]:

    set values [list]
    set labels [list]
    foreach result_name [GiD_Info postprocess get cur_results_list contour_fill] {
        set result_analysis [GiD_Info postprocess get cur_analysis]
        set result_step [GiD_Info postprocess get cur_step]
        set full_result [list $result_name $result_analysis $result_step]
        if { ![GiD_Result exists $full_result] } {
            #not all results are defined for all steps
            continue
        }
        set data [GiD_Result get -info $full_result]
        set header [lindex $data 0]
        set over [lindex $header 5] ;# "OnNodes"
        set type [lindex $header 4] ;# "Scalar" "Vector"
        if { $type == "Scalar" } {
            lappend values [list $result_name 0]
            lappend labels [_ $result_name]
        } elseif { $type == "Vector" } {
            foreach axe {x y z} i {0 1 2} {
                lappend values [list $result_name $i]
                lappend labels [_ $result_name]-$axe
            }
            lappend values [list $result_name 3]
            lappend labels |[_ $result_name]|
        } elseif { $type == "Matrix" } {
            foreach axe {xx yy zz xy yz xz} i {0 1 2 3 4 5} {
                lappend values [list $result_name $i]
                lappend labels [_ $result_name]-$axe
            }
        } else {
            lappend values [list $result_name 0]
            lappend labels [_ $result_name]
        }
    }

    set ::ResultQualityPriv(qualitytype) [lindex $values 0]

    [TTKMB_CreateOrConfigure $fr.type.m] $fr.type.m -textvariable ::ResultQualityPriv(qualitytype) \
        -labels $labels -values $values
    if { [GiD_Info postprocess get cur_result] != "" } {
        set ::ResultQualityPriv(qualitytype) [list [GiD_Info postprocess get cur_result] 0]
    }

    ttk::menubutton $fr.send_to -text [_ "Send to"] -underline 0 -menu $fr.send_to.menu
    menu $fr.send_to.menu -borderwidth 1 -activeborderwidth 1
    FillMenuWithSets $fr.send_to.menu

    grid $fr.type.l $fr.type.m
    grid $fr.f1 -sticky ew
    grid $fr.f2 -sticky ew
    grid $fr.type -sticky w
    grid $fr.send_to -row 2 -sticky e ;#same row and col as $fr.type
    grid columnconfigure $fr 0 -weight 1
    grid rowconfigure $fr 0 -weight 1

    bind $fr.f1.e1 <Return> [list DrawResultQualityCurrentValues $w]
    bind $fr.f1.e2 <Return> [list DrawResultQualityCurrentValues $w]
    bind $fr.f2.e1 <Return> [list DrawResultQualityCurrentValues $w]
    bind $w.f.c <Double-Button-1> [list ResultQualitySelectEntities $w %x %y]
    bind $w.f.c <Configure> [list DrawResultQualityCurrentValues $w]
    bind $fr.send_to <Button-1> [list FillMenuWithSets $fr.send_to.menu]

    grid $w.f -sticky nsew
    grid $fr -sticky sew

    grid $w.buts -sticky ews -columnspan 7
    grid anchor $w.buts center
    grid rowconfigure $w.f 0 -weight 1
    grid columnconfigure $w.f 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 0 -weight 1

    bind $w <Destroy> [list +DestroyResultQuality %W $w]

    trace add variable ResultQualityPriv(qualitytype) write "OnChangeQualityResult $w ;#"
    trace add variable ResultQualityPriv(distributiontype) write "DrawResultQualityCurrentValues $w ;#"
    focus $w
}

proc FillMenuWithSets { m } {
    $m delete 0 end
    #global GidPriv
    #set ::GidPriv(LayersAlsoLower) [GiD_Set LayersAlsoLower]
    #set ::GidPriv(LayersAlsoHigher) [GiD_Set LayersAlsoHigher]
    #$m add checkbutton -label [_ "Also lower entities"] -variable ::GidPriv(LayersAlsoLower) -command {GiD_Set LayersAlsoLower $::GidPriv(LayersAlsoLower)}
    #$m add checkbutton -label [_ "Also higher entities"] -variable GidPriv(LayersAlsoHigher) -command {GiD_Set LayersAlsoHigher $::GidPriv(LayersAlsoHigher)}
    $m add command -label [_ "New set"] -command [list ResultQualitySendSelectionToNewSetAutomaticName]
    set names [Sets_GetList]
    if { [llength $names] } {
        $m add separator
        foreach name $names {
            $m add command -label $name -command [list ResultQualitySendSelectionToOldSet $name]
        }
    }
}

proc DestroyResultQuality { W w } {
    global ResultQualityPriv
    if { $W != $w } return
    trace remove variable ResultQualityPriv(qualitytype) write "OnChangeQualityResult $w ;#"
    trace remove variable ResultQualityPriv(distributiontype) write "DrawResultQualityCurrentValues $w ;#"
}
