#argument is one of the files inside tmp directory
proc DeleteOldFiles { tmpdir } {    
    set tmpdir [file dirname $tmpdir]    
    set NumOfDays 7    
    set oldtime [expr [clock seconds]-$NumOfDays*86400]    
    set filelist [list]
	foreach i [glob -nocomplain -directory $tmpdir -types d gid*] {
        if { [file owned $i] && [file exists [file join $i tmp-gidOutput]] && [file mtime $i]<$oldtime } {
            lappend filelist $i
        }
    }            
    #delete old temporary gid directories without ask to user   
	foreach i $filelist {
        if { [catch { file delete -force $i } msg] } {
            WarnWinText [_ "Error deleting file: %s" $msg]
        }
    }
}
