# interface generated by SpecTcl version 1.0 from /usr/people/ramsan/tmp/CopyMain.ui
#   root     is the parent window for this user interface

proc CopyMain_ui {root sc args} {
    global CopyMoveInfo GidPriv
    # this treats "." as a special case    
    if { [catch { set whatuse [GiD_Info Project ViewMode] }] } {
        set whatuse GEOMETRYUSE
    }
    if {$root == "."} {
        set base ""
    } else {
        set base $root
    }
    ttk::frame $base.frame#1 \
        -borderwidth 0 \
        -style sunken.TFrame

    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
        label $base.label#1 -text [_ "Entities type"]:
        GidHelp $base.label#1 [_ "Type of source entities to be selected"]  
        # ComboBoxGiD $base.menubutton#1 -width 10
        TTKMenubutton $base.menubutton#1 -width 10
        
        label $base.label#2 -text [_ "Transformation"]:
        GidHelp $base.label#2 [_ "Transformation to apply to the selection"]  
        # ComboBoxGiD $base.menubutton#2 -width 10
        TTKMenubutton $base.menubutton#2 -width 10
    } else {
        label $base.label#1 -text [_ "Transformation type"]:
        GidHelp $base.label#1 [_ "Transformation to apply to the selection"]  
        # ComboBoxGiD $base.menubutton#2 -width 12
        TTKMenubutton $base.menubutton#2 -width 12
    }
  
    set canvas [ CreateScrolledCanvas $sc]
     
    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
        if { ![info exists GidPriv(DuplicateEntities)] } { set GidPriv(DuplicateEntities) 0 }
        ttk::checkbutton $base.checkbutton#1 \
            -text [_ "Collapse"] \
            -variable GidPriv(DuplicateEntities) -onvalue 0 -offvalue 1
        GidHelp $base.checkbutton#1 [_ "If selected the transformed entities will be locally collapsed with other close entities"]
        
        label $base.doextrudel -text [_ "Do extrude"]:
        GidHelp $base.doextrudel  [_ "To create extra entities by extrussion along the transformation"]
        # ComboBoxGiD $base.doextrude -width 9
        TTKMenubutton $base.doextrude -width 9
    } else {
        #label $base.duplicatel -text [_ "Transformation"]
        ttk::radiobutton $base.checkbutton#1 \
            -text [_ "View"] \
            -variable GidPriv(PostDuplicateEntities) -value 0
        GidHelp $base.checkbutton#1 [_ "The defined transformation is only graphically applied at what is being drawn, as it is.\n No meshes or results are created. Visualization may be not accurate,\n for instance, vector components will not change their sign when doing a c.fill."]
        
        ttk::radiobutton $base.checkbutton#11 \
            -text [_ "Create"] \
            -variable GidPriv(PostDuplicateEntities) -value 1

        GidHelp $base.checkbutton#11 [_ "Creates new meshes and results by applying the defined transformation.\n Vector and tensors will change orientation, and their components may change their sign."]
    }

    if { ![info exists GidPriv(CopyMoveCreateContacts)] } { set GidPriv(CopyMoveCreateContacts) 0 }
    ttk::checkbutton $base.createcontact \
        -text [_ "Create contacts"] \
        -variable GidPriv(CopyMoveCreateContacts)
    GidHelp $base.createcontact [_ "If set create special geometry contact entities between entities"]

    if { ![info exists GidPriv(CopyMoveMaintainLayers)] } { set GidPriv(CopyMoveMaintainLayers) 0 }
    ttk::checkbutton $base.maintainlayers \
        -text [_ "Maintain layers"] \
        -variable GidPriv(CopyMoveMaintainLayers)
    GidHelp $base.maintainlayers [_ "To have the new entities in the same layer as its source (else new entities will be created in the current 'layer to use')"]

    ttk::label $base.label#3 -text [_ "Multiple copies"]:
    GidHelp $base.label#3 [_ "To repeat the same transformation several times"]

    ttk::entry $base.mcopy \
        -textvariable GidPriv(CopyMoveMCopies) \
        -width 7

    if { ( $whatuse != "GEOMETRYUSE") && ( $whatuse != "MESHUSE") } {
        ttk::frame $base.fopt -style ridge.TFrame -borderwidth 2
        
        
        # label $base.doextrudel -text [_ "Transform"]
        ttk::checkbutton $base.doextrudel -text [_ "Show transformation"]
        
        # label $base.doextrudel -text [_ "Transform"]
        ttk::checkbutton $base.doshoworiginal -text [_ "Show original"]
        
        #menubutton $base.doextrude -disabledforeground grey60 -text menubutton -width 5
        # ComboBoxGiD $base.doextrude -width 9
        TTKMenubutton $base.doextrude -width 9

        ttk::button $base.fopt.bdellast -text [_ "Undo"] -command {
            GiD_Process Utilities Transformation DelLastTransf
        }
        
        ttk::button $base.fopt.bclearall -text [_ "Clear"] -command {
            GiD_Process Utilities Transformation ClearTransfs
        }
        
        grid $base.doextrudel -in $base.fopt -row 0 -column 0  \
            -sticky w -pady 1 -padx 0 -ipady 1
        grid $base.doshoworiginal -in $base.fopt -row 0 -column 1  \
            -sticky w -pady 1 -padx 0 -ipady 1
        grid $base.doextrude -in $base.fopt -row 1 -column 0  \
            -sticky e -pady 1 -padx 0 -ipady 1
        
        grid $base.fopt.bdellast $base.fopt.bclearall \
            -pady 1 -ipady 1 -padx 2 -ipadx 2
        
        grid rowconfigure $base.fopt 0 -weight 1
        grid rowconfigure $base.fopt 1 -weight 1
        grid columnconfigure $base.fopt 0 -weight 1
        grid columnconfigure $base.fopt 1 -weight 1
        
    }
    # Geometry management

    grid $base.frame#1 -in $root        -row 3 -column 1  \
        -columnspan 2 \
        -sticky nesw -padx 0 -pady 1 -ipady 1


    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
        grid $base.label#1 -in $root        -row 1 -column 1  \
            -sticky e -pady 1 -padx 2 -ipady 1
        grid $base.menubutton#1 -in $root        -row 1 -column 2  \
            -sticky w -pady 1 -padx 2 -ipady 1
        grid $base.label#2 -in $root        -row 2 -column 1  \
            -sticky e -pady 1 -padx 2 -ipady 1
        grid $base.menubutton#2 -in $root        -row 2 -column 2  \
            -sticky w -pady 1 -padx 2 -ipady 1
    } else {
        grid $base.label#1 -in $root        -row 1 -column 1  \
            -columnspan 2  -pady 1 -padx 2 -ipady 1 -sticky w
        grid $base.menubutton#2 -in $root        -row 1 -column 2  \
            -columnspan 2 -pady 1 -padx 2 -ipady 1
    }
    
    grid $sc -in $base.frame#1        -row 1 -column 1  -columnspan 2 -rowspan 2\
        -sticky nesw -pady 0 -padx 0 -ipady 0 -ipadx 0
   
    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
        grid $base.checkbutton#1 -in $root        -row 4 -column 1  \
            -columnspan 2 \
            -sticky w -pady 1 -padx 2 -ipady 1
        grid $base.doextrudel -in $root        -row 5 -column 1  \
            -sticky e -pady 1 -padx 2 -ipady 1
        grid $base.doextrude -in $root        -row 5 -column 2  \
            -sticky w -pady 1 -padx 2 -ipady 1
        grid $base.createcontact -in $root        -row 6 -column 1  \
            -columnspan 2 \
            -sticky w -pady 1 -padx 2 -ipady 1
        grid $base.maintainlayers -in $root        -row 7 -column 1  \
            -columnspan 2 \
            -sticky w -pady 1 -padx 2 -ipady 1
        grid $base.label#3 -in $root        -row 8 -column 1  \
            -sticky e -pady 1 -padx 2 -ipady 1
        grid $base.mcopy -in $root        -row 8 -column 2  \
            -sticky w -pady 1 -padx 2 -ipady 1
    } else {
        $base.label#3 configure -text [_ "Copies"]:
        grid $base.label#3 -in $root        -row 4 -column 1  \
            -sticky e -pady 1 -padx 2 -ipady 1
        grid $base.mcopy -in $root        -row 4 -column 2  \
            -sticky w -pady 1 -padx 2 -ipady 1
        
        grid $base.checkbutton#1 -in $root -row 5 -column 1  \
            -sticky we -pady 0 -padx 0 -ipady 0
        grid $base.checkbutton#11 -in $root -row 5 -column 2  \
            -sticky we -pady 0 -padx 0 -ipady 0
        
        grid $base.fopt -in $root        -row 6 -column 1  \
            -columnspan 2 -rowspan 2 \
            -sticky we -pady 1 -padx 2 -ipady 0
    }
    # Resize behavior management

    grid rowconfigure $root 1 -weight 0 -minsize 30
    grid rowconfigure $root 2 -weight 0 -minsize 30
    grid rowconfigure $root 3 -weight 1 -minsize 156
    grid rowconfigure $root 4 -weight 0 -minsize 30
    grid rowconfigure $root 5 -weight 0 -minsize 30
    grid rowconfigure $root 6 -weight 0 -minsize 30
    grid rowconfigure $root 7 -weight 0 -minsize 30
    grid rowconfigure $root 8 -weight 0 -minsize 30
    grid columnconfigure $root 1 -weight 1 -minsize 30
    grid columnconfigure $root 2 -weight 1 -minsize 30

    grid rowconfigure $base.frame#1 1 -weight 1 -minsize 30
    grid rowconfigure $base.frame#1 2 -weight 0
    grid columnconfigure $base.frame#1 1 -weight 1 -minsize 118
    grid columnconfigure $base.frame#1 2 -weight 0
    # additional interface code

    switch $whatuse {
        "GEOMETRYUSE" {                  
            [TTKMB_CreateOrConfigure $base.menubutton#1] $base.menubutton#1 -textvariable ::CopyMoveInfo(EntitiesType) \
                -labels [GetGeometryLabels 1] -values [GetGeometryCommands 1]
            
            set ::CopyMoveInfo(EntitiesType) Points
        }
        "MESHUSE" {                      
            [TTKMB_CreateOrConfigure $base.menubutton#1] $base.menubutton#1 -textvariable ::CopyMoveInfo(EntitiesType) \
                -labels [GetMeshLabels 1] -values [GetMeshCommands 1]        
              set ::CopyMoveInfo(EntitiesType) Nodes
        }
        default {           
            [TTKMB_CreateOrConfigure $base.menubutton#1] $base.menubutton#1 -textvariable ::CopyMoveInfo(EntitiesType) \
                -labels [list [_ "All"]] -values {All}
              set ::CopyMoveInfo(EntitiesType) All
        }
    }


    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
        if { ( $whatuse == "MESHUSE") || ( $CopyMoveInfo(what)!= "Copy") } {           
            [TTKMB_CreateOrConfigure $base.menubutton#2]  $base.menubutton#2 -textvariable ::CopyMoveInfo(Transformation) \
                -labels [list [_ "Translation"] [_ "Rotation"] [_ "Mirror"] \
                     [_ "Scale"] [_ "Offset"] [_ "Align"]] \
                -values {Translation Rotation Mirror Scale Offset Align}
              set ::CopyMoveInfo(Transformation) Translation
        } else {           
            [TTKMB_CreateOrConfigure $base.menubutton#2] $base.menubutton#2 -textvariable ::CopyMoveInfo(Transformation) \
                -labels [list [_ "Translation"] [_ "Rotation"] [_ "Mirror"] [_ "Scale"] \
                     [_ "Offset"] [_ "Sweep"] [_ "Align"]] \
                -values {Translation Rotation Mirror Scale Offset Sweep Align}
              set ::CopyMoveInfo(Transformation) Translation
        }
    } else {
        [TTKMB_CreateOrConfigure $base.menubutton#2] $base.menubutton#2 -textvariable ::CopyMoveInfo(Transformation) \
            -labels [list [_ "Translation"] [_ "Rotation"] [_ "Mirror"] [_ "Scale"] ] \
            -values {Translation Rotation Mirror Scale}
              set ::CopyMoveInfo(Transformation) Translation
    }


    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
        if { $::GidPriv(HideSurfaceLevel) } {
            [TTKMB_CreateOrConfigure $base.doextrude] $base.doextrude -textvariable ::GidPriv(CopyMoveDoExtrude) \
                    -labels [list [_ "No#C#Nothing, None"] [_ "Lines"]] \
                -values {No Lines}
        } else {
            if { $::GidPriv(HideVolumeLevel) } {           
                [TTKMB_CreateOrConfigure $base.doextrude] $base.doextrude -textvariable ::GidPriv(CopyMoveDoExtrude) \
                    -labels [list [_ "No#C#Nothing, None"] [_ "Lines"] [_ "Surfaces"]] \
                    -values {No Lines Surfaces}
            } else {         
                [TTKMB_CreateOrConfigure $base.doextrude] $base.doextrude -textvariable ::GidPriv(CopyMoveDoExtrude) \
                    -labels [list [_ "No#C#Nothing, None"] [_ "Lines"] [_ "Surfaces"] [_ "Volumes"]] \
                    -values {No Lines Surfaces Volumes}
            }
        }
        set ::GidPriv(CopyMoveDoExtrude) No
    } else {
        [TTKMB_CreateOrConfigure $base.doextrude] $base.doextrude -textvariable ::GidPriv(CopyMoveDoExtrude) \
            -labels [list [_ "Show"] [_ "Hide"]] \
            -values {Show Hide}
        set ::GidPriv(CopyMoveDoExtrude) Show
    }

    return $canvas
    # end additional interface code

}


