*realformat "%g"
*intformat "%8i"
Input Data file generated by GiD (www.gidhome.com) for Frame3DD - 3D structural frame analysis (*tcl(GiD_Info unitssystems prbsys))

*npoin # number of nodes
#.node       X-coord  Y-coord  Z-coord  radius 
#                *Units(LENGTH)       *Units(LENGTH)       *Units(LENGTH)      *Units(LENGTH)
*loop nodes
*nodesnum *nodescoord(1) *nodescoord(2) *nodescoord(3) 0.0
*end nodes

*set cond point_Constraint
*condnumentities  # number of nodes with reactions
#.node    X      Y      Z       XX      YY      ZZ       0:free, 1:fixed
*loop nodes *onlyincond
*nodesnum  *cond(Fixed_translation_x) *cond(Fixed_translation_y) *cond(Fixed_translation_z) *cond(Fixed_rotation_x) *cond(Fixed_rotation_y) *cond(Fixed_rotation_z)
*end nodes

*set cond Section_properties
*condnumentities # number of frame elements 
#.elmnt n1     n2    Ax     Asy     Asz     Jx     Iy     Iz     E     G     roll  density
#       .      .     *Units(LENGTH)^2   *Units(LENGTH)^2    *Units(LENGTH)^4   *Units(LENGTH)^4   *Units(LENGTH)^4   *Units(PRESSURE)   *Units(PRESSURE)   *Units(TEMPERATURE)   *Units(MASS)/*Units(LENGTH)^3
*loop elems *onlyincond
*elemsnum *elemsconec(1) *elemsconec(2) *cond(Ax) *cond(Asy) *cond(Asz) *cond(Jx) *cond(Iy) *cond(Iz) *tcl(Frame3DD::GetMaterialProperties *cond(Material))
*end elems

*gendata(Shear_deformation_effects) # 1=Do, 0=Don't include shear deformation effects
*gendata(Geometric_stiffness_effects) # 1=Do, 0=Don't include geometric stiffness effects
1.0
1.0
*tcl(Frame3DD::GetDxFromNumDivisions *gendata(Spans_internal_forces)) # Dx length of x-axis increment for frame element internal force data, *Units(LENGTH)
	     # if dx is -1 then internal force calculations are skipped

*nintervals # number of static load cases,  1..30
*loop intervals
# Begin Static Load Case *loopvar

# gravitational acceleration for self-weight loading, *Units(LENGTH)/s^2 (global)
#   gX         gY         gZ
#   *Units(LENGTH)/s^2     *Units(LENGTH)/s^2     *Units(LENGTH)/s^2
*if(intvdata(Gravity_load,int))
*if(strcmp(gendata(Gravity_direction),"-Z")==0)
0.0 0.0 -*gendata(Gravity_value)   
*elseif(strcmp(gendata(Gravity_direction),"-Y")==0)
0.0 -*gendata(Gravity_value) 0.0
*elseif(strcmp(gendata(Gravity_direction),"-X")==0)
-*gendata(Gravity_value) 0.0 0.0 
*elseif(strcmp(gendata(Gravity_direction),"+Z")==0)
0.0 0.0 *gendata(Gravity_value)
*elseif(strcmp(gendata(Gravity_direction),"+Y")==0)
0.0 *gendata(Gravity_value) 0.0
*elseif(strcmp(gendata(Gravity_direction),"+X")==0)
*gendata(Gravity_value) 0.0 0.0
*else
0.0 0.0 0.0
*end if
*else
0.0 0.0 0.0
*end if

*set cond point_Momentum
*set var n_momentum=condnumentities
*set cond point_Load
*set var nL=operation(condnumentities+n_momentum)
*nL # number of loaded nodes (global)
*if(nL)
#.node  X-load   Y-load   Z-load   X-mom     Y-mom     Z-mom
#         *Units(STRENGTH)        *Units(STRENGTH)        *Units(STRENGTH)        *Units(STRENGTH).*Units(LENGTH)      *Units(STRENGTH).*Units(LENGTH)      *Units(STRENGTH).*Units(LENGTH)
*loop nodes onlyincond
*nodesnum *cond(Force_x) *cond(Force_y) *cond(Force_z) 0 0 0
*end nodes
*set cond point_Momentum
*loop nodes onlyincond
*nodesnum 0 0 0 *cond(Momentum_x) *cond(Momentum_y) *cond(Momentum_z)
*end nodes
*end if
*set cond line_Uniform_load
*condnumentities # number of uniformly-distributed element loads (local)
*if(condnumentities)
#.elmnt  X-load   Y-load   Z-load   uniform member loads in member coordinates
#         *Units(STRENGTH)/*Units(LENGTH)     *Units(STRENGTH)/*Units(LENGTH)     *Units(STRENGTH)/*Units(LENGTH)
*loop elems onlyincond
*if(strcmp(cond(Coordinates_system),"Global")==0)
*elemsnum *tcl(Frame3DD::ConvertForceFromGlobalToLocal *elemsnum *cond(Load_x) *cond(Load_y) *cond(Load_z))
*else
*elemsnum *cond(Load_x) *cond(Load_y) *cond(Load_z)
*end if
*end elems
*end if
*set cond line_Trapezoidal_load
*condnumentities  # number of trapezoidally-distributed element loads (local)
*if(condnumentities)
#       start    stop     start    stop
#.elmnt loc'n    loc'n    load     load
#       *Units(LENGTH)       *Units(LENGTH)       *Units(STRENGTH)/*Units(LENGTH)     *Units(STRENGTH)/*Units(LENGTH)
*loop elems onlyincond
*set var t0(real)=tcl(Frame3DD::GetElementAbsoluteDistanceConsideringUnits *elemsnum *cond(Start_relative_position))
*set var t1(real)=tcl(Frame3DD::GetElementAbsoluteDistanceConsideringUnits *elemsnum *cond(End_relative_position))
*if(strcmp(cond(Coordinates_system),"Global")==0)
*set var f0x(real)=tcl(Frame3DD::ConvertForceFromGlobalToLocalGetIndex *elemsnum *cond(Start_load_x) *cond(Start_load_y) *cond(Start_load_z) 0)
*set var f0y(real)=tcl(Frame3DD::ConvertForceFromGlobalToLocalGetIndex *elemsnum *cond(Start_load_x) *cond(Start_load_y) *cond(Start_load_z) 1)
*set var f0z(real)=tcl(Frame3DD::ConvertForceFromGlobalToLocalGetIndex *elemsnum *cond(Start_load_x) *cond(Start_load_y) *cond(Start_load_z) 2)
*set var f1x(real)=tcl(Frame3DD::ConvertForceFromGlobalToLocalGetIndex *elemsnum *cond(End_load_x) *cond(End_load_y) *cond(End_load_z) 0)
*set var f1y(real)=tcl(Frame3DD::ConvertForceFromGlobalToLocalGetIndex *elemsnum *cond(End_load_x) *cond(End_load_y) *cond(End_load_z) 1)
*set var f1z(real)=tcl(Frame3DD::ConvertForceFromGlobalToLocalGetIndex *elemsnum *cond(End_load_x) *cond(End_load_y) *cond(End_load_z) 2)
*elemsnum *t0 *t1 *f0x *f1x
	 *t0 *t1 *f0y *f1y
	 *t0 *t1 *f0z *f1z
*else
*elemsnum *t0 *t1 *cond(Start_load_x) *cond(End_load_x)
	 *t0 *t1 *cond(Start_load_y) *cond(End_load_y)
	 *t0 *t1 *cond(Start_load_z) *cond(End_load_z)
*end if
*end elems
*end if
*set cond line_Interior_point_load
*condnumentities # number of concentrated interior point loads (local)
*if(condnumentities)
#.elmnt  X-load   Y-load   Z-load    x-loc'n  point loads in member coordinates 
*loop elems onlyincond
*if(strcmp(cond(Coordinates_system),"Global")==0)
*elemsnum *tcl(Frame3DD::ConvertForceFromGlobalToLocal *elemsnum *cond(Force_x) *cond(Force_y) *cond(Force_z)) *tcl(Frame3DD::GetElementAbsoluteDistanceConsideringUnits *elemsnum *cond(Relative_position))
*else
*elemsnum *cond(Force_x) *cond(Force_y) *cond(Force_z) *tcl(Frame3DD::GetElementAbsoluteDistanceConsideringUnits *elemsnum *cond(Relative_position))
*end if
*end elems
*end if
*set cond line_Thermal_load
*condnumentities # number of frame elements with temperature changes (local)
*if(condnumentities)
#.elmnt   coef.  y-depth  z-depth  deltaTy+  deltaTy-  deltaTz+  deltaTz-
#        1/*Units(TEMPERATURE)  *Units(LENGTH)       *Units(LENGTH)       *Units(TEMPERATURE)     *Units(TEMPERATURE)     *Units(TEMPERATURE)     *Units(TEMPERATURE)
*loop elems onlyincond
*elemsnum *cond(Coefficient) *cond(Y-depth) *cond(Z-depth) *cond(DeltaTy+) *cond(DeltaTy-) *cond(DeltaTz+) *cond(DeltaTz-)
*end elems
*end if
*set cond point_Constraint
*set var nD=0
*loop nodes onlyincond
*if(cond(Value_translation_x,real) || cond(Value_translation_y,real) || cond(Value_translation_z,real) || cond(Value_rotation_x,real) || cond(Value_rotation_y,real) || cond(Value_rotation_z,real))
*set var nD=operation(nD+1)
*end if
*end nodes
*nD # number of prescribed displacements nD<=nR (global)
*if(nD)
#.node    X-displ  Y-displ  Z-displ  X-rot'n   Y-rot'n   Z-rot'n
#         *Units(LENGTH)       *Units(LENGTH)       *Units(LENGTH)       *Units(ANGLE)    *Units(ANGLE)    *Units(ANGLE)
*loop nodes onlyincond
*if(cond(Value_translation_x) || cond(Value_translation_y) || cond(Value_translation_z) || cond(Value_rotation_x) || cond(Value_rotation_y) || cond(Value_rotation_z))
*nodesnum  *cond(Value_translation_x) *cond(Value_translation_y) *cond(Value_translation_z) *cond(Value_rotation_x) *cond(Value_rotation_y) *cond(Value_rotation_z)
*end if
*end nodes
*end if

# End Static Load Case *loopvar

*end intervals

# dynamic analysis data ...
*gendata(Number_of_modes) # number of desired dynamic modes of vibration
*if(gendata(Number_of_modes,int))
*if(strcmp(gendata(Method),"Subspace-Jacobi")==0)
1
*elseif(strcmp(gendata(Method),"Stodola")==0)
2
*else
1
*end if
*if(strcmp(gendata(Lump),"Consistent_mass_matrix")==0)
0
*elseif(strcmp(gendata(Lump),"Lumped_mass_matrix")==0)
1
*else
0
*end if
*gendata(Frequency_tolerance)
*gendata(Frequency_shift-factor)
1.0

*set cond point_Extra_mass
# extra node inertia data ...
*condnumentities # number of nodes with extra node mass or rotatory inertia
*if(condnumentities)
#.node   mass      XX-inertia   YY-inertia   ZZ-inertia
#       *Units(MASS)     *Units(MASS).*Units(LENGTH)^2   *Units(MASS).*Units(LENGTH)^2   *Units(MASS).*Units(LENGTH)^2
*loop nodes onlyincond
*nodesnum *cond(Mass) *cond(Inertia_x) *cond(Inertia_y) *cond(Inertia_z)
*end nodes
*end if

*set cond line_Extra_mass
# extra frame element mass data ...
*condnumentities  # number of frame elements with extra mass 
*if(condnumentities)
#.elmnt   extra mass
#         *Units(MASS)
*loop elems onlyincond
*elemsnum *cond(Mass)
*end elems
*end if

# mode shape animation data ...
*set var nA=gendata(Number_of_modes,int)
*nA # number of modes to be animated
# list of modes to be animated, sorted in increasing order 
*for(i=1;i<=nA;i=i+1) 
*i *\
*end for

0 # pan rate of the animation 0 = no panning

# matrix condensation data ...
*if(strcmp(gendata(Matrix_condensation_method),"None")==0)
0
*elseif(strcmp(gendata(Matrix_condensation_method),"Static")==0)
1
*elseif(strcmp(gendata(Matrix_condensation_method),"Guyan")==0)
2
*elseif(strcmp(gendata(Matrix_condensation_method),"Dynamic")==0)
3
*else
0
*end if

*set cond point_Condensed
*condnumentities  # number of condensed nodes
*if(condnumentities)
#.node   X      Y      Z       XX      YY     ZZ   1: condense; 0: don't
*loop nodes onlyincond
*nodesnum *cond(Condense_x) *cond(Condense_y) *cond(Condense_z) *cond(Condense_xx) *cond(Condense_yy) *cond(Condense_zz)
*end nodes
*end if
*set var nM=gendata(Number_modes_matched,int)
*if(strcmp(gendata(Matrix_condensation_method),"Static")==0)
# if Cmethod == Static, only mode m[1] is matched.
*set var nM=1
*end if
# list of modes matched in dynamic condensation
*for(i=1;i<=nM;i=i+1)
*i *\
*end for

*end if
