#######################################################################################
#GiD Raised events
#######################################################################################

proc GiD_Event_InitProblemtype {dir} {
    #source [file join $dir scripts protection.tcl]
    #lassign [Cmas2d::GetHasPassword $dir] has_password message
    #if { $has_password } {
    #    GidUtils::SetWarnLine [= "This is the professional version of the interface %s" $::problemtype_current(Name)]        
    #} else {
    #    GidUtils::SetWarnLine [= "This is the limited version of the interface %s. Please go to Help->Register Problem type" $::problemtype_current(Name)]
    #}
    global ProblemTypePriv
    set ::ProblemTypePriv(dir) $dir    

    array set problemtype_local [GidUtils::ReadProblemtypeXml [file join $dir cmas2d.xml] Infoproblemtype {Name Version MinimumGiDVersion}]
    if { [GidUtils::VersionCmp $problemtype_local(MinimumGiDVersion)] < 0 } {  
            W [= "This problemtype requires GiD %s or later" $problemtype_local(MinimumGiDVersion)]
    }
    set ::ProblemTypePriv(name) $problemtype_local(Name)
    set ::ProblemTypePriv(version) $problemtype_local(Version)    
    if { ![GiD_Info Geometry NumSurfaces] } {
        set materials  [GiD_Info materials]
        set conditions [GiD_Info conditions ovpnt]
        Cmas2d::CreateWindow $dir $materials $conditions
    }
}

proc GiD_Event_EndProblemtype {} {    
    #Cmas2d::ReleasePassword
    global ProblemTypePriv
    array unset ::ProblemTypePriv
}

proc GiD_Event_LoadModelSPD { filespd } {
    global ProblemTypePriv
    set problemtype_current [GiD_Info project ProblemType]
    if { [file tail $problemtype_current] == $::ProblemTypePriv(name) } {
        set model_problemtype_version_number [GidUtils::ReadXmlWithNameAndVersion [file rootname $filespd].xml $::ProblemTypePriv(name)]
        if { $model_problemtype_version_number != $::ProblemTypePriv(version) } {
            set must_transform 1
        } else {
            set must_transform 0
        }
        if { $must_transform } {
            GiD_Project transform_problemtype $problemtype_current
        }
    }
}

proc GiD_Event_SaveModelSPD { filespd } {
    global ProblemTypePriv    
    GidUtils::SaveXmlWithNameAndVersion [file rootname $filespd].xml $::ProblemTypePriv(name) $::ProblemTypePriv(version)
}

#######################################################################################
# Cmas2d namespace procedures
#######################################################################################

namespace eval Cmas2d {
}

proc Cmas2d::Transform { from_version to_version } {
    global ProblemTypePriv
    #GiD_Process escape escape escape escape Data Defaults TransfProblem $::ProblemTypePriv(name) escape
    GiD_Project transform_problemtype $::ProblemTypePriv(name)
}


proc Cmas2d::CreateWindow {dir mat cond} {  
    if { [GidUtils::AreWindowsDisabled] } {
	return
    }  
    set w .gid.win_example
    InitWindow $w [= "CMAS2D.TCL - Example tcl file"] PreExampleCMAS2DWindowGeom "" "" 1
    if { ![winfo exists $w] } return ;# windows disabled || usemorewindows == 0

    ttk::frame $w.top
    ttk::label $w.top.title_text -text [= "TCL window example for CMAS2D problem type"]
   
    ttk::frame $w.information -relief ridge
    ttk::label $w.information.path -text [= "Problem Type path: %s" $dir]
    ttk::label $w.information.materials -text [= "Available materials: %s" $mat]
    ttk::label $w.information.conditions -text [= "Available conditions: %s" $cond]
 
    ttk::frame $w.bottom
    ttk::button $w.bottom.start -text [= "Continue"] -command "destroy $w"
    ttk::button $w.bottom.random -text [= "Random surface"] -command "Cmas2d::CreateRandomSurface $w"

    grid $w.top.title_text -sticky ew
    grid $w.top -sticky new
    grid $w.information.path -sticky w -padx 6 -pady 6
    grid $w.information.materials -sticky w -padx 6 -pady 6
    grid $w.information.conditions -sticky w -padx 6 -pady 6
    grid $w.information -sticky nsew
    
    grid $w.bottom.start $w.bottom.random -padx 6
    grid $w.bottom -sticky sew -padx 6 -pady 6
    if { $::tcl_version >= 8.5 } { grid anchor $w.bottom center }
    grid rowconfigure $w 1 -weight 1
    grid columnconfigure $w 0 -weight 1    
}

proc Cmas2d::CreateRandomSurface {w} {
    set ret [tk_dialogRAM $w.dialog [= "Warning!!"] \
		 [= "Warning: this will create a nurbs surface in your current project"] "" 1 [= "Ok"] [= "Cancel"]]

    if {$ret ==0} {
        Cmas2d::Create_surface
        destroy $w
    }
}

proc Cmas2d::Create_surface {} {
    set a_x [expr rand()*10]
    set a_y [expr rand()*10]    
    set b_x [expr $a_x + rand()*10]
    set b_y [expr $a_y + rand()*10]    
    set c_x [expr $b_x + rand()*10]
    set c_y [expr $b_y - rand()*10]    
    if {$a_y < $c_y} {
	set d_y [expr $a_y - rand()*10]
	set d_x [expr $a_x + rand()*10]
    } else {
	set d_y [expr $c_y - rand()*10] 
	set d_x [expr $c_x - rand()*10]
    }    
    set next_line_id [GiD_Info Geometry MaxNumLines]
    GiD_Process MEscape Geometry Create Line $a_x,$a_y,0.000000 $b_x,$b_y,0.000000 $c_x,$c_y,0.000000 $d_x,$d_y,0.000000 close escape
    GiD_Process Mescape Geometry Create NurbsSurface [expr $next_line_id+1]:[expr $next_line_id+4] escape escape
    GiD_Process 'Zoom Frame
}
