package require icons
package require ico
package require snit
#package require Img
#package require treectrl

proc set_bbox_borderwidth { bbox w} {
    foreach c [ winfo children $bbox] {
        if { [ winfo class $c] == "Button"} {
            $c configure -borderwidth $w
        }
        # WarnWinText "$c --> [ winfo class $c]"
    }
}

################################################################################
#    text_and_variable
################################################################################

snit::widgetadaptor text_and_variable {
    option -variable ""

    delegate method * to hull
    delegate method _insert to hull as insert
    delegate method _delete to hull as delete
    delegate option * to hull

    variable updating 0

    constructor args {
        installhull [text $self]
        
        bind $win <Tab> "[bind all <Tab>] ; break"
        bind $win <<PrevWindow>> "[bind all <<PrevWindow>>] ; break"

        $self configurelist $args
    }
    destructor {
        $self clear
    }
    onconfigure -variable {value} {
        $self clear
        set options(-variable) $value
        if { $value ne "" } {
            #ind $win <<Modified>> [mymethod modifytext]
            trace add variable $value write "[mymethod modifyvariable];#"
        }
    }
    method clear {} {
        if { $options(-variable) ne "" } {
            trace remove variable $options(-variable) write \
                "[mymethod modifyvariable];#"
            #bind $win <<Modified>> ""
        }
    }
    method modifytext {} {
        if { $options(-variable) eq "" } { return }
        if { $updating } { return }
        set updating 1
        upvar #0 $options(-variable) v
        if { ![info exists v] } { set v "" }
        set data [$self get 1.0 end-1c]
        if { $data ne $v} { set v $data }
        $self edit modified 0
        set updating 0
    }
    method modifyvariable {} {
        if { $updating } { return }
        set updating 1
        upvar #0 $options(-variable) v
        if { ![info exists v] } { set v "" }
        set data [$self get 1.0 end-1c]
        if { $data ne $v } {
            $self delete 1.0 end
            $self insert end $v
        }
        $self edit modified 0
        set updating 0
    }
    method insert { args } {
        set ret [eval $self _insert $args]
        $self modifytext
        return $ret
    }
    method delete { args } {
        set ret [eval $self _delete $args]
        $self modifytext
        return $ret
    }

}

################################################################################
#    ComboBox_and_valuesvar
################################################################################

snit::widgetadaptor ComboBox_and_valuesvar {
    option -valuesvariable ""
    option -values ""

    delegate method * to hull
    delegate option * to hull
    delegate option -_values to hull as -values

    constructor args {
        installhull [ComboBox $self]
        $self configurelist $args
    }
    destructor {
        $self clear
    }
    onconfigure -valuesvariable {value} {
        if { $options(-valuesvariable) ne "" } {
            trace remove variable $options(-valuesvariable) write \
                "[mymethod modifyvariable];#"
        }
        set options(-valuesvariable) $value
        if { $value ne "" } {
            trace add variable $value write "[mymethod modifyvariable];#"
        }
    }
    onconfigure -values {value} {
        upvar #0 $options(-valuesvariable) v
        if { ![info exists v] } { set v "" }
        set data [$self cget -values]
        if { $data ne $v} {
            $self configure -_values $v
        }
    }
    method clear {} {
        if { $options(-valuesvariable) ne "" } {
            trace remove variable $options(-valuesvariable) write \
                "[mymethod modifyvariable];#"
        }
    }
    method modifyvariable {} {
        upvar #0 $options(-valuesvariable) v
        if { ![info exists v] } { set v "" }
        set data [$self cget -values]
        if { $data ne $v} {
            $self configure -_values $v
        }
    }
}

################################################################################
#     icon_chooser
################################################################################


namespace eval icon_chooser {
    variable default_library
    variable imported_images
    variable macros_images
    variable _map_new_name
    if { ![info exists default_library] } {
        set default_library ""
    }
    if { ![info exists imported_images] } {
        set imported_images ""
    }
    # to map some image filenames used in old versions and stored in macros.tcl
    # probably is the same done in TransformMacrosToolbarImages (maybe this proc is unneded nowadays, or at least will be more efficient filling an array)
    # renamed in GiD 16.1.10d :
    #     PantallaResize.png
    #     PantallaInfo.png
    array set _map_new_name {
        "PantallaResize.png" "screen_resize.png"
        "PantallaInfo.png" "screen_info.png"
    }
}

proc icon_chooser::MapOldImageName { oldimg } {
    variable _map_new_name
    set name $oldimg
    if { [info exists _map_new_name($oldimg)] } {
        set name $_map_new_name($oldimg)
    }
    return $name
}

proc TransformMacrosToolbarImages { oldimg } {
        #gear-22 edit-22 forward-16 remove-16 finish-16 
    #ok-16 top-16 bottom-16 filesave-16
        set newimg ""
        switch $oldimg {
                "up-22" - "up-16" {
                        set newimg "send_to_back.png"
                }
                "down-22" - "down-16" {
                        set newimg "bring_to_front.png"
                }
                "border_horizontal-22" {
                        set newimg "border_horizontal.png"
                }
                "border_vertical-22" {
                        set newimg "border_vertical.png"
                }
                "text_left-22" {
                        set newimg "align_text_left.png"
                }
                "appearance-22" {
                        set newimg "color.png"
                }
                "record-22" - "record-16" {
                        set newimg Record.png
                }
                "recordend-22" - "recordend-16" {
                        set newimg EndRecord.png
                }
                "macro-22" {
                        set newimg Macro.png
                }
                "transparent-16" {
                        set newimg blank.png
                }
                "pre-24" {
                        set newimg surface.png
                }
                "post-24" {
                        set newimg PostBarContourFill.png
                }
                "prepost-24" {
                        set newimg prepost.png
                }
                "PantallaResize.svg" {
                    screen_resize.png
                }
                "PantallaInfo.svg" {
                    screen_info.png
                }
                "PantallaResize.png" {
                    screen_resize.png
                }
                "PantallaInfo.png" {
                    screen_info.png
                }
                "note.gif" - "dimension_edit.gif" - \
                "surface_trim.gif" - "surface_hole.gif" -        "surface_parallel_lines.gif1" - \
                "point_move.gif" - "line_divide_nparts.gif" -        "line_divide_nearpoint.gif" - \
                "intersect_lines.gif1" - "surface_divide_nparts.gif" - "surface_divide_split.gif" - \
                "intersect_line_surface.gif" -        "intersect_surfaces.gif" -        "collapse_alltypes.gif" - \
                "view_labels.gif" - "view_normals_surface.gif" - "view_higherentity_lines.gif" - \
                "view_assigned_meshsizes.gif" - "view_rotate_xy.gif" - "view_swap_render.gif" - \
                "dimension_dist.gif" - "dimension_angle.gif" - \
                "dimension_vertex.gif" - "dimension_arc.gif1" - "dimension_delete.gif1" - \
                "send_to_back_opposite.gif" - "send_to_back_opposite.gif" - "intersect_lines_nodivide.gif" - \
                "split_elements.gif" - "collapse_edges.gif" - "align_quadratic_nodes.gif" - \
                "user_open.gif" - "user_save.gif" - "collapse_points.gif1" - \
                "collapse_lines.gif" - "view_rotate_xz.gif" - "view_rotate_yz.gif" - \
                "view_rotate_-xy.gif" - "view_rotate_-yz.gif" - "Scalar2Vector.gif" - \
                "CreateMaxScalar.gif" - "view_rotate_-xz.gif" - "CreateMinMaxMed.gif" {
                        set newimg "[file root $oldimg].png"
                }                
        }
        return $newimg
}

proc icon_chooser::get_macros_images { name } {    
    if { ![info exists icon_chooser::macros_images($name)] } {
        WarnWinText "icon_chooser::get_macros_images. image '$name' not found"
        return ""
    }
    return $icon_chooser::macros_images($name)
}

proc icon_chooser::free_default_macro_image { img } {
    variable _default_macro_images
    #check and free unused ones
    foreach item [array names _default_macro_images] {
        if { $_default_macro_images($item) == $img } {
            unset _default_macro_images($item)        
            #if { ![image inuse $img] } {
            #    image delete $img             
            #}            
            image delete $img
            break
        }                    
    }
}
    
proc icon_chooser::get_default_macro_image { } {
    variable _default_macro_images
#     #check and free unused ones
#     foreach item [array names _default_macro_images] {
#         if { ![image inuse $_default_macro_images($item)] } {
#             image delete $_default_macro_images($item)
#             unset _default_macro_images($item)                  
#         }                    
#     }
    set idx 1
    while { [info exists _default_macro_images($idx)] } {
        incr idx
    }    
    set _default_macro_images($idx) [image create photo]
    $_default_macro_images($idx) copy [::gid_themes::GetImage Macro.png toolbar]    
    GidUtils::PrintNumberOverImage $idx $_default_macro_images($idx) 1 1
    return $_default_macro_images($idx)
}

proc icon_chooser::giveimage { icodesc } {
    if { [llength $icodesc] == 4 } {
        #new themed GiD uses only second part of Icon data saved in gid_macros.tcl
        #old unthemed GiDs use only first part 
        set icodesc [lrange $icodesc 2 3]
    }

    lassign $icodesc name origin
    if { $origin eq "themed_image" } {
        return [::gid_themes::GetImage $name toolbar]
    } elseif { $icodesc == "" } {
        return [::gid_themes::GetImage Macro.png toolbar]
    } elseif { $origin eq "imported_images" } { 
        variable imported_images
        set i [lsearch -index 0 $imported_images $name]
        if { $i != -1 } { 
            return [ gid_themes::HighResolutionImage [lindex [lindex $imported_images $i] 1] ]
        }            
    } elseif { $origin == "" } {
        #back compatibility, used by gid_groups_conds. is a Tk image?
        #
        #set newname [TransformMacrosToolbarImages $name]
        #if { $newname != "" } {
        #    return [::gid_themes::GetImage $newname toolbar]
        #}
        set name [icons::icons create $name]
        if { $name eq "" } {
            error "icon '$icodesc' cannot be found"
        }
        return [ gid_themes::HighResolutionImage ::icon::$name]
    } elseif { [regexp {(?i)^\.(dll|ico|exe)$} [file extension $origin]] } {
        #back compatibility, used by gid_groups_conds. is a Tk image?
        return [ gid_themes::HighResolutionImage [::ico::getIcon $origin $name]]
    }
    error "error in icon_chooser::giveimage icodesc=$icodesc"
}

proc icon_chooser::choose_icon { parent } {

    set w $parent.%AUTO%
    set w [dialogwin_snit $w -title [_ "Choose icon"] -morebuttons [list [_ "Clear"]] -transient 1]
    set f [$w giveframe]

    set values [list [_ "Themed"] [_ "Not themed"]]
    
    ttk::combobox $f.cb1 -textvariable [$w give_uservar origin] -width 10 \
        -values $values -state readonly
    bind $f.cb1 <<ComboboxSelected>> [namespace code [list _fill_canvas $f.s.c $w]]
    ttk::frame $f.f1
    ttk::radiobutton $f.f1.r1 -text [_ "Unused"] -variable [$w give_uservar showused] -value 0 \
        -command [namespace code [list _fill_canvas $f.s.c $w]]
    ttk::radiobutton $f.f1.r2 -text [_ "Used"] -variable [$w give_uservar showused] -value 1 \
        -command [namespace code [list _fill_canvas $f.s.c $w]]
    ttk::button $f.f1.b1 -text [_ "Import"]... -command [list icon_chooser::_import_image $f.s.c $w]
    ttk::button $f.f1.b2 -text [_ "Delete"] -command [list icon_chooser::_delete_imported_image $f.s.c $w]
    grid $f.f1.r1 $f.f1.r2 $f.f1.b1 $f.f1.b2 -padx 5
    grid remove $f.f1.b1 $f.f1.b2

    ScrolledWindow $f.s -relief sunken -borderwidth 0
    canvas $f.s.c -background white -borderwidth 0 -highlightthickness 1 \
        -width 224 -height 224 -takefocus 1
    $f.s setwidget $f.s.c

    grid $f.cb1 -sticky nw -padx 3 -pady 3
    grid $f.f1  -sticky nw
    grid $f.s   -sticky nsew -padx 1 -pady 1
    grid configure $f.cb1 -sticky nwe
    grid columnconfigure $f 0 -weight 1
    grid rowconfigure $f 2 -weight 1

    $w set_uservar_value origin [_ "Themed"]
    $w set_uservar_value showused 0
    $w set_uservar_value icondesc ""

    after 100 [namespace code [list _fill_canvas $f.s.c $w]]

    bind $f.cb1 <Return> [namespace code [list _fill_canvas $f.s.c $w]]
    bind $f.s.c <1> [list focus $f.s.c]
    bind $f.s.c <MouseWheel> {
        %W yview scroll [expr {- (%D / 120) * 4}] units
    }

    $w focusok
    set action [$w createwindow]
    while 1 {
        switch -- $action {
            -1 - 0 {
                destroy $w
                return -
            }
            1 {
                set icondesc [$w give_uservar_value icondesc]
                if { $icondesc eq "" } {
                    WarnWin [_ "Select one icon"] $w
                } else {
                    set origin [$w give_uservar_value origin]
                    destroy $w
                    if { $origin eq [_ "Themed"] } {
                        return [list $icondesc themed_image]
                    } else {
                        return [list $icondesc imported_images]
                    }
                }
            }   
            2 {
                #clear to default ico
                destroy $w
                return ""
            }        
        }
        set action [$w waitforwindow]
    }
}

proc icon_chooser::SaveIconInFile { fout name date img} {
    puts $fout "[list set ::icon_chooser::ImportedDates($name) $date]\n"
    puts $fout "[list image create photo ::icon_chooser::images::$name] -data \{"
    puts $fout [$img data -format png]
    puts $fout "\}\n"
}

proc icon_chooser::SaveImages { fout macronames } {        
    #save all macro images: imported_image and also themed_image because now gid_macros.tcl is shared by all GiD versions
    #and old unthemed versions coul no have this image if is not saved here
    #new themed versions will ignore it and use the one of the \themes folder appropiated to current theme
    #in the future probable each version of GiD must have its own copy of user preferences and gid_macros.tcl...
    
    set written_names ""
    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    puts $fout "\n"
    foreach item [array names macrosdata *,Icon] {
        set macroname [string range $item 0 end-5]
        if { $macronames ne "" && [lsearch -exact $macronames $macroname] == -1 } { continue }    
        set date $macrosdata($macroname,CreationDate)   
        lassign $macrosdata($item) name origin        
        if { $origin == "themed_image" } {
            #save always the classic 24x24 icons, to be used by old GiDs only
            set fullname [file join [ gid_themes::GetThemesBaseFolder] GiD_classic images large_size(24andmore) $name]
            set icon_exists 1
            if { ![ file exists $fullname]} {
                set icon_exists 0
                W [_ "Icon %s could not be found." $fullname]
            }
            if { $icon_exists} {
                set img [image create photo -file $fullname]
                SaveIconInFile $fout $name $date $img
                image delete $img
                lappend written_names $name
            }
        } else {
            set img [icon_chooser::giveimage $macrosdata($item)]
            SaveIconInFile $fout $name $date $img
            lappend written_names $name
        }
    }
    
    #write also imported_images that are not assigned to any macro
    variable imported_images
    foreach item $imported_images {
        lassign $item name img date        
        if { [lsearch $written_names $name] == -1 } { 
            puts $fout "[list set ::icon_chooser::ImportedDates($name) $date]\n"
            puts $fout "[list image create photo ::icon_chooser::images::$name] -data \{"
            puts $fout [$img data -format png]
            puts $fout "\}\n"
        }
    }
}

proc icon_chooser::AfterReadMacros {} {
    variable macros_images
    upvar #0 icon_chooser::macros_images macros_images
    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    foreach var [array names macrosdata *,Icon] {
        set name [lindex [split $var ,] 0]
        if { $macrosdata($name,Icon) eq "" } {
            set macros_images($name) [icon_chooser::get_default_macro_image]
        } else {
            if { [lindex $macrosdata($name,Icon) 1] == "themed_image" } {
                set imgname [lindex $macrosdata($name,Icon) 0]
                set imgname [icon_chooser::MapOldImageName $imgname]
                set macros_images($name) [::gid_themes::GetImage $imgname toolbar]
            } else {
                lassign $macrosdata($name,Icon) imgname imgtype
                if { $imgtype == "imported_images" || $imgtype == "" } {
                    set correspondenceimg [TransformMacrosToolbarImages $imgname ]
                    if { $correspondenceimg != "" } {
                        set macrosdata($name,Icon) [list $correspondenceimg themed_image]
                        set now [clock format [clock seconds] -format "%Y-%m-%d %H:%M:%S"]
                        set macrosdata($name,ModificationDate) $now
                        set macros_images($name) [gid_themes::GetImage $correspondenceimg toolbar]
                    } else {
                        set macros_images($name) [icon_chooser::giveimage $macrosdata($name,Icon)]
                    }
                }
            }
        }
    }
}

proc icon_chooser::_delete_imported_image { c w } {
    variable imported_images

    set ic [$w give_uservar_value icondesc]
    if { $ic eq "" } { return }
    foreach tag [$c gettags A$ic] {
        if { [regexp {^A(.*)$} $tag {} name] } {
            $w set_uservar_value icondesc $name
            regsub -all { } $name {_} name ;#avoid names with spaces (problems using tile)
        }
        if { [regexp {^N(\d+)$} $tag {} number] } { break }
    }

    if { [::toolbarmacros::is_image_in_use $name] } {
        WarnWin [_ "this icon can't be deleted because it is used in the macros toolbar"]
        return 1
    }

    set idx [lsearch -index 0 $imported_images $name]
    if { $idx != -1 } {
        lassign [lindex $imported_images $idx] name img date
        if { [lsearch [image names] $img] != -1 } {
            image delete $img
        }
        set imported_images [lreplace $imported_images $idx $idx]
        unset icon_chooser::ImportedDates($name)
    }
    toolbarmacros::SaveMacros
    _fill_canvas $c $w $number
}

proc icon_chooser::_import_image { c w } {
    variable imported_images

    set types [list \
            [list [_ "Image"] [list .svg .png .jpg .gif]] \
            [list [_ "All files"] .*]]

#     set basefile [$w give_uservar_value file]
#     if { $basefile ne "tkIcons" && $basefile ne [_ "Imported images"] } {
#         set initialfile [file tail $basefile]
#     } else {
#         set initialfile ""
#     }
    set initialfile ""

    set filenames [MessageBoxGetFilename file read [_ "Select image"] $initialfile $types "" 1]
    if { $filenames == "" } { return }

    set required_size [::gid_themes::GetImageSize toolbar]
    foreach filename $filenames {
        set idx ""
        while 1 {
            set name [file tail $filename]$idx
            regsub -all { } $name {_} name ;#avoid names with spaces (problems using tile)
            if { [lsearch -index 0 $imported_images $name] == -1 } {
                break
            }
            if { $idx eq "" } { 
                set idx 1 
            } else { 
                incr idx 
            }
        }
        set err [catch {image create photo icon_chooser::images::$name -file $filename} img]
        if { $err } {
            WarnWinText [_ "Error importing image '%s' (%s)" $filename $img]            
        } else {            
            if { [image width $img] != $required_size || [image height $img] != $required_size } {
                set new_img [GidUtils::ResizeImage $img $required_size $required_size]               
                image delete $img
                set img $new_img
            }
            set now [clock format [clock seconds] -format "%Y-%m-%d %H:%M:%S"]
            set ::icon_chooser::ImportedDates($name) $now
            lappend imported_images [list $name $img $now]
        }
    }
    
    toolbarmacros::SaveMacros
    _fill_canvas $c $w
}

proc icon_chooser::_select_library { c w } {
    set types [list \
            [list [_ "Icons files"] [list .dll .exe .ico]] \
            [list [_ "All files"] .*]]
    set initialfile [file tail [$w give_uservar_value file]]
    set filename [MessageBoxGetFilename file read [_ "Select library"] \
            $initialfile $types "" 0]
    if { $filename != "" } {
        $w set_uservar_value file $filename
        _fill_canvas $c $w
    }
}

proc icon_chooser::_fill_canvas_select { c w what } {

    switch $what {
        cursor {
            set id [$c find withtag current]
        }
        Home {
            set id [$c find withtag N1]
        }
        End {
            set id [$c find withtag N[$w give_uservar_value icon_number]]
        }
        Left - Right - Up - Down {
            if { [$w give_uservar_value icondesc] eq "" } {
                return [_fill_canvas_select $c $w Home]
            }
            foreach tag [$c gettags A[$w give_uservar_value icondesc]] {
                if { [regexp {^N(\d+)$} $tag {} number] } { break }
            }
            switch $what {
                Left {
                    if { $number > 1 } { incr number -1 }
                }
                Right {
                    if { $number < [$w give_uservar_value icon_number] } { incr number }
                }
                Up {
                    if { $number > [$w give_uservar_value icon_number_row] } {
                        incr number -[$w give_uservar_value icon_number_row]
                    }
                }
                Down {
                    if { $number < [$w give_uservar_value icon_number]-\
                        [$w give_uservar_value icon_number_row]+1 } {
                        incr number [$w give_uservar_value icon_number_row]
                    }
                }
            }
            set id N$number
        }
    }
    _fill_canvas_select_do $c $w $id
}

proc icon_chooser::_center_canvas_in_id { canvas i } {
    foreach "x y" [$canvas coords $i] break
    foreach "- - width height" [$canvas cget -scrollregion] break

    foreach "f1 f2" [$canvas xview] break
    set xs [expr $x/double($width)-($f2-$f1)/2.0]
    if { $xs < 0 } { set xs 0 }
    $canvas xview moveto $xs

    foreach "f1 f2" [$canvas yview] break
    set ys [expr $y/double($height)-($f2-$f1)/2.0]
    if { $ys < 0 } { set ys 0 }
    $canvas yview moveto $ys
}

proc icon_chooser::_fill_canvas_select_do { c w id } {

    $c delete selmask
    foreach "x y" [$c coords $id] break
    foreach tag [$c gettags $id] {
        if { [regexp {^A(.*)$} $tag {} name] } {
            $w set_uservar_value icondesc $name
        }
    }
    set width [image width [$c itemcget $id -image]]
    $c create rectangle [expr {$x-1}] [expr {$y-1}] [expr {$x+$width+2}] \
        [expr {$y+$width+2}] \
        -outline "" -fill grey60 -tags selmask
    $c lower selmask
    _center_canvas_in_id $c $id
}

proc icon_chooser::_fill_canvas { c w { sel_idx "" } } {
    GidUtils::WaitState $w
    update
    set err [catch { _fill_canvasDo $c $w $sel_idx } msg]    
    GidUtils::EndWaitState $w
    if { $err } {
        WarnWin [_ "Library not valid %s" $msg] $w
    }
}

proc icon_chooser::_fill_canvasDo { c w  { sel_idx "" } } {   
    variable imported_images
    
    package require tooltip
    

    set origin [$w give_uservar_value origin]
    set showused [$w give_uservar_value showused]

    $c delete all

    set f [$w giveframe]
    if { $origin eq [_ "Themed"] } {
        grid remove $f.f1.b1 $f.f1.b2
        grid $f.f1.r1 $f.f1.r2 -padx 5        
    } else {
        grid remove $f.f1.r1 $f.f1.r2
        grid $f.f1.b1 $f.f1.b2 -padx 5
    }        

    set lst ""
    set maxnumber 0
    set used_filenames ""
    foreach i [array names toolbarmacros::macrospace::macrosdata *,Icon] {
        if { [llength $toolbarmacros::macrospace::macrosdata($i)] == 2 } {
            lappend used_filenames [lindex $toolbarmacros::macrospace::macrosdata($i) 0]
        } elseif { [llength $toolbarmacros::macrospace::macrosdata($i)] == 1 } {
            incr unexpected_case        
        }
    }
    set used_filenames [lsort -unique -dictionary $used_filenames]
        
    set width 0
    set l ""
    if { $origin eq [_ "Themed"] } {
        set ThemeSize [GiD_Set Theme(Size)]
        set IconCategory toolbar
        foreach filename [glob -nocomplain -tails -directory $::GidPriv(CurrentTheme,path,$ThemeSize,$IconCategory) *.png] {
            set found [lsearch -sorted -dictionary $used_filenames $filename]
            if { ($showused && $found != -1) || (!$showused && $found == -1)} {
                #show only used or unused
                lappend l $filename
            }
        }
        foreach filename_real [glob -nocomplain -tails -directory $::GidPriv(CurrentTheme,path,$ThemeSize,$IconCategory) *.svg] {
            set filename [file rootname $filename_real].png
            set found [lsearch -sorted -dictionary $used_filenames $filename]
            if { ($showused && $found != -1) || (!$showused && $found == -1)} {
                #show only used or unused
                lappend l $filename
            }
        }
        set l [lsort -unique -dictionary $l]
    } else { 
        #[_ "Not themed"] 
        set IconCategory generic                  
        foreach i $imported_images {
            lappend l [lindex $i 0]            
        }
    }
    foreach "x y idx idxrow" [list 4 4 0 0] break
    foreach name $l {
        if { $IconCategory == "toolbar" } {
            set image [::gid_themes::GetImage $name $IconCategory]
        } else {
            set i [lsearch -index 0 $imported_images $name]
            if { $i == -1 } {
                continue
            }
            set image [lindex [lindex $imported_images $i] 1]
        }
        if { $width == 0 } {
            set width [image width $image]
        }
        set help [file rootname $name]
        regsub -all {_} $help { } help
        set id [$c create image $x $y -image $image -anchor nw \
                -tags [list A$name icon N[incr idx]]]
        if { $sel_idx == $idx } {
            _fill_canvas_select_do $c $w $id
        }
        incr x [expr {$width+4}]
        if { $x > 600 } {
            if { !$idxrow } { set idxrow $idx }
            set x 4
            incr y [expr {$width+4}]
        }
        $c bind icon <1> [namespace code [list _fill_canvas_select $c $w cursor]]
        $c bind icon <Double-1> [list $w invokeok]
        bind $c <Return> [list $w invokeok]
        
        tooltip::tooltip $c -item $id $help
    }
    foreach i [list Home End Left Right Up Down] {
        bind $c <$i> [namespace code [list _fill_canvas_select $c $w $i]]
    }    
    $w set_uservar_value icon_number_row $idxrow
    $w set_uservar_value icon_number $idx
    $w set_uservar_value icondesc ""
    $c configure -scrollregion [list 0 0 624 $y]
}
################################################################################
#    TreeCtrlList
################################################################################

::snit::widgetadaptor TreeCtrlList {
    option -columns

    delegate method * to hull
    delegate method _selection to hull as selection
    delegate option * to hull

    variable SortColumn
    variable itemStyle
    variable SystemButtonFace
    variable SystemHighlight
    variable SystemHighlightText

    constructor args {
        package require treectrl

        installhull using treectrl -highlightthickness 0 -borderwidth 0
        $self debug configure -enable no -display no
        
        if { ![info exists SystemButtonFace] } {
            set w [listbox .listbox]
            set SystemButtonFace [$w cget -highlightbackground]
            set SystemHighlight [$w cget -selectbackground]
            set SystemHighlightText [$w cget -selectforeground]
            destroy $w
        }

        set height [font metrics [$self cget -font] -linespace]
        # height : the size of icons
        set height [::gid_themes::GetImageSize toolbar]

        if {$height < 24} {
            set height 24
        }

        $self configure -showroot no -showbuttons no -showlines no -itemheight $height \
            -selectmode extended -xscrollincrement 20 \
            -scrollmargin 16 -xscrolldelay "500 50" -yscrolldelay "500 50"

        $self element create e1 image
        $self element create e2 text -fill [list $SystemHighlightText {selected focus}] \
            -lines 1
        $self element create e3 text -lines 1
        $self element create e4 rect -fill [list $SystemHighlight {selected focus} \
                gray {selected !focus}] -showfocus yes -open we
        $self element create e5 text -lines 1 -format " " -datatype string

        set S [$self style create imagetext -orient horizontal]
        $self style elements $S {e4 e1 e2}
        $self style layout $S e1 -expand ns
        $self style layout $S e2 -padx {4 0} -squeeze x -expand ns
        $self style layout $S e4 -union [list e2] -iexpand nswe -ipadx 2

        set S [$self style create text -orient horizontal]
        $self style elements $S {e4 e2}
        $self style layout $S e2 -padx {2 0} -squeeze x -expand ns
        $self style layout $S e4 -union [list e2] -iexpand nswe -ipadx 2

        set S [$self style create image -orient horizontal]
        $self style elements $S {e4 e1 e2 e5}
        $self style layout $S e1 -expand ns
        $self style layout $S e2 -padx 0 -squeeze x -expand ns
        $self style layout $S e4 -union [list e1] -iexpand nswe -ipadx 2
        $self style layout $S e5 -padx 0 -squeeze x -expand nswe
                
        $self notify install event Header
        $self notify install detail Header invoke
        
        $self notify install event Drag
        $self notify install detail Drag begin
        $self notify install detail Drag end
        $self notify install detail Drag receive
        
        $self notify install event Edit
        $self notify install detail Edit accept
        
        
        $self notify bind $self <Edit-accept> {
            %T item text %I 0 %t
        }
        set SortColumn 0
        $self notify bind $self <Header-invoke> [mymethod headerinvoke %C]
        
        $self configurelist $args
    }
    onconfigure -columns {value} {
        set options(-columns) $value

        set w0 [font measure [$self cget -font] 0]
        set itemStyle ""
        set idx 0
        foreach i [list edit sensitive dragimage] {
            set ::TreeCtrl::Priv($i,$self) ""
        }
        foreach "width name justify type" $value {
             $self column create -text $name -width [expr {$w0*$width}] \
                -tag $name -justify $justify
            lappend itemStyle $idx $type
            switch $type {
                imagetext {
                    #lappend ::TreeCtrl::Priv(edit,$self) [list e2 e3]
                    lappend ::TreeCtrl::Priv(sensitive,$self)  \
                            [list $idx $type e1 e2]
                    lappend ::TreeCtrl::Priv(dragimage,$self)  \
                            [list $idx $type e1 e2]
                }
                text {
                    #lappend ::TreeCtrl::Priv(edit,$self) [list e2 e3]
#                     lappend ::TreeCtrl::Priv(sensitive,$self)  \
#                             [list $idx $type e2]
                    lappend ::TreeCtrl::Priv(dragimage,$self) \
                            [list $idx $type e2]
                }
                image {
#                     lappend ::TreeCtrl::Priv(sensitive,$self)  \
#                             [list $idx $type e1]
                    lappend ::TreeCtrl::Priv(dragimage,$self) \
                            [list $idx $type e1]
                }
            }
            incr idx
        }
#        set ::TreeCtrl::Priv(edit,$self) [list e2 e3]
#         set ::TreeCtrl::Priv(edit,$self) {e2}
#         set ::TreeCtrl::Priv(sensitive,$self) [list \
#                 [list [lindex $value 1] [lindex $value 3] e1 e2] \
#             ]
#         set ::TreeCtrl::Priv(dragimage,$self) [list \
#                 [list [lindex $value 1] [lindex $value 3] e1 e2] \
#         ]
        bindtags $self [list $self TreeCtrlFileList TreeCtrl [winfo toplevel $self] all]
    }
    method insert { index list } {
        if { $index ne "end" } { error "only implemented index end in insert" }

        set item [$self item create]
        eval [list $self item style set $item] $itemStyle

        set desc ""
        set idx 0
        foreach "- - - type" $options(-columns) {
            switch $type {
                imagetext {
                    foreach "img txt" [lindex $list $idx] break
                    # dirty trick to avoid a crash in tktreectrl
                    if { $txt eq "" } { set txt " " }
                    set selimg ${img}::selected
                    if { [lsearch [image names] $selimg] == -1 } {
                        image create photo $selimg
                        $selimg copy $img
                        imagetint $selimg $SystemHighlight 128
                    }
                    lappend desc [list [list e1 -image [list $selimg {selected} $img {}]] \
                            [list e2 -text $txt]]
                }
                text {
                    set txt [lindex $list $idx]
                    if { $txt eq "" } { set txt " " }
                    lappend desc [list [list e2 -text $txt]]
                }
                image {
                    foreach "img txt" [lindex $list $idx] break
                    if { $txt eq "" } { set txt " " }
                    lappend desc [list [list e1 -image $img] [list e5 -data $txt]]
                }
            }
            incr idx
        }
        eval [list $self item complex $item] $desc
        $self item lastchild root $item
        set ::TreeCtrl::Priv(DirCnt,$self) $item
    }
    method headerinvoke { C } {
        if {$C == $SortColumn} {
            if {[$self column cget $SortColumn -arrow] eq "down"} {
                set order -increasing
                set arrow up
            } else {
                set order -decreasing
                set arrow down
            }
        } else {
            if {[$self column cget $SortColumn -arrow] eq "down"} {
                set order -decreasing
                set arrow down
            } else {
                set order -increasing
                set arrow up
            }
            $self column configure $SortColumn -arrow none
            set SortColumn $C
        }
        set type [lindex $options(-columns) [expr {$C*4+3}]]
        $self column configure $C -arrow $arrow
        if { $type eq "image" } {
            $self item sort root $order -column $C -element e5 -dictionary
        } else {
            $self item sort root $order -column $C -dictionary
        }
    }
    method sortcolumn {} {
        return $SortColumn
    }
    method sortorder {} {
        if {[$self column cget $SortColumn -arrow] eq "down"} {
            return decreasing
        } else {
            return increasing
        }
    }
    method sortbycolumn { col { sortorder -increasing } } {

        switch -- $sortorder {
            "-increasing" { set arrow up }
            "-decreasing" { set arrow down }
        }
        $self column configure $SortColumn -arrow none
        set SortColumn $col

        set type [lindex $options(-columns) [expr {$col*4+3}]]
        $self column configure $col -arrow $arrow
        if { $type eq "image" } {
            $self item sort root $sortorder -column $col -element e5 -dictionary
        } else {
            $self item sort root $sortorder -column $col -dictionary
        }
    }
    method get { first { last "" } } {
        set ret ""
        if { $last ne "" } {
            for { set i $first } { $i <= $last } { incr i } {
                lappend itemList $i
            }
        } else { set itemList $first }
        set idx 0
        foreach i $itemList {
            set id [$self index "rnc $i 0"]
            set retel ""
            foreach "- - - type" $options(-columns) {
                switch $type {
                    imagetext - text {
                        lappend retel [$self item element cget $id $idx e2 -text]
                    }
                    image {
                        lappend retel [$self item element cget $id $idx e5 -data]
                    }
                }
                incr idx
            }
            lappend ret $retel
        }
        if { [llength $itemList] == 1 } {
            return [lindex $ret 0]
        } else {
            return $ret
        }
    }
    method selection_r { what args } {

        switch $what {
            set - add {
                if { [llength $args] != 1 } {
                    error "error in TreeCtrlList selection"
                }
                if { ![string is integer -strict [lindex $args 0]] } {
                    return [$self _selection add [lindex $args 0]]
                } else {
                    return [$self _selection add "rnc [lindex $args 0] 0"]
                }
            }
            includes {
                if { [llength $args] != 1 } {
                    error "error in TreeCtrlList selection"
                }
                if { ![string is integer -strict [lindex $args 0]] } {
                    return [$self _selection includes [lindex $args 0]]
                } else {
                    return [$self _selection includes "rnc [lindex $args 0] 0"]
                }
            }
            clear {
                if { [llength $args] < 0 || [llength $args] > 2 } {
                    error "error in TreeCtrlList selection"
                }
                if { [llength $args] == 0 } {
                    return [$self _selection clear]
                }
                if { [lindex $args 0] eq "last" } {
                    set first last
                } else { set first [$self index "rnc [lindex $args 0] 0"] }
                if { [llength $args] == 1 } {
                    return [$self _selection clear $first]
                }
                if { [lindex $args 1] eq "last" } {
                    set last last
                } else { set last [$self index "rnc [lindex $args 1] 0"] }
                return [$self _selection clear $first $last]
            }
            default {
                return [eval [list $self _selection $what] $args]
            }
        }
        error "error in TreeCtrlList selection"
    }
    method curselection {} {
        set ret ""
        foreach i [$self _selection get] {
            lappend ret [lindex [$self item rnc $i] 0]
        }
        return $ret
    }
    method delete { first { last "" } } {
        if { $first == 0 && $last eq "end" } {
            $self item delete 0 last
            return
        }
        if { $last ne "" } {
            for { set i $first } { $i <= $last } { incr i } {
                lappend itemList $i
            }
        } else { set itemList $first }
        foreach i $itemList {
            $self item delete "rnc $i 0"
        }
    }
}


################################################################################
#    toolbarmacros
################################################################################

# Fields in macrosdata:
# Number
# Group
# Description
# Accelerators
# Icon
# InToolbar
# Active
# PrePost
# CreationDate
# ModificationDate
# Code

namespace eval toolbarmacros {
    variable _isinit 0    
    variable preferences
    variable _complete_width ""
    variable macrowindow ""
}

namespace eval toolbarmacros::macrospace {
    variable macrosdata
}

proc toolbarmacros::Init {} {
    variable _isinit
    variable preferences
    variable macrowindow

    set _isinit 1

    set preferences(toolbar_one_col) 1

    toolbarmacros::ReadMacros
    #toolbarmacros::UpdateToNewThemeStyleIfNeeded
    if { 0 } {
        toolbarmacros::Create
        toolbarmacros::_update_MacrosList $macrowindow
    }
    toolbarmacros::ApplyMacrosBindings
}
#proc toolbarmacros::UpdateToNewThemeStyleIfNeeded { } {
#        global GidPriv GiDPrivToolBar
#        TransformMacrosToolbarImages
#}


proc toolbarmacros::Create { { type "DEFAULT INSIDETOP"} } {
    global GidPriv GiDPrivToolBar
    variable _isinit

    if { !$_isinit} {
        ::toolbarmacros::Init
    }
    #create_images

    set title [_ "Macros toolbar"]
    set name MacrosToolbar
    set geomname PrePostMacrosToolbarWindowGeom
    set windowname PrePostMacrosToolbarWindow
    set w .gid.bitmapsMacrosToolbar

    DestroySlave $w

    AddNewToolbar $name $geomname toolbarmacros::Create $title

    if { [info exists GidPriv($geomname)] } {
        if { [lindex $type 0] != "DEFAULT" } {            
            set GidPriv($geomname) [list $type {} 1 [list toolbarmacros::Create $type]]
        }
        if { [lindex $GidPriv($geomname) 0] == "NONE" } {
            return ""
        }
    } elseif { [lindex $type 0] == "DEFAULT" && [lindex $type 1] != "" } {
      set GidPriv($geomname) [list [lindex $type 1] {} 1 [list toolbarmacros::Create [lindex $type 1]]]
    }

    set what [GetCurrentPrePostMode] 

    if { ![ info exists GidPriv($geomname)] || \
            ![string match INSIDE* [lindex $GidPriv($geomname) 0]] } {
        InitWindow2 $w -title $title -geometryvariable $geomname \
            -initcommand toolbarmacros::Create "" -ontop -nodestroy
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
        $w configure -background $GidPriv(Color,ToolbarBg)
        if { [ winfo width $w] > [ winfo height $w]} {
            set orient horizontal
        } else {
            set orient vertical
        }
    } else {
        set vv $GidPriv($geomname)
        set GidPriv($geomname) $vv
        set GiDPrivToolBar($geomname) $w
        set GidPriv($windowname) $w

        ttk::frame $w -style Horizontal.ForcedFrame

        bind $w <Destroy> "+ unset GiDPrivToolBar($geomname)"
        regexp {([a-zA-Z]*)([0-9]*)} [lindex $GidPriv($geomname) 0] {} \
                where pos
      set widget ""
        switch $where {
            INSIDETOP {
              GridInside $geomname $w .gid.top "we"
              set orient horizontal
            }
            INSIDELEFT {
              GridInside $geomname $w .gid.left "ns"
              set orient vertical
            }
            INSIDEBOTTOM {
              GridInside $geomname $w .gid.bottom "we"
              set orient horizontal
            }
            INSIDERIGHT {
              GridInside $geomname $w .gid.right "ns"
                set orient vertical
            }
        }
        switch $orient {
                horizontal {
                        SetStyleHorizontalVertical $w horizontal
                }
                vertical {
                        SetStyleHorizontalVertical $w vertical
                }
        }    
        if { $widget != ""} {
            pack configure $w -before $widget
        }
    }
    if { [winfo class $w] == "Toplevel" } {
        bind $w <Leave> [list wm title $w $title]
        foreach i [bind .gid] {
            bind $w $i [bind .gid $i]
        }
    }
    #toolbar_create $w
    bind $w <Configure> [list +toolbarmacros::toolbar_create $w]

    GidHelpT $w $title
    return $w
}

proc toolbarmacros::toolbar_create { w } {
    variable afterid

    if { [info exists afterid] } { after cancel $afterid }
    set afterid [after idle toolbarmacros::_toolbar_createDo $w]
}

proc toolbarmacros::_toolbar_createDo { w { force "" } } {
    global GidPriv
    variable afterid
    variable toolbar_last_len
    variable preferences

    unset -nocomplain afterid
    update idletasks

    if { ![winfo exists $w] } { return }

    if { [winfo width $w] > [winfo height $w] } {
        set orient horizontal
    } else { set orient vertical }

    switch $orient {
        vertical {
            set len [winfo height $w]
        }
        horizontal {
            set len [winfo width $w]
        }
    }
    if { $force eq "" && [winfo exists $w.w0] && [info exists toolbar_last_len] && \
        $toolbar_last_len == $len } {
        return
    }
    set toolbar_last_len $len

    switch $orient {
        vertical {
            foreach "sticky_s orient_s padx_s pady_s" [list new horizontal 0 2] break
        }
        horizontal {
            foreach "sticky_s orient_s padx_s pady_s" [list wns vertical 2 0] break
            #Separator $w.sep1 -orient vertical
        }
    }

    #set isrecording [GiD_RecordBatch isrecording]
    set isrecording [toolbarmacros::RecordBatch isrecording]
    if { $isrecording == ""} {
        # may be recordbatch is not registered yet (mode client)...
        set isrecording 0
    }

    if { $isrecording} {
        set cmds [list [::gid_themes::GetImage EndRecord.png toolbar] [_ "Press here to end recording macro"] \
                      [list toolbarmacros::EndRecording $w toolbar] ""\
                      [::gid_themes::GetImage edit_file.png toolbar] [_ "Edit macros..."] \
                      toolbarmacros::MacrosWindow "" \
                      - - - -]
    } else {
        set cmds [list [::gid_themes::GetImage Record.png toolbar] [_ "Record macro"] \
                      [list toolbarmacros::StartRecording $w toolbar] ""\
                      [::gid_themes::GetImage edit_file.png toolbar] [_ "Edit macros..."] \
                      toolbarmacros::MacrosWindow "" \
                      - - - -]
    }

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata

    set prepost [GetCurrentPrePostMode]
    set lst ""
    foreach i [array names macrosdata *,Number] {
        regexp {^[^,]*} $i name
        if { !$macrosdata($name,InToolbar) || !$macrosdata($name,Active) } {
            continue
        }
        if { $prepost eq "PRE" && $macrosdata($name,PrePost) eq "post" } {
            continue
        }
        if { $prepost eq "POST" && $macrosdata($name,PrePost) eq "pre" } {
            continue
        }
        lappend lst [list $macrosdata($i) $name]
    }
    set lst [lsort -integer -index 0 $lst]

    foreach i $lst {
        set name [lindex $i 1]
        if { $name eq "-" } {
            lappend cmds [icon_chooser::get_default_macro_image] macro "" ""
        } else {                                        
            set help $name\n[_ $macrosdata($name,Description)]\n
            append help [_ "Creation date: %s" $macrosdata($name,CreationDate)]\n
            append help [_ "Modification date: %s" $macrosdata($name,ModificationDate)]\n
            lappend cmds [icon_chooser::get_macros_images $name] [_ $macrosdata($name,Description)] \
                [list ::toolbarmacros::macrospace::$name] $name
        }         
    }
    set inum 0
    if { [winfo exists $w.w0] } {
       while { [winfo exists $w.w$inum] } {
            if { $force ne "" } {
                destroy $w.w$inum
            } else {
                grid forget $w.w$inum
            }
            incr inum
        }
    }


    set maxrow 0
    set maxcol 0
    set rlen 0
    foreach "row col inum" [list 0 0 0] break
    foreach "img help cmd macroname" $cmds {    
        if { $img eq "-" } {
            if { ![winfo exists $w.w$inum] } {
                #Separator $w.w$inum -orient $orient_s
                switch $orient { 
                    horizontal { ttk::label $w.w$inum -image [::gid_themes::GetImage sep_vert.png toolbar] -style Horizontal.ForcedLabel }
                    vertical { ttk::label $w.w$inum -image [::gid_themes::GetImage sep_hori.png toolbar] -style Vertical.ForcedLabel }
                }
            }
            foreach "sticky padx pady" [list $sticky_s $padx_s $pady_s] break
            switch $orient horizontal { set isseparator(col,$col) 1 } vertical { set isseparator(row,$row) 1 }
        
        } else {
            if { ![winfo exists $w.w$inum] } {
                switch $orient {
                    vertical {
                        ttk::button $w.w$inum -image $img -style Vertical.IconButton
                    }
                    horizontal {
                        ttk::button $w.w$inum -image $img -style Horizontal.IconButton
                    }
                }                
                EnterCommand $w.w$inum [concat -np- $cmd]
                GidHelp $w.w$inum $help
                if { $macroname ne "" } {
                    bind $w.w$inum <$::gid_central_button> [namespace code [list ToolbarContextual \
                                %W $macroname $help %X %Y]]
                    bind $w.w$inum <$::gid_right_button> [namespace code [list ToolbarContextual \
                                %W $macroname $help %X %Y]]
                }
            }
            foreach "sticky padx pady" [list nw 0 0] break
        }
        switch $orient {
            vertical {
                set len [winfo height $w]
                #set rlen [winfo reqheight $w]
                incr rlen [winfo reqheight $w.w$inum]
            }
            horizontal {
                set len [winfo width $w]
                #set rlen [winfo reqwidth $w]
                incr rlen [winfo reqwidth $w.w$inum]
            }
        }
        if { $inum > 1 && $len < $rlen } {
            if { ![ info exists preferences(toolbar_one_col)] } {
                set preferences(toolbar_one_col) 1
            }
            switch $orient {
                vertical {
                    if { $preferences(toolbar_one_col) } {
                        break
                    }  
                    incr col            
                    if {![winfo exists $w.separator$col]} {
                        ttk::frame $w.separator$col -style SeparatorToolbar.TFrame    
                    }
                    grid $w.separator$col -row 0 -column $col -rowspan 100 -sticky news
                    
                    incr col
                    set maxcol $col
                    set row 0
                    set rlen [winfo reqheight $w.w$inum]
                }
                horizontal {
                    if { $preferences(toolbar_one_col) } {
                        break
                    }
                    incr row
                    if {![winfo exists $w.separator$row]} {
                        ttk::frame $w.separator$row -style SeparatorToolbar.TFrame              
                    }           
                    grid $w.separator$row -row $row -column 0 -columnspan 100 -sticky news
                    
                    incr row
                    set maxrow $row
                    set col 0
                    set rlen [winfo reqwidth $w.w$inum]
                }
            }
        }

        switch $orient {
            vertical {
                if { $maxrow < $row} { set maxrow $row }
            }
            horizontal {
                if { $maxcol < $col} { set maxcol $col }
            }
        }
#WarnWinText "-padx $padx -pady $pady"
        grid $w.w$inum -row $row -column $col -sticky $sticky \
            -padx $padx -pady $pady
        grid rowconfigure $w $row -weight 0
        grid columnconfigure $w $col -weight 0
                
        switch $orient vertical { incr row } horizontal { incr col }

        if { ([info exists isseparator(row,$row)] || [info exists isseparator(col,$col)]) && $img != "-" } {
            switch $orient vertical { incr row } horizontal { incr col }
        }
        incr inum
    }
    switch $orient {
        vertical {            
            incr col        
            incr maxcol
            if {![winfo exists $w.separator$maxcol]} {
                ttk::frame $w.separator$maxcol -style SeparatorToolbar.TFrame           
            }
            grid $w.separator$maxcol -row 0 -column $maxcol -rowspan 100 -sticky news 
            
        }
        horizontal {            
            incr row
            incr maxrow
            if {![winfo exists $w.separator$maxrow]} {
                ttk::frame $w.separator$maxrow -style SeparatorToolbar.TFrame              
            }           
            grid $w.separator$maxrow -row $maxrow -column 0 -columnspan 100 -sticky news 
            
        }
    }
    grid rowconfigure $w $maxrow -weight 1
    grid columnconfigure $w $maxcol -weight 1

        #     for { set i [expr {$inum-1}] } { $i >= 2 } { incr i -1 } {
        #         update idletasks
        #         switch $orient {
        #             vertical {
        #                 set len [winfo height $w]
        #                 set rlen [winfo reqheight $w]
        #             }
        #             horizontal {
        #                 set len [winfo width $w]
        #                 set rlen [winfo reqwidth $w]
        #             }
        #         }
        #         if { $len < $rlen } { grid forget $w.w$i } else { break }
        #     }
}

proc toolbarmacros::GetDetailsIcon { what} {
    set details_icon [::gid_themes::GetImage ArrowRight.png toolbar]
    if { $what == "complete"} {
        set details_icon [::gid_themes::GetImage ArrowLeft.png toolbar]
    }
    return $details_icon
}

proc toolbarmacros::ToggleDetailsFrame { w changegeometry w_details_button} {
    variable _complete_width
    wm withdraw $w
    update idletasks

    if { ![winfo exists $w.pw] } {
        set wf1 [winfo width $w.f1]
        if { $wf1 <= 1 } { set wf1 [winfo reqwidth $w.f1] }
        grid forget $w.f1
#         panedwindow $w.pw
#         $w.pw add $w.f1 -sticky nsew -padx 1 -pady 1 -width $wf1
#         $w.pw add $w.f2 -sticky nsew -padx 1 -pady 1

        PanedWindow $w.pw
        set p1 [$w.pw add -weight $wf1 -minsize 70]
        set p2 [$w.pw add -weight [winfo reqwidth $w.f2] -minsize 190]
        grid $w.f1 -in $p1 -sticky nsew -padx 3 -pady 3
        grid columnconfigure $p1 0 -weight 1
        grid rowconfigure $p1 0 -weight 1
        grid $w.f2 -in $p2 -sticky nsew -padx 3 -pady 3
        grid columnconfigure $p2 0 -weight 1
        grid rowconfigure $p2 0 -weight 1

        raise $w.f1
        raise $w.f2
        grid $w.pw -sticky nsew -row 0 -column 0 -padx 0 -pady 0
        set newwidth [expr {[winfo width $w]+[winfo reqwidth $w.f2]+0}]
        if { ( $_complete_width != "") && ( $_complete_width > $newwidth)} {
            set newwidth $_complete_width
        }
        InitWindow_ModifyInitComm $w PrePostMacrosWindowGeom [list toolbarmacros::MacrosWindow complete]
        $w_details_button configure -image [ GetDetailsIcon complete]
    } else {
        set _complete_width [winfo width $w]
        destroy $w.pw
        grid $w.f1 -sticky nsew -row 0 -column 0 -padx 3 -pady 3
        set newwidth [expr {[winfo width $w.f1]}]
        InitWindow_ModifyInitComm $w PrePostMacrosWindowGeom [list toolbarmacros::MacrosWindow simple]
        $w_details_button configure -image [ GetDetailsIcon simple]
    }

    if { $changegeometry } { 
        wm geometry $w ${newwidth}x[winfo height $w] 
    }
    wm deiconify $w
}

proc toolbarmacros::ToolbarContextual { button name help x y } {
    variable macrowindow
    set menu $button.menu
    destroy $menu
    menu $menu -tearoff 0    
    $menu add command -label [_ "Help"] -command [list PopupTransparentInfo $help $x $y $button 0 -1]
    $menu add command -label [_ "Configure toolbars"] -command TOBegin
    $menu add command -label [_ "Change appearance"] -command [ list PreferencesWindow graphical]
    $menu add command -label [_ "Bring up all windows"] -command BringUpAllGiDWindows
    $menu add separator
    $menu add command -label [_ "Rename"] -command [list toolbarmacros::_rename_copy_macro $macrowindow rename $name]
    $menu add command -label [_ "Change icon"] -command [list toolbarmacros::ChangeToolbarIcon $button $name]
    $menu add command -label [_ "Add accelerator"] -command [list toolbarmacros::FastAcceleratorsWindow $button $name]
    $menu add command -label [_ "Delete"] -command [list toolbarmacros::DeleteMacro $button [list $name]]
    $menu add separator
    $menu add command -label [_ "Edit window"] -command [list toolbarmacros::MacrosWindow complete [list $name]]    
    GiD_PopupMenu $menu $x $y
}


proc toolbarmacros::OnAfterProcess { words is_view } {
    variable _accumulated_commands
    lappend _accumulated_commands $words
}

# toolbarmacros::RecordBatch procedure to replace GiD_RecordBatch because now the batch is different
# e.g. doing 'DoFilesNew AUTO' will clear the file content (the old keywords must be avoided by Undo)
# value: begin end isrecording
proc toolbarmacros::RecordBatch { value } {
    variable _accumulated_commands
    variable _isrecording
    set result ""
    set event_after_process {GiD_Event_AfterProcess toolbarmacros::OnAfterProcess GENERAL gid}
    if { $value == "begin" } {
        if { ![GiD_GetIsRegisteredEventProc {*}$event_after_process] } {
            GiD_RegisterEvent {*}$event_after_process
        }
        set _isrecording 1
        set result 0
    } elseif { $value == "end" } {
        if { [GiD_GetIsRegisteredEventProc {*}$event_after_process] } {
            GiD_UnRegisterEvent {*}$event_after_process
        }
        if { [info exists _accumulated_commands] } {
            set result $_accumulated_commands
            set _accumulated_commands [list]
        } else {
            set result [list]
        }
        set _isrecording 0
    } elseif { $value == "isrecording" } {
        if { [info exists _isrecording] } {
          set result $_isrecording
        } else {
          set result 0
        }
    } else {
        error "unexpected value $value"
    }
    return $result
}

proc toolbarmacros::StartRecording { w type args } {
    if { $type eq "toolbar" } {
        foreach i [winfo children $w] {
            if { [winfo class $i] eq "TButton" && \
                [$i cget -image] eq [::gid_themes::GetImage Record.png toolbar] } {
                $i configure -image [::gid_themes::GetImage EndRecord.png toolbar] -command \
                    [list toolbarmacros::EndRecording $w $type]
                GidHelp $i [_ "Press here to end recording macro"]
                break
            }
        }
    } elseif { $type eq "window" } {
        foreach "bbox idx" $args break
        $bbox itemconfigure $idx -image [::gid_themes::GetImage EndRecord.png menu] -command \
            "[list toolbarmacros::EndRecording $w $type] $args"
        GidHelp $bbox [_ "Press here to end recording macro"]

    }
    #GiD_RecordBatch begin
    toolbarmacros::RecordBatch begin
}

proc toolbarmacros::_ReorderMacrosNumbers { { hole_interval "" } } {

    if { $hole_interval eq "" } {
        foreach "h_start h_end" [list 0 0] break
    } else {
        foreach "h_start h_end" $hole_interval break
    }

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata

    set lst ""
    foreach i [array names macrosdata *,Number] {
        regexp {^[^,]*} $i name
        lappend lst [list $macrosdata($i) $name]
    }
    set lst [lsort -integer -index 0 $lst]
    set idx 1
    for { set i 0 } { $i < [llength $lst] } { incr i } {
        while { $idx >= $h_start && $idx <= $h_end } { incr idx }
        lset lst $i 0 $idx
        incr idx
    }
    foreach i $lst {
        foreach "number name" $i break
        set macrosdata($name,Number) $number
    }
}

proc toolbarmacros::EndRecording { w type args } {
    if { $type eq "toolbar" } {
        foreach i [winfo children $w] {
            if { [winfo class $i] eq "Button" && \
                [$i cget -image] eq [::gid_themes::GetImage EndRecord.png toolbar] } {
                $i configure -image [::gid_themes::GetImage Record.png toolbar] -command \
                    [list toolbarmacros::StartRecording $w $type]
                GidHelp $i [_ "Record macro"]
                break
            }
        }
    } elseif { $type eq "window" } {
        foreach "bbox idx" $args break
        $bbox itemconfigure $idx -image [::gid_themes::GetImage Record.png toolbar] -command \
            "[list toolbarmacros::StartRecording $w $type] $args"
        GidHelp $bbox [_ "Record macro"]

    }

    #set data [GiD_RecordBatch end]
    set data [toolbarmacros::RecordBatch end]

    regsub -all {(?n)\*{5}MARK .*$} $data {} data
    toolbarmacros::CreateMacro $data
}

proc toolbarmacros::CreateMacro { data { name "" } { desc "" } { acc "" } { update yes } } {
    variable macrowindow

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata

    toolbarmacros::_ReorderMacrosNumbers [list 1 1]

    set macrosnames ""
    foreach i [array names macrosdata *,Number] {
        regexp {^[^,]*} $i name_in
        lappend macrosnames $name_in
    }
    if { $name eq "" } {
        set i 1
        while 1 {
            if { [lsearch -exact $macrosnames Macro$i] == -1 } { break }
            incr i
        }
        set name Macro$i        
    }

    if { $desc eq "" } {
        regsub -all {\mescape\M} $data {} desc
        regsub -all {[ \t]+} $desc { } desc
        set desc [string trim $desc]
        if { [string length $desc] > 200 } {
            set desc [string range $desc 0 196]...
        }
    }
    set now [clock format [clock seconds] -format "%Y-%m-%d %H:%M:%S"]

    set macrosdata($name,Number) 1
    set macrosdata($name,Accelerators) $acc
    set macrosdata($name,Description) $desc
    set macrosdata($name,Group) ""
    set macrosdata($name,InToolbar) 1
    set macrosdata($name,Active) 1
    set macrosdata($name,PrePost) prepost
    set macrosdata($name,Icon) ""
    set macrosdata($name,CreationDate) $now
    set macrosdata($name,ModificationDate) $now
    set macrosdata($name,IsStandard) 0

    set body ""
    set body_pr ""
    foreach line [split $data \n] {
        if { [string trim $line] ne "" } {
            if { [string match -np-* $line] } {
                if { $body_pr ne "" } {
                    if { [string index $body_pr 0] == "'" } {
                        #transparent command start by '
                        append body "GiD_Process $body_pr\n"
                    } else {
                        append body "GiD_Process MEscape $body_pr\n"
                    }
                    set body_pr ""
                }
                append body "[string trim [string range $line 4 end]]\n"
            } else {
                append body_pr "$line "
            }
        }
    }
    if { $body_pr ne "" } {
        if { [string index $body_pr 0] == "'" } {
            #transparent command start by '
            append body "GiD_Process $body_pr\n"
        } else {
            append body "GiD_Process MEscape $body_pr\n"
        }
    }
    set macrosdata($name,Code) $body
    namespace eval macrospace [list proc $name {} $body]
  
    set icon_chooser::macros_images($name) [icon_chooser::get_default_macro_image]

    if { $update eq "yes" } {
        toolbarmacros::_update_MacrosList $macrowindow 0
        toolbarmacros::_update_toolbar
        toolbarmacros::SaveMacros
    }
}

proc toolbarmacros::ApplyMacrosBindings {} {
    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    set prepost [GetCurrentPrePostMode]
    set lst ""
    foreach i [array names macrosdata *,Number] {
        regexp {^[^,]*} $i name
        lappend lst [list $macrosdata($i) $name]
    }
    foreach i [lsort -decreasing -integer -index 0 $lst] {
        set name [lindex $i 1]
        if { !$macrosdata($name,Active) } { continue }
       if { $prepost eq "PRE" && $macrosdata($name,PrePost) eq "post" } {
            continue
        }
        if { $prepost eq "POST" && $macrosdata($name,PrePost) eq "pre" } {
            continue
        }
        foreach j $macrosdata($name,Accelerators) {
            set bind [_manage_accelerators_short2long $j]
            bind .gid $bind "[list ::toolbarmacros::macrospace::$name] ;break"
        }
    }
}

proc toolbarmacros::FastAcceleratorsWindow { button name } {   
    set w [toplevel $button.faw]
    if { $::tcl_platform(platform) == "windows" } {       
        wm attributes $w -toolwindow 1
    }
    wm overrideredirect $w 1
    set x [expr {[winfo rootx $button]+[winfo width $button]}]
    set y [winfo rooty $button]
    wm geometry $w +$x+$y
    wm title $w [_ "Enter accelerator"]

    $w configure -borderwidth 2 -relief groove

    ttk::button $w.l1 -image [::gid_themes::GetImage EndRecord.png menu] -command [list destroy $w]

    ttk::label $w.l2 -text [_ "Accelerators"]:
    ttk::label $w.l22 -textvariable toolbarmacros::macrospace::macrosdata($name,Accelerators)
    ttk::label $w.l3 -text [_ "New accelerator"]:
    ttk::entry $w.e1 -width 7
    bind $w.e1 <KeyPress> "[namespace code [list _enter_accelerators_here_do \
                $w.e1 %K %A]] ; break"
    bind $w.e1 <Return> [namespace code [list _manage_accelerators_add $w.e1 $name]]
    $w.e1 delete 0 end
    ButtonBox $w.b1 -spacing 0 -padx 1 -pady 1 -homogeneous 1
    set b [$w.b1 add -image [::gid_themes::GetImage ok.png menu] \
               -command [namespace code [list _manage_accelerators_add $w.e1 $name]]]  
    GidHelp $b [_ "Define new accelerator"]

    grid $w.l1 - - -sticky ne
    grid $w.l2 $w.l22 - -pady "5 2" -sticky nw -padx 2
    grid $w.l3 $w.e1 $w.b1 -sticky nw -padx 2 -pady "0 3"

    focus $w.e1
    grab $w
    bind $w <Escape> [list destroy $w]
    bind $w.e1 <Escape> "[list destroy $w] ; break"

    set_bbox_borderwidth $w.b1 1
}

proc toolbarmacros::_update_toolbar {} {
    _toolbar_createDo .gid.bitmapsMacrosToolbar force
}

proc toolbarmacros::_update_MacrosList { w { selnums "" } { selnames "" } } {
    variable tablelists
    variable showusermacrosonly
    variable filterentry
    variable filterentry_onlygroup
    variable afterfilterid
    variable groups

    if { [info exists afterfilterid] } { unset afterfilterid }
    if { ![winfo exists $w] } { return }
    set t $tablelists($w)

    if { $selnums eq "" } {
        set yviewargs [list moveto [lindex [$t yview] 0]]
    } else {
        # to make treectnrl work
        set yviewargs [list moveto 0]
        #set yviewargs [lindex $selnums 0]
    }
    if { $selnums eq "" && $selnames eq "" } {
        set selnums [$t curselection]
    }
    if { $selnums ne "" } {
        foreach i $selnums {
            lappend selnames [lindex [$t get $i] 1]
        }
    }

    $t delete 0 end

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    set lst ""
    set groups ""
    foreach i [array names macrosdata *,Number] {
        regexp {^[^,]*} $i name
        lappend lst [list $macrosdata($i) $name]
        if { $macrosdata($name,Group) ne "" && \
            [lsearch -exact $groups $macrosdata($name,Group)] == -1 } {
            lappend groups $macrosdata($name,Group)
        }
    }
    set lst [lsort -integer -index 0 $lst]

    if { [catch { regexp $filterentry {} }] } {
        set rex (?qi)$filterentry
    } else { 
        set rex (?i)$filterentry 
    }
    foreach i $lst {
        lassign $i number name
        if { $showusermacrosonly && $macrosdata($name,IsStandard)} {
            continue            
        }
        if { $filterentry_onlygroup == 0 && $filterentry ne "" && ![regexp $rex $name] && \
            ![regexp $rex $macrosdata($name,Description)] && \
            ![regexp $rex $macrosdata($name,Group)] } {
            continue
        }
        if { $filterentry_onlygroup == 1 && ![regexp $rex $macrosdata($name,Group)] } {
            continue
        }
       
        
        set icon [icon_chooser::get_macros_images $name]
        
        set intimg [expr {$macrosdata($name,InToolbar)?[::gid_themes::GetImage ok.png menu]:[::gid_themes::GetImage blank.png menu]}]
        set actimg [expr {$macrosdata($name,Active)?[::gid_themes::GetImage ok.png menu]:[::gid_themes::GetImage blank.png menu]}]
        switch $macrosdata($name,PrePost) {           
            pre { set ppimg [::gid_themes::GetImage surface.png toolbar] }
            post { set ppimg [::gid_themes::GetImage PostBarContourFill.png toolbar] }
            prepost { set ppimg [::gid_themes::GetImage prepost.png toolbar] }
        }
        
        $t insert end [list $number [list $icon $name] $macrosdata($name,Accelerators) \
                [list $intimg $macrosdata($name,InToolbar)] \
                [list $actimg $macrosdata($name,Active)] \
                [list $ppimg $macrosdata($name,PrePost)] \
                $macrosdata($name,Group) \
                [_ $macrosdata($name,Description)] \
                $macrosdata($name,CreationDate) \
                $macrosdata($name,ModificationDate)]



        if { [lsearch -exact $selnames $name] != -1 } {
            $t selection_r add last
        }
    }
   set col [$t sortcolumn]
   if { $col != -1 } {
       $t sortbycolumn $col -[$t sortorder]
    }
    if { [$t numitems] > 1 } {
        foreach i $selnums {
            $t selection_r add $i
        }
    } else {
        $t selection_r clear
    }
    eval [list $t yview] $yviewargs

    _changeMacrosList_selection $w
    ApplyMacrosBindings
}

proc toolbarmacros::_filter_MacrosList { w } {
    variable afterfilterid
    if { [info exists afterfilterid] } {
        after cancel $afterfilterid
    }
    set afterfilterid [after 100 [namespace code [list _update_MacrosList $w ""]]]
}

proc toolbarmacros::_changeMacrosList_selection_handler { w { update_details yes } } {
    variable afterCMLid

    if { [info exists afterCMLid] } {
        after cancel $afterCMLid
    }
    set afterCMLid [after 100 [namespace code [list _changeMacrosList_selection $w $update_details]]]
}
proc toolbarmacros::_changeMacrosList_selection { w { update_details yes } } {
    variable tablelists
    variable macroname
    variable macroaccelerators
    variable macrointoolbar
    variable macroactive
    variable macroprepost
    variable macrodescription
    variable macrogroup
    variable macrocode
    variable macroicon
    variable iconbuttons
    variable Dragging

    set t $tablelists($w)

    set id [lindex [$t curselection] 0]
    if { [info exists Dragging] || [llength [$t curselection]] != 1 } {
        if { $update_details } { update_macrodetails $w }
        set macroaccelerators ""
        set macrointoolbar 0
        set macroactive 0
        set macroprepost prepost
        set macrodescription ""
        set macrogroup ""
        set macrocode ""
        # macroname must be at the end as it activates a handler
        set macroname ""
        set macroicon ""
        return
    }
    set newmacroname [lindex [$t get $id] 1]
    if { $macroname eq $newmacroname && $update_details eq "yes" } { return }
    if { $update_details } { update_macrodetails $w }

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    set lst ""
    foreach i [array names macrosdata *,Number] {
        regexp {^[^,]*} $i name
        lappend lst [list $macrosdata($i) $name]
    }
    set macronames [lsort -integer -index 0 $lst]
    set macroname $newmacroname
    set macroaccelerators $macrosdata($macroname,Accelerators)
    set macrointoolbar $macrosdata($macroname,InToolbar)
    set macroactive $macrosdata($macroname,Active)
    set macroprepost $macrosdata($macroname,PrePost)
    set macrogroup $macrosdata($macroname,Group)
    set macrodescription $macrosdata($macroname,Description)
    set macrocode $macrosdata($macroname,Code)
    set macroicon $macrosdata($macroname,Icon)
    $iconbuttons($w) configure -image [icon_chooser::giveimage $macroicon]
}

proc toolbarmacros::update_macrodetails { w } {
    variable macroname
    variable macroaccelerators
    variable macrointoolbar
    variable macroactive
    variable macroprepost
    variable macrogroup
    variable macrodescription
    variable macrocode
    variable macroicon 
    variable iconbuttons

    if { ![winfo exists $w] } { return }

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    if { ![info exists macroname] || $macroname eq "" || \
        ![info exists macrosdata($macroname,Number)] } {
        return
    }

    set changes 0
    if { $macrosdata($macroname,Accelerators) ne $macroaccelerators } {
        foreach j $macrosdata($macroname,Accelerators) {
            set bind [_manage_accelerators_short2long $j]
            bind .gid $bind ""
        }
        set macrosdata($macroname,Accelerators) $macroaccelerators
        set changes 1
    }
    if { $macrosdata($macroname,InToolbar) != $macrointoolbar } {
        set macrosdata($macroname,InToolbar) $macrointoolbar
        set changes 1
    }
    if { $macrosdata($macroname,Active) != $macroactive } {
        set macrosdata($macroname,Active) $macroactive
        set changes 1
        if { !$macroactive } {
            foreach j $macrosdata($macroname,Accelerators) {
                set bind [_manage_accelerators_short2long $j]
                bind .gid $bind ""
            }
        }
    }
    if { $macrosdata($macroname,PrePost) ne $macroprepost } {
        set macrosdata($macroname,PrePost) $macroprepost
        set changes 1
    }
    if { $macrosdata($macroname,Description) ne $macrodescription } {
        set macrosdata($macroname,Description) $macrodescription
        set changes 1
    }
    if { $macrosdata($macroname,Group) ne $macrogroup } {
        set macrosdata($macroname,Group) $macrogroup
        set changes 1
    }
    if { $macrosdata($macroname,Code) ne $macrocode } {
        set macrosdata($macroname,Code) $macrocode
        namespace eval macrospace [list proc $macroname "" $macrocode]
        set changes 1
    }

    if { $macrosdata($macroname,Icon) ne $macroicon } {
        set macrosdata($macroname,Icon) $macroicon   
        set icon_chooser::macros_images($macroname) [icon_chooser::giveimage $macroicon]
        set changes 1      
    }        

    if { $changes } {
        set now [clock format [clock seconds] -format "%Y-%m-%d %H:%M:%S"]
        set macrosdata($macroname,ModificationDate) $now
        toolbarmacros::_update_MacrosList $w
        toolbarmacros::_update_toolbar
        toolbarmacros::SaveMacros
        ApplyMacrosBindings
    }
}


proc toolbarmacros::_rename_copy_macro { w what { name "" } } {
    variable macroname

    if { $name eq "" } { set name $macroname }
    update_macrodetails $w

    switch $what {
        rename { set tt [_ "Enter new macro name"] }
        copy { set tt [_ "Enter name for the copied macro"] }
    }

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    set lst ""
    set maxnumber 0
    foreach i [array names macrosdata *,Number] {
        regexp {^[^,]*} $i name_in
        lappend lst $name_in
        if { $macrosdata($i) > $maxnumber } { set maxnumber $macrosdata($i) }
    }
    if { [winfo exists $w] } {
        set win $w._ask
    } else { set win .gid._ask }
    dialogwin_snit $win -title $tt -entrytype entry \
        -entrylabel [_ "Name"]: -entrytext $tt: -entrydefault $name
    set action [$win createwindow]
    while 1 {
        if { $action <= 0 } {
            destroy $win
            return
        }
        set newname [string trim [$win giveentryvalue]]
        if { $newname eq "" } {
            WarnWin [_ "Enter a name"] $w
        } elseif { [string match *,* $newname] } {
            WarnWin [_ "Character ',' is not allowed in name"] $w
        } elseif { [lsearch -exact $lst $newname] != -1 } {
            WarnWin [_ "Macro name '%s' already exists" $newname] $w
        } else { break }
        set action [$win waitforwindow]
    }
    destroy $win

    set now [clock format [clock seconds] -format "%Y-%m-%d %H:%M:%S"]
    if { $what eq "rename" } {
        foreach j $macrosdata($name,Accelerators) {
            set bind [_manage_accelerators_short2long $j]
            bind .gid $bind ""
        }
        foreach i [list Number Accelerators InToolbar Active PrePost \
                Description Group Icon \
                CreationDate ModificationDate Code IsStandard] {
            if { [info exists macrosdata($name,$i)] } {
                set macrosdata($newname,$i) $macrosdata($name,$i)
                unset macrosdata($name,$i)
            }
        }        

        namespace eval macrospace [list rename $name $newname]
        set macroname ""
    } else {
        set macrosdata($newname,Number) [incr maxnumber]
        foreach i [list Accelerators InToolbar Active PrePost Group Description \
                Icon Code] {
            if { [info exists macrosdata($name,$i)] } {
                set macrosdata($newname,$i) $macrosdata($name,$i)
            }
        }
        set macrosdata($newname,IsStandard) 0
        namespace eval macrospace [list proc $newname {} \
                $macrosdata($newname,Code)]
        set macrosdata($newname,CreationDate) $now
    }
    set icon_chooser::macros_images($newname) $icon_chooser::macros_images($name)
    
    set macrosdata($newname,ModificationDate) $now
    toolbarmacros::_update_MacrosList $w
    toolbarmacros::_update_toolbar
    toolbarmacros::SaveMacros
}

proc toolbarmacros::FileOperations {w buttonbox } {
    set menu $w.menu
    destroy $menu
    menu $menu -tearoff 0
    $menu add command -label [_ "Import macros"]... -command \
        [namespace code [list toolbarmacros::FileOperations_do $w import]]
    $menu add command -label [_ "Import Default macros"] -command \
        [namespace code [list toolbarmacros::ReadMacrosFromFileAndUpdate [GetGidMacrosDefaultsFilename]]]
    $menu add command -label [_ "Export macros"]... -command \
        [namespace code [list toolbarmacros::FileOperations_do $w export]]
    $menu add command -label [_ "Export selected macros"]... -command \
        [namespace code [list toolbarmacros::FileOperations_do $w export_selection]]

    update idletasks
    set x [expr {[winfo rootx $buttonbox]+[winfo width $buttonbox]-\
            [winfo reqwidth $menu]}]
    set y [expr {[winfo rooty $buttonbox]+[winfo height $buttonbox]}]
    tk_popup $menu $x $y
}

proc toolbarmacros::ReadMacrosFromFileAndUpdate { filename } {
    variable macrowindow
    if { $filename == "" } { return }
    set err [catch { toolbarmacros::ReadMacrosFromFile $filename 0 } errstring]
    if { $err } {
        WarnWin [_ "Could not import macros file '%s' (%s)" $filename $errstring]
        return
    }
    icon_chooser::AfterReadMacros
    toolbarmacros::_update_MacrosList macrowindow
    toolbarmacros::_update_toolbar
    ApplyMacrosBindings
    toolbarmacros::toolbarmacros::SaveMacros
}

proc toolbarmacros::FileOperations_do { w what } {
    variable filetoclose
    variable tablelists

    set types [list [list [_ "TCL files"] [list .tcl]] [list [_ "All files"] *]]

    if { ![info exists ::DefaultDirectories(file)] || ![file isdirectory $::DefaultDirectories(file)]} {
        set ::DefaultDirectories(file) [pwd]
    }
    switch $what {
        import {
            set filename [MessageBoxGetFilename file read [_ "Import macros"] "" $types .tcl 0]
            toolbarmacros::ReadMacrosFromFileAndUpdate $filename
        }
        export {
            set filename [MessageBoxGetFilename file write [_ "Export macros"] "" $types .tcl 0]

            if { $filename == "" } { return }
            set err [catch { toolbarmacros::SaveMacrosInFile $filename } errstring]
            if { $err } {
                WarnWin [_ "Could not export macros file '%s' (%s)" $filename $errstring]
                catch { close $filetoclose }
                return
            }
        }
        export_selection {
            set t $tablelists($w)
            set ids [$t curselection]
            if { [llength $ids] == 0 } {
                WarnWin [_ "Select one or more macros for exporting them"]
                return
            }
            set selnames ""
            foreach id $ids {
                lappend selnames [lindex [$t get $id] 1]
            }
            set filename [MessageBoxGetFilename file write [_ "Export selected macros"] "" $types .tcl 0]
            if { $filename == "" } { return }
            set err [catch { toolbarmacros::SaveMacrosInFile $filename $selnames } errstring]
            if { $err } {
                WarnWin [_ "Could not export macros file '%s' (%s)" $filename $errstring]
                catch { close $filetoclose }
                return
            }
        }
    }
    set ::DefaultDirectories(file) [file dirname $filename]
}

proc toolbarmacros::SaveMacros {} {
    variable filetoclose
    set create_folders 1
    set filename [GetGidMacrosFilename $create_folders]
    set err [catch { toolbarmacros::SaveMacrosInFile $filename } errstring]
    if { $err } {
        WarnWin [_ "Could not save macros file '%s' (%s)" $filename $errstring]
        catch { close $filetoclose }
    }
}

proc toolbarmacros::SaveMacrosInFile { filename { names "" } } {
    variable filetoclose
    variable preferences

    set fout [open $filename w]
    set filetoclose $fout
                
    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata

    set lst ""
    foreach i [array names macrosdata *,Number] {
        regexp {^[^,]*} $i name
        lappend lst [list $macrosdata($i) $name]
    }    
    puts $fout "# Macros file for GiD v1.0\n"
    puts $fout "# Created by GiD version [GiD_Info GiDVersion]\n"
    foreach i [lsort -integer -index 0 $lst] {
        foreach "number name" $i break
        if { $names != "" && [lsearch -exact $names $name] == -1 } { continue }        
        if { ![info exists macrosdata($name,IsStandard)] } {
            set macrosdata($name,IsStandard) 0
        }
        puts $fout "#\[_ \"[regsub -all \n $macrosdata($name,Description) {\n}]\"\]" ;#for translation
        
        #Number Accelerators InToolbar Active PrePost Icon Group \
        #Description CreationDate ModificationDate IsStandard 
        
        foreach i [array names macrosdata $name,*] {
            if { $i != "$name,Code" } {
                if { $i == "$name,Icon" } {
                    #trick, in disk now are saved 4 items, but in memory only maintain the two effectives
                    #old gids use the first two and new gids the second two
                    if { [llength $macrosdata($i)] == 0 } {
                        set to_print {}                    
                    } elseif { [llength $macrosdata($i)] == 2 } {
                        set to_print [list [lindex $macrosdata($i) 0] imported_images {*}$macrosdata($i)]
                    } else {
                        set to_print $macrosdata($i)
                    }
                    puts $fout [list set macrosdata($i) $to_print]
                } else {
                    puts $fout [list set macrosdata($i) $macrosdata($i)]
                }
            }
        }
        puts $fout ""
        puts $fout "[list proc $name] {} \{"
        foreach line [split [string trim $macrosdata($name,Code)] \n] {
            puts $fout "    $line"
        }
        puts $fout "\}\n"
    }
    icon_chooser::SaveImages $fout $names

    puts $fout [list array set preferences [array get preferences]]

    close $fout
    unset -nocomplain filetoclose
}

proc toolbarmacros::ReadMacros { } {
    set create_folders 0
    set gid_defaults [GetGidMacrosFilename $create_folders]
    if { ![file exists $gid_defaults] } {
        set similar_gid_defaults [GetSimilarDefaultsFile [file tail $gid_defaults]]
        if { [file exists $similar_gid_defaults] } {
            set parent_folder [file dirname $gid_defaults]
            if {  $parent_folder != [gid_filesystem::get_folder_standard scripts] && [file exists $parent_folder] } {
                # copy it from preferences of the similar old GiD version to the current one
                # do not try to copy it inside scripts, and ignore possible error copying, e.g. folder not exists or read only
                catch { file copy $similar_gid_defaults $gid_defaults } msg
            }
            set gid_defaults $similar_gid_defaults
        }
    }
    if { ![file exists $gid_defaults] } {
        set gid_defaults [GetGidMacrosDefaultsFilename]
    }
    if { [file exists $gid_defaults] } {
        set err [catch { toolbarmacros::ReadMacrosFromFile $gid_defaults 1 } errstring]
        if { $err } {
            WarnWin [_ "Could not open macros file '%s' (%s)" $gid_defaults $errstring]
        }
    }    
    #update user macros with default macros, to add new macros that could appear in new GiD versions
    #if each GiD version had its own folder with .ini and macros maybe this won't be necessary
    #and must only read if not exists 'gid_macros.tcl' of the user
    if { $gid_defaults != [GetGidMacrosDefaultsFilename] } {
        set gid_defaults [GetGidMacrosDefaultsFilename]
        set err [catch { toolbarmacros::ReadMacrosFromFile $gid_defaults 0 } errstring]
        if { $err } {
            WarnWin [_ "Could not open macros file '%s' (%s)" $gid_defaults $errstring]
        }
    }
    icon_chooser::AfterReadMacros
}

proc toolbarmacros::ReadMacrosFromFile { filename readpreferences } {  
    variable macrosdata
    variable preferences

    namespace eval imported_macrospace [list source $filename]

    if { $readpreferences } {
        array set preferences [namespace eval imported_macrospace array get preferences]
    }

    foreach i [info commands imported_macrospace::*] {
        lappend imported_commands [namespace tail $i]
    }
    set imported_commands [lsort $imported_commands]

    upvar #0 toolbarmacros::imported_macrospace::macrosdata imported_macrosdata

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata

    #try to mantain the current macros settings, and after add the new ones
    foreach i [info commands macrospace::*] {
        set name [namespace tail $i]
        if { [lsearch -sorted $imported_commands $name] != -1 } {
            #set the imported body
            set body [string trim [namespace eval imported_macrospace [list info body $name]]]
            regsub -all {\n\s{4}} $body "\n" body
            if { $macrosdata($name,Code) != $body } {
                set macrosdata($name,Code) $body
            }
        }
        if { [info exists imported_macrosdata($name,IsStandard)] } {
            set macrosdata($name,IsStandard) $imported_macrosdata($name,IsStandard)
            if { $imported_macrosdata($name,IsStandard) == "1" && \
                    $imported_macrosdata($name,Active) == "0" && \
                    $imported_macrosdata($name,InToolbar) == "0" } {
                #is an standard macro that is hidden in the imported version
                set macrosdata($name,Active) 0
                set macrosdata($name,InToolbar) 0
            }
        } elseif { [info exists macrosdata($name,IsStandard)] && $macrosdata($name,IsStandard) == "1" } {
            #is an standard macro that is removed in the imported version
            set macrosdata($name,Active) 0
            set macrosdata($name,InToolbar) 0
        }
    }

    #add the new ones, without repeat an used number
    set maxnumber 0
    foreach i [array names macrosdata *,Number] {
        if { $macrosdata($i) > $maxnumber } { set maxnumber $macrosdata($i) }
        set usednumber($macrosdata($i)) 1
    }

    # imported macros should be handled acording to their Name,Number
    set lst_ordered_imported_macrosdata_names {}
    set lst {}
    foreach i [array names imported_macrosdata *,Number] {
        lappend lst [list $imported_macrosdata($i) $i]
    }
    set lst [ lsort -integer -index 0 $lst]
    foreach item $lst {
        lappend lst_ordered_imported_macrosdata_names [ lindex $item 1]
    }
    

    foreach i $lst_ordered_imported_macrosdata_names {
        set name [string range $i 0 end-7]
        if { ![info exists macrosdata($name,Number)] } {
            foreach j [array names imported_macrosdata $name,*] {
                set macrosdata($j) $imported_macrosdata($j)
            }
            if { [info exists macrosdata($name,Icon)] } {
                if { [llength $macrosdata($name,Icon)] == 4 } {
                    #trick, in disk now are saved 4 items, but in memory only maintain the two effectives
                    #old gids use the first two and new gids the second two
                    set macrosdata($name,Icon) [lrange $macrosdata($name,Icon) 2 3]
                } elseif { [llength $macrosdata($name,Icon)] == 3 } {
                    #GiD 2.1 write thinks like this for tkimages                    
                    #down-22 bring_to_front.png themed_image
                    set macrosdata($name,Icon) [lrange $macrosdata($name,Icon) 1 2]            
                }
            }
            #set the imported body
            set body [string trim [namespace eval imported_macrospace [list info body $name]]]
            regsub -all {\n\s{4}} $body "\n" body
            set macrosdata($name,Code) $body
            rename imported_macrospace::$name macrospace::$name
            if { [info exists usednumber($macrosdata($name,Number))] } {
                set macrosdata($name,Number) [incr maxnumber]
            }
            if { $macrosdata($name,Number) > $maxnumber } {
                set maxnumber $macrosdata($name,Number)
            }
            set usednumber($macrosdata($name,Number)) 1
        }
    }     
                   
    unset imported_macrosdata
    foreach i [info commands imported_macrospace::*] {
        rename $i ""
    }
    
    #update the information of ::icon_chooser::imported_images
    set themed_images ""
    foreach i [array names macrosdata *,Icon] {
        if { [lindex $macrosdata($i) 1] == "themed_image" } {
            lappend themed_images [lindex $macrosdata($i) 0]            
        }
    }
    foreach img [image names] {
        if { [string range $img 0 23] == "::icon_chooser::images::" } {
            set image_name [string range $img 24 end]
            if { $image_name == "" } {
                continue
            }
            if { [lsearch -index 0 $::icon_chooser::imported_images $image_name] == -1 } {
                #not classify as imported ::icon_chooser::images:: that are used in a macro "themed_image"
                #they are written in gid_macros.tcl also as ::icon_chooser::images:: for back compatibility with old GiDs
                if { [lsearch $themed_images $image_name] == -1 } {                    
                    set now $::icon_chooser::ImportedDates($image_name)
                    lappend ::icon_chooser::imported_images [list $image_name $img $now]
                }
            }            
        }        
    } 
       
    #avoid image names with spaces (problems using tile)
    foreach name [array names ::icon_chooser::ImportedDates] {
        if { [regsub -all { } $name {_} newname] > 0 } {
            set ::icon_chooser::ImportedDates($newname) $::icon_chooser::ImportedDates($name)
            array unset ::icon_chooser::ImportedDates $name
        }
    }
}

proc toolbarmacros::UpdateAllMacrosForTest { } {
    upvar #0 toolbarmacros::imported_macrospace::macrosdata imported_macrosdata
    unset -nocomplain imported_macrosdata
    foreach i [info commands imported_macrosdata::*] {
        rename $i ""
    }

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    unset -nocomplain macrosdata
    foreach i [info commands macrospace::*] {
        rename $i ""
    }
    toolbarmacros::ReadMacros
}

proc toolbarmacros::TransferMacrosFromOldSystem {} {
    global MacrosList
    variable macrowindow

    foreach i [array names MacrosList] {
        regexp [join [list "ACCELERATORS\n(.*)END ACCELERATORS.*" \
                "COMMENTS\n(.*)END COMMENTS.*ACTION\n(.*)END ACTION"] ""] \
                $MacrosList($i) {} acc comments action
        foreach j $acc {
            if { [regexp {KeyPress} $j] } {
                regsub -all -- {KeyPress} $j {Key} j
            } elseif { ![regexp {Key} $j] } {
                regsub -all -- {-\d$} $j {-Key&} j
            }
        }
        toolbarmacros::CreateMacro [string trim $action] $i [string trim $comments] [string trim $acc] no
    }
    toolbarmacros::_update_MacrosList $macrowindow
    toolbarmacros::_update_toolbar
    toolbarmacros::SaveMacros
}

proc toolbarmacros::PlayMacro { w } {
    variable tablelists

    set t $tablelists($w)
    set id [lindex [$t curselection] 0]
    if { [llength $id] != 1 } {
        WarnWin [_ "Select only one macro for playing it"]
        return
    }
    set name [lindex [$t get $id] 1]
    macrospace::$name
}

proc toolbarmacros::DeleteMacro { w { names "" } } {
    variable tablelists
    variable macrowindow

    if { $names eq "" } {
        set t $tablelists($w)
        foreach id [$t curselection] {
            lappend names [lindex [$t get $id] 1]
        }
    }
    switch [llength $names] {
        0 {
            WarnWin [_ "Select one or more macros for deleting them"]
            return
        }
        1 {
            set name [lindex $names 0]
            set tt [_ "Are you sure to delete macro '%s?" $name]
        }
        default {
            set tt [_ "Are you sure to delete %d macros?" [llength $names]]
        }
    }
    set retval [GID_tk_messageBox -parent $w -message $tt -title [_ "Warning"] \
            -icon question -default ok -type okcancel]
    if { $retval eq "cancel" } { return }

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata

    set standardmacros ""
    foreach name $names {
        if { $macrosdata($name,IsStandard) == "1" } {
            set macrosdata($name,Active) 0
            set macrosdata($name,InToolbar) 0
            lappend standardmacros $name
            continue
        }
        foreach j $macrosdata($name,Accelerators) {
            set bind [_manage_accelerators_short2long $j]
            bind .gid $bind ""
        }   
        if { $macrosdata($name,Icon) == "" } {
            set img [icon_chooser::get_macros_images $name]
            icon_chooser::free_default_macro_image $img
            
        }
        foreach i [list Number Accelerators Group Description InToolbar Active \
                PrePost Icon CreationDate ModificationDate] {
            unset macrosdata($name,$i)
        }
        namespace eval macrospace [list rename $name {}]
    }
    if { $standardmacros != "" } {
        WarnWin [_ "Standard macros can't be deleted. Set %d macros to inactive" [llength $standardmacros]]
    }
    toolbarmacros::_ReorderMacrosNumbers
    toolbarmacros::_update_MacrosList $macrowindow
    toolbarmacros::_update_toolbar
    toolbarmacros::SaveMacros
}

proc toolbarmacros::MoveMacroUpDown { w what } {
    variable tablelists
    variable macroname

     # to activate trace
    set macroname ""

    set t $tablelists($w)
    set ids [$t curselection]
    if { [llength $ids] == 0 } {
        WarnWin [_ "Select one or more macros for moving them"]
        return
    }
    set sellst ""
    set selnames ""
    foreach id $ids {
        lappend sellst [lrange [$t get $id] 0 1]
        lappend selnames [lindex [$t get $id] 1]
    }
    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata

    if { $what eq "top" || $what eq "bottom" || [lindex $what 0] eq "pos" } {
        set newnum [lindex [$t get [lindex $what 1]] 0]
        switch -glob -- $what {
            top {
                toolbarmacros::_ReorderMacrosNumbers [list 1 [llength $selnames]]
                set idx 1
            }
            bottom {
                toolbarmacros::_ReorderMacrosNumbers
            }
            pos* {
                toolbarmacros::_ReorderMacrosNumbers [list $newnum [expr {$newnum+[llength $selnames]-1}]]
                set idx $newnum
            }
        }
        foreach "lst maxnumber" [list "" 0] break
        foreach i [array names macrosdata *,Number] {
            regexp {^[^,]*} $i name
            lappend lst [list $macrosdata($i) $name]
            if { $macrosdata($i) > $maxnumber } { set maxnumber $macrosdata($i) }
        }
        if { $what eq "bottom" } { set idx [expr {$maxnumber+1}] }

        foreach i [lsort -integer -index 0 $lst] {
            set name [lindex $i 1]
            if { [lsearch -exact $selnames $name] != -1 } {
                set macrosdata($name,Number) $idx
                incr idx
            }
        }
        toolbarmacros::_ReorderMacrosNumbers
    } else {
        if { $sellst ne [lsort -integer -index 0 $sellst] } {
            WarnWin [_ "To apply this operation, list must be sorted by number"]
            return
        }
        
        set maxnumber 0
        foreach i [array names macrosdata *,Number] {
            regexp {^[^,]*} $i name
            set number2name($macrosdata($i)) $name
            if { $macrosdata($i) > $maxnumber } { set maxnumber $macrosdata($i) }
        }
        if { $what eq "down" } {
            set sellst [lsort -decreasing -integer -index 0 $sellst]
            set maxmin [expr {$maxnumber+1}]
        } else { set maxmin 0 }
        foreach i $sellst {
            foreach "number name" $i break
            switch $what {
                down {
                    set newnumber [expr {$number+1}]
                    if { $newnumber >= $maxmin } { continue }
                }
                up {
                    set newnumber [expr {$number-1}]
                    if { $newnumber <= $maxmin } { continue }
                }
            }
            set newname $number2name($newnumber)
            set macrosdata($name,Number) $newnumber
            set macrosdata($newname,Number) $number
            set number2name($newnumber) $name
            set number2name($number) $newname
            set maxmin $newnumber
        }
    }
    toolbarmacros::_update_MacrosList $w "" $selnames
    toolbarmacros::_update_toolbar
}

proc toolbarmacros::ChangeToolbarIcon { button name } {
    variable macroname
    variable macrowindow

    # to activate trace
    set macroname ""

    set icondesc [icon_chooser::choose_icon $button]
    if { $icondesc != "-" } { 
        upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
        if { $icondesc ne $macrosdata($name,Icon) } {
            set macrosdata($name,Icon) $icondesc            
            set icon_chooser::macros_images($name) [icon_chooser::giveimage $icondesc]
            toolbarmacros::_update_MacrosList $macrowindow
            toolbarmacros::_update_toolbar
            toolbarmacros::SaveMacros
        }
    }
}

proc toolbarmacros::ChangeIcon { button } {
    variable macroicon
    set icondesc [icon_chooser::choose_icon $button]
    if { $icondesc != "-" } {
        $button configure -image [icon_chooser::giveimage $icondesc] 
        set macroicon $icondesc
    }
}

proc toolbarmacros::EditMacro {} {
    variable macroname
    variable macrocode

    set data "\n[list proc ::toolbarmacros::macrospace::$macroname] {} \{\n"
    foreach line [split [string trim $macrocode] \n] {
        append data "    $line\n"
    }
    append data "\}\n"

    if { ![interp exists ramdebugger] } { interp create ramdebugger }
    ramdebugger eval [list set argv [list -noprefs -rgeometry 500x250+200+100 -onlytext]]
        
    set err [catch { package require RamDebugger }]
    if { $err } {
        WarnWin [_ "Package RamDebugger is not installed"]
        return
    }
    interp alias ramdebugger EditEndInRamDebugger "" toolbarmacros::EditEndInRamDebugger

    #if { 0 } to avoid unwanted and ugly modification of the original text in short lines
    if { 0 } {
        set tdata ""
        set max_line 80
        while { $data ne "" } {
            if { [string length $data] > $max_line } {
                for { set i [expr {$max_line-1}] } { $i > 10 } { incr i -1 } {
                    if { [string index $data $i] eq " " } { break }
                }
                if { $i > 10 } {
                    append tdata [string range $data 0 $i] "\\\n        "
                    set data [string range $data [expr {$i+1}] end]
                } else {
                    append tdata $data
                    set data ""
                }
            } else {
                append tdata $data
                set data ""
            }
        }
    } else {
        set tdata $data
    }

    ramdebugger eval [list RamDebugger::OpenFileSaveHandler *$macroname* $tdata EditEndInRamDebugger]
}

proc toolbarmacros::_enter_accelerators_here_error { entry } {

    set types [list Ctrl-s Alt-a F1 Ctrl-F1 "Ctrl-x Ctrl-a"]
    WarnWin  [_ "Error: Accelerators can be of the types:%s" \n\t[join $types \n\t]] $entry
}
proc toolbarmacros::_enter_accelerators_here_do { entry K A } {

    set data [$entry get]

    # some computers are strange
    if { $K eq "L1" } { set K F11 }
    if { $K eq "L2" } { set K F12 }

    regexp {(Ctrl|Alt)?-?(\S*)\s*(Ctrl|Alt)?-?(\S*)} \
        $data {} ctrl(1) l(1) ctrl(2) l(2)

    if { $K == "BackSpace" || $K == "Delete" } {
        $entry delete 0 end
        return
    }
    if { $l(2) != "" } { _enter_accelerators_here_error $entry ; return }
    if { $l(1) != "" } { set i 2 } else { set i 1 }

    if { [string match Control* $K] } {
        if { $ctrl($i) == "" } {
            tk::EntryInsert $entry Ctrl-
        } elseif { $ctrl($i) ne "Ctrl" } { _enter_accelerators_here_error $entry }
    } elseif { [string match Alt* $K] } {
        if { $ctrl($i) == "" } {
            tk::EntryInsert $entry Alt-
        } elseif { $ctrl($i) ne "Alt" }  { _enter_accelerators_here_error $entry }
    } elseif { $A == "" && [string match F* $K] } {
        tk::EntryInsert $entry "$K "
    } elseif { $A != "" } {
        if { $ctrl($i) != "" } {
            tk::EntryInsert $entry "$K "
        } else { _enter_accelerators_here_error $entry }
    }
}

proc toolbarmacros::_manage_accelerators_short2long { acc } {
    regsub -all {Ctrl} $acc {Control} acc
    regsub {\s+} $acc {><} acc
    set acc <$acc>
    regsub -all {[^-<]+>} $acc {Key-&} acc
    return $acc
}

proc toolbarmacros::_manage_accelerators_delete  { entry } {
    variable macroname
    variable macroaccelerators

    set acc [string trim [$entry get]]
    regsub -all {\s+} $acc { } acc
    if { $acc eq "" } {
        set macroaccelerators ""
        return
    }
    set ipos [lsearch -exact $macroaccelerators $acc]
    if { $ipos == -1 } {
        WarnWin [_ "Accelerator '%s' is not contained in list '%s" \
                $acc $macroaccelerators] $entry
        return
    }
    set macroaccelerators [lreplace $macroaccelerators $ipos $ipos]
    $entry delete 0 end
}

proc toolbarmacros::_manage_accelerators_add { entry { name "" } } {
    variable macroname
    variable macroaccelerators
    variable macrowindow

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata

    if { $name eq "" } {
        set name $macroname
        set accs $macroaccelerators
        set where editwindow
    } else {
        set where fastwindow
        set accs $macrosdata($name,Accelerators)
    }

    set acc [string trim [$entry get]]
    regsub -all {\s+} $acc { } acc
    if { $acc eq "" } {
        WarnWin [_ "Enter an accelerator in the text space"] $entry
        return
    }
    foreach j $accs {
        if { $acc eq $j } { return }
    }
    set foundname ""
    foreach i [array names macrosdata *,Accelerators] {
        regexp {^[^,]*} $i name_in
        if { $name_in eq $name } { continue }
        foreach j $macrosdata($i) {
            if { $acc eq $j } {
                set foundname $name_in
                break
            }
        }
    }
    if { $foundname ne "" } {
        set tt [_ "Accelerator '%s' is currently assigned to macro '%s'. Proceed?" \
                $acc $foundname]
        set w [dialogwin_snit $entry.%AUTO% -title [_ Warning] -entrytext $tt]
        set f [$w giveframe]
        set tt [_ "Note: if two macros have the same accelerator, The one with higher order has precedence"]
        label $f.l1 -text $tt -wraplength 200 -justify left
        grid $f.l1 -sticky nw -padx 3 -pady 10
        $w focusok
        set action [$w createwindow]
        destroy $w
        if { $action < 1 } { return }
    } else {
        set cmd [bind .gid [_manage_accelerators_short2long $acc]]
        if { $cmd ne "" && $cmd ne [list ::toolbarmacros::macrospace::$name] } {
            set tt [_ "Accelerator '%s' is currently assigned to function '%s'. Proceed?" $acc $cmd]
            set retval [GID_tk_messageBox -parent $entry -message $tt -title [_ "Warning"] \
                    -icon question -default ok -type okcancel]
            if { $retval eq "cancel" } { return }
        }
    }
    $entry delete 0 end

    switch $where {
        editwindow {
            lappend macroaccelerators $acc
        }
        fastwindow {
            lappend macrosdata($name,Accelerators) $acc
            toolbarmacros::_update_MacrosList $macrowindow
            toolbarmacros::_update_toolbar
            toolbarmacros::SaveMacros
            ApplyMacrosBindings
        }
    }
}

proc toolbarmacros::_add_to_group { w names } {
    variable groups
    variable macrowindow

    if { [winfo exists $w] } {
        set win $w._ask
    } else { set win .gid._ask }
    dialogwin_snit $win -title [_ "Add to group"] -entrytype entry \
        -entrylabel [_ "Group"]: -entrytext [_ "Add to group"]: \
        -entryvalues $groups
    set action [$win createwindow]
    while 1 {
        if { $action <= 0 } {
            destroy $win
            return
        }
        set newname [string trim [$win giveentryvalue]]
        if { [string match *,* $newname] } {
            WarnWin [_ "Character ',' is not allowed in group name"] $w
        } else { break }
        set action [$win waitforwindow]
    }
    destroy $win

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    foreach name $names {
        set macrosdata($name,Group) $newname
    }
    toolbarmacros::_update_MacrosList $macrowindow
    toolbarmacros::SaveMacros
}

proc toolbarmacros::Activate_deactivate_intoolbar { what names save } {
    variable macroname
    variable macrowindow
    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    set macroname ""

    update_macrodetails $macrowindow
    foreach name $names {
        switch $what {
            activate { set macrosdata($name,Active) 1 }
            deactivate { set macrosdata($name,Active) 0 }
            intoolbar { set macrosdata($name,InToolbar) 1 }
            no_intoolbar { set macrosdata($name,InToolbar) 0 }
            pre { set macrosdata($name,PrePost) pre }
            post { set macrosdata($name,PrePost) post }
            prepost { set macrosdata($name,PrePost) prepost }
        }
    }
    toolbarmacros::_update_MacrosList $macrowindow
    toolbarmacros::_update_toolbar
    if { $save } {
        toolbarmacros::SaveMacros
    }
    #ApplyMacrosBindings
}

# this proc is only coded if the modifications of the  macrocode in ramdebugger has been saved
proc toolbarmacros::EditEndInRamDebugger { name data } {
    variable macroname
    variable macrocode
    variable macrowindow

    set name [string trim $name *]

    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    if { ![info exists macrosdata($name,Number)] } {
        WarnWin [_ "Macro '%s' does not exist" $name]
        return
    }
    set err [catch {
            namespace eval macrospace $data
            set body [namespace eval macrospace [list info body $name]]
        } errstring]
    if { $err } {
        WarnWin [_ "There are errors in the code. Correct them and save again (%s)" \
                $errstring]
        return
    }
    regsub -all {\n\s{4}} [string trim $body] "\n" body
    # do not update the variable macrosdata($name,Code)
    # this will be done in update_macrodetails
    # set macrosdata($name,Code) $body
    if { $name eq $macroname } {
        set macrocode $body
        update_macrodetails $macrowindow
    }
}

proc toolbarmacros::ContextualMacrosList { tbl x y X Y} {
    variable macrowindow

#     set y [expr {$y + [winfo y [$tbl bodypath]]}]
#     set id [$tbl nearest $y]
#     if { ![$tbl selection includes $id] } {
#         $tbl selection clear 0 end
#         $tbl selection set $id
#     }

    if { ![$tbl selection_r includes "nearest $x $y"] } {
        $tbl selection_r clear 0 last
        $tbl selection_r add "nearest $x $y"
    }

    set w [winfo toplevel $tbl]
    set menu $tbl.menu
    destroy $menu
    menu $menu -tearoff 0

    if { [llength [$tbl curselection]] == 1 } {
        $menu add command -label [_ "Run"] -command \
            [namespace code [list PlayMacro $w]]
        set name [lindex [$tbl get [$tbl curselection]] 1]
        $menu add command -label [_ "Change icon"] -command \
            [namespace code [list ChangeToolbarIcon $w $name]]
        $menu add command -label [_ "Rename"] -command \
            [namespace code [list _rename_copy_macro $macrowindow rename $name]]
        $menu add command -label [_ "Copy"] -command \
            [namespace code [list _rename_copy_macro $macrowindow copy $name]]
        $menu add separator
    }
    set names ""
    foreach i [$tbl curselection] {
        lappend names [lindex [$tbl get $i] 1]
    }
    $menu add command -label [_ "Delete"] -command \
        [namespace code [list DeleteMacro $w]]
    $menu add separator
    $menu add command -label [_ "Add to group"] -command \
        [namespace code [list _add_to_group $w $names]]
    $menu add command -label [_ "In toolbar"] -command \
        [namespace code [list Activate_deactivate_intoolbar intoolbar $names 1]]
    $menu add command -label [_ "Out of toolbar"] -command \
        [namespace code [list Activate_deactivate_intoolbar no_intoolbar $names 1]]
    $menu add command -label [_ "Activate"] -command \
        [namespace code [list Activate_deactivate_intoolbar activate $names 1]]
    $menu add command -label [_ "Deactivate"] -command \
        [namespace code [list Activate_deactivate_intoolbar deactivate $names 1]]

    $menu add cascade -label [_ "PrePost"] -menu $menu.m1
    menu $menu.m1 -tearoff 0
    $menu.m1 add command -label [_ "Pre"] -command \
        [namespace code [list Activate_deactivate_intoolbar pre $names 1]]
    $menu.m1 add command -label [_ "Post"] -command \
        [namespace code [list Activate_deactivate_intoolbar post $names 1]]
    $menu.m1 add command -label [_ "PrePost"] -command \
        [namespace code [list Activate_deactivate_intoolbar prepost $names 1]]

    $menu add separator

    $menu add command -label [_ "Up"] -command \
            [namespace code [list MoveMacroUpDown $w up]]
    $menu add command -label [_ "Down"] -command \
            [namespace code [list MoveMacroUpDown $w down]]
    $menu add command -label [_ "Top"] -command \
            [namespace code [list MoveMacroUpDown $w top]]
    $menu add command -label [_ "Bottom"] -command \
            [namespace code [list MoveMacroUpDown $w bottom]]

    tk_popup $menu $X $Y
}

proc toolbarmacros::_change_recursive_state { w state } {
    catch { $w configure -state $state }
    foreach i [winfo children $w] {
        _change_recursive_state $i $state
    }
}

proc toolbarmacros::_enabledisable_macrodetails { w } {
    variable macroname

    if { $macroname eq "" } {
        _change_recursive_state $w disabled
    } else {
        _change_recursive_state $w normal
    }
}

proc toolbarmacros::TreeCtrlDouble1 { w x y } {
    set id [$w identify $x $y]
    if {[lindex $id 0] eq "item" && [llength [$w curselection]] == 1 } {
        PlayMacro [winfo toplevel $w]
        return -code break
    }
}

proc toolbarmacros::TreeCtrlDrop { w I l } {

    GID_tk_messageBox -message "%w $I -- $l" -parent $w
}

# what: undefined, simple or complete
proc toolbarmacros::MacrosWindow { { what complete } { selnames "" } { w .gid.tmacros } } {
    global GidPriv    
    variable tablelists
    variable iconbuttons
    variable showusermacrosonly
    variable filterentry
    variable filterentry_onlygroup
    variable macroname

    variable macrointoolbar
    variable macroactive
    variable macroprepost
    variable macrogroup
    variable macrodescription
    variable macrocode
    variable macroicon
    variable macrowindow 
    set macrowindow $w

    variable _isinit
    if { !$_isinit} {
        ::toolbarmacros::Init
    }
    if { $what eq "undefined" } {
        if { [info exists GidPriv(PrePostMacrosWindowGeom)] } {
            set what [lindex $GidPriv(PrePostMacrosWindowGeom) 4]
        } else { 
            set what complete
        }
    }

    destroy $w
    InitWindow2 $w -title [_ "Macros window"] \
        -geometryvariable PrePostMacrosWindowGeom \
        -initcommand [list toolbarmacros::MacrosWindow $what]
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    ttk::labelframe $w.f1 -text [_ "macros list"]
    if { ![info exists toolbarmacros::showusermacrosonly] } { set toolbarmacros::showusermacrosonly 0 }
    ttk::checkbutton $w.f1.showusermacrosonly -text [_ "Show user macros only"] -variable toolbarmacros::showusermacrosonly
    ttk::entry $w.f1.e1 -textvariable toolbarmacros::filterentry

    if { ![info exists toolbarmacros::filterentry_onlygroup] } { set toolbarmacros::filterentry_onlygroup 0 }
    ttk::checkbutton $w.f1.cb1 -image [::gid_themes::GetImage filter.png toolbar] \
        -variable toolbarmacros::filterentry_onlygroup -style Toolbutton
    GidHelp $w.f1.cb1 [_ "Filter only on group name"]

    set filterentry ""
    set cmd "[namespace code [list _filter_MacrosList $w]] ;#"
    trace add variable toolbarmacros::filterentry write $cmd
    bind $w.f1.e1 <Destroy> [list trace remove variable toolbarmacros::filterentry write $cmd]
    trace add variable toolbarmacros::showusermacrosonly write $cmd
    bind $w.f1.showusermacrosonly <Destroy> [list trace remove variable toolbarmacros::showusermacrosonly write $cmd]
    trace add variable toolbarmacros::filterentry_onlygroup write $cmd
    bind $w.f1.cb1 <Destroy> [list trace remove variable toolbarmacros::filterentry_onlygroup write $cmd]

    ScrolledWindow $w.f1.lf -relief sunken -borderwidth 0

    # adjust width of columns with images
    set img_width [::gid_themes::GetImageSize toolbar]
    set prepost_width [ expr int( 0.5 + double( $img_width) / 5.0)]
    if { $prepost_width < 4} { set prepost_width 4}
    set img_width [::gid_themes::GetImageSize menu]
    set active_width [ expr int( 0.5 + double( $img_width) / 5.0)]
    if { $active_width < 4} { set active_width 4}

    TreeCtrlList $w.f1.lf.lb -width 450 -height 400 -columns [list \
            4  "#"        left text \
            21 [_ "Name"]        left imagetext \
            6  [_ "Accelerators"] left text \
            $active_width  [_ "In toolbar"]  center image \
            $active_width  [_ "Active"]  center image \
            $prepost_width [_ "PrePost"]  center image \
            10 [_ "Group"] left text \
            25 [_ "Description"] left text \
            14 [_ "Creation date"] left text \
            14 [_ "Modification date"] left text] \
        -xscrollincrement 20 -yscrollincrement 20

    ::gid_themes::ConfigureHeaders $w.f1.lf.lb
    ::gid_themes::ApplyHeadersConfig $w.f1.lf.lb    

    $w.f1.lf.lb notify bind $w.f1.lf.lb <Selection> [namespace code \
            [list _changeMacrosList_selection $w]]
    bind $w.f1.lf.lb <$::gid_right_button> [namespace code [list ContextualMacrosList \
                $w.f1.lf.lb %x %y %X %Y]]
    bind $w.f1.lf.lb <Return> [namespace code [list PlayMacro $w]]
    bind $w.f1.lf.lb <Double-1> [namespace code [list TreeCtrlDouble1 $w.f1.lf.lb %x %y]]
    bind $w.f1.lf.lb <Delete> [namespace code [list DeleteMacro $w]]
    bind $w.f1.lf.lb <Button1-Motion> {
        set toolbarmacros::Dragging 1
    }
    bind $w.f1.lf.lb <ButtonRelease-1> {
        unset -nocomplain toolbarmacros::Dragging
    }

    $w.f1.lf.lb notify bind $w.f1.lf.lb <Drag-receive> {
        set w [winfo toplevel %T]
        set row [lindex [%T item rnc %I] 0]
        toolbarmacros::MoveMacroUpDown $w [list pos $row]
    }

    set tablelists($w) $w.f1.lf.lb
    focus $w.f1.lf.lb
    $w.f1.lf setwidget $w.f1.lf.lb

    # be careful to update these args, specially the index 7
    set record_macro_args [list $w window $w.f1.bbox1 7]

    set cmds [list play.png [_ "Run macro"] [namespace code [list PlayMacro $w]] \
            delete.png [_ "Delete macro"] [namespace code [list DeleteMacro $w]] \
            ArrowUp.png [_ "Move macro up"] [namespace code [list MoveMacroUpDown $w up]] \
            ArrowDown.png [_ "Move macro down"] [namespace code [list MoveMacroUpDown $w down]] \
            ArrowTop.png [_ "Move macro top"] [namespace code [list MoveMacroUpDown $w top]] \
            ArrowBottom.png [_ "Move macro bottom"] [namespace code [list MoveMacroUpDown $w bottom]] \
            save.png [_ "File operations"] [namespace code \
                [list FileOperations $w $w.f1.bbox1]] \
            Record.png [_ "Record macro"] [namespace code "StartRecording $record_macro_args"] \
            ]

    set bbox [ButtonBox $w.f1.bbox1 -spacing 0 -padx 1 -pady 1 -homogeneous 1]
    foreach "img help cmd" $cmds {
        set b [$bbox add -image [::gid_themes::GetImage $img toolbar] -takefocus 0 -command $cmd  -relief flat]
        GidHelp $b $help
    }
    set_bbox_borderwidth $w.f1.bbox1 1
    ttk::menubutton $w.f1.b05 -text [_ "View"] -menu $w.f1.b05.m
    menu $w.f1.b05.m -tearoff 0
    $w.f1.b05.m add command -label [_ "View toolbar"] -command TOBegin

    set cmd [list toolbarmacros::_update_toolbar]
    append cmd ";" [list toolbarmacros::SaveMacros]
    $w.f1.b05.m add checkbutton -label [_ "Toolbar one column"] -variable \
        toolbarmacros::preferences(toolbar_one_col) -command $cmd

    set details_icon [ GetDetailsIcon $what]

    ttk::button $w.f1.b1 -image $details_icon \
        -command [list toolbarmacros::ToggleDetailsFrame $w 1 $w.f1.b1]
    GidHelp w.f1.b1 [_ "View macro details"]

    grid $w.f1.showusermacrosonly $w.f1.e1 $w.f1.cb1 -sticky ew -padx "3 0" -pady 3
    grid $w.f1.lf  - - -sticky nsew
    grid $bbox $w.f1.b05 $w.f1.b1 -sticky w
    grid configure $w.f1.b1 $w.f1.cb1 -sticky ne -padx 3

    grid columnconfigure $w.f1 1 -weight 1
    grid rowconfigure $w.f1 1 -weight 1

    set f2 [ttk::labelframe $w.f2 -text [_ "macro details"]]
    ttk::label $f2.l1 -text [_ "Name"]:

    ttk::frame $f2.fn
    set font [concat [font actual [$f2.l1 cget -font]] -weight bold]
    ttk::label $f2.fn.cb1 -textvariable toolbarmacros::macroname -font $font \
        -anchor w

    set cmd [namespace code [list _enabledisable_macrodetails $f2]]
    trace add variable toolbarmacros::macroname write "$cmd;#"
    bind $f2.fn.cb1 <Destroy> [list trace remove variable \
            toolbarmacros::macroname write "$cmd;#"]

    ButtonBox $f2.fn.b0 -spacing 0 -padx 1 -pady 1 -homogeneous 1
    set b [$f2.fn.b0 add -image [::gid_themes::GetImage edit_file.png menu] \
               -command [namespace code [list _rename_copy_macro $w rename]]]
    GidHelp $b [_ "Rename macro"]
    set b [$f2.fn.b0 add -image [::gid_themes::GetImage copy.png menu] \
               -command [namespace code [list _rename_copy_macro $w copy]]]  

    set_bbox_borderwidth $f2.fn.b0 1

    GidHelp $b [_ "Copy macro"]
    grid $f2.fn.cb1 $f2.fn.b0 -sticky nw
    grid configure $f2.fn.cb1 -sticky ew
    grid columnconfigure $f2.fn 0 -weight 1

    ttk::label $f2.lg -text [_ "Group"]:
    ComboBox_and_valuesvar $f2.cbg -textvariable toolbarmacros::macrogroup \
        -valuesvariable ::toolbarmacros::groups -editable 1


    ttk::label $f2.l2 -text [_ "Accelerators"]:
    ttk::label $f2.l22 -textvariable toolbarmacros::macroaccelerators
    ttk::label $f2.l3 -text [_ "New accelerator"]:

    ttk::frame $f2.fa
    ttk::entry $f2.fa.e1 -textvariable toolbarmacros::macronewaccelerator -width 7
    bind $f2.fa.e1 <KeyPress> "[namespace code [list _enter_accelerators_here_do \
                $f2.fa.e1 %K %A]] ; break"
    bind $f2.fa.e1 <Return> [namespace code [list _manage_accelerators_add $f2.fa.e1]]
    $f2.fa.e1 delete 0 end
    ButtonBox $f2.fa.b1 -spacing 0 -padx 1 -pady 1 -homogeneous 1
    set b [$f2.fa.b1 add -image [::gid_themes::GetImage ok.png menu] \
               -command [namespace code [list _manage_accelerators_add $f2.fa.e1]]]   
    GidHelp $b [_ "Define new accelerator"]
    set b [$f2.fa.b1 add -image [::gid_themes::GetImage delete.png menu] \
               -command [namespace code [list _manage_accelerators_delete $f2.fa.e1]]]   

    set_bbox_borderwidth $f2.fa.b1 1

    GidHelp $b [_ "Remove accelerator"]
    grid $f2.fa.e1 $f2.fa.b1 -sticky nw
    grid configure $f2.fa.e1 -sticky ew
    grid columnconfigure $f2.fa 0 -weight 1

    if { ![info exists toolbarmacros::macrointoolbar] } { set toolbarmacros::macrointoolbar 0 }
    ttk::checkbutton $f2.cb2 -variable toolbarmacros::macrointoolbar -text [_ "In toolbar"]
    ttk::frame $f2.fb
    ttk::label $f2.fb.l4 -text [_ "Icon"]:
    if { ![info exists toolbarmacros::macroicon] } { set toolbarmacros::macroicon "" }    
    set iconbuttons($w) [ttk::button $f2.fb.l5 -image [::gid_themes::GetImage Macro.png toolbar] \
        -command [list toolbarmacros::ChangeIcon $f2.fb.l5]]
    GidHelp $iconbuttons($w) [_ "Press to choose icon"]
    if { ![info exists toolbarmacros::macroprepost] } { set toolbarmacros::macroprepost "" }
    ComboBox $f2.fb.cbpp -textvariable toolbarmacros::macroprepost -editable 0 \
        -values [list pre post prepost] -width 6

    grid $f2.fb.l4 $f2.fb.l5 $f2.fb.cbpp -padx 3

    if { ![info exists  toolbarmacros::macroactive] } { set  toolbarmacros::macroactive 0 }
    ttk::checkbutton $f2.cb3 -variable toolbarmacros::macroactive -text [_ "Active"]

    set f21 [ttk::labelframe $f2.lf -text [_ "description"]]
    ScrolledWindow $f21.lf -relief sunken -borderwidth 0
    text_and_variable $f21.lf.t -width 20 -height 2 -wrap word \
        -variable ::toolbarmacros::macrodescription -borderwidth 1
    $f21.lf setwidget $f21.lf.t
    grid $f21.lf -sticky nsew -padx 3 -pady 3
    grid columnconfigure $f21 0 -weight 1
    grid rowconfigure $f21 0 -weight 1

    set f22 [ttk::labelframe $f2.lf1 -text [_ "code"]]
    ScrolledWindow $f22.lf -relief sunken -borderwidth 0
    text_and_variable $f22.lf.t -width 20 -height 4 -wrap none \
        -variable ::toolbarmacros::macrocode -borderwidth 1 \
        -font FixedFont
    $f22.lf setwidget $f22.lf.t
    ttk::button $f22.b1 -text [_ "Edit"] -command [namespace code EditMacro]
    GidHelp $f22.b1 [_ "Edit macro command"]
    grid $f22.lf -sticky nsew -padx 3 -pady 3
    grid $f22.b1 -pady 3
    grid columnconfigure $f22 0 -weight 1
    grid rowconfigure $f22 0 -weight 1

    set f23 [ttk::frame $f2.f3 -style BottomFrame.TFrame]
    ttk::button $f23.accept -text [_ "Apply"] -command \
        [namespace code [list update_macrodetails $w]] -style BottomFrame.TButton
    ttk::button $f23.cancel -text [_ "Cancel"] -command \
        [namespace code [list _changeMacrosList_selection $w no]] -style BottomFrame.TButton
    grid $f23.accept $f23.cancel -padx 3

    grid $f2.l1 $f2.fn -sticky nw
    grid $f2.lg $f2.cbg -sticky nw -padx "0 2" -pady 2
    grid $f2.l2 $f2.l22 -sticky w
    grid $f2.l3 $f2.fa -sticky w
    grid $f2.cb2  $f2.cb3 -sticky w
    grid $f2.fb    -  -sticky w
    grid $f21   -     -sticky nsew -padx 3 -pady 3
    grid $f22   -     -sticky nsew -padx 3 -pady 3
    grid $f23 -       -sticky ews 
    grid columnconfigure $f2 1 -weight 1
    # description labelframe weight
    grid rowconfigure $f2 6 -weight 1
    # code labelframe weight
    grid rowconfigure $f2 7 -weight 4

    ttk::frame $w.f_but -style BottomFrame.TFrame
    ttk::button $w.f_but.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton

    grid $w.f1 -sticky nsew -padx 3 -pady 3
    grid $w.f_but.close -padx 5 -pady 5
    grid $w.f_but -sticky ews
    grid anchor $w.f_but center
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    set macroname ""
    set macroaccelerators ""
    set macrointoolbar 0
    set macroactive 0
    set macroprepost prepost
    set macrogroup ""
    set macrodescription ""
    set macrocode ""

    bind $w <Escape> [list destroy $w]
    bind $w <Destroy> "+[namespace code [list update_macrodetails $w]]"

    if { $what eq "complete" } {
        ToggleDetailsFrame $w 0 $w.f1.b1
    }
    toolbarmacros::_update_MacrosList $w "" $selnames

    # for testing, to test
    # wm transient $w .gid
}


proc toolbarmacros::is_image_in_use { name } {
    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    foreach item [array names macrosdata *,Icon] {
        if { [lindex $macrosdata($item) 0] == $name && \
                [lindex $macrosdata($item) 1] == "imported_images" } {
            return 1
        }
    }
    return 0
}
