
namespace eval postattachablewindow {
    # variables
    variable data
    variable num_phantom        0

    proc SetInsideBindings { w ev cmd } {
	bind $w <$ev> $cmd
	SetChildrenInsideBindings $w $ev $cmd
    }

    proc SetChildrenInsideBindings { w ev cmd} {
	foreach ch [ winfo children $w] {
	    SetInsideBindings $ch $ev $cmd
	}
    }

    proc FinishMotion { wid} {
	variable data
	catch {
	    unset data($wid,phantom,start_x)
	    unset data($wid,phantom,start_y)
	}
    }

    proc defineBindingsForInsideWindow { wid} {
	variable data
	SetInsideBindings $data($wid,phantom) B1-Motion \
	    [ list postattachablewindow::CheckInOutFromInside $wid %x %y %W]
	SetInsideBindings $data($wid,phantom) B1-ButtonRelease \
	    [ list postattachablewindow::FinishMotion $wid]
    }

    proc SwitchInsideOutside { wid inside} {
	variable data
	variable num_phantom
	# WarnWinText "SwitchInsideOutside: $data($wid,inside) --> $inside"
	# ensure first time position click on inside window
	catch {
	    unset data($wid,phantom,start_x)
	    unset data($wid,phantom,start_y)
	}
	if { $inside} {
	    if { $data($wid,in_out_cmd) == ""} {
		if { ![ info exists data($wid,phantom)] || ![ winfo exists $data($wid,phantom)]} {
		    # set data($wid,phantom) [ frame $data($wid,base_win).phantom -width $w -height $h -bg red]
		    set w_phantom $data($wid,base_win).phantom$num_phantom
		    set data($wid,phantom) [ frame $w_phantom -border 0 \
						 -background [ CCColorSombra [ $wid cget -background]]]
		    incr num_phantom
		    set inside_widget [ $data($wid,create_cmd) $w_phantom.in]
		    #ttk::sizegrip $w_phantom.sizegrip
		    grid $inside_widget -padx 2 -pady 2 -sticky news
		    # grid $w_phantom.sizegrip -sticky se
		    grid rowconfigure $w_phantom 0 -weight 1
		    grid columnconfigure $w_phantom 0 -weight 1
		}
		# set height [ winfo height  $data($wid,base_win)]
		# a minimum height of 300, but a max of base_win - 200, to let space for axes
		set min_height [ winfo height $data($wid,phantom).in]
		set rh [ winfo reqheight $data($wid,phantom).in]
		if { $rh > $min_height} { set min_height $rh}
		if { $min_height < 300} { set min_height 300}
		set ph [ expr [ winfo height  $data($wid,base_win)] - 200]
		if { $min_height > $ph} { set min_height $ph}
		place $data($wid,phantom) -in $data($wid,base_win) -x 0 -y 0 -height $min_height
		# -height $height
		wm withdraw $wid
		SetInsideBindings $wid Configure {}
		after 500 [ list postattachablewindow::defineBindingsForInsideWindow $wid]
	    } else {
		# WarnWinText "2. [ winfo height $wid]"
		# WarnWinText "2. [ winfo reqheight $wid]"
		# set data($wid,phantom) [ ]
		$data($wid,in_out_cmd) $wid INSIDE_LEFT
		SetChildrenInsideBindings $wid B1-Motion \
		    [ list postattachablewindow::CheckInOutFromInside $wid %x %y %W]
		SetInsideBindings $wid B1-ButtonRelease \
		    [ list postattachablewindow::FinishMotion $wid]
	    }
	} else {
	    if { $data($wid,in_out_cmd) == ""} {
		if { [ info exists data($wid,phantom)] || [ winfo exists $data($wid,phantom)]} {
		    SetInsideBindings $data($wid,phantom) B1-Motion {}
		    SetInsideBindings $data($wid,phantom) B1-ButtonRelease {}
		    place forget $data($wid,phantom)
		}
		wm deiconify $wid
		wm geometry  $wid +[ winfo pointerx $data($wid,base_win)]+[ winfo pointery $data($wid,base_win)]
		after 500 [ list postattachablewindow::SetInsideBindings $wid Configure \
				[ list postattachablewindow::CheckInOutFromOutside $wid %x %y %W]]
	    } else {
		$data($wid,in_out_cmd) $wid OUTSIDE
		SetInsideBindings $wid B1-Motion {}
		SetInsideBindings $wid B1-ButtonRelease {}
		wm geometry  $wid +[ winfo pointerx $data($wid,base_win)]+[ winfo pointery $data($wid,base_win)]
		update
		after 500 [ list postattachablewindow::SetInsideBindings $wid Configure \
				[ list postattachablewindow::CheckInOutFromOutside $wid %x %y %W]]
	    }
	}
	set data($wid,inside) $inside

	# if { [ info exists data($wid,after_id,switch)]} {
	# 	after cancel $data($wid,after_id,switch)
	# }
	# set data($wid,after_id,switch) [ after 500 [ list WarnWinText "PLACE WINDOW $inside - $data($wid,phantom)"]]
    }

    proc CheckInOutFromInside { wid x y w} {
	variable data
	set class_under_cursor [ winfo class $w]
	if { $class_under_cursor == "TScrollbar"} {
	    return
	}
	if { ![ info exists data($wid,phantom,start_x)]} {
	    set data($wid,phantom,start_x) $x
	    set data($wid,phantom,start_y) $y
	    return
	}
	if { ![ info exists data($wid,phantom,start_y)]} {
	    set data($wid,phantom,start_x) $x
	    set data($wid,phantom,start_y) $y
	    return
	}
	set dx [ expr $x - $data($wid,phantom,start_x)]
	set dy [ expr $y - $data($wid,phantom,start_y)]
	# if { $class_under_cursor == "Frame"} {
	#     # WarnWinText "change size from [ winfo width $wid] + $x x [ winfo height $wid] + $y"
	#     # set xx [ winfo x $w]
	#     # set yy [ winfo y $w]
	#     # set rx [ winfo rootx $w]
	#     # set ry [ winfo rooty $w]
	#     set ww [ winfo width $w]
	#     set hh [ winfo height $w]
	#     WarnWinText "$data($wid,phantom,start_x) + $data($wid,phantom,start_y)  widht x height = $ww x $hh"
	#     # WarnWinText "my dim = $xx + $yy   to   [ expr $xx + $ww] x [ expr $yy + $hh]"
	#     # WarnWinText "or     = $rx + $ry   to   [ expr $rx + $ww] x [ expr $ry + $hh]"
	#     set resize ""
	#     set diff 0
	#     # resize thickness
	#     set snap_size 2
	#     set new_width $ww
	#     set new_height $hh
	#     if { [ expr abs( $data($wid,phantom,start_x) - $ww)] <= $snap_size} {
	# 	set resize horizontal
	# 	set diff $dx
	# 	set new_width [ expr $ww + $dx]
	#     }
	#     if { [ expr abs( $data($wid,phantom,start_y) - $hh)] <= $snap_size} {
	# 	set resize vertical
	# 	set diff $dy
	# 	set new_height [ expr $hh + $dy]
	#     }
	#     WarnWinText "$w resizing -$resize- + $diff"
	#     # after idle $w configure -width $new_width -height $new_height
	#     # calculate rh = new_height / parent_height
	#     # after idle place $w in sadfsdf -x 0 -y 0 -relwidth rw -relheight rh
	#     set ph [ winfo height $data($wid,base_win)]
	#     set pw [ winfo width $data($wid,base_win)]
	#     set rh [ expr $new_height / $ph]
	#     set rw [ expr $new_height / $pw]
	#     # after idle [ list place $w -in $data($wid,base_win) -x 0 -y 0 -relheight $rh -relwidth $rw]
	#     WarnWinText " to $new_width x $new_height == $rw x $rh"
	#     set data($wid,phantom,start_x) $x
	#     set data($wid,phantom,start_y) $y
	#     return
	# }
	set snap_size 16
	set inside 0
	if { ( [ expr abs( $dx)] <= $snap_size) && \
		 ( [ expr abs( $dy)] <= $snap_size)} {
	    set inside 1
	}
	# set w [ winfo width $wid]
	# WarnWinText "CheckInOutFromInside: $data($wid,phantom,start_x) $data($wid,phantom,start_y) <--> $x $y = $inside"

	if { $data($wid,inside) != $inside} {
	    after idle [ list postattachablewindow::SwitchInsideOutside $wid $inside]
	}
    }

    proc CheckInOutFromOutside { wid x y w} {
	variable data
	if { [ winfo class $w] == "TScrollbar"} {
	    return
	}
	# WarnWinText " class = [ winfo class $w]"
	if { ![ info exists data($wid,base_win)]} {
	    # something went wrong just unstransform it
	    untransform $wid
	    return
	}
	set base_x [ winfo rootx $data($wid,base_win)]
	set base_y [ winfo rooty $data($wid,base_win)]
	set snap_size 16
	set inside 0
	if { ( [ expr abs( $base_x - $x)] <= $snap_size) && \
		 ( [ expr abs( $base_y - $y)] <= $snap_size)} {
	    set inside 1
	}
	# WarnWinText "CheckInOutFromOutside: $base_x $base_y <--> $x $y = $inside"

	if { $data($wid,inside) != $inside} {
	    postattachablewindow::SwitchInsideOutside $wid $inside
	}
    }

    proc untransform { w } {
	variable data
	# unset bindings
	SetInsideBindings $w Configure {}
	SetInsideBindings $w B1-Motion {}
	SetInsideBindings $w B1-ButtonRelease {}
	if { [ info exists data($w,phantom)]} {
	    SetInsideBindings $data($w,phantom) Configure {}
	    SetInsideBindings $data($w,phantom) B1-Motion {}
	    SetInsideBindings $data($w,phantom) B1-ButtonRelease {}
	}
	# set lst_destroy [ bind $w <Destroy>]
	# bind $w <Destroy> {}
	# eval $lst_destroy
	foreach idx [ array names data $w,*] {
	    unset data($idx)
	}
    }

    #procedures
    proc transform { w create_w_cmd base_win { in_out_cmd ""}} {
	variable data
	set data($w,create_cmd) $create_w_cmd
	set data($w,base_win) $base_win
	set data($w,in_out_cmd) $in_out_cmd
	if { ![ info exists data($w,inside)]} {
	    set data($w,inside) 0
	    after 500 [ list bind $w <Configure> [ list postattachablewindow::CheckInOutFromOutside $w %x %y %W]]
	    after 500 [ list bind $w <Destroy> "+ postattachablewindow::untransform $w"]
	}
	# GidHelp $w [_ "Drag window to integrate it or make it independent"]
	# GiDPopUpHelp $w [_ "Drag window to integrate it or make it independent"]
    }
}

package provide postattachablewindow 1.0
