# test of a tool to preview the mesh size doing mesh generations of lines only. 
# when finish a remesh will do a normal full meshing

proc ::PreviewLineMesh_Event_AfterMeshGeneration { fail } {
  if { !$fail } {
    MeshView 0
    DoMeshingGenerate
  } else {    
    # DoMeshingGenerate
    ::PreviewLineMesh_Event_AfterMeshWindowSizeCancel     
    # W [_ "Mesh generation fail"]
    GidUtils::SetWarnLine [_ "Mesh generation fail"]
  }
}

proc ::PreviewLineMesh_Event_AfterMeshWindowSizeCancel { } {
    GiD_UnRegisterEvent GiD_Event_AfterMeshGeneration ::PreviewLineMesh_Event_AfterMeshGeneration
    GiD_UnRegisterEvent GiD_Event_WindowCancelMeshSize ::PreviewLineMesh_Event_AfterMeshWindowSizeCancel
    foreach type {volume surface line} {
        GiD_MeshData mesh_criteria to_be_meshed 0 ${type}s [GiD_Geometry list $type]
    } 
    set old_value 0
    GiD_Set ShowFigures(Nodes) $old_value
    set ::GidPriv(HideMeshProgress) 0
    GiD_Set AutomaticAnswers 0
    set ::GidPriv(IsPreviewLineMesh) 0
    # can delete the line mesh and invoke again a normal mesh generation...    
    # GiD_Process Mescape Meshing CancelMesh PreserveFrozen Yes escape escape
    GiD_Redraw
    # uplevel #0 DoMeshingGenerate
}

proc PreviewLineMesh { } {
    set ::GidPriv(IsPreviewLineMesh) 1
    # to do it well must store the previous state of each entity, if is not default, to be restored...
    foreach type {volume surface} {
        GiD_MeshData mesh_criteria to_be_meshed 1 ${type}s [GiD_Geometry list $type]
    }
    GiD_MeshData mesh_criteria to_be_meshed 2 lines [GiD_Geometry list line]
    set old_value [GiD_Set ShowFigures(Nodes)]
    GiD_Set ShowFigures(Nodes) 1
    GiD_Set AutomaticAnswers 1
    set ::GidPriv(HideMeshProgress) 1
    GiD_RegisterEvent GiD_Event_AfterMeshGeneration ::PreviewLineMesh_Event_AfterMeshGeneration
    GiD_RegisterEvent GiD_Event_WindowCancelMeshSize ::PreviewLineMesh_Event_AfterMeshWindowSizeCancel
    DoMeshingGenerate
}

# PreviewLineMesh
