#this file implements GiD events to do special things
#a GiD-event is a collection of Tcl procedures with a predefined prototype invoked from GiD

#$::gid_start_mode != "server" (normal or client)
#dark trick: do not remove this if, it prevent that the procs appear in tclIndex when using auto_mkindex and sourced by error
if { $::gid_start_mode == "normal" || $::gid_start_mode == "client" } {

    proc GiD_Implement_Event_BeforeMainLoop { args } {
        GiD_BeforeMainLoopDo {*}$args    
        if { $::gid_start_mode == "client" } {
            gid_client_setup        
            proc GiD_Implement_Event_ResizeTogl { w width height x y } {
                gid_client_on_resize_togl $w $width $height $x $y
            }
        }   
    }

    proc GiD_Implement_Event_DynamicBox { w x y type } {
        $w draw_dynamic_box $x $y $type       
    }
        
    proc GiD_Implement_Event_MessageBoxOk { title question image } {
        if { [GidUtils::AreWindowsDisabled] } {  
            #e.g. batch mode without windows
            return 1
        }
        MessageBoxOk $title $question $image
        #only an ok option, do not send anything to process, only show the message and wait
        return ""
    }

    proc GiD_Implement_Event_MessageBoxModeless { title message  } {
        if { [GidUtils::AreWindowsDisabled] } {  
            #e.g. batch mode without windows
            return 1
        }
        set w_parent "."
        WarnWinText $message $title 0 0 $w_parent
        #only on ok option, do not send anything to process, only show the message and continue
        return ""
    }
            
    proc GiD_Implement_Event_MessageBoxEntry { title question entry_win_type default_answer button_assign image } {
        if { [GidUtils::AreWindowsDisabled] } {  
            #e.g. batch mode without windows
            return 1
        }
        set value [MessageBoxEntry $title $question $entry_win_type $default_answer $button_assign $image]
        if { $value != "" } {
            GiD_Process $value
        } else {
            GiD_Process escape
        }
    }

    proc GiD_Implement_Event_MessageBoxCombobox { title question options state image } {
        if { [GidUtils::AreWindowsDisabled] } {  
            #e.g. batch mode without windows
            return 1
        }
        set value [MessageBoxCombobox $title $question $options $state $image]
        if { $value != "" } {
            GiD_Process $value
        } else {
            GiD_Process escape
        }
    }
        
    proc GiD_Implement_Event_MessageBoxOptionsButtons { title question options labels image option_do_it_for_all_text } {
        if { [GidUtils::AreWindowsDisabled] } {  
            #e.g. batch mode without windows
            return 1
        }       
        set value [MessageBoxOptionsButtons $title $question $options $labels $image $option_do_it_for_all_text]
        if { $value != "" } {
            GiD_Process $value
        } else {
            GiD_Process escape
        }
    }

    proc GiD_Implement_Event_MessageBoxOptionsButtonsModeless { title question options labels image button_callback cancel_callback } {
        if { [GidUtils::AreWindowsDisabled] } {  
            #e.g. batch mode without windows
            return 1
        }
        MessageBoxOptionsButtonsModeless $title $question $options $labels $image $button_callback $cancel_callback
    }
        
    proc GiD_Implement_Event_MessageBoxGetNormal { title } {
        if { [GidUtils::AreWindowsDisabled] } {  
            #e.g. batch mode without windows
            return 1
        }
        set normal [MessageBoxGetNormal $title]
        if { $normal != "" } {
            GiD_Process [join $normal ,]
        } else {
            GiD_Process escape
        }
    }    

    proc GiD_Implement_Event_MessageBoxGetFilename { cathegory mode title initial_filename file_types default_extension multiple extra_options } {        
        if { [GidUtils::AreWindowsDisabled] } {  
            #e.g. batch mode without windows, and also batch when temporary windows are disabled (to avoid show file dialog when UnDo DXF or other formats import)
            return 1
        }
        set filename [MessageBoxGetFilename $cathegory $mode $title $initial_filename $file_types $default_extension $multiple $extra_options]
        if { $filename != "" } {
            set cmd [list]
            set get_extra_options_procedure [lindex $extra_options 2]
            if { $get_extra_options_procedure != "" } {
                lappend cmd {*}[$get_extra_options_procedure]
            }
            lappend cmd $filename
            GiD_Process {*}$cmd
        } else {
            GiD_Process escape
        }
    }

    proc GiD_Implement_Event_MessageBoxGetGeneralMeshSize { last_generation_size recommended_size get_meshing_parameters_from_model } {
        MeshGenerationWindow $last_generation_size $recommended_size $get_meshing_parameters_from_model
    }

    proc GiD_Implement_Event_BeforeSetWarnLine { message } {
        gid_client_update_warnline $message
    }

    proc GiD_Implement_Event_BeforeSetMenu { menu_data menu } {      
        if { 0 } {
            #cache to not re-build tk menus if doesn't change
            if { [info exists ::MenuPrevState($menu)] } {
                if { $::MenuPrevState($menu) == $menu_data } {
                    return
                }
            }
            set ::MenuPrevState($menu) $menu_data
        }
        gid_client_update_menu $menu_data $menu
    }

    proc GiD_Implement_Event_WarnWinText { message { title ""} } {
        gid_client_WarnWinText $message $title
    }

    proc GiD_Implement_Event_AfterSetProjectName { projectname } {           
        gid_client_update_title $projectname [GiD_Info project problemtype]
    }

    proc GiD_Implement_Event_AfterSetProblemtypeName { name } {
        gid_client_update_title [GiD_Info project modelname] $name
    }

    proc GiD_Implement_Event_AfterSetPostModelName { name } {  
        gid_client_update_title $name [GiD_Info project problemtype]
    }

    proc GiD_Implement_Event_AfterChangeZoomFactor { zoom_factor } {
        set err [ catch {
            # may be it's a NaN ...
            set zoom_factor_label "x [format %.2g $zoom_factor]"
        }]
        if { $err} {
            set zoom_factor_label "N/A"
        }
        gid_client_update_status_bar ZoomFactor $zoom_factor_label
    }

    proc GiD_Implement_Event_AfterChangeMesh { num_nodes num_elements } {
        gid_client_update_status_bar MeshInfo [list $num_nodes $num_elements]        
    }

    proc GiD_Implement_Event_AfterChangeLayersOrSets { num_layers num_off num_withback num_transparent } {
        gid_client_update_status_bar LayersOrSetsInfo [list $num_layers $num_off $num_withback $num_transparent]
    }

    proc GiD_Implement_Event_AfterChangeCoordinates { coordinates } {
        set ::GidPriv(Coordinates) $coordinates
        gid_client_update_status_bar Coordinates $coordinates
    }

    proc GiD_Implement_Event_BeforeUpdateWindow { window } {
        GidUtils::UpdateWindow $window
    }

    proc GiD_Implement_Event_BeforeSetCursor { name togl } {
        gid_client_set_cursor $name $togl
    }

    proc GiD_Implement_Event_BeforeMeshProgress { n0 n1 n2 n3 } {
        if { ![info exists ::GidPriv(HideMeshProgress)] || $::GidPriv(HideMeshProgress) != 1 } {
            ProgressInMeshing::Init $n0 $n1 $n2 $n3
        }
    }

    #return -cancel- ;#to set user stop
    proc GiD_Implement_Event_MeshProgress { total_percent partial_percents_0 partial_percents_1 partial_percents_2 partial_percents_3 n_nodes n_elems } {
        if { ![info exists ::GidPriv(HideMeshProgress)] || $::GidPriv(HideMeshProgress) != 1 } {
            set result [ProgressInMeshing::MeshProgress $total_percent $partial_percents_0 $partial_percents_1 $partial_percents_2 $partial_percents_3 $n_nodes $n_elems]            
        } else {
            set result 0
        }
        return $result
    }

    proc GiD_Implement_Event_AfterMeshProgress { } {
        #ProgressInMeshing::End     
    }

    proc GiD_Implement_Event_AfterMeshGeneration { fail } {
        if { ![info exists ::GidPriv(HideMeshProgress)] || $::GidPriv(HideMeshProgress) != 1 } {
            #after 500 dark trick to try to allow finish ProgressInMeshing::CreateWindow            
            after 500 [list ProgressInMeshing::AfterMeshGeneration $fail]
        }
    }

    proc GiD_Implement_Event_AfterChangeLicence { password_mode password_type password_expiration } {                
        set ::GidPriv(password,mode) $password_mode
        set ::GidPriv(password,type) $password_type
        set ::GidPriv(password,expiration) $password_expiration
        if { $password_mode == "academic" } {
            set txt [_ "ACADEMIC licence. Click on Help->Register GiD in order to register a professional one"]
        } else {
            # password_mode == "professional"
            # password_type could be "none", "local", "usb", "floating", "login"
            if { $password_type == "login" } {
                #show the text cloud instead the internal key login
                set password_type "named user"
            }
            set txt [_ "%s %s licence" [string toupper [_ $password_mode]] [_ $password_type]]        
        }
        gid_client_update_warnline $txt
        ShowGiDVersionType $password_mode
    }
    
    proc GiD_Implement_Event_AfterLogin { username } {
        Login::UpdateLoginButton login $username  
        gid_client_update_warnline [_ "Signed in as %s" $username]
        
        if { [GiD_Info Project ProblemType] != "UNKNOWN" } {
            #if the problemype is loaded and has .xml file is has been read and ::problemtype_current array is filled
            if { [info exists ::problemtype_current(Name)] && [info exists ::problemtype_current(Version)] } {
                set program [string tolower $::problemtype_current(Name)]
                set main_version [lindex [split $::problemtype_current(Version) .] 0]                                
                set user_programs [Login::GetLoggedUserProgramsAvailable $username]
                if { [lsearch $user_programs [list $program $main_version]] != -1 || [lsearch $user_programs [list $program "X-X"]] != -1} {
                    # X-X , mean all versions like it was a * wildcard
                    if { ![GiD_Login is_session $program $main_version] } {
                        set err_login [ catch {                            
                            GiD_Login start_session $program $main_version
                        } error_code ]
                        if { $err_login} { 
                            Login::show_error_message $program $main_version $error_code
                        }
                    }
                }
            }
        }
    }

    # this event is only called before storing the usertoken.
    # ( when token is stored in file, then all gid's will raise the AfterLogin event)
    # data manager needs 1 GiD (the one doing activelly the login, i.e. storing the user_token in file)
    #     to launch this event so that it can mount the cloud folder locally
    # proc GiD_Implement_Event_BeforeLogin { username user_token} {
    # }

    proc GiD_Implement_Event_AfterLogout {  } {
        Login::UpdateLoginButton logout ""
        gid_client_update_warnline [_ "Signed out"]
    }

    proc GiD_Implement_Event_AfterStartSession { program main_version session_token } {
        if { $program == "gid" } {
            if { (![info exists ::GidPriv(password,mode)] || $::GidPriv(password,mode) == "academic") } {
                if { ![info exists ::GidPriv(LocalSessionStarted,$program,$main_version)] || !$::GidPriv(LocalSessionStarted,$program,$main_version) } {
                    #do this if session was started from outside
                    if { $session_token != "" } {
                        set ::GidPriv(LocalSessionStarted,$program,$main_version) 1 ;#to avoid recursive call                        
                        GiD_Login start_session_with_token $program $main_version $session_token
                        if { ![GiD_Login is_session $program $main_version] } {
                            #GiD_Login start_session_with_token failed
                            set ::GidPriv(LocalSessionStarted,$program,$main_version) 0
                        }
                    }
                }
            }
        }
        gid_client_update_warnline [_ "Started session %s" $program]
    }

    proc GiD_Implement_Event_AfterStopSession { program main_version } {
        if { $program == "gid" } {
            if { [info exists ::GidPriv(LocalSessionStarted,$program,$main_version)] && $::GidPriv(LocalSessionStarted,$program,$main_version) } {
                #do this if session was stopped from outside
                set ::GidPriv(LocalSessionStarted,$program,$main_version) 0 ;#to avoid recursive call
                GiD_Login end_session $program $main_version
                if { [GiD_Login is_session $program $main_version] } {
                    #GiD_Login end_session failed
                    set ::GidPriv(LocalSessionStarted,$program,$main_version) 1
                }
            }
        }
        gid_client_update_warnline [_ "Stopped session %s" $program]
    }

    #to update the user problemtypes menu
    proc GiD_Implement_Event_AfterDataManagerSetCloudFolder { path } {        
        CacheReset menu_data
        if { [GiD_Set Cloud(SynchronizePreferences)] } {
            if { $path != "" } {
                #path empty if cloud folder is not connected
                global GidPriv
                if { ![info exists ::GidPriv(user_preferences_from_cloud_were_read)] || !$::GidPriv(user_preferences_from_cloud_were_read) } {                
                    set file_key "gid.ini"
                    if { [GetAlternativeUserSettingsFilename] != "" } {
                        #-c2 must not save as "gid.ini" but as an alternative provided name like "IBER.ini"
                        set file_key [file tail [GetAlternativeUserSettingsFilename]]
                    }
                    Login::ReadLoggedUserPreferences $file_key
                }
            }
        }
    }

    #
    proc GiD_Implement_Event_BeforeRenderProgress { num_surfaces } {
        ProgressInRender::Init $num_surfaces
    }

    #return -cancel- ;#to set user stop
    proc GiD_Implement_Event_RenderProgress { total_percent n_nodes n_elems } {    
        return [ProgressInRender::RenderProgress $total_percent $n_nodes $n_elems]  
    }

    proc GiD_Implement_Event_AfterRenderProgress { } {
        ProgressInRender::End     
    }
        
    proc GiD_Implement_Event_AfterChangeRenderMode { render_mode } {        
        gid_client_update_status_bar RenderMode $render_mode
    }

    proc GiD_Implement_Event_AfterChangeViewMode { ViewMode } {
        if { $ViewMode == "GEOMETRYUSE" || $ViewMode == "MESHUSE" } {
            after idle {
                GidUtils::UpdateWindow COPY
                SetStateConditionGroupsAllowedTypes GD_CND_1
            }
        }
    }   

    proc GiD_Implement_Event_AfterRunCalculation  { name directory problemtype uid error filenameerror } {
        gid_client_after_run_calculation $name $directory $problemtype $uid $error $filenameerror
    }

    proc GiD_Implement_Event_InitGIDPostProcess {} {
        StatusBarToPost
        if { [info exists ::GidPriv(PrePostButtonName)] && [winfo exists $::GidPriv(PrePostButtonName)] } {
            $::GidPriv(PrePostButtonName) configure -image [gid_themes::GetImage pre_post.png toolbar]
        }
        if { [info exists ::problemtype_current(CustomLibAutomatic)] && $::problemtype_current(CustomLibAutomatic) } {  
            #avoid continue showing data tree in post
            gid_groups_conds::close_all_windows
            #gid_groups_conds::open_post check_default 
        }
        #after idle ChangeTopMenusAndWindows
        #DispWinContainer.MakeCurrent(DispWin);
        ChangeTopMenusAndWindows
        CreateResultFromEmbeddedDistance
    }

    proc GiD_Implement_Event_EndGIDPostProcess {} {         
        StatusBarToPre        
        if { [info exists ::GidPriv(PrePostButtonName)] && [winfo exists $::GidPriv(PrePostButtonName)] } {
            $::GidPriv(PrePostButtonName) configure -image [gid_themes::GetImage post_pre.png toolbar]
        }
        
        if { [info exists ::problemtype_current(CustomLibAutomatic)] && $::problemtype_current(CustomLibAutomatic) } {  
            #gid_groups_conds::close_all_windows
            #gid_groups_conds::open_conditions check_default
            gid_groups_conds::open_conditions menu
        }
        ChangeTopMenusAndWindows
        return 0
    }    

    proc GiD_Implement_Event_AfterSetGraphSetToUse { name } {
        GiD_Togl current .gid.central.s
        GiD_Redraw
    }

    proc GiD_Implement_Event_BeforeInitProblemtype { dir } {
        if { $::gid_start_mode == "client" } {
            #dir is the full path location on the server, probably is different at server side, must be fixed
            set dir [file join [gid_filesystem::get_folder_standard problemtypes] [GidUtils::GetRelativeProblemTypePath $dir]]            
        }

        
        gid_common_problemtype_init_message_catalogs $dir                  
        gid_common_problemtype_init_themes $dir
        gid_common_problemtype_init_read_xml $dir
        gid_common_problemtype_init_customlib_automatic $dir
        gid_common_problemtype_init_tcl_source $dir

        if { !$::GID_LOGIN_HIDE && [GiD_Login is_logged] } {
            if { [info exists ::problemtype_current(Name)] && [info exists ::problemtype_current(Version)] } {                
                set program [string tolower $::problemtype_current(Name)]
                set main_version [lindex [split $::problemtype_current(Version) .] 0]
                set username [GiD_Login logged_username]
                set user_programs [Login::GetLoggedUserProgramsAvailable $username]
                if { [lsearch $user_programs [list $program $main_version]] != -1 || [lsearch $user_programs [list $program "X-X"]] != -1} {
                    # X-X , mean all versions like it was a * wildcard
                    if { ![GiD_Login is_session $program $main_version] } {
                        catch { GiD_Login start_session $program $main_version } error_code
                    }
                }
            }
        }

        if { $::gid_start_mode == "client" } {
            #dir is the full path location on the server, probably is different at server side, must be fixed
            set dir [file [gid_filesystem::get_folder_standard problemtypes] [GidUtils::GetRelativeProblemTypePath $dir]]
            GiD_RaiseEvent GiD_Event_InitProblemtype $dir
            GiD_RaiseEvent InitGIDProject $dir ;#deprecated, but raised for back compatibility
        }
    }
        
    #    proc GiD_Implement_Event_InitProblemtype { dir } {
    #        if { ![info exists ::problemtype_current(EnableDeprecated)] || !$::problemtype_current(EnableDeprecated) } {  
    #            check_implemented_events
    #        }
    #    }

    proc GiD_Implement_Event_EndProblemtype { } {
        gid_common_problemtype_end_customlib_automatic
        foreach event_name [GiD_Info events] {
            catch {rename $event_name {}}
        }
        foreach event_name [GiD_Info events -deprecated] {
            catch {rename $event_name {}}
        }
        ConfigureProgramSetVariablesDefault
        DWInitUserDataOptions
        
        if { ![GidUtils::AreWindowsDisabled] && [GiD_Set MaintainProblemTypeInNew] } {
            SetAllMenusVariables
            after 100 [list CreateTopMenus]
        }
    }

    proc GiD_Implement_Event_AfterChangeProblemtype { old_problemtype new_problemtype } {
        gid_common_problemtype_after_change_problemtype $old_problemtype $new_problemtype
    }

    proc GiD_Implement_Event_MessageBoxZmesherAskPassword { id_machinename id_operating_system id_sysinfo } {
        GiD_Password zmesher window $id_machinename $id_operating_system $id_sysinfo local
    }

    proc GiD_Implement_Event_AfterSetVariable { variable value } { 
        if { $variable == "MeshType" } {
            #UpdateMenusAndToolbars
            UpdateMenus ;#this really also modify preferences window
            CreateWidgetsFromXml::UpdatePreferencesWindow
        } elseif { [lsearch -sorted -dictionary [list AutoCollapseAfterImport AutoImportTolerance CollapseAllowMoreTasks CollapseIgnoringLayers ImportTolerance] $variable] !=-1 } {
            #to avoid unwanted behavior that changing the global variable the local variable of the window (e.g. IGES import) remember his last value different of the preference!!
            BrowserExtraOptionsImportGeomClearCache
        }
    }

    proc GiD_Implement_Event_ChangedLanguage { language } {
        MsgcatSetLocale $language
        GUI_UpdateWidgetsLanguage
    }
                   
    proc GiD_Implement_Event_ResizeTogl { w width height x y } {
        if { $::gid_start_mode == "client" } {   
            if { [info exists ::img_screen] } {
                gid_client_on_resize_togl $w $width $height $x $y
            }     
        }
    }

    
    proc GiD_Implement_Event_AfterEndCommand { is_view } {
        if { !$is_view } {
            Undo::ResetRedo
        }
    }

    proc GiD_Implement_Event_BeforeExit { } {
        GidLock::ModelDeleteLockFile
    }

    proc GiD_Implement_Event_DiskFull { filename } {
        set message [_ "Error writing file '%s': no space left on device" $filename]
        set is_cloud_path [GidDataManager::isCloudPath $filename]
        if { $is_cloud_path } {
            W $message
            W [_ "Cloud unit full (can buy more storage space at https://shop.gidsimulation.com)"]
        } else {
            #MessageBoxOkModeless [_ "Disk full"] $message error
            W $message
        }
    }

} else {
    error "this file must not be sourced with ::gid_start_mode=$::gid_start_mode"
}
