if { $::gid_start_mode == "normal" } {
    #the file is sourced also in normal mode to define common GUI procs
} elseif { $::gid_start_mode == "server" } {
    error "this file must not be sourced with ::gid_start_mode=$::gid_start_mode"
} elseif { $::gid_start_mode == "client" } {


    proc gid_client_debug_print { text } {
        # W "gid_client_debug_print $text"
        #GidUtils::DebugPrint $text           
    }

    proc gid_client_debug_open { } {
        # W gid_client_debug_open
        #GidUtils::DebugOpen
    }

    proc gid_client_debug_close { } {
        # W gid_client_debug_close
        #GidUtils::DebugClose
    }                    
   
    proc gid_client_get_host { } {
        if { $::gid_start_server_ip == "" } {
            set host localhost
        } else {
            set host $::gid_start_server_ip
        }
        return $host
    }

    proc gid_client_get_port { } {
        if { $::gid_start_port == "" } {
            set port [gid_client_get_default_port]
        } else {
            set port $::gid_start_port
        }
        return $port
    }

    if { $::gid_server_client_protocol == "comm" } {

        proc gid_client_get_default_port { } {
            return 6900 ;#comm default port
        }
  
        proc gid_client_connect { } {
            gid_client_debug_open
            package require comm
            #::comm::comm configure -listen 0
            set port [gid_client_get_port]
            set host [gid_client_get_host] ;#eon 147.83.143.187
            if { $host == "localhost" || $host == "127.0.0.1" } {
                set ::server_id $port
            } else {                
                set ::server_id [list $port $host]  
            }    
            #if { [catch { ::comm::comm connect $::server_id } msg] } {
            #    second try after 1 second to allow the server start
            #    after 1000
            #    ::comm::comm connect $::server_id
            #}
            ::comm::comm connect $::server_id
        }

        proc gid_server_eval { script } {
            gid_client_debug_print "EVAL $script"
            ::comm::comm send $::server_id $script
        }

        proc gid_server_eval_async { script } {
            gid_client_debug_print "EVAL_ASYNC $script"
            ::comm::comm send -async $::server_id $script
        }

        #asyncronous (modeless) but invoking a callback proc when processing
        #not used by now...
        proc gid_server_eval_async_callback { script callback_command } {
            ::comm::comm send -command $callback_command $::server_id $script
        }

    } elseif { $::gid_server_client_protocol == "rabbitmq" } {

        set ::rmq_use_tls 0
        set ::rmq_channel_client "" ;#internal use to be passed to procs
        set ::rmq_reply_to_queue "" ;#internal use to be passed to procs
        if { [ info exists ::gid_start_client_sessionid] } {
            set ::rmq_sessionid $::::gid_start_client_sessionid
        } else {
            set ::rmq_sessionid 1
        }
        if { [ info exists ::gid_start_client_username] && [ info exists ::gid_start_client_password]} {
            set ::rmq_user $::gid_start_client_username
            set ::rmq_pass $::gid_start_client_password
        } else {
            # package require rmq  ; # to define ::rmq::DEFAULT_UN and ::rmq::DEFAULT_PW
            # set user $::rmq::DEFAULT_UN ;#guest
            # set pass $::rmq::DEFAULT_PW ;#guest
            set ::rmq_user guest
            set ::rmq_pass guest            
        }
        # queue_name should have a sessionID so a single user can have different sessions
        # at the moment we'll use the username so that different users can work at the same time
        # When poler-equiv is ready we'll use sessionID instead
        set ::rmq_server_input_queue_name queue_server_input-$::rmq_user-$::rmq_sessionid
        set ::rmq_exchange_server_output exchange_server_output-$::rmq_user-$::rmq_sessionid
        
        proc gid_client_get_default_port { } {
            package require rmq        
            if { $::rmq_use_tls } {
                # using the guide in https://www.rabbitmq.com/ssl.html
                set port 5671
            } else {
                set port $::rmq::DEFAULT_PORT ;# 5672
            }
            return $port
        }

        proc gid_client_connect { } {
            gid_client_debug_open
            #$::gid_start_port $::gid_start_server_ip  (if $::gid_start_server_ip == "" use localhost)
            package require uuid
            package require rmq            
            set port [gid_client_get_port]
            set host [gid_client_get_host]
            # set user $::rmq::DEFAULT_UN ;#guest
            # set pass $::rmq::DEFAULT_PW ;#guest
            set rqm_login [::rmq::Login new -user $::rmq_user -pass $::rmq_pass]        
            set rmq_connection [rmq::Connection new -host $host -port $port -login $rqm_login]
            if { $::rmq_use_tls } {
                $rmq_connection tlsOptions -cafile "$::env(HOME)/testca/cacert.pem" \
                    -certfile "$::env(HOME)/client/cert.pem" \
                    -keyfile "$::env(HOME)/client/key.pem"
            }

            $rmq_connection onConnected _gid_client_on_connected
            $rmq_connection onClose _gid_client_on_close
            $rmq_connection onError _gid_client_on_error
            $rmq_connection onBlocked _gid_client_on_bloqued
            $rmq_connection onFailedReconnect _gid_client_on_fail_reconnect
            $rmq_connection connect                      
        }

        #syncronous (modal)
        proc gid_server_eval { script } {     
            if { $::rmq_channel_client == "" || $::rmq_reply_to_queue == "" } {
                gid_client_debug_print "gid_server_eval $script ::rmq_channel_client=$::rmq_channel_client ::rmq_reply_to_queue=$::rmq_reply_to_queue"
                return ""
            }            
            set channel $::rmq_channel_client
            set reply_to $::rmq_reply_to_queue                        
            set data [list EVAL $script]
            set exchange_name ""
            set routing_key $::rmq_server_input_queue_name ; # "queue_server_input"
            set flags [list]
            #use an id to track this rpc (remote procedure call) that is a syncronous (modal) call expecting a result
            set correlation_id [::uuid::uuid generate]
            set rpc_properties [dict create]
            dict set rpc_properties correlation-id $correlation_id
            dict set rpc_properties reply-to $reply_to           
            gid_client_debug_print ">> DATA $data"
            set ::rmq_rpc_result($correlation_id) ""
            $channel basicPublish $data $exchange_name $routing_key $flags $rpc_properties            
            vwait ::rmq_rpc_result($correlation_id)            
            set result $::rmq_rpc_result($correlation_id)
            unset ::rmq_rpc_result($correlation_id)
            return $result
        }

        #asyncronous (modeless)
        proc gid_server_eval_async { script } {
            if { $::rmq_channel_client == "" } {                
                gid_client_debug_print "gid_server_eval $script ::rmq_channel_client=$::rmq_channel_client"
                return ""
            }
            set channel $::rmq_channel_client   
            set data [list EVAL_ASYNC $script]
            set exchange_name ""
            set routing_key $::rmq_server_input_queue_name ; # "queue_server_input"
            set flags [list]
            set props ""
            gid_client_debug_print "<< DATA $data"    
            $channel basicPublish $data $exchange_name $routing_key $flags $props
            return ""
        }

        #rabbitmq particular procs
        ##########################

        proc  _gid_client_on_receive { channel methodD frameD msg } {
            #gid_client_debug_print "_gid_client_on_receive "  
           after idle [list _gid_client_on_receive_do_at_level_0 $channel $methodD $frameD $msg]
        }

        proc  _gid_client_on_receive_do_at_level_0 { channel methodD frameD msg } {
            #gid_client_debug_print "_gid_client_on_receive_do_at_level_0 channel=$channel methodD=$methodD frameD=$frameD msg=$msg"
            gid_client_debug_print ">> ON RECEIVE $msg"                  
            lassign $msg action value        
            if { $action == "RESULT" } {
                lassign $value fail result
                set rpc_properties [dict get $frameD properties]
                set correlation_id [dict get $rpc_properties correlation-id]
                if { [info exists ::rmq_rpc_result($correlation_id)] } {                    
                    set ::rmq_rpc_result($correlation_id) $result
                } else {
                    gid_client_debug_print "***DOESN'T MATCH!! correlation_id=$correlation_id fail=$fail result=$result"
                }                               
            } elseif { $action == "EVAL_ASYNC" } {
                #gid_client_debug_print "EVAL_ASYNC $value"
                set proc_name [lindex $value 0]
                set arguments [lrange $value 1 end]
                if { [string range $proc_name 0 19] == "GiD_Implement_Event_" } {
                    after idle [list GiD_RaiseEvent $proc_name {*}$arguments]
                    #W "GiD_RaiseEvent $proc_name {*}$arguments"
                } else {
                    #could validate before if it is an allowed proc
                    #after idle $proc_name {*}$arguments
                    after idle [list eval $value]
                    #W "after idle [list eval $value]"
                }
            } elseif { $action == "EVAL" } {
                W "better do not use rpc syncronous call from server to client!!"                
            } else {
                W "unexpected action $action"
            }            
            #$channel basicAck [dict get $methodD deliveryTag]
        }

        proc _gid_client_on_queue_declare_ok { channel queue_name msg_count consumers } {   
            #gid_client_debug_print "_gid_client_on_queue_declare_ok channel=$channel queue_name=$queue_name msg_count=$msg_count consumers=$consumers"
            if { $queue_name != $::rmq_server_input_queue_name } {
                #warning: this callback command is raised also for queues with queueDeclare used before set the callback!!
                #check then that only apply its body when necessary!!
                # bind the new self-named exclusive queue to the fanout exchange_client_input exchange, with default empty string routing key
                set exchange_name $::rmq_exchange_server_output
                set routing_key ""
                set no_wait 0
                set qargs ""
                $channel queueBind $queue_name $exchange_name $routing_key $no_wait $qargs
                #set the queue consume callback   
                
                set consume_tag "" ;# empty: automatic tag will be created bu the server
                # consume bit flags:
                # CONSUME_NO_LOCAL
                # CONSUME_NO_ACK
                # CONSUME_EXCLUSIVE 
                # CONSUME_NO_WAIT    
                set consume_flags [list $::rmq::CONSUME_NO_ACK]
                set consume_args ""
                $channel basicConsume _gid_client_on_receive $queue_name $consume_tag $consume_flags $consume_args                
                set ::rmq_reply_to_queue $queue_name                
            }            
        }

        proc _gid_client_on_queue_delete_ok { args } {
            #gid_client_debug_print "_gid_client_on_queue_delete_ok args=$args"
        }

        proc _gid_client_on_queue_unbind_ok { args } {
            #gid_client_debug_print "_gid_client_on_queue_unbind_ok args=$args"
        }

        proc _gid_client_on_connected { connection } {
            #gid_client_debug_print "_gid_client_on_connected $connection"
            set channel [rmq::Channel new $connection]
            #$channel basicQos 1 1;#quality of service, to not give more than one message to a consumer at a time, prefetchCount=1, globalQos=1

            $channel on queueDeclareOk _gid_client_on_queue_declare_ok
            $channel on queueDeleteOk _gid_client_on_queue_delete_ok
            $channel on queueUnbindOk _gid_client_on_queue_unbind_ok

            # queue bit flags:
            # QUEUE_PASSIVE (queue must previously exists, used to check existence)
            # QUEUE_DURABLE (persistent re-filled restarting rabbitMQ)
            # QUEUE_EXCLUSIVE (only this channel? could consume)
            # QUEUE_AUTO_DELETE (delete the queue when last consumer unsubscribes)
            # QUEUE_DECLARE_NO_WAIT (?)
            set queue_flags [list $::rmq::QUEUE_AUTO_DELETE]
            #set queue_flags [list ]
            # Warning-1: (name cannot be a predefined constant: see warning-1 explanation in gid_server.tcl)
            $channel queueDeclare $::rmq_server_input_queue_name $queue_flags
                    
            # create an exclusive input queue by client
            # declare also a exchange fanout named $::rmq_exchange_server_output and bind this queue to it to facilitate server send an event to all clients
            # but also the server could answer to a client from its queue instead of the exchange
            # Warning-1: (name cannot be a predefined constant: see warning-1 explanation in gid_server.tcl)
    
            set exchange_flags [list $::rmq::EXCHANGE_AUTO_DELETE]
            # set exchange_flags [list ] ;#a comment of tclrms said that the flag EXCHANGE_AUTO_DELETE must be 0?
            $channel exchangeDeclare $::rmq_exchange_server_output "fanout" $exchange_flags

            # declare an exclusive queue and bind to the fanout exchange            
            
            set queue_flags [list $::rmq::QUEUE_EXCLUSIVE]
            set ::rmq_reply_to_queue ""
            $channel queueDeclare "" $queue_flags
            if { $::rmq_reply_to_queue == "" } {                
                vwait ::rmq_reply_to_queue                       
            }            
            set ::rmq_channel_client $channel
        }

        proc _gid_client_on_close { rmq_connection closeD } {      
            #gid_client_debug_print "_gid_client_on_close rmq_connection=$rmq_connection closeD=$closeD"
            set ::rmq_channel_client ""
            set ::rmq_reply_to_queue ""
            gid_client_debug_close
            if { [dict get $closeD replyCode] == "403" } {
                W "replyCode 403 : [dict get $closeD replyText]"
            }
                    
        }

        proc _gid_client_on_error { args } {
            #gid_client_debug_print "_gid_client_on_error args=$args"
        }

        proc _gid_client_on_bloqued { args } {
            #gid_client_debug_print "_gid_client_on_bloqued args=$args"
        }

        proc _gid_client_on_fail_reconnect { args } {
            #gid_client_debug_print "_gid_client_on_fail_reconnect args=$args"
        }
    
    } elseif { $::gid_server_client_protocol == "websocket" } {
        set ::ws_socket_client "" ;#internal use to be passed to procs

        proc gid_client_get_default_port { } {
            # return 80 ;#ws default port
            #return 9160 ;#ws default port
            return 443 ;#wss  default port
        }
        
        proc _gid_client_on_receive { wsock type msg } {     
            gid_client_debug_print ">> ON RECEIVE $type $msg"
            switch -nocase -- $type {
                "error" {
                    W "Error _gid_client_on_receive: $msg"
                    close $wsock
                    set ::ws_socket_client $socket ""
                    #gid_client_debug_print ">>$type $msg"                    
                }
                "connect" {                    
                    ##gid_client_debug_print ">>$type $msg"                    
                }
                "text" {
                    set action [lindex $msg 0]               
                    if { $action == "RESULT" } {
                        lassign $msg action correlation_id fail result          
                        if { [info exists ::ws_rpc_result($correlation_id)] } {                                  
                            set ::ws_rpc_result($correlation_id) $result
                        } elseif { [info exists ::ws_callback($correlation_id)] } { 
                            set callback_command ::ws_callback($correlation_id)
                            after idle [list {*}$callback_command $fail $result]                       
                            unset ::ws_callback($correlation_id)                 
                        } else {
                            error "Doesn't match correlation_id=$correlation_id fail=$fail result=$result"                            
                        }            
                    } elseif { $action == "EVAL_ASYNC" } {
                        #gid_client_debug_print ">> EVAL_ASYNC $type $msg"
                        lassign $msg action command
                        set proc_name [lindex $command 0]
                        set arguments [lrange $command 1 end]
                        if { [string range $proc_name 0 19] == "GiD_Implement_Event_" } {                            
                            after idle [list GiD_RaiseEvent $proc_name {*}$arguments]
                            #gid_client_debug_print "GiD_RaiseEvent $proc_name {*}$arguments"
                        } else {
                            #could validate before if it is an allowed proc
                            #after idle $proc_name {*}$arguments
                            after idle [list eval $command]                           
                        }
                    } elseif { $action == "EVAL" } {
                        #gid_client_debug_print ">> EVAL $type $msg"  
                        #W "better do not use rpc syncronous call from server to client!!"
                        # but it seemt that works better sending images to client and the server waiting its evaluation!!!
                        lassign $msg action correlation_id command                   
                        set fail [catch {eval $command} result]                   
                        #set result [{*}$command]     
                        #rpc. reply only to this client                    
                        set data [list RESULT $correlation_id $fail $result]
                        #gid_server_debug "_gid_client_websocket_send $wsock text $data"                  
                        _gid_client_websocket_send $wsock text $data             
                    } else {
                        #gid_client_debug_print ">> ? $action ? $type $msg"
                        W "unexpected action $action"
                    }                            
                }
                "binary" {
                    #gid_client_debug_print ">>$type $msg"
                }
                "close" {
                    #gid_client_debug_print ">>$type $msg"
                    array unset ::ws_rpc_result *
                    array unset ::ws_callback *
                    gid_client_debug_close                    
                }
                "disconnect" {
                    #gid_client_debug_print ">>$type $msg"
                }
                "request" {
                    #gid_client_debug_print ">>$type $msg"
                }
                "ping" {
                    #gid_client_debug_print ">>$type $msg"
                }
                "pong" {
                    #gid_client_debug_print ">>$type $msg"
                }
                default {
                    error "unexpected type $type $msg"
                }                
            }            
        }
  
        proc gid_client_connect { } {     
            gid_client_debug_open
            package require websocket
            package require uuid
            set port [gid_client_get_port]
            set host [gid_client_get_host] ;#eon 147.83.143.187
            if { 1 } {
                package require tls
                if { [info exists ::env(http_proxy)] || [info exists ::env(https_proxy)] } {
                    package require autoproxy
                    autoproxy::init
                    # it seems that here -autoservername 1 option is not valid
                    http::register https 443 [list autoproxy::tls_socket]
                } else {
                    http::register https 443 [list ::tls::socket -autoservername 1]
                }
                set socket [::websocket::open wss://$host:$port _gid_client_on_receive -protocol gid -timeout 10000]
            } else {
                set socket [::websocket::open ws://$host:$port _gid_client_on_receive -protocol gid -timeout 10000]
            }            
            #chan configure $socket -translation binary -blocking 0
            #fconfigure $socket -blocking 0            
            ##gid_client_debug_print "[::websocket::conninfo $socket type] from [::websocket::conninfo $socket sockname] to [::websocket::conninfo $socket peername]"
            update ;#seems that otherwise websocket::send is not sending
            set ::ws_socket_client $socket                
        }

        #use an id to track this rpc (remote procedure call) that is a syncronous (modal) call expecting a result
        proc gid_server_eval { script } {                    
            set correlation_id [::uuid::uuid generate]
            set ::ws_rpc_result($correlation_id) ""
            #gid_client_debug_print "EVAL $script"            
            _gid_client_websocket_send $::ws_socket_client text [list EVAL $correlation_id $script]                    
            vwait ::ws_rpc_result($correlation_id)            
            set result $::ws_rpc_result($correlation_id)
            unset ::ws_rpc_result($correlation_id)
            ##gid_client_debug_print "=$result"               
            return $result
        }

        proc gid_server_eval_async { script } {      
            #gid_client_debug_print "EVAL_ASYNC $script"                
            _gid_client_websocket_send $::ws_socket_client text [list EVAL_ASYNC $script]            
            return         
        }

        #asyncronous (modeless) but invoking a callback proc when processing
        #not used by now...
        proc gid_server_eval_async_callback { script callback_command } {        
            set correlation_id [::uuid::uuid generate]
            set ::ws_callback($correlation_id) $callback_command
            _gid_client_websocket_send $::ws_socket_client text [list EVAL_ASYNC_CALLBACK $correlation_id $script]
            return correlation_id
        }

        #particular procs
        ##########################
        proc _gid_client_websocket_send { wsocket type msg } {
            gid_client_debug_print "<< SEND $type $msg"
            set fail 1
            for {set i 0} { $i<20 } {incr i} {
                #update ;#seems that otherwise websocket::send is not sending
                set num_bytes [::websocket::send $wsocket $type $msg]                
                if { $num_bytes == -1 } {
                    update
                    #gid_client_debug_print "_gid_client_websocket_send num_bytes=$num_bytes i=$i"                    
                } else {
                    set fail 0
                    break
                }
            }
            if { $fail } {
                error "$msg"
            }            
            return $fail
        }
        
    } else {
        error  "unexpected gid_server_client_protocol=$::gid_server_client_protocol"
    }
}


proc GetCursorFilename { cursors_folder base_name } {
    set name ""
    if { $::tcl_platform(platform) == "windows" } {
        set name [list @[file join $cursors_folder ${base_name}.cur]]
    } else {
        # in macOS, although it reads the file it will not set the transparent background
        # showing an opaque square with white background and black foreground with the cursor image
        set name [list @[file join $cursors_folder ${base_name}.xbm] [file join $cursors_folder ${base_name}_msk.xbm] black white]
    }
    return $name
}

proc gid_client_initialize_theme_cursors { cursors_folder} {
    #standard cursors, available on all platforms
    set ::gid_cursor(NORMAL) ""
    set ::gid_cursor(SELECT_ONE) dotbox
    set ::gid_cursor(SELECT_BOX) crosshair
    set ::gid_cursor(CREATE_POINT) plus        
    set ::gid_cursor(CREATE_POINT_IN_LINE) icon
    set ::gid_cursor(WATCH) watch
    #cursors created from file
    set ::gid_cursor(ROTATE) [GetCursorFilename $cursors_folder rotate]    
    set ::gid_cursor(ROTATE_AROUND_X) [GetCursorFilename $cursors_folder rotate_around_x]
    set ::gid_cursor(ROTATE_AROUND_Y) [GetCursorFilename $cursors_folder rotate_around_y]
    set ::gid_cursor(ROTATE_AROUND_Z) [GetCursorFilename $cursors_folder rotate_around_z]
    set ::gid_cursor(PAN_FROM) [GetCursorFilename $cursors_folder pan_from]
    set ::gid_cursor(PAN_TO) [GetCursorFilename $cursors_folder pan_to]
    set ::gid_cursor(ZOOM) [GetCursorFilename $cursors_folder zoom]
    set ::gid_cursor(ZOOM_IN) [GetCursorFilename $cursors_folder zoom_in]
    set ::gid_cursor(ZOOM_OUT) [GetCursorFilename $cursors_folder zoom_out]        
    #n/f==near/far  t/b==top/bottom l/r==left/right
    set ::gid_cursor(LIGHT_NTL) [GetCursorFilename $cursors_folder light_ntl]
    set ::gid_cursor(LIGHT_NTR) [GetCursorFilename $cursors_folder light_ntr]
    set ::gid_cursor(LIGHT_NBL) [GetCursorFilename $cursors_folder light_nbl]
    set ::gid_cursor(LIGHT_NBR) [GetCursorFilename $cursors_folder light_nbr]
    set ::gid_cursor(LIGHT_FTL) [GetCursorFilename $cursors_folder light_ftl]
    set ::gid_cursor(LIGHT_FTR) [GetCursorFilename $cursors_folder light_ftr]
    set ::gid_cursor(LIGHT_FBL) [GetCursorFilename $cursors_folder light_fbl]
    set ::gid_cursor(LIGHT_FBR) [GetCursorFilename $cursors_folder light_fbr]
}

proc gid_client_initialize_standard_x11_cursors { } {
    # standard cursors are:
    # X_cursor arrow based_arrow_down based_arrow_up boat bogosity bottom_left_corner
    # bottom_right_corner bottom_side bottom_tee box_spiral center_ptr circle clock
    # coffee_mug cross cross_reverse crosshair diamond_cross dot dotbox double_arrow
    # draft_large draft_small draped_box exchange fleur gobbler gumby hand1 hand2
    # heart icon iron_cross left_ptr left_side left_tee leftbutton ll_angle lr_angle
    # man middlebutton mouse pencil pirate plus question_arrow right_ptr right_side
    # right_tee rightbutton rtl_logo sailboat sb_down_arrow sb_h_double_arrow sb_left_arrow
    # sb_right_arrow sb_up_arrow sb_v_double_arrow shuttle sizing spider spraycan
    # star target tcross top_left_arrow top_left_corner top_right_corner top_side
    # top_tee trek ul_angle umbrella ur_angle watch xterm
    # also in https://www.tcl.tk/man/tcl8.4/TkCmd/cursors.htm
    # Windows native:
    #   arrow
    #   center_ptr
    #   crosshair
    #   fleur
    #   ibeam
    #   icon
    #   sb_h_double_arrow
    #   sb_v_double_arrow
    #   watch
    #   xterm
    # Windows additional:
    #   no
    #   starting
    #   size
    #   size_ne_sw
    #   size_ns
    #   size_nw_se
    #   size_we
    #   uparrow
    #   wait
    # macOS native:
    #   arrow
    #   cross
    #   crosshair
    #   ibeam
    #   plus
    #   watch
    #   xterm
    # macOS additional:
    #   copyarrow
    #   aliasarrow
    #   contextualmenuarrow
    #   text
    #   cross-hair
    #   closedhand
    #   openhand
    #   pointinghand
    #   resizeleft
    #   resizeright
    #   resizeleftright
    #   resizeup
    #   resizedown
    #   resizeupdown
    #   none
    #   notallowed
    #   poof
    #   countinguphand
    #   countingdownhand
    #   countingupanddownhand
    #   spinning
    #standard cursors, available on all platforms
    set ::gid_cursor(NORMAL) ""
    set ::gid_cursor(SELECT_ONE) dotbox
    set ::gid_cursor(SELECT_BOX) crosshair
    set ::gid_cursor(CREATE_POINT) plus        
    set ::gid_cursor(CREATE_POINT_IN_LINE) icon
    if { $::tcl_platform(os) == "Darwin" } {
        set ::gid_cursor(WATCH) spinning
    } else {
        set ::gid_cursor(WATCH) watch
    }
    #cursors created from file
    set ::gid_cursor(ROTATE) exchange
    # set ::gid_cursor(ROTATE) circle
    set ::gid_cursor(ROTATE_AROUND_X) circle
    set ::gid_cursor(ROTATE_AROUND_Y) circle
    set ::gid_cursor(ROTATE_AROUND_Z) circle
    if { $::tcl_platform(os) == "Darwin" } {
        set ::gid_cursor(PAN_FROM) openhand
        set ::gid_cursor(PAN_TO) closedhand
    } else {
        set ::gid_cursor(PAN_FROM) sb_right_arrow
        set ::gid_cursor(PAN_TO) right_side
    }
    set ::gid_cursor(ZOOM) sizing
    set ::gid_cursor(ZOOM_IN) sb_down_arrow
    set ::gid_cursor(ZOOM_OUT) sb_up_arrow
    #n/f==near/far  t/b==top/bottom l/r==left/right
    set ::gid_cursor(LIGHT_NTL) bottom_right_corner
    set ::gid_cursor(LIGHT_NTR) bottom_left_corner
    set ::gid_cursor(LIGHT_NBL) top_right_corner
    set ::gid_cursor(LIGHT_NBR) top_left_corner
    set ::gid_cursor(LIGHT_FTL) lr_angle
    set ::gid_cursor(LIGHT_FTR) ll_angle
    set ::gid_cursor(LIGHT_FBL) ur_angle
    set ::gid_cursor(LIGHT_FBR) ul_angle
}

proc gid_client_initialize_cursors { } {     
    package require gid_themes   
    set themes_folder [ gid_themes::GetThemesBaseFolder]
    set current_theme [gid_themes::GetCurrentTheme]
    #maybe themes are already not read (e.g. if gid.ini doesn't exists)
    set cursors_folder [file join $themes_folder $current_theme cursors]
    if { ![file exists $cursors_folder]} {
        foreach theme [glob -nocomplain -tails -directory $themes_folder -types d *] {
            set cursors_folder [file join [ gid_themes::GetThemesBaseFolder] $theme cursors]
            if { [file exists $cursors_folder]} {
                break
            }
        }
        if { ![file exists $cursors_folder]} {
            error "cursors_folder $cursors_folder doesn't exists"
        }
    }
    #separe cursors in two folders
    if { $::tcl_platform(platform) == "windows" } {         
        set cursors_folder [file join $cursors_folder cur]
        gid_client_initialize_theme_cursors $cursors_folder
    } else {
        if { $::tcl_platform(os) != "Darwin" } {
            set cursors_folder [file join $cursors_folder xbm]
            gid_client_initialize_theme_cursors $cursors_folder
        } else {
            gid_client_initialize_standard_x11_cursors
        }
    }
}

proc gid_client_set_cursor { name togl } {
    if { [winfo exists $togl] } {
        #set w .gid ;#this must not be hardcoded!!
        set w [winfo toplevel $togl]
        # W "$w $name cursor = '$::gid_cursor($name)'"
        $w configure -cursor $::gid_cursor($name)    
    }
}

# w usually could be .gid
proc gid_client_get_cursor { w } {
    set name ""
    if { [winfo exists $w] } {
        set cursor [$w cget -cursor]
        foreach item [array names ::gid_cursor] {
            if { $cursor == $::gid_cursor($item) } {
                set name $item
                break
            }
        }
    }
    return $name
}

proc gid_client_on_resize_togl { w width height x y } {
    #$w configure -width $width -height $height
    $::img_screen configure -width $width -height $height
    #assuming a single togl, in offscreen really must set the buffer size...
    gid_server_eval_async [list gid_server_set_main_draw_area_size $width $height]
}

#image_format: png jpeg or raw
#image_quality: 0 to 100 (unused in some formats)
proc gid_client_set_image_format { image_format image_quality } {   
    gid_server_eval_async [list set ::gid_server_client_image_format $image_format]
    gid_server_eval_async [list set ::gid_server_client_image_quality $image_quality]
}

proc gid_client_update_title { projectName problemType } {
    # ChangeWindowTitle $projectName $problemType
    GiD_RaiseEvent GiD_Event_ChangeMainWindowTitle $projectName $problemType
}

proc gid_client_update_warnline { message } {
    GidUtils::SetWarnLine $message    
}

proc gid_client_WarnWinText { message { title "" } } {
    WarnWinText $message $title
}

# type : warning info question error
proc gid_client_MessageWin { message { title "" } { type "warning"}} {
    set type [ string tolower $type]
    if { $type == "error"} {
        ErrorWin $message $title
    } elseif { $type == "info"} {
        InfoWin $message $title
    } elseif { $type == "question"} {
        QuestionWin $message $title
    } else {
        WarnWin $message $title
    }
}

proc gid_client_update_status_bar { key value } {
    StatusBarSet $key $value
}

proc gid_client_redefine_commands { } {
    #sync commands
    #GiD_Project was removed to get/set its values always from the client, not from the server
    #otherwise [GiD_Project set disable_windows] will return true if the server is offscreen (normal case), but the client has GUI (and the GUI become invisible)
    #but maybe some subcommands like [GiD_Project batchfile] must be refered to the server. This casuistic must be studied in detail...
    foreach cmd { GiD_Info GiD_Set GiD_Tools \
        GiD_ModifiedFileFlag GiD_MustRemeshFlag GiD_SetModelName \
            GiD_BackgroundImage GiD_Reflection \
            GiD_Geometry GiD_Layers GiD_EntitiesLayers GiD_Groups GiD_EntitiesGroups \
            GiD_Mesh GiD_Cartesian GiD_SetMeshOptions GiD_ProgressInMeshing \
            GiD_MeshPost \
            GiD_SetProblemtypeName GiD_AccessValue GiD_ModifyData GiD_AssignData \
            GiD_UnAssignData GiD_CreateData GiD_Book GiD_LocalAxes GiD_IntervalData \
            GiD_Sets GiD_EntitiesSets \
            GiD_Result \
            GiD_Graph GiD_GraphSet } {
        rename $cmd ${cmd}_Original
        proc $cmd args "gid_server_eval \[list $cmd \{*\}\$args]"
    }
    #async commands
    foreach cmd { GiD_Process GiD_Redraw } {
        rename $cmd ${cmd}_Original
        proc $cmd args "gid_server_eval_async \[list $cmd \{*\}\$args]"
    }
    #async commands with callback
    #gid_server_clients_eval_async_callback $script $callback_command
}

proc gid_client_setup { } { 
    #img::raw require Img > 1.4.1, and 1.4.6 show png images dark, seems a bug!!
    #in any case now using png or jpg is better to raw
    package require img::$::gid_server_client_image_format
    
    update ;#to have appropiated widget size    
    lassign [gid_server_eval gid_server_get_main_draw_area_size] w h
    #W "gid_client_setup w=$w h=$h"
    set ::img_screen [image create photo -width $w -height $h]
    #set client widget size same as server size
    set widget .gid.central.s
    set toplevel [winfo toplevel $widget]
    set offset_width [expr [winfo width $toplevel]-[winfo width $widget]]
    set offset_height [expr [winfo height $toplevel]-[winfo height $widget]]   
    #$widget configure -image $::img_screen -width $w -height $h
    $widget configure -width $w -height $h
    $widget create image 0 0 -tags image_screen -anchor nw -image $::img_screen
    #bind $widget <Destroy> +[list gid_client_shutdown]        
    wm geometry $toplevel [expr $offset_width+$w]x[expr $offset_height+$h]
    GiD_Redraw
}

#if img::raw is not available: require Img > 1.4.1 (and 1.4.6 has problems and show png images too dark!!)
#I am trying a mix of img::base and img::raw (and img::dted) 1.4.6 and the rest img 1.4.1 and works well in win x64
proc gid_client_convert_to_image_data_generic { w h pixels } {
    set row_bytes [expr {$w*3}]
    set row_hexa_letters [expr {$row_bytes*2}]
    set image_data [list]
    for {set row 0} {$row<$h} {incr row} {
        set i0 [expr {$row*$row_bytes}]
        set i1 [expr {$i0+$row_bytes-1}]
        binary scan [string range $pixels $i0 $i1] H$row_hexa_letters rgb888rowdata
        regsub -all -nocase -- {([0-9a-f]{6})} $rgb888rowdata {#\1 } rgb888rowdata_out
        lappend image_data $rgb888rowdata_out
    }
    return $image_data
}

proc gid_client_update_image_screen_compressed { w h pixels_compressed } {
    if { [info exists ::img_screen] } {
        $::img_screen put [binary encode base64 [zlib decompress $pixels_compressed]]
    }
}

proc gid_client_update_image_screen { pixels_base64 } {
    if { [info exists ::img_screen] } {
        $::img_screen put $pixels_base64
    }
}

proc gid_client_exit { } {
    exit 0
}

proc gid_client_dynamic_line { w x y type } {
    W "gid_client_dynamic_line $w $x $y $type"
}

proc gid_client_init { } {
    gid_client_connect    
    gid_pseudo_togl_redefine_commands ;#replace gid_togl by another widget that get the image from server           
    gid_client_redefine_commands
}
