proc translate_select_text {entity_type} {
	if { $entity_type == {POINTS} } {
		set msg [_ "Select all points"]
	} elseif { $entity_type == {LINES} } {
		set msg [_ "Select all lines"]
	} elseif { $entity_type == {SURFACES} } {
		set msg [_ "Select all surfaces"]
	} elseif { $entity_type == {VOLUMES} } {
		set msg [_ "Select all volumes"]
	} elseif { $entity_type == {ALL} } {
		set msg [_ "Select all"]
	} elseif { $entity_type == {NODES} } {
		set msg [_ "Select all nodes"]
	} elseif { $entity_type == {ELEMENTS} } {
		set msg [_ "Select all elements"]
	} elseif { $entity_type == {FACEELEMENTS} } {
		set msg [_ "Select all faces"]
	} else {
		set msg [_ "Select none"]
	}
	return $msg
}

proc make_win_filter { {w .gid.filter_win} } {
	global SelectionPriv
	if { [winfo exists $w] } {
		destroy $w
	}
	if { ![info exists SelectionPriv(status)] } {
		set entity_type NONE
	} else {
		set entity_type $SelectionPriv(status)
	}

	InitWindow2 $w -title [_ "Selection window"] \
		-geometryvariable PreSelectionWindowGeom \
		-initcommand make_win_filter -ontop
	if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

	wm minsize $w 150 150
	ttk::frame $w.frame_buttons -style BottomFrame.TFrame

	ttk::frame $w.frange
	ttk::radiobutton $w.frange.radiobutton_all -text [translate_select_text $entity_type] \
		-variable SelectionPriv(mode) -value ALL
	ttk::radiobutton $w.frange.radiobutton_from -text [_ "From"]: -variable SelectionPriv(mode) -value FROM

	set SelectionPriv(mode) ALL

	if { ![info exists SelectionPriv(from)] } { set SelectionPriv(from) "" }
	if { ![info exists SelectionPriv(to)] } { set SelectionPriv(to) "" }
	ttk::entry $w.frange.entry_from -textvariable SelectionPriv(from) -width 7
	ttk::label $w.frange.label_to -text [_ "To"]:
	ttk::entry $w.frange.entry_to -textvariable SelectionPriv(to) -width 7
	if { ![info exists ::SelectionPriv(var_mode_menu) ] } {
		set ::SelectionPriv(var_mode_menu) SWAP
	}
	[ TTKCB_CreateOrConfigure $w.menu_mode] $w.menu_mode -textvariable ::SelectionPriv(var_mode_menu) \
		-labels [list [_ "Swap"] [_ "Add"] [_ "Remove"]] \
		-values {SWAP ADD REMOVE}
	ttk::label $w.label_mode -text [_ "Mode"]:
	ttk::label $w.label_filter -text [_ "Filter"]:
	ttk::label $w.label_value -text [_ "Value"]:
	ttk::label $w.label_type -text [_ "Type"]:
	ttk::entry $w.entry_value -textvariable SelectionPriv(entry_value) -width 4
	ttk::label $w.label_field -text [_ "Field"]:
	ttk::frame $w.ffield
	#alternative representations of the same variable:
	ttk::entry $w.ffield.entry_field -textvariable ::SelectionPriv(entry_field) -width 4
	if { ![info exists ::SelectionPriv(entry_field)] } { set ::SelectionPriv(entry_field) 0 }
	ttk::checkbutton $w.ffield.cb_field -variable ::SelectionPriv(entry_field)

	#$w.SelectionPriv(entry_value) configure -state disabled
	create_filters_menu $w $entity_type

	ttk::button $w.frame_buttons.ok -text [_ "Apply"] -style BottomFrame.TButton -command [list OK_Select $w]
	#ttk::button $w.frame_buttons.clear_sel -text [_ "Clear"] -style BottomFrame.TButton -command [list WarnClearSelection $w]
	ttk::button $w.frame_buttons.clear_sel -text [_ "Clear"] -style BottomFrame.TButton -command {GiD_Process ClearSelection}
	ttk::button $w.frame_buttons.cancel -text [_ "Close"] -style BottomFrame.TButton -command [list destroy $w]

	# Geometry management
	grid $w.frange.radiobutton_all -row 0 -column 0 -columnspan 5 -sticky w
	grid $w.frange.radiobutton_from $w.frange.entry_from $w.frange.label_to $w.frange.entry_to -sticky w
	grid configure $w.frange.entry_from $w.frange.entry_to -sticky we

	grid $w.frange -row 0 -columnspan 2 -sticky new
	grid $w.label_mode $w.menu_mode -row 1 -sticky e
	grid configure $w.menu_mode -sticky ew
	grid $w.label_filter -row 2 -sticky e
	#grid $w.label_value -row 3 -sticky e
	#grid $w.label_type -row 3 -sticky e
	#grid $w.label_field $w.ffield -row 4 -sticky e
	#grid configure $w.ffield -sticky ew
	#grid columnconfigure $w.ffield "0" -weight 1

	grid columnconfigure $w.frange "1 3" -weight 1
	grid columnconfigure $w.frange "5" -weight 4

	grid $w.frame_buttons.ok $w.frame_buttons.clear_sel $w.frame_buttons.cancel -padx 2 -pady 6
	grid $w.frame_buttons -row 7 -sticky ews -columnspan 2
	grid anchor $w.frame_buttons center

	# Resize behavior management

	grid rowconfigure $w "6" -weight 1
	grid columnconfigure $w "1" -weight 1

	if {$entity_type=="NONE" || $entity_type=="ALL"} {
		disable_filter_win $w $entity_type
	} else {
		enable_filter_win $w $entity_type
	}

	focus $w.frame_buttons.cancel

	bind $w <Return> "OK_Select $w"
	bind $w <Escape> "GiD_Process escape ; destroy $w"
	bind $w <Destroy> [list +DestroyFilterWindow %W $w] ;# + to add to previous script

	# wm attributes $w -topmost 1
	# topmost forbidden
	# GidUtils::WindowAboveGid $w
	raise $w

	trace add variable SelectionPriv(from) write "change_entry_from_or_to $w ;#"
	trace add variable SelectionPriv(to) write "change_entry_from_or_to $w ;#"
	trace add variable SelectionPriv(entry_value) write "change_entry_value $w ;#"
	trace add variable SelectionPriv(var_filter_menu) write "change_filter_menu $w ;#"
	trace add variable SelectionPriv(var_mode_menu) write "change_mode_menu $w ;#"
	trace add variable SelectionPriv(var_condition_menu) write "change_condition_menu $w ;#"
	trace add variable SelectionPriv(mode) write "control_all_from $w ;#"
}

proc DestroyFilterWindow { W w } {
	if { $W != $w } return
	global SelectionPriv
	#avoid reenter multiple times, one by child
	trace remove variable SelectionPriv(from) write "change_entry_from_or_to $w ;#"
	trace remove variable SelectionPriv(to) write "change_entry_from_or_to $w ;#"
	trace remove variable SelectionPriv(entry_value) write "change_entry_value $w ;#"
	trace remove variable SelectionPriv(var_filter_menu) write "change_filter_menu $w ;#"
	trace remove variable SelectionPriv(var_mode_menu) write "change_mode_menu $w ;#"
	trace remove variable SelectionPriv(var_condition_menu) write "change_condition_menu $w ;#"
	trace remove variable SelectionPriv(mode) write "control_all_from $w ;#"
}

proc create_filters_menu {w entity_type} {
	global SelectionPriv
	if { 0 } {
		foreach item [list $w.menu_filters $w.menu_type $w.menu_layer $w.menu_group $w.menu_label $w.menu_material $w.menu_condition] {
			if { [winfo exists $item] } {
				destroy $item
			}
		}
		catch {
			unset SelectionPriv(var_filter_menu)
			unset SelectionPriv(var_type_menu)
			unset SelectionPriv(var_layer_menu)
			unset SelectionPriv(var_group_menu)
			unset SelectionPriv(var_material_menu)
			unset SelectionPriv(var_condition_menu)
		}
	}

	set nonename [_ "None"]
	set nonecommand {{""}}

	set layer_list [GiD_Layers list]
	set layer_names [concat $nonename $layer_list]
	set layer_commands [concat $nonecommand $layer_list]

	set group_list [Groups::ListGroups normal "" ""] ;#hidden groups are not listed
	set group_names [concat $nonename $group_list]
	set group_commands [concat $nonecommand $group_list]

	set matlist [GiD_Info materials]
	set matnames [concat $nonename $matlist]
	set matcommands [concat $nonecommand $matlist]

	set cndnames $nonename
	set cndcommands $nonecommand

	if {$entity_type == "POINTS"} {
		set cndlist [GiD_Info conditions over_point]
		set prefix {Point_}
		foreach cnd $cndlist {
			lappend cndnames [regsub -nocase $prefix $cnd {}]
		}
		set cndcommands "$nonecommand $cndlist"
		if { ![info exists ::SelectionPriv(var_filter_menu) ] } {
			set ::SelectionPriv(var_filter_menu) NONE
		}
		[ TTKCB_CreateOrConfigure $w.menu_filters] $w.menu_filters -textvariable ::SelectionPriv(var_filter_menu) \
			-labels	[list [_ "None"] [_ "Higher entities"] [_ "Layer"] [_ "Group"] [_ "Label"] [_ "Material"] [_ "Condition"]] \
			-values	{NONE HIGHERENTITY LAYER GROUP LABEL MATERIAL CONDITION}
		if { ![info exists ::SelectionPriv(var_type_menu) ] } {
			set ::SelectionPriv(var_type_menu) a
		}
		[ TTKCB_CreateOrConfigure $w.menu_type] $w.menu_type -textvariable ::SelectionPriv(var_type_menu) \
			-labels	a \
			-values	a
	} elseif {$entity_type == "LINES"} {
		set cndlist [GiD_Info conditions over_line]
		set prefix {Line_}
		foreach cnd $cndlist {
			lappend cndnames [regsub -nocase $prefix $cnd {}]
		}
		set cndcommands "$nonecommand $cndlist"
		if { ![info exists ::SelectionPriv(var_filter_menu) ] } {
			set ::SelectionPriv(var_filter_menu) NONE
		}
		[ TTKCB_CreateOrConfigure $w.menu_filters] $w.menu_filters -textvariable ::SelectionPriv(var_filter_menu) \
			-labels	[list [_ "None"] [_ "Higher entities"] [_ "Layer"] [_ "Group"] [_ "Label"] [_ "Material"] [_ "Condition"] [_ "Min. length"] \
			[_ "Max. length"] [_ "Entity type"]] \
			-values	{NONE HIGHERENTITY LAYER GROUP LABEL MATERIAL CONDITION MINLENGTH MAXLENGTH ENTITYTYPE}
		if { ![info exists ::SelectionPriv(var_type_menu) ] } {
			set ::SelectionPriv(var_type_menu) STLINE
		}
		[ TTKCB_CreateOrConfigure $w.menu_type] $w.menu_type -textvariable ::SelectionPriv(var_type_menu) \
			-labels	[list [_ "StLine"] [_ "ArcLine"] [_ "PolyLine"] [_ "NurbLine"]] \
			-values	{STLINE ARCLINE POLYLINE NURBLINE}
	} elseif {$entity_type == "SURFACES"} {
		set cndlist [GiD_Info conditions over_surface]
		set prefix {Surface_}
		foreach cnd $cndlist {
			lappend cndnames [regsub -nocase $prefix $cnd {}]
		}
		set cndcommands "$nonecommand $cndlist"
		if { ![info exists ::SelectionPriv(var_filter_menu) ] } {
			set ::SelectionPriv(var_filter_menu) NONE
		}
		[ TTKCB_CreateOrConfigure $w.menu_filters] $w.menu_filters -textvariable ::SelectionPriv(var_filter_menu) \
			-labels	[list [_ "None"] [_ "Higher entities"] [_ "Layer"] [_ "Group"] [_ "Label"]  [_ "Material"] [_ "Condition"] [_ "Num. sides"] [_ "Entity type"]] \
			-values	{NONE HIGHERENTITY LAYER GROUP LABEL MATERIAL CONDITION NUMSIDES ENTITYTYPE}
		if { ![info exists ::SelectionPriv(var_type_menu) ] } {
			set ::SelectionPriv(var_type_menu) PLSURFACE
		}
		[ TTKCB_CreateOrConfigure $w.menu_type] $w.menu_type -textvariable ::SelectionPriv(var_type_menu) \
			-labels	[list [_ "PLSurface"] [_ "CoonSurface"] [_ "ContactSurface"] [_ "MeshSurface"] \
			[_ "NurbSurface"] [_ "PolySurface"]] \
			-values	{PLSURFACE COONSURFACE CONTACTSURFACE MESHSURFACE NURBSURFACE POLYSURFACE}
	} elseif {$entity_type == "VOLUMES"} {
		set cndlist [GiD_Info conditions over_volume]
		set prefix {Volume_}
		foreach cnd $cndlist {
			lappend cndnames [regsub -nocase $prefix $cnd {}]
		}
		set cndcommands "$nonecommand $cndlist"
		if { ![info exists ::SelectionPriv(var_filter_menu) ] } {
			set ::SelectionPriv(var_filter_menu) NONE
		}
		[ TTKCB_CreateOrConfigure $w.menu_filters] $w.menu_filters -textvariable ::SelectionPriv(var_filter_menu) \
			-labels	[list [_ "None"] [_ "Layer"] [_ "Group"] [_ "Label"] [_ "Material"] [_ "Condition"] [_ "Num. sides"] [_ "Entity type"]] \
			-values	{NONE LAYER GROUP LABEL MATERIAL CONDITION NUMSIDES ENTITYTYPE}
		if { ![info exists ::SelectionPriv(var_type_menu) ] } {
			set ::SelectionPriv(var_type_menu) VOLUME
		}
		[ TTKCB_CreateOrConfigure $w.menu_type] $w.menu_type -textvariable ::SelectionPriv(var_type_menu) \
			-labels	[list [_ "Volume"]  [_ "ContactVolume"]] \
			-values	{VOLUME CONTACTVOLUME}
	} elseif {$entity_type == "ALL"} {
		if { ![info exists ::SelectionPriv(var_filter_menu) ] } {
			set ::SelectionPriv(var_filter_menu) NONE
		}
		[ TTKCB_CreateOrConfigure $w.menu_filters] $w.menu_filters -textvariable ::SelectionPriv(var_filter_menu) \
			-labels	[list [_ "None"] [_ "Layer"] [_ "Group"] [_ "Label"] [_ "Material"]] \
			-values {NONE LAYER GROUP LABEL MATERIAL}
		if { ![info exists ::SelectionPriv(var_type_menu) ] } {
			set ::SelectionPriv(var_type_menu) a
		}
		[ TTKCB_CreateOrConfigure $w.menu_type] $w.menu_type -textvariable ::SelectionPriv(var_type_menu) \
			-labels	a \
			-values	a
	} elseif {$entity_type == "ELEMENTS"} {
		set cndlist "[GiD_Info conditions over_element] [GiD_Info conditions over_face]"
		set prefix {Element_}
		foreach cnd $cndlist {
			lappend cndnames [regsub -nocase $prefix $cnd {}]
		}
		set cndcommands "$nonecommand $cndlist"
		if { ![info exists ::SelectionPriv(var_filter_menu) ] } {
			set ::SelectionPriv(var_filter_menu) NONE
		}
		[ TTKCB_CreateOrConfigure $w.menu_filters] $w.menu_filters -textvariable ::SelectionPriv(var_filter_menu) \
			-labels	[list [_ "None"] [_ "Layer"] [_ "Group"] [_ "Label"] [_ "Material"] [_ "Condition"] [_ "Min angle"] \
			[_ "Max angle"] [_ "Min edge"] [_ "Max edge"] [_ "Shape quality"] [_ "Minimum Jacobian"] \
			[_ "Entity type"]] \
			-values	{NONE LAYER GROUP LABEL MATERIAL CONDITION BADMINANGLE BADMAXANGLE MINLENGTH MAXLENGTH SHAPEQUALITY MINJACOB ELEMENTTYPE}
		if { ![info exists ::SelectionPriv(var_type_menu) ] } {
			set ::SelectionPriv(var_type_menu) LINEAR
		}
		[ TTKCB_CreateOrConfigure $w.menu_type] $w.menu_type -textvariable ::SelectionPriv(var_type_menu) \
			-labels	[list [_ "Linear"]  [_ "Triangle"] [_ "Quadrilateral"] \
			[_ "Tetrahedron"] [_ "Hexahedron"] [_ "Prism"] [_ "Pyramid"] [_ "Point"] [_ "Sphere"] [_ "Circle"]] \
			-values	{LINEAR TRIANGLE QUADRILATERAL TETRAHEDRA HEXAHEDRA PRISM PYRAMID POINT SPHERE CIRCLE}
	} elseif {$entity_type == "NODES"} {
		set cndlist [GiD_Info conditions over_node]
		set prefix {Node_}
		foreach cnd $cndlist {
			lappend cndnames [regsub -nocase $prefix $cnd {}]
		}
		set cndcommands "$nonecommand $cndlist"
		if { ![info exists ::SelectionPriv(var_filter_menu) ] } {
			set ::SelectionPriv(var_filter_menu) NONE
		}
		[ TTKCB_CreateOrConfigure $w.menu_filters] $w.menu_filters -textvariable ::SelectionPriv(var_filter_menu) \
			-labels	[list [_ "None"] [_ "Higher entities"] [_ "Layer"] [_ "Group"] [_ "Label"] [_ "Condition"]] \
			-values	{NONE HIGHERENTITY LAYER GROUP LABEL CONDITION}
		if { ![info exists ::SelectionPriv(var_type_menu) ] } {
			set ::SelectionPriv(var_type_menu) a
		}
		[ TTKCB_CreateOrConfigure $w.menu_type] $w.menu_type -textvariable ::SelectionPriv(var_type_menu) \
			-labels	a \
			-values	a
	} elseif {$entity_type == "FACEELEMENTS"} {
		if { ![info exists ::SelectionPriv(var_filter_menu) ] } {
			set ::SelectionPriv(var_filter_menu) NONE
		}
		[ TTKCB_CreateOrConfigure $w.menu_filters] $w.menu_filters -textvariable ::SelectionPriv(var_filter_menu) \
			-labels	[list [_ "None"] [_ "Layer"] [_ "Group"] ] \
			-values	{NONE LAYER GROUP}
		if { ![info exists ::SelectionPriv(var_type_menu) ] } {
			set ::SelectionPriv(var_type_menu) a
		}
		[ TTKCB_CreateOrConfigure $w.menu_type] $w.menu_type -textvariable ::SelectionPriv(var_type_menu) \
			-labels	a \
			-values	a
	} else {
		if { ![info exists ::SelectionPriv(var_filter_menu) ] } {
			set ::SelectionPriv(var_filter_menu) NONE
		}
		[ TTKCB_CreateOrConfigure $w.menu_filters] $w.menu_filters -textvariable ::SelectionPriv(var_filter_menu) \
			-labels	[list [_ "None"]] \
			-values	{NONE}
		if { ![info exists ::SelectionPriv(var_type_menu) ] } {
			set ::SelectionPriv(var_type_menu) a
		}
		[ TTKCB_CreateOrConfigure $w.menu_type] $w.menu_type -textvariable ::SelectionPriv(var_type_menu) \
			-labels	a \
			-values	a
	}

	if { ![info exists ::SelectionPriv(var_layer_menu) ] } {
		set ::SelectionPriv(var_layer_menu) [lindex $layer_commands 0]
	}
	[ TTKCB_CreateOrConfigure $w.menu_layer] $w.menu_layer -textvariable ::SelectionPriv(var_layer_menu) \
		-labels $layer_names \
		-values $layer_commands
	if { ![info exists ::SelectionPriv(var_group_menu) ] } {
		set ::SelectionPriv(var_group_menu) [lindex $group_commands 0]
	}
	[ TTKCB_CreateOrConfigure $w.menu_group] $w.menu_group -textvariable ::SelectionPriv(var_group_menu) \
		-labels $group_names \
		-values $group_commands
	if { ![info exists ::SelectionPriv(var_label_menu) ] } {
		set ::SelectionPriv(var_label_menu) OFF
	}
	[ TTKCB_CreateOrConfigure $w.menu_label] $w.menu_label -textvariable ::SelectionPriv(var_label_menu) \
		-labels [list [_ "Off"] [_ "On"]] \
		-values {OFF ON}
	if { ![info exists ::SelectionPriv(var_material_menu) ] } {
		set ::SelectionPriv(var_material_menu) [lindex $matcommands 0]
	}
	[ TTKCB_CreateOrConfigure $w.menu_material] $w.menu_material -textvariable ::SelectionPriv(var_material_menu) \
		-labels $matnames \
		-values $matcommands
	if { ![info exists ::SelectionPriv(var_condition_menu) ] } {
		set ::SelectionPriv(var_condition_menu) [lindex $cndcommands 0]
	}
	[ TTKCB_CreateOrConfigure $w.menu_condition] $w.menu_condition -textvariable ::SelectionPriv(var_condition_menu) \
		-labels $cndnames \
		-values $cndcommands

	grid $w.menu_filters -row 2 -column 1 -sticky we
	if  {$entity_type == "ALL"} {
		$w.menu_filters configure -state disabled
	}

	set SelectionPriv(var_filter_menu) {NONE}
}

proc control_all_from {w} {
	global SelectionPriv
	if {$SelectionPriv(mode) == "ALL"} {focus .gid.filter_win}
}

proc contr_entry {t_string t_entry} {
	return
	if {[regexp {.*([a-z]+).*} $t_string] || [regexp {.*([A-Z]+).*} $t_string]} {
		set last [expr [string length $t_string]-1]
		$t_entry delete $last
	}
}

proc change_entry_from_or_to {w} {
	global SelectionPriv
	set SelectionPriv(mode) FROM
	contr_entry $SelectionPriv(from) $w.frange.entry_from
	contr_entry $SelectionPriv(to) $w.frange.entry_to
}

proc change_entry_value {w} {
	global SelectionPriv
	contr_entry $SelectionPriv(entry_value) $w.entry_value
}


proc change_filter_menu {w} {
	global SelectionPriv
	if { $SelectionPriv(var_filter_menu) == "ENTITYTYPE" || $SelectionPriv(var_filter_menu) == "ELEMENTTYPE" } {
		grid forget $w.entry_value
		grid forget $w.label_value
		grid forget $w.menu_layer
		grid forget $w.menu_group
		grid forget $w.menu_label
		grid forget $w.menu_material
		grid forget $w.menu_condition
		grid $w.label_type -row 3 -column 0 -sticky e
		grid $w.menu_type -row 3 -column 1 -sticky we
		grid forget $w.label_field $w.ffield
	} elseif { $SelectionPriv(var_filter_menu) == "LAYER" } {
		grid forget $w.entry_value
		grid forget $w.label_value
		grid forget $w.menu_type
		grid forget $w.menu_group
		grid forget $w.menu_label
		grid forget $w.menu_material
		grid forget $w.menu_condition
		grid $w.label_value -row 3 -column 0 -sticky e
		grid $w.menu_layer -row 3 -column 1 -sticky we
		grid forget $w.label_field $w.ffield
	} elseif { $SelectionPriv(var_filter_menu) == "GROUP" } {
		grid forget $w.entry_value
		grid forget $w.label_value
		grid forget $w.menu_type
		grid forget $w.menu_layer
		grid forget $w.menu_label
		grid forget $w.menu_material
		grid forget $w.menu_condition
		grid $w.label_value -row 3 -column 0 -sticky e
		grid $w.menu_group -row 3 -column 1 -sticky we
		grid forget $w.label_field $w.ffield
	} elseif { $SelectionPriv(var_filter_menu) == "LABEL" } {
		grid forget $w.entry_value
		grid forget $w.label_value
		grid forget $w.menu_type
		grid forget $w.menu_layer
		grid forget $w.menu_group
		grid forget $w.menu_material
		grid forget $w.menu_condition
		grid $w.label_type -row 3 -column 0 -sticky e
		grid $w.menu_label -row 3 -column 1 -sticky we
		grid forget $w.label_field $w.ffield
	} elseif { $SelectionPriv(var_filter_menu) == "MATERIAL" } {
		grid forget $w.entry_value
		grid forget $w.label_value
		grid forget $w.menu_type
		grid forget $w.menu_layer
		grid forget $w.menu_group
		grid forget $w.menu_label
		grid forget $w.menu_condition
		grid $w.label_type -row 3 -column 0 -sticky e
		grid $w.menu_material -row 3 -column 1 -sticky we
		grid forget $w.label_field $w.ffield
	} elseif { $SelectionPriv(var_filter_menu) == "CONDITION" } {
		grid forget $w.entry_value
		grid forget $w.label_value
		grid forget $w.menu_type
		grid forget $w.menu_layer
		grid forget $w.menu_group
		grid forget $w.menu_label
		grid forget $w.menu_material
		grid $w.label_type -row 3 -column 0 -sticky e
		grid $w.menu_condition -row 3 -column 1 -sticky we
		set ::SelectionPriv(var_condition_menu) {""}
	} elseif { $SelectionPriv(var_filter_menu) == "NONE" } {
		grid forget $w.menu_type
		grid forget $w.label_type
		grid forget $w.menu_layer
		grid forget $w.menu_group
		grid forget $w.menu_label
		grid forget $w.menu_material
		grid forget $w.menu_condition
		grid forget $w.entry_value
		grid forget $w.label_value
		grid forget $w.label_field $w.ffield
	} else {
		#HIGHERENTITY MINLENGTH MAXLENGTH BADMINANGLE BADMAXANGLE MINLENGTH MAXLENGTH SHAPEQUALITY MINJACOB NUMSIDES
		grid forget $w.menu_type
		grid forget $w.label_type
		grid forget $w.menu_layer
		grid forget $w.menu_group
		grid forget $w.menu_label
		grid forget $w.menu_material
		grid forget $w.menu_condition
		grid $w.label_value -row 3 -column 0 -sticky e
		grid $w.entry_value -row 3 -column 1 -sticky we
		grid forget $w.label_field $w.ffield
	}
}

proc change_mode_menu {w} {
	global SelectionPriv
	if { $SelectionPriv(var_mode_menu) == "SWAP" } {
		GiD_Process SwapSelection
	} elseif { $SelectionPriv(var_mode_menu) == "ADD" } {
		GiD_Process AddToSelection
	} elseif { $SelectionPriv(var_mode_menu) == "REMOVE"} {
		GiD_Process RemoveFromSel
	}
}

proc change_condition_menu {w} {
	global SelectionPriv
	set nonename [_ "None"]
	set nonecommand {{""}}
	if { $::SelectionPriv(var_condition_menu) != {""} } {
		set cndfieldnames $nonename
		set cndfieldcommands $nonecommand
		foreach {Question DefValue} [lrange [GiD_Info condition $::SelectionPriv(var_condition_menu)] 2 end] {
			if { [regexp -nocase {([^#]+)(?:#(MAT|CB|LA|FUNC|UNITS)#(.*))?$} $Question {} id type args] } {
				lappend cndfieldnames [regsub -all _ $id { }]
				lappend cndfieldcommands $id
			}
		}
		if { [winfo exists $w.ffield.menu_condfield] } {
			trace remove variable SelectionPriv(var_condfield_menu) write "change_condfield_menu $w ;#"
			destroy $w.ffield.menu_condfield
		}
		if { ![info exists ::SelectionPriv(var_condfield_menu) ] } {
			set ::SelectionPriv(var_condfield_menu) [lindex $cndfieldcommands 0]
		}
		[ TTKCB_CreateOrConfigure $w.ffield.menu_condfield] $w.ffield.menu_condfield -textvariable ::SelectionPriv(var_condfield_menu) \
			-labels $cndfieldnames \
			-values $cndfieldcommands

		trace add variable SelectionPriv(var_condfield_menu) write "change_condfield_menu $w ;#"

		grid $w.ffield.menu_condfield -row 0 -column 0 -sticky w
		grid $w.ffield.entry_field -row 0 -column 1 -sticky ew -padx 2
		grid $w.label_field $w.ffield -row 4 -sticky e
		grid configure $w.ffield -sticky ew
		grid columnconfigure $w.ffield "1" -weight 1
	} else {
		grid forget $w.label_field
		grid forget $w.ffield
	}
	set ::SelectionPriv(var_condfield_menu) {""}
}

proc change_condfield_menu { w } {
	global SelectionPriv
	if { $::SelectionPriv(var_condfield_menu) != {""} } {
		foreach {Question DefValue} [lrange [GiD_Info condition $::SelectionPriv(var_condition_menu)] 2 end] {
			if { [regexp -nocase {([^#]+)(?:#(MAT|CB|LA|FUNC|UNITS)#(.*))?$} $Question {} id type args] } {
				if { $id == $::SelectionPriv(var_condfield_menu) } {
					if { $type == {CB} || $type == {LA} } {
						set fieldvalnames [split [string range $args 1 end-1] ,]
						if { $type == {LA} } {
							#add user defined local axes
							set fieldvalnames [concat $fieldvalnames [GiD_Info localaxes]]
						} elseif { $type == {MAT} } {
							set fieldvalnames [GiD_Info Materials]
							set book ""
							if { $args != "" } {
								set bookname [string range $args 1 end-1]
								foreach {ibook i} [GiD_Info materials books] {
									if { $bookname == $ibook } {
										set book $bookname
										break
									}
								}
							}
							if { $book != "" } {
								#add only materials of this book
								set newvalues ""
								foreach mati $fieldvalnames {
									if { $book == [GiD_Info materials $mati book] } {
										lappend newvalues $mati
									}
								}
								set fieldvalnames $newvalues
							}
						}
						set fieldvalcommands $fieldvalnames
						if { $type == {CB} && ($fieldvalcommands == "1 0" || $fieldvalcommands == "0 1") } {
							if { [winfo exists $w.ffield.menu_field] } {
								destroy $w.ffield.menu_field
							}
							grid forget $w.ffield.entry_field
							grid $w.ffield.cb_field -row 0 -column 1 -sticky ew
							set ::SelectionPriv(entry_field) [lindex $fieldvalcommands 0]

						} else {
							if { [winfo exists $w.ffield.menu_field] } {
								destroy $w.ffield.menu_field
							}
							if { ![info exists ::SelectionPriv(entry_field) ] } {
								set ::SelectionPriv(entry_field) [lindex $fieldvalcommands 0]
							}
							[ TTKCB_CreateOrConfigure $w.ffield.menu_field] $w.ffield.menu_field -textvariable ::SelectionPriv(entry_field) \
								-labels $fieldvalnames \
								-values $fieldvalcommands


							grid forget $w.ffield.entry_field $w.ffield.cb_field
							grid $w.ffield.menu_field -row 0 -column 1 -sticky ew
							set ::SelectionPriv(entry_field) [lindex $fieldvalcommands 0]
						}
					} else {
						if { [winfo exists $w.ffield.menu_field] } {
							destroy $w.ffield.menu_field
						}
						grid forget $w.ffield.cb_field
						grid $w.ffield.entry_field -row 0 -column 1 -sticky ew -padx 2
						set ::SelectionPriv(entry_field) {}
					}
					break
				}
			}
		}
	} else {
		grid forget $w.ffield.entry_field $w.ffield.cb_field
		if { [winfo exists $w.ffield.menu_field] } {
			destroy $w.ffield.menu_field
		}
		set ::SelectionPriv(entry_field) {}
	}
}


proc OK_Select {w} {
	global SelectionPriv

	GiD_Process filter:

	if { $SelectionPriv(var_filter_menu) == "ENTITYTYPE" } {
		GiD_Process filter:ENTITYTYPE=$SelectionPriv(var_type_menu)
	} elseif { $SelectionPriv(var_filter_menu) == "LAYER" } {
		if { $SelectionPriv(var_layer_menu) ==  {""} } {
			set name ""
		} else {
			set name $SelectionPriv(var_layer_menu)
		}
		#quotes to avoid parsing of filter
		GiD_Process filter:LAYER=\"$name\"
	} elseif { $SelectionPriv(var_filter_menu) == "GROUP" } {
		if { $SelectionPriv(var_group_menu) ==  {""} } {
			set name ""
		} else {
			set name $SelectionPriv(var_group_menu)
		}
		#quotes to avoid parsing of filter
		GiD_Process filter:GROUP=\"$name\"
	} elseif { $SelectionPriv(var_filter_menu) == "LABEL" } {
		GiD_Process filter:LABEL=$SelectionPriv(var_label_menu)
	} elseif { $SelectionPriv(var_filter_menu) == "MATERIAL" } {
		if { $SelectionPriv(var_material_menu) ==  {""} } {
			set name ""
		} else {
			set name $SelectionPriv(var_material_menu)
		}
		#quotes to avoid parsing of filter
		GiD_Process filter:MATERIAL=\"$name\"
	} elseif { $SelectionPriv(var_filter_menu) == "CONDITION" } {
		if { $SelectionPriv(var_condition_menu) ==  {""} } {
			set condname ""
		} else {
			set condname $SelectionPriv(var_condition_menu)
		}
		if { $SelectionPriv(var_condfield_menu) ==  {""} } {
			set fieldname ""
		} else {
			set fieldname $SelectionPriv(var_condfield_menu)
		}
		#quotes to avoid parsing of filter
		if { $fieldname !=  "" } {
			GiD_Process filter:CONDITION=\"[list $condname $fieldname $SelectionPriv(entry_field)]\"
		} else {
			GiD_Process filter:CONDITION=\"$condname\"
		}
	} elseif { $SelectionPriv(var_filter_menu) == "HIGHERENTITY" } {
		GiD_Process filter:HIGHERENTITY=$SelectionPriv(entry_value)
	} elseif { $SelectionPriv(var_filter_menu) == "MINLENGTH" } {
		GiD_Process filter:MINLENGTH=$SelectionPriv(entry_value)
	} elseif { $SelectionPriv(var_filter_menu) == "MAXLENGTH" } {
		GiD_Process filter:MAXLENGTH=$SelectionPriv(entry_value)
	} elseif { $SelectionPriv(var_filter_menu) == "BADMINANGLE" } {
		GiD_Process filter:BADMINANGLE=$SelectionPriv(entry_value)
	} elseif { $SelectionPriv(var_filter_menu) == "BADMAXANGLE" } {
		GiD_Process filter:BADMAXANGLE=$SelectionPriv(entry_value)
	} elseif { $SelectionPriv(var_filter_menu) == "SHAPEQUALITY" } {
		GiD_Process filter:MINQUALITY=$SelectionPriv(entry_value)
	} elseif { $SelectionPriv(var_filter_menu) == "MINJACOB" } {
		GiD_Process filter:MINJACOB=$SelectionPriv(entry_value)
	} elseif { $SelectionPriv(var_filter_menu) == "NUMSIDES" } {
		GiD_Process filter:NUMSIDES=$SelectionPriv(entry_value)
	} elseif { $SelectionPriv(var_filter_menu) == "ELEMENTTYPE" } {
		GiD_Process filter:ELEMENTTYPE=$SelectionPriv(var_type_menu)
	}

	if { $SelectionPriv(mode) == "ALL" } {
		GiD_Process 1:end
	} elseif { $SelectionPriv(mode) == "FROM" } {
		GiD_Process $SelectionPriv(from):$SelectionPriv(to)
	}
}




proc disable_filter_win {w entity_type} {
	global SelectionPriv

	$w.frame_buttons.ok configure -state disabled
	$w.frange.entry_to configure -state disabled
	$w.frange.entry_from configure -state disabled
	$w.frange.radiobutton_all configure -state disabled
	$w.frange.radiobutton_from configure -state disabled
	$w.menu_filters configure -state disabled
	$w.frange.label_to configure -state disabled
	$w.label_filter configure -state disabled
	$w.menu_type configure -state disabled
	$w.menu_layer configure -state disabled
	$w.menu_group configure -state disabled
	$w.menu_label configure -state disabled
	$w.menu_material configure -state disabled
	$w.menu_condition configure -state disabled
	$w.frame_buttons.clear_sel configure -state disabled
	$w.menu_mode configure -state disabled
	$w.label_mode configure -state disabled
	$w.entry_value configure -state disabled
	$w.label_value configure -state disabled
	$w.label_type configure -state disabled
	$w.label_field configure -state disabled
	$w.ffield.entry_field configure -state disabled
	$w.ffield.cb_field configure -state disabled

	$w.frange.radiobutton_all configure -text [translate_select_text $entity_type]
	bind $w <Return> ""
	set SelectionPriv(enabled) "NO"
}


proc enable_filter_win {w entity_type} {
	global SelectionPriv

	$w.frame_buttons.ok configure -state normal
	$w.frange.entry_to configure -state normal
	$w.frange.entry_from configure -state normal
	$w.frange.radiobutton_all configure -state normal
	$w.frange.radiobutton_from configure -state normal
	$w.label_mode configure -state normal
	$w.menu_mode configure -state normal
	$w.label_field configure -state normal
	$w.ffield.entry_field configure -state normal
	$w.ffield.cb_field configure -state normal

	grid forget $w.menu_filters
	grid forget $w.menu_type
	grid forget $w.menu_layer
	grid forget $w.menu_group
	grid forget $w.menu_label
	grid forget $w.menu_material
	grid forget $w.menu_condition
	create_filters_menu $w $entity_type

	$w.menu_filters configure -state normal
	$w.frange.label_to configure -state normal
	$w.label_filter configure -state normal
	$w.menu_type configure -state normal
	$w.menu_layer configure -state normal
	$w.menu_group configure -state normal
	$w.menu_label configure -state normal
	$w.menu_material configure -state normal
	$w.menu_condition configure -state normal
	$w.frame_buttons.clear_sel configure -state normal

	$w.entry_value configure -state normal
	$w.label_value configure -state normal
	$w.label_type configure -state normal

	$w.frange.radiobutton_all configure -text [translate_select_text $entity_type]
	bind $w <Return> "OK_Select $w"
	set SelectionPriv(enabled) "YES"
}



proc SetSelectionEnable { status OpenWindow } {
	global SelectionPriv

	set SelectionPriv(status) $status
	set w .gid.filter_win
	if { ![winfo exists $w] && !$OpenWindow } return

	if { ![winfo exists $w] } {
		make_win_filter $w
		SetDefaultSelectionOptions
	} else {
		if { $status == "NONE" || $status == "ALL" } {
			disable_filter_win $w $status
		} else {
			if { [info exists SelectionPriv(enabled)] && $SelectionPriv(enabled) == "NO" } {
				#make_win_filter $w ;#destroy and create again, to syncronize with default state
				enable_filter_win $w $status
				SetDefaultSelectionOptions
			}
		}
	}
}

proc WarnClearSelection {w} {
	set ret [MessageBoxOptionsButtons [_ "Warning"] \
		[_ "This will clear your current selection!"] \
		{0 1} [list [_ "Ok"] [_ "Cancel"]] info ""]

	if {$ret ==0} {
		GiD_Process ClearSelection
	}
}

proc SetDefaultSelectionOptions { } {
	#to avoid showing a previous state different ot the internal initial=SWAP
	global SelectionPriv
	set SelectionPriv(var_mode_menu) SWAP
}
