
proc getColorMask { str var} {
    set intMask [ scan $str "%d"]
    set ${var}(red) 0
    set ${var}(green) 0
    set ${var}(blue) 0
    set ${var}(alpha) 0
    if { $intMask >= 1000} {
        set ${var}(red) 1
        incr intMask -1000
    }
    if { $intMask >= 100} {
        set ${var}(green) 1
        incr intMask -100
    }
    if { $intMask >= 10} {
        set ${var}(blue) 1
        incr intMask -10
    }
    if { $intMask >= 1} {
        set ${var}(alpha) 1
        incr intMask -1
    }
}

proc strColorMask { var} {
    set msk ""
    foreach idx {red green blue alpha} {
        if { [ subst $${var}($idx)]} {
            append msk "1"
        } else {
            append msk "0"
        }
    }
    return $msk
}

proc StereoGetInfo { } {
    # copy variables to check user changes
    foreach idx [list On Mode EyeDistance FlipEyes RelativeEyeDistance LeftEyeColorMask RightEyeColorMask] {
        set ::GID_Stereo($idx) [GiD_Set Stereo($idx)]
    }
    getColorMask $::GID_Stereo(LeftEyeColorMask) ::GID_Stereo_Left_Mask
    getColorMask $::GID_Stereo(RightEyeColorMask) ::GID_Stereo_Right_Mask
    if { ![ info exists ::GID_Stereo(DynamicApply)]} {
        set ::GID_Stereo(DynamicApply) 0
    }
    
    # NORMAL o PERSPECTIVE
    set ::GID_Stereo(PerspectiveMode) [GiD_Info perspectivemode]
    set ::GID_Stereo(OldPerspectiveMode) $::GID_Stereo(PerspectiveMode)
    
    # Shadow options
    array set ::GID_Shadow [GiD_Info shadow]
    # copy variables to check user changes
    foreach idx [ list Shadow Render ShadowBias ShowDepthMap ShadowMode UseFBO FBOSize DimmedLightFactor] {
        set ::GID_Shadow(Old$idx) $::GID_Shadow($idx)
    }
    # set idx [ lsearch $::GID_Shadow(FBOSizeOptions) $::GID_Shadow(FBOSize)]
    # set ::GID_Shadow(FBOSizeIdx) $idx
    # set ::GID_Shadow(OldFBOSizeIdx) $::GID_Shadow(FBOSizeIdx)
    
    # Mirror options
    array set ::GID_Mirror [GiD_Info mirror]
    foreach idx [ list Mirror Angle AngleFake SizeFactor HeightOffset Color Backlight EdgeStyle Type DrawMode] {
        set ::GID_Mirror(Old$idx) $::GID_Mirror($idx)
    }
}

proc CreateLabelMenuButtonFrame { w txt lst_lbl lst_val var} {
    ttk::frame $w -borderwidth 0
    ttk::label $w.lbl -text $txt
    TTKComboBox $w.mb -labels $lst_lbl -values $lst_val -textvariable $var -state readonly
    grid $w.lbl $w.mb -sticky nes
    grid configure  $w.mb -sticky nw
    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 0 -weight 1
}

proc CreateLabelMenuButton { w txt lst_lbl lst_val var w_top} {
    ttk::label ${w}_lbl -text $txt
    TTKComboBox ${w}_mb -labels $lst_lbl -values $lst_val -textvariable $var \
        -modifycmd "StereoDynamicApply $w_top ;\#" -state readonly
    # grid ${w}_lbl ${w}_mb -sticky nes
    # grid configure  ${w}_mb -sticky nw
    # grid rowconfigure $w 0 -weight 1
    # grid columnconfigure $w 0 -weight 1
}

proc CreateColorMaskCB { w var} {
    ttk::frame $w
    foreach idx {red green blue alpha} lbl [list [_ "red"] [_ "green"] [_ "blue"] [_ "alpha"]] {
        if { ![info exists ${var}($idx)] } { set ${var}($idx) 0 }
        ttk::checkbutton ${w}.$idx -text $lbl -variable ${var}($idx) \
            -command "StereoDynamicApply $w ;\#"
    }
    grid ${w}.red ${w}.green ${w}.blue ${w}.alpha -padx 4
}

proc CheckSoftwareOpenGL { w txt} {
    if { [GiD_Set SoftwareOpenGL] } {
        set msg $txt
        append msg " " [_ "Open preferences window to change OpenGL mode?"]
        set resp [ GID_tk_messageBox -parent $w -default yes -title [_ "Change OpenGL mode"] \
                -type yesno -message $msg]
        if { $resp == "yes"} {
            PreferencesWindow graphical_system
        }
    }
}

proc AdjustMirrorAngleLimits { } {
    set angle_min -90.0
    set angle_max 0.0
    if { $::GID_Stereo(PerspectiveMode) == "NORMAL"} {
        set angle_min [ expr -90.0 - $::GID_Mirror(AngleFake)]
        set angle_max [ expr 0.0 - $::GID_Mirror(AngleFake)]
    }
    $::GID_Mirror(Angle,wid) configure -from $angle_min -to $angle_max
}

proc StereoApply { w } {
    PostAnimateDisableGUIUpdates
    ##############################
    # Stereo options
    ############################## 
    
    # para salir de todos los menus, que a veces no entiende 'View'
    GiD_Process escape escape escape escape escape escape
    
    # First the options
    if { $::GID_Stereo(OldPerspectiveMode) != $::GID_Stereo(PerspectiveMode)} {
        GiD_Process 'Projection $::GID_Stereo(PerspectiveMode)
        set ::GID_Stereo(OldPerspectiveMode) $::GID_Stereo(PerspectiveMode)
        # correct limits of mirror angle
        AdjustMirrorAngleLimits
    }
    set ::GID_Stereo(LeftEyeColorMask) [strColorMask ::GID_Stereo_Left_Mask]
    set ::GID_Stereo(RightEyeColorMask) [strColorMask ::GID_Stereo_Right_Mask]
    foreach idx [list EyeDistance FlipEyes RelativeEyeDistance LeftEyeColorMask RightEyeColorMask Mode On] {
        if { [GiD_Set Stereo($idx)] != $::GID_Stereo($idx) } {
            #GiD_Set Stereo($idx) $::GID_Stereo($idx)
            GiD_Process Mescape Utilities Variables Stereo($idx) $::GID_Stereo($idx) escape escape
        }        
    }

    GiD_Process escape escape escape escape escape escape
    
    ##############################
    # Shadow options
    ############################## 
    
    # First the options
    foreach idx [ list Render ShowDepthMap ShadowMode UseFBO] {
        if { $::GID_Shadow(Old$idx) != $::GID_Shadow($idx)} {
            # sustituimos 0,1 por si valor
            set val [ lindex $::GID_Shadow(${idx}Options) $::GID_Shadow($idx)]
            GiD_Process 'Shadow $val escape escape
            set ::GID_Shadow(Old$idx) $::GID_Shadow($idx)
        }
    }
    if { $::GID_Shadow(OldShadowBias) != $::GID_Shadow(ShadowBias)} {
        GiD_Process 'Shadow ShadowBias $::GID_Shadow(ShadowBias) escape escape
        set ::GID_Shadow(OldShadowBias) $::GID_Shadow(ShadowBias)
    }
    if { $::GID_Shadow(OldDimmedLightFactor) != $::GID_Shadow(DimmedLightFactor)} {
        GiD_Process 'Shadow DimmedLightFactor $::GID_Shadow(DimmedLightFactor) escape escape
        set ::GID_Shadow(OldDimmedLightFactor) $::GID_Shadow(DimmedLightFactor)
    }
    
    # if { $::GID_Shadow(OldFBOSizeIdx) != $::GID_Shadow(FBOSizeIdx)} {
        #         set ::GID_Shadow(FBOSize) [ lindex $::GID_Shadow(FBOSizeOptions) $::GID_Shadow(FBOSizeIdx)]
        #         GiD_Process 'Shadow FBOSize $::GID_Shadow(FBOSize) escape escape
        #         set ::GID_Shadow(OldFBOSizeIdx) $::GID_Shadow(FBOSizeIdx)
        # }
    
    if { $::GID_Shadow(OldFBOSize) != $::GID_Shadow(FBOSize)} {
        GiD_Process 'Shadow FBOSize $::GID_Shadow(FBOSize) escape escape
        set ::GID_Shadow(OldFBOSize) $::GID_Shadow(FBOSize)
    }
    
    # then shitch mode on or off
    if { $::GID_Shadow(OldShadow) != $::GID_Shadow(Shadow)} {
        set val "Off"
        if { $::GID_Shadow(Shadow)} {
            set val "On"
        }
        GiD_Process 'Shadow $val escape escape
        set ::GID_Shadow(OldShadow) $::GID_Shadow(Shadow)
        if { $::GID_Shadow(Shadow)} {
            StereoGetInfo
        }
    }
    
    GiD_Process escape escape escape escape escape escape
    
    ##############################
    # Mirror options
    ############################## 
    
    # First the options
    # AngleFake SizeFactor
    foreach idx [ list Angle SizeFactor HeightOffset Color Backlight EdgeStyle Type DrawMode] {
        if { $::GID_Mirror(Old$idx) != $::GID_Mirror($idx)} {
            GiD_Process 'Mirror $idx $::GID_Mirror($idx) escape escape
            set ::GID_Mirror(Old$idx) $::GID_Mirror($idx)
        }
    }
    
    # then shitch mode on or off
    if { $::GID_Mirror(OldMirror) != $::GID_Mirror(Mirror)} {
        set val "No"
        if { $::GID_Mirror(Mirror)} {
            set val "Yes"
        }
        GiD_Process 'Mirror $val escape escape
        set ::GID_Mirror(OldMirror) $::GID_Mirror(Mirror)
        if { $::GID_Mirror(Mirror)} {
            StereoGetInfo
        }
    }
    
    GiD_Process escape escape escape escape escape escape
    
    PostAnimateEnableGUIUpdates
    GiD_Redraw
}

proc StereoDynamicApply { w} {
    if { $::GID_Stereo(DynamicApply)} {
        StereoApply $w
    }
}

proc StereoClose { w } {
    destroy $w
}

proc StereoChangeColor { w var_name} {
    set var $var_name
    set nuevo [ GIDChooseColor $w.mc -title [_ "Select color"] -color [ subst $$var] -parent $w]
    if { [ string length $nuevo]} {
        set $var $nuevo
        $w configure -background [ string range $nuevo 0 6]
    }
}

proc AdjustScaleResolution { var_name resolution} {
    set var $var_name
    set n_int [ expr int( 0.5 + [ subst $$var] / $resolution)]
    # nice outlook
    set $var [ format %g [ expr $resolution * $n_int]]
    # WarnWinText " $resolution * $n_int = [ format %g [ subst $$var]]"
}

proc ChangedMirrorType { topMirror} {
    set state normal
    if { $::GID_Mirror(Type) == "Object"} {
        set state disabled
    } else {
        # == "Scene"
        set state normal
    }
    
    $topMirror.angle_lbl configure -state $state
    $topMirror.angle_sc_lbl configure -state $state
    $topMirror.angle_sc configure -state $state
    
}

proc ChangedMirrorDrawMode { topMirror} {
    set state normal
    set ground mirror
    if { $::GID_Mirror(DrawMode) == "Floor"} {
        set state disabled
        set ground floor
        $topMirror.decor.col_lbl configure -text [_ "floor colour"]
        $topMirror.mirrorType configure -text [_ "floor attached to object"]
        $topMirror.angle_lbl configure -text [_ "floor angle"]
        $topMirror.height_lbl configure -text [_ "floor height"]
        $topMirror.size_lbl configure -text [_ "floor size"]
    } else {
        # == "Mirror"
        set state normal
        set ground mirror
        $topMirror.decor.col_lbl configure -text [_ "mirror colour"]
        $topMirror.mirrorType configure -text [_ "mirror attached to object"]
        $topMirror.angle_lbl configure -text [_ "mirror angle"]
        $topMirror.height_lbl configure -text [_ "mirror height"]
        $topMirror.size_lbl configure -text [_ "mirror size"]
    }
    
    $topMirror.decor.useBacklight configure -state $state
}

proc StereoW { { w .gid.wStereoW} } {
    
    InitWindow2 $w -title [_ "Advanced viewing settings"] \
        -geometryvariable PrePostStereoWindowGeom \
        -initcommand StereoW -ontop
    if { ![ winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    #toplevel $w
    
    StereoGetInfo
    
    set top $w.top
    set but $w.but
    CreateApplyCloseDecorationWindow $w $top $but "StereoApply $w" "StereoClose $w"
    # CreateDecorationWindow $w $top $but \
        #         [ list [_ "Apply"] [_ "Close"]] \
        #         [ list "StereoApply $w" "StereoClose $w"] \
        #         [ list <Return> <Escape>]
    
    ########################################
    # Stereo Frame
    ########################################
    
    #set topStereo [ ttk::frame $top.fStereo -style ridge.TFrame -borderwidth 2]
    set topStereo [ ttk::labelframe $top.fStereo -text [_ "Stereo"]]
    set def_back [ [winfo toplevel $topStereo] cget -background]
    
    
    #ttk::label $topStereo.lbl -text [_ "Stereo settings"]
    
    if { ![info exists ::GID_Stereo(On)] } { set ::GID_Stereo(On) 0 }
    ttk::checkbutton $topStereo.useStereo -variable ::GID_Stereo(On) -text [_ "Use stereo"] \
        -command "StereoDynamicApply $w ;\#"
    # help
    setTooltip $topStereo.useStereo -text [_ "Enable or disable stereo view mode."]
    
    ttk::frame $topStereo.f
    if { ![info exists ::GID_Stereo(PerspectiveMode)] } { set ::GID_Stereo(PerspectiveMode) NORMAL }
    ttk::checkbutton $topStereo.f.perspCB -text [_ "Perspective"] \
        -variable ::GID_Stereo(PerspectiveMode) \
        -onvalue PERSPECTIVE -offvalue NORMAL \
        -command "StereoDynamicApply $w ;\#"
    ttk::button $topStereo.f.perspOpt -text "-->" -command PerspectiveW -width 5
    
    grid $topStereo.f.perspCB $topStereo.f.perspOpt -sticky en
    # help
    setTooltip $topStereo.f -text [_ "Enable or disable perspective view mode."]
    
    CreateLabelMenuButton $topStereo.stereo_mode [_ "stereo mode"] \
        [ list [_ "Anaglyph colors"] [_ "Quad buffers"]] \
        [ list AnaglyphColors QuadBuffers] \
        ::GID_Stereo(Mode) $w
    # help
    # setTooltip $topStereo.stereo_mode -text [_ "Stereo perception can be created using colours ( by software) or quad buffers ( by hardware)."]
    setTooltip $topStereo.stereo_mode_lbl -text [_ "Stereo perception can be created using colours ( by software) or quad buffers ( by hardware)."]
    setTooltip $topStereo.stereo_mode_mb -text [_ "Stereo perception can be created using colours ( by software) or quad buffers ( by hardware)."]
    
    #scale ....
    ttk::label $topStereo.eye_dist_lbl -text [_ "eye distance"]
    if { ![info exists ::GID_Stereo(EyeDistance)] } {
        set ::GID_Stereo(EyeDistance) 0
    }
    gidscale $topStereo.eye_dist_sc -from 0.0 -to 0.1 -resolution 0.005 \
        -variable ::GID_Stereo(EyeDistance) -orient horizontal \
        -showbuttons 0 \
        -command "StereoDynamicApply $w ;#" \
        -showvalue 0
    
    ttk::label $topStereo.eye_dist_sc_lbl -width 5 -anchor e \
        -textvariable ::GID_Stereo(EyeDistance)
    # ttk::scale $topStereo.eye_dist_sc -from 0.0 -to 0.1 \
        #         -variable ::GID_Stereo(EyeDistance) -orient horizontal \
        #         -command "AdjustScaleResolution ::GID_Stereo(EyeDistance) 0.005 ; StereoDynamicApply $w ;#"
    # AdjustScaleResolution ::GID_Stereo(EyeDistance) 0.005
    # help
    setTooltip $topStereo.eye_dist_lbl -text [_ "Adjust the eye distance to get a better Stereo perception depending on screen distance and angle. \nSuggested value is 0.02."]
    setTooltip $topStereo.eye_dist_sc -text [_ "Adjust the eye distance to get a better Stereo perception depending on screen distance and angle. \nSuggested value is 0.02."]
    setTooltip $topStereo.eye_dist_sc_lbl -text [_ "Adjust the eye distance to get a better Stereo perception depending on screen distance and angle. \nSuggested value is 0.02."]
    
    if { ![info exists ::GID_Stereo(FlipEyes)] } { set ::GID_Stereo(FlipEyes) 0 }
    ttk::checkbutton $topStereo.flipEyes -variable ::GID_Stereo(FlipEyes) -text [_ "switch eyes"] \
        -command "StereoDynamicApply $w ;\#"
    # help
    setTooltip $topStereo.flipEyes -text [_ "Sometimes the output for left and right eyes are swapped."]
    
    CreateLabelMenuButton $topStereo.relative_distance [_ "eye distance mode"] \
        [ list [_ "scaled with the model"] [_ "absolute eye distance"]] \
        [ list 1 0] \
        ::GID_Stereo(RelativeEyeDistance) $w
    # help
    # setTooltip $topStereo.relative_distance -text [_ "The adjusted eye distance should be scaled with the model or not."]
    setTooltip $topStereo.relative_distance_lbl -text [_ "The adjusted eye distance should be scaled with the model or not."]
    setTooltip $topStereo.relative_distance_mb -text [_ "The adjusted eye distance should be scaled with the model or not."]
    
    ttk::label $topStereo.left_mask_lbl -text [_ "left color mask"]
    CreateColorMaskCB $topStereo.left_mask_cb ::GID_Stereo_Left_Mask
    # help
    setTooltip $topStereo.left_mask_lbl -text [_ "In colour stereo mode, the default colours are red for left eye and cyan for right eye.\n Colourmas can be adjusted here if other colour glasses are used."]
    setTooltip $topStereo.left_mask_cb -text [_ "In colour stereo mode, the default colours are red for left eye and cyan for right eye.\n Colourmas can be adjusted here if other colour glasses are used."]
    
    ttk::label $topStereo.right_mask_lbl -text [_ "right color mask"]
    CreateColorMaskCB $topStereo.right_mask_cb ::GID_Stereo_Right_Mask
    # help
    setTooltip $topStereo.right_mask_lbl -text [_ "In colour stereo mode, the default colours are red for left eye and cyan for right eye.\n Colourmas can be adjusted here if other colour glasses are used."]
    setTooltip $topStereo.right_mask_cb -text [_ "In colour stereo mode, the default colours are red for left eye and cyan for right eye.\n Colourmas can be adjusted here if other colour glasses are used."]
    
    # empaquetamiento # -columnspan 2
    grid $topStereo.useStereo $topStereo.f -sticky w -padx 8 -pady 4
    grid configure $topStereo.f -sticky e -columnspan 2
    # grid $topStereo.lbl -sticky w -columnspan 2
    #grid $topStereo.stereo_mode -sticky w -padx 8
    grid $topStereo.stereo_mode_lbl $topStereo.stereo_mode_mb -sticky nes
    grid configure $topStereo.stereo_mode_mb -sticky nw -columnspan 2
    
    grid $topStereo.eye_dist_lbl $topStereo.eye_dist_sc_lbl $topStereo.eye_dist_sc -sticky nes -padx 4 -pady 1
    grid configure $topStereo.eye_dist_sc -sticky nwe
    
    grid $topStereo.flipEyes -sticky w -row 3 -column 2
    # grid $topStereo.relative_distance -sticky w -padx 8
    grid $topStereo.relative_distance_lbl $topStereo.relative_distance_mb -sticky nes
    grid configure $topStereo.relative_distance_mb -sticky nw -columnspan 2
    
    grid $topStereo.left_mask_lbl $topStereo.left_mask_cb -sticky nes
    grid configure $topStereo.left_mask_cb -sticky nw -columnspan 2
    
    grid $topStereo.right_mask_lbl $topStereo.right_mask_cb -sticky nes
    grid configure $topStereo.right_mask_cb -sticky nw -columnspan 2
    
    grid columnconfigure $topStereo 2 -weight 1
    
    
    ########################################
    # Shadow Frame
    ########################################
    
    #set topShadow [ ttk::frame $top.fShadow -style ridge.TFrame -borderwidth 2]
    set topShadow [ ttk::labelframe $top.fShadow -text [_ "Shadow"]]
    set def_back [ [winfo toplevel $topShadow] cget -background]
    
    #ttk::label $topShadow.lbl -text [_ "Shadow settings"]
    
    # Shadow on / off
    if { ![info exists ::GID_Shadow(Shadow)] } { set ::GID_Shadow(Shadow) 0 }
    ttk::checkbutton $topShadow.useShadow -variable ::GID_Shadow(Shadow) \
        -text [_ "Use shadow"] \
        -command "StereoDynamicApply $w ;\#"
    # help
    setTooltip $topShadow.useShadow -text [_ "Enable or disable shadows."]
    
    ttk::label $topShadow.shadow_mode_lbl -text [_ "shadow color"]
    ttk::frame $topShadow.shadow_mode_f
    ttk::radiobutton $topShadow.shadow_mode_f.rd1 \
        -variable ::GID_Shadow(ShadowMode) \
        -text [_ "black#C#shadow color"] \
        -value 0 \
        -command "StereoDynamicApply $w ;\#"
    ttk::radiobutton $topShadow.shadow_mode_f.rd2 \
        -variable ::GID_Shadow(ShadowMode) \
        -text [_ "ambient#C#shadow color"] \
        -value 1 \
        -command "StereoDynamicApply $w ;\#"
    if { ![info exists ::GID_Shadow(DimmedLightFactor)] } {
        set ::GID_Shadow(DimmedLightFactor) 0
    }
    gidscale $topShadow.shadow_mode_f.dimmed_light_sc \
        -from [ lindex $::GID_Shadow(DimmedLightFactorOptions) 0] \
        -to [ lindex $::GID_Shadow(DimmedLightFactorOptions) 1] \
        -resolution 0.005 \
        -variable ::GID_Shadow(DimmedLightFactor) \
        -orient horizontal \
        -showbuttons 0 \
        -command "StereoDynamicApply $w ;#" \
        -showvalue 0
    ttk::label $topShadow.shadow_mode_f.dimmed_light_sc_lbl -width 5 -anchor e \
        -textvariable ::GID_Shadow(DimmedLightFactor)
    # ttk::scale $topShadow.shadow_mode_f.dimmed_light_sc \
        #         -from [ lindex $::GID_Shadow(DimmedLightFactorOptions) 0] \
        #         -to [ lindex $::GID_Shadow(DimmedLightFactorOptions) 1] \
        #         -variable ::GID_Shadow(DimmedLightFactor) \
        #         -orient horizontal \
        #         -command "AdjustScaleResolution ::GID_Shadow(DimmedLightFactor) 0.005 ; StereoDynamicApply $w ;#"
    # AdjustScaleResolution ::GID_Shadow(DimmedLightFactor) 0.005
    grid $topShadow.shadow_mode_f.rd1 -row 0 -column 0 -sticky nw
    grid $topShadow.shadow_mode_f.rd2 -row 1 -column 0 -sticky nw
    grid $topShadow.shadow_mode_f.dimmed_light_sc_lbl -row 1 -column 1 -sticky ne -padx 4 -pady 1
    grid $topShadow.shadow_mode_f.dimmed_light_sc -row 1 -column 2 -sticky nwe
    grid rowconfigure $topShadow.shadow_mode_f 0 -weight 1
    grid columnconfigure $topShadow.shadow_mode_f 2 -weight 1
    # help
    setTooltip $topShadow.shadow_mode_lbl -text [_ "Select how to drawn the shadows: black hard or with dimmed ambient light."]
    setTooltip $topShadow.shadow_mode_f -text [_ "Select how to drawn the shadows: black hard or with dimmed ambient light."]
    
    #scale .... shadow bias
    ttk::label $topShadow.depth_bias_lbl -text [_ "shadow bias"]
    if { ![info exists ::GID_Shadow(ShadowBias)] } {
        set ::GID_Shadow(ShadowBias) 0
    }
    gidscale $topShadow.depth_bias_sc \
        -from [ lindex $::GID_Shadow(ShadowBiasOptions) 0] \
        -to [ lindex $::GID_Shadow(ShadowBiasOptions) 1] \
        -resolution 0.001 \
        -variable ::GID_Shadow(ShadowBias) -orient horizontal \
        -command "StereoDynamicApply $w ;#" \
        -showbuttons 0 \
        -showvalue 0
    ttk::label $topShadow.depth_bias_sc_lbl -width 5 -anchor e \
        -textvariable ::GID_Shadow(ShadowBias)
    # ttk::scale $topShadow.depth_bias_sc \
        #         -from [ lindex $::GID_Shadow(ShadowBiasOptions) 0] \
        #         -to [ lindex $::GID_Shadow(ShadowBiasOptions) 1] \
        #         -variable ::GID_Shadow(ShadowBias) -orient horizontal \
        #         -command "AdjustScaleResolution ::GID_Shadow(ShadowBias) 0.001 ; StereoDynamicApply $w ;#"
    # AdjustScaleResolution ::GID_Shadow(ShadowBias) 0.001                    
    # help
    setTooltip $topShadow.depth_bias_lbl -text [_ "Separation between ocluder and shadow test begin. \nSuggested value is -0.002."]
    setTooltip $topShadow.depth_bias_sc -text [_ "Separation between ocluder and shadow test begin. \nSuggested value is -0.002."]
    setTooltip $topShadow.depth_bias_sc_lbl -text [_ "Separation between ocluder and shadow test begin. \nSuggested value is -0.002."]
    
    ttk::frame $topShadow.fbo_opt
    if { ![info exists ::GID_Shadow(UseFBO)] } { set ::GID_Shadow(UseFBO) 0 }
    ttk::checkbutton $topShadow.fbo_opt.useFBO -variable ::GID_Shadow(UseFBO) \
        -text [_ "finer silhouette (FramebufferObject)"] \
        -command "StereoDynamicApply $w ;\#"
    # gidscale $topShadow.fbo_opt.fbo_size_sc \
        #         -from 0 \
        #         -to [ expr [ llength $::GID_Shadow(FBOSizeOptions)] - 1] \
        #         -resolution 1 \
        #         -variable ::GID_Shadow(FBOSizeIdx) -orient horizontal \
        #         -command "StereoDynamicApply $w ;#"
    ttk::label $topShadow.fbo_opt.fbo_size_lbl -text [_ "quality"]
    TTKComboBox $topShadow.fbo_opt.fbo_size_sc \
        -labels [ list [_ "medium#C#Quality"] [_ "high#C#Quality"] [_ "very high#C#Quality"] [_ "highest#C#Quality"]] \
        -values [ list 1024 2048 4096 8192] \
        -textvariable ::GID_Shadow(FBOSize) \
        -state readonly \
        -modifycmd "StereoDynamicApply $w ;#"
    # help
    setTooltip $topShadow.fbo_opt -text [_ "Resolution of shadow map. Higher quality requires more graphic memory: \nmedium - 4 MB \nheight - 16 MB \nvery height - 64 MB \nhighest - 256 MB ."]
    
    grid $topShadow.fbo_opt.useFBO $topShadow.fbo_opt.fbo_size_lbl $topShadow.fbo_opt.fbo_size_sc -sticky w -padx 0 -pady 0
    grid configure $topShadow.fbo_opt.fbo_size_lbl -sticky e -padx 4 -pady 1
    grid configure $topShadow.fbo_opt.fbo_size_sc -sticky ew -padx 4 -pady 1
    grid rowconfigure $topShadow.fbo_opt 0 -weight 1
    grid columnconfigure $topShadow.fbo_opt 2 -weight 1
    
    grid $topShadow.useShadow -sticky w -padx 8 -pady 4 -columnspan 3
    grid $topShadow.shadow_mode_lbl $topShadow.shadow_mode_f -sticky nes -padx 4 -pady 1
    grid configure $topShadow.shadow_mode_f -sticky new -columnspan 2
    grid $topShadow.depth_bias_lbl $topShadow.depth_bias_sc_lbl $topShadow.depth_bias_sc -sticky nes -padx 4 -pady 1
    grid configure $topShadow.depth_bias_sc -sticky new
    grid $topShadow.fbo_opt -sticky new -padx 4 -pady 1 -columnspan 3
    
    grid columnconfigure $topShadow 2 -weight 1
    # grid columnconfigure $topShadow 1 -weight 1
    
    ########################################
    # Mirror Frame
    ########################################
    
    #set topMirror [ ttk::frame $top.fMirror -style ridge.TFrame -borderwidth 2]
    set topMirror [ ttk::labelframe $top.fMirror -text [_ "Mirror"]]
    set def_back [ [winfo toplevel $topMirror] cget -background]
    
    ttk::label $topMirror.lbl -text [_ "Mirror settings"]
    
    # Floor on / off
    if { ![info exists ::GID_Mirror(Mirror)] } { set ::GID_Mirror(Mirror) 0 }
    ttk::checkbutton $topMirror.useMirror -variable ::GID_Mirror(Mirror) \
        -text [_ "Use floor"] \
        -command "StereoDynamicApply $w ;\#"
    # help
    setTooltip $topMirror.useMirror -text [_ "Enable or disable a ground plane to be used as floor or mirror."]
    
    # Mirror on / off
    if { ![info exists ::GID_Mirror(DrawMode)] } { set ::GID_Mirror(DrawMode) "Floor" }
    ttk::checkbutton $topMirror.mirrorMode -variable ::GID_Mirror(DrawMode) \
        -text [_ "As mirror"] \
        -onvalue "Mirror" -offvalue "Floor" \
        -command "ChangedMirrorDrawMode $topMirror ; StereoDynamicApply $w ;\#"
    # help
    setTooltip $topMirror.mirrorMode -text [_ "Uses the ground plane as mirror."]
    
    # Mirror color
    ttk::frame $topMirror.decor  
    ttk::label $topMirror.decor.edge_lbl -text [_ "edge relief"]
    TTKComboBox $topMirror.decor.edge_cb \
        -labels [ list [_ "no#C#floor edge"] [_ "line#C#edge relief"] [_ "smooth#C#edge relief"]] \
        -values [ list No Line Smooth] \
        -textvariable ::GID_Mirror(EdgeStyle) \
        -state readonly \
        -width 8 \
        -modifycmd "StereoDynamicApply $w ;#"
    # help
    setTooltip $topMirror.decor.edge_lbl -text [_ "How to drawn the edge of the mirror / floor."]
    setTooltip $topMirror.decor.edge_cb -text [_ "How to drawn the edge of the mirror / floor."]
    
    # Mirror backlight on / off
    if { ![info exists ::GID_Mirror(Backlight)] } { set ::GID_Mirror(Backlight) Off }
    ttk::checkbutton $topMirror.decor.useBacklight -variable ::GID_Mirror(Backlight) \
        -text [_ "backlight"] \
        -command "StereoDynamicApply $w ;\#" \
        -onvalue On -offvalue Off
    # help
    setTooltip $topMirror.decor.useBacklight -text [_ "Use backlight on the mirroed model."]
    
    ttk::label $topMirror.decor.col_lbl -text [_ "floor colour"]
    tk::button $topMirror.decor.col_sel -borderwidth 1 -width 3 \
        -background [ string range $::GID_Mirror(Color) 0 6] \
        -command "StereoChangeColor $topMirror.decor.col_sel ::GID_Mirror(Color) ; StereoDynamicApply $w ;#"
    grid $topMirror.decor.edge_lbl $topMirror.decor.edge_cb $topMirror.decor.useBacklight \
        $topMirror.decor.col_lbl $topMirror.decor.col_sel -padx 4 -pady 1 -sticky ne
    # help
    setTooltip $topMirror.decor.col_lbl -text [_ "Select the colour for the mirror / floor."]
    
    # type of mirror: related ro scene or attacked to object
    if { ![info exists ::GID_Mirror(Type)] } { set ::GID_Mirror(Type) Scene }
    ttk::checkbutton $topMirror.mirrorType -variable ::GID_Mirror(Type) \
        -text [_ "floor attached to object"] \
        -command "ChangedMirrorType $topMirror ; StereoDynamicApply $w ;\#" \
        -onvalue Object -offvalue Scene
    # help
    setTooltip $topMirror.mirrorType -text [_ "Should the floor / mirror move with the object or it's static."]
    
    #scale .... mirror angle
    ttk::label $topMirror.angle_lbl -text [_ "floor angle"]
    if { ![info exists ::GID_Mirror(Angle)] } {
        set ::GID_Mirror(Angle) 0
    }
    gidscale $topMirror.angle_sc \
        -from 0.0 \
        -to 90.0 \
        -resolution 0.5 \
        -variable ::GID_Mirror(Angle) \
        -orient horizontal \
        -command "StereoDynamicApply $w ;#" \
        -showbuttons 0 \
        -showvalue 0
    ttk::label $topMirror.angle_sc_lbl -width 5 -anchor e \
        -textvariable ::GID_Mirror(Angle)
    # ttk::scale $topMirror.angle_sc \
        #         -from 0.0 \
        #         -to 90.0 \
        #         -variable ::GID_Mirror(Angle) \
        #         -orient horizontal \
        #         -command "AdjustScaleResolution ::GID_Mirror(Angle) 0.5 ; StereoDynamicApply $w ;#"
    # AdjustScaleResolution ::GID_Mirror(Angle) 0.5
    # help
    setTooltip $topMirror.angle_lbl -text [_ "Select the floor / mirror inclination angle."]
    setTooltip $topMirror.angle_sc -text [_ "Select the floor / mirror inclination angle."]
    setTooltip $topMirror.angle_sc_lbl -text [_ "Select the floor / mirror inclination angle."]
    
    set ::GID_Mirror(Angle,wid) $topMirror.angle_sc
    AdjustMirrorAngleLimits
    
    #scale .... height offset
    ttk::label $topMirror.height_lbl -text [_ "floor height"]
    set height_min -1.0
    set height_max 1.0
    if { ![info exists ::GID_Mirror(HeightOffset)] } {
        set ::GID_Mirror(HeightOffset) 0
    }
    gidscale $topMirror.height_sc \
        -from $height_min \
        -to $height_max \
        -resolution 0.01 \
        -variable ::GID_Mirror(HeightOffset) \
        -orient horizontal \
        -command "StereoDynamicApply $w ;#" \
        -showbuttons 0 \
        -showvalue 0
    ttk::label $topMirror.height_sc_lbl -width 5 -anchor e \
        -textvariable ::GID_Mirror(HeightOffset)
    # ttk::scale $topMirror.height_sc \
        #         -from $height_min \
        #         -to $height_max \
        #         -variable ::GID_Mirror(HeightOffset) \
        #         -orient horizontal \
        #         -command "AdjustScaleResolution ::GID_Mirror(HeightOffset) 0.01 ; StereoDynamicApply $w ;#"
    # AdjustScaleResolution ::GID_Mirror(HeightOffset) 0.01
    # help
    setTooltip $topMirror.height_lbl -text [_ "Select the floor / mirror relative height."]
    setTooltip $topMirror.height_sc -text [_ "Select the floor / mirror relative height."]
    setTooltip $topMirror.height_sc_lbl -text [_ "Select the floor / mirror relative height."]
    
    #scale .... size factor
    ttk::label $topMirror.size_lbl -text [_ "floor size"]
    set size_min 0.0
    set size_max 5.0
    if { ![info exists ::GID_Mirror(SizeFactor)] } {
        set ::GID_Mirror(SizeFactor) 0
    }
    gidscale $topMirror.size_sc \
        -from $size_min \
        -to $size_max \
        -resolution 0.01 \
        -variable ::GID_Mirror(SizeFactor) \
        -orient horizontal \
        -command "StereoDynamicApply $w ;#" \
        -showbuttons 0 \
        -showvalue 0
    ttk::label $topMirror.size_sc_lbl -width 5 -anchor e \
        -textvariable ::GID_Mirror(SizeFactor)
    # ttk::scale $topMirror.size_sc \
        #         -from $size_min \
        #         -to $size_max \
        #         -variable ::GID_Mirror(SizeFactor) \
        #         -orient horizontal \
        #         -command "AdjustScaleResolution ::GID_Mirror(SizeFactor) 0.01 ; StereoDynamicApply $w ;#"
    # AdjustScaleResolution ::GID_Mirror(SizeFactor) 0.01
    # help
    setTooltip $topMirror.size_lbl -text [_ "Select the floor / mirror relative size."]
    setTooltip $topMirror.size_sc -text [_ "Select the floor / mirror relative size."]
    setTooltip $topMirror.size_sc_lbl -text [_ "Select the floor / mirror relative size."]
    
    ChangedMirrorType $topMirror
    ChangedMirrorDrawMode $topMirror
    
    grid $topMirror.useMirror -sticky w -padx 8 -pady 4 -columnspan 2
    grid $topMirror.mirrorMode -row 0 -column 2 -sticky w -padx 8 -pady 4
    grid $topMirror.decor -sticky we -padx 4 -pady 1 -columnspan 3
    grid $topMirror.mirrorType -sticky we -padx 8 -pady 1 -columnspan 3
    grid $topMirror.angle_lbl $topMirror.angle_sc_lbl $topMirror.angle_sc -sticky nes -padx 8 -pady 1
    grid configure $topMirror.angle_sc -sticky new
    grid $topMirror.height_lbl $topMirror.height_sc_lbl $topMirror.height_sc -sticky nes -padx 8 -pady 1
    grid configure $topMirror.height_sc -sticky new
    # need to correct mirror size influence
    grid $topMirror.size_lbl $topMirror.size_sc_lbl $topMirror.size_sc -sticky nes -padx 8 -pady 1
    grid configure $topMirror.size_sc -sticky new
    grid columnconfigure $topMirror 2 -weight 1
    
    
    ########################################
    
    if { ![info exists ::GID_Stereo(DynamicApply)] } { set ::GID_Stereo(DynamicApply) 0 }
    ttk::checkbutton $top.dynamicUpdate -variable ::GID_Stereo(DynamicApply) \
        -text [_ "Dynamic update"]
    # help
    setTooltip $top.dynamicUpdate -text [_ "The model will be updated at the same moment any option is changed."]
    
    grid $topStereo -sticky news
    grid $topShadow -sticky news
    grid $topMirror -sticky news
    grid $top.dynamicUpdate -sticky w  -padx 8 -pady 8
    grid columnconfigure $top 0 -weight 1
    grid rowconfigure $top 0 -weight 1
    grid rowconfigure $top 1 -weight 1
    grid rowconfigure $top 2 -weight 1
    grid rowconfigure $top 3 -weight 1
    
}
