
set ::GidPriv(EnableMeshGroupWindow) 0

set ::GidPriv(DrawThreeGearsWidget) 0
# There is some problem between the togl used for the 3 gears and VBO in GiD, so disabling it
# if { $::tcl_platform(os) != "Darwin"} {
#     set ::GidPriv(DrawThreeGearsWidget) 1
# }


proc GetSetTypeName { name } {        
    if { [catch { set type [GiD_Sets get type $name] } err_txt] } {
        # assumed error because do not exists, will implement in the future [GiD_Sets exists $name] (or use [GetSetExists $name])
        set type_name ""
        return $type_name
    }
    if { $type == 1 } {
        set type_name VolumeSets
    } elseif { $type == 2 } {
        set type_name SurfaceSets
    } elseif { $type == 3 } {
        set type_name CutSets
    } else {       
        set type_name ""
        # W "Set '$name': unexpected type $type"        
    }
    return $type_name
}

#change post 'background set has nomenclature "***** $num ($front_name) to  use the same as pre layer: "${front_name}_*back*" 
#better without num, to be able to know a name from the other

set ::PD_debug_table_update   0

proc GetIsBackSet { name } {
    set is_back 0
    if { [string range $name end-6 end] == "_*back*"} {
        set is_back 1
    }
    return $is_back
}

proc GetFrontNameFromBackName { back_name } {    
    if { [string range $back_name end-6 end] == "_*back*"} {
        set front_name [string range $back_name 0 end-7]
    } else {
        set front_name $back_name
    }
    return $front_name
}

proc GetBackNameFromFrontName { front_name } {    
    if { [GetIsBackSet $front_name] } {
        set back_name ""
    } else {
        set back_name ${name}_*back*
    }
    return $back_name
}

proc GetSetExists  { name } {
    set exists 0
    set names [Sets_GetList]
    if { [lsearch -dictionary -sorted $names $name] != -1 } {
        set exists 1
    }
    return $exists
}

proc Sets_GetList { } {
    set names [list]
    foreach type {VolumeSets SurfaceSets CutSets} {
        lappend names {*}[GiD_Info postprocess get all_$type]
    }
    set names [lsort -dictionary -unique $names]
    return $names
}

proc Sets_NameJoin { parent name } {
    if { $parent == "" } {
        set fullname $name
    } else {
        set fullname $parent//$name
    }                
    return $fullname
}

proc Sets_GetAutomaticName { {prefix ""} } {
    set names [Sets_GetList]    
    set name ""
    for {set i 0} {$i<10000} {incr i} {
        set fullname [Sets_NameJoin $prefix Set${i}]
        if { [lsearch -exact $names $fullname] == -1 } { 
            set name $fullname
            break 
        }
    }
    return $name
}

proc WOGLRotStart {x y W } {
    global startx starty xangle0 yangle0 xangle yangle
    set startx $x
    set starty $y
    set vPos [$W position]
    set xangle0 [lindex $vPos 0]
    set yangle0 [lindex $vPos 1]
}

proc WOGLRotMove {x y W} {
    global startx starty xangle0 yangle0 xangle yangle
    set xangle [expr $xangle0 + ($x - $startx)  ]
    set yangle [expr $yangle0 + ($y - $starty)  ]
    $W rotate $xangle $yangle
}

proc WOGLChangeColor { } {
    global WoglPriv

    $WoglPriv(w) makecurrent
    $WoglPriv(w) setcolor ambient $WoglPriv(ambient)
    $WoglPriv(w) setcolor diffuse $WoglPriv(diffuse)
    $WoglPriv(w) setcolor specular $WoglPriv(specular)
    $WoglPriv(w) setcolor shininess $WoglPriv(shininess2)
    $WoglPriv(w) setcolor transparency $WoglPriv(transparency)
    #$WoglPriv(w) setcolor shininess [ expr pow(10,$WoglPriv(shininess) - 3.0)]
    $WoglPriv(w) settransparent $WoglPriv(transparent)

    # y los de los botones
    $::WoglPriv(diffuse,botonbasico) configure -background $::WoglPriv(diffuse)

    foreach comp "ambient diffuse specular" {
        $::WoglPriv($comp,boton) configure -background $::WoglPriv($comp)
    }
    WOGLChangeSlideComponent $::WoglPriv(SlideComponent)
}

proc WOGLChangeColorComponent { wb comp} {
    global WoglPriv

    # actualizamos las escalas de colores
    set WoglPriv(SlideComponent) $comp
    WOGLChangeSlideComponent $comp

    if { $wb != ""} {
        set entero WoglPriv($comp)
        CCCambiaColor $wb $entero
    }
    if { $WoglPriv(Old,$comp) != $WoglPriv($comp) } {
        $WoglPriv(w) makecurrent
        $WoglPriv(w) setcolor $comp $WoglPriv($comp)
        set WoglPriv(Old,$comp) $WoglPriv($comp)
        if { $comp ==  $WoglPriv(SlideComponent)} {
            scan $WoglPriv($comp) #%2x%2x%2x r g b
            $WoglPriv(slide,red) set $r
            $WoglPriv(slide,green) set $g
            $WoglPriv(slide,blue) set $b
        }
    }
}

proc WOGLAplicaTipoColor { } {
    global WoglPriv

    scan $WoglPriv(diffuse) #%2x%2x%2x r g b
    # set new_transparency 0.0
    set new_transparency $WoglPriv(transparency)
    switch "$WoglPriv(TipoColor)" {
        "metal" {
            #set r2 [ expr int( 0.5 + 64 - 0.25 * $r)]
            #set g2 [ expr int( 0.5 + 64 - 0.25 * $g)]
            #set b2 [ expr int( 0.5 + 64 - 0.25 * $b)]
            set r2 [ expr int( 0.5 + 0.5 * $r)]
            set g2 [ expr int( 0.5 + 0.5 * $g)]
            set b2 [ expr int( 0.5 + 0.5 * $b)]
            set WoglPriv(ambient) [ format #%02x%02x%02x $r2 $g2 $b2]
            set WoglPriv(specular) #ffffff
            set new_shininess 0.3
            # set new_transparency 0.0
        }
        "plastico" {
            set r2 [ expr int( 0.5 + 0.33333333333 * $r)]
            set g2 [ expr int( 0.5 + 0.33333333333 * $g)]
            set b2 [ expr int( 0.5 + 0.33333333333 * $b)]
            set WoglPriv(ambient) [ format #%02x%02x%02x $r2 $g2 $b2]
            #set r2 [ expr int( 0.5 + 1.2 * $r)]
            #set g2 [ expr int( 0.5 + 1.2 * $g)]
            #set b2 [ expr int( 0.5 + 1.2 * $b)]
            set r2 [ expr int( 0.5 + 0.5 * $r)]
            set g2 [ expr int( 0.5 + 0.5 * $g)]
            set b2 [ expr int( 0.5 + 0.5 * $b)]
            if { $r2 > 255} { set r2 255}
            if { $g2 > 255} { set g2 255}
            if { $b2 > 255} { set b2 255}
            set WoglPriv(specular) [ format #%02x%02x%02x $r2 $g2 $b2]
            set new_shininess 1.0
            # set new_transparency 0.0
        }
        "goma" {
            set mx $r
            if { $g > $mx} { set mx $g}
            if { $b > $mx} { set mx $b}
            set mn $r
            if { $g < $mn} { set mn $g}
            if { $b < $mn} { set mn $b}
            if { $mx == $mn} {
                set r2 [ expr int( 0.5 + 0.3 * $r)]
                set g2 [ expr int( 0.5 + 0.3 * $g)]
                set b2 [ expr int( 0.5 + 0.3 * $b)]
                set r3 [ expr int( 0.5 + 0.6 * $r)]
                set g3 [ expr int( 0.5 + 0.6 * $g)]
                set b3 [ expr int( 0.5 + 0.6 * $b)]
            } else {
                set div [ expr 1.0 / ( $mx - $mn)]
                set fa [ expr 0.1 * $mx * $div ]
                set fb [ expr - $fa * $mn]
                set r2 [ expr int( 0.5 + $fa * $r + $fb)]
                set g2 [ expr int( 0.5 + $fa * $g + $fb)]
                set b2 [ expr int( 0.5 + $fa * $b + $fb)]
                set fa [ expr ( 1.4 * $mx - 0.1 * $mn) * $div]
                set fb [ expr $mn * ( 0.1 - $fa)]
                set r3 [ expr int( 0.5 + $fa * $r + $fb)]
                set g3 [ expr int( 0.5 + $fa * $g + $fb)]
                set b3 [ expr int( 0.5 + $fa * $b + $fb)]
                if { $r3 > 255} { set r3 255}
                if { $g3 > 255} { set g3 255}
                if { $b3 > 255} { set b3 255}
            }
            set WoglPriv(ambient) [ format #%02x%02x%02x $r2 $g2 $b2]
            set WoglPriv(specular) [ format #%02x%02x%02x $r3 $g3 $b3]
            set new_shininess 0.078
            # set new_transparency 0.0
        }
        default {
            set WoglPriv(ambient) $WoglPriv(diffuse)
            set WoglPriv(specular) #ffffff
            set new_shininess 0.1
            # set new_transparency 0.0
        }
    }

    WOGLChangeColorComponent "" diffuse
    WOGLChangeColorComponent "" ambient
    WOGLChangeColorComponent "" specular

    $WoglPriv(diffuse,boton) configure -background $WoglPriv(diffuse)
    $WoglPriv(ambient,boton) configure -background $WoglPriv(ambient)
    $WoglPriv(specular,boton) configure -background $WoglPriv(specular)

    set WoglPriv(shininess2) [format %.2f $new_shininess]
    set WoglPriv(transparency) $new_transparency
}

proc WOGLChangeColorBasico { wb} {
    global WoglPriv

    #set WoglPriv(diffuse) #cc0000
    #WOGLChangeColorComponent $WoglPriv(diffuse,boton) diffuse
    #set WoglPriv(ambient) $WoglPriv(diffuse)
    #WOGLChangeColorComponent $WoglPriv(ambient,boton) ambient
    #set WoglPriv(specular) #ffffff
    #WOGLChangeColorComponent $WoglPriv(specular,boton) specular

    #set entero WoglPriv(diffuse)
    #CCCambiaColor $wb $entero

    set nuevo [ GIDChooseColor $wb.mc -title [_ "Select color"] -color $WoglPriv(diffuse)]
    if { [ string length $nuevo]} {
        set WoglPriv(diffuse) $nuevo
        $wb configure -background $nuevo
    }
    if { $WoglPriv(Old,diffuse) != $WoglPriv(diffuse) } {
        WOGLAplicaTipoColor
    }
}

proc WOGLChangeTipoColor { name1 name2 op} {
    WOGLAplicaTipoColor
}

proc WOGLChangeShininess { name1 name2 op } {
    global WoglPriv

    if { $WoglPriv(shininess) == ""} { return}
    if { $WoglPriv(shininess) > 3.0} {
        bell
        set WoglPriv(shininess) 3.0
        return
    }
    if { $WoglPriv(shininess) < 0.0} {
        bell
        set WoglPriv(shininess) 0.0
        return
    }
    set WoglPriv(shininess) [format %.2f $WoglPriv(shininess)]
    if { [ scan $WoglPriv(shininess) %g sh]} {
        if { $WoglPriv(Old,shininess) != $sh} {
            $WoglPriv(w) makecurrent
            $WoglPriv(w) setcolor shininess [format %.2f [ expr pow(10,$sh - 3.0)]]
            set WoglPriv(Old,shininess) $sh
            set WoglPriv(shininess2) [format %.2f [ expr pow(10,$sh - 3.0)]]
            set WoglPriv(Old,shininess2) $WoglPriv(shininess2)
        }
    }
}

proc WOGLChangeTransparency { name1 name2 op } {
    global WoglPriv

    if { $WoglPriv(transparency) == ""} { return}
    if { $WoglPriv(transparency) > 1.0} {
        bell
        set WoglPriv(transparency) 1.0
        return
    }
    if { $WoglPriv(transparency) < 0.0} {
        bell
        set WoglPriv(transparency) 0.0
        return
    }

    if { [ scan $WoglPriv(transparency) %g tr]} {
        if { $WoglPriv(Old,transparency) != $tr} {
            $WoglPriv(w) makecurrent
            $WoglPriv(w) setcolor transparency $tr
            set WoglPriv(Old,transparency) $tr
        }
    }
}

proc WOGLChangeShininess2 { name1 name2 op } {
    global WoglPriv

    if { $WoglPriv(shininess2) == ""} { return}
    if { $WoglPriv(shininess2) > 1.0} {
        bell
        set WoglPriv(shininess2) 1.0
        return
    }
    if { $WoglPriv(shininess2) < 0.0} {
        bell
        set WoglPriv(shininess2) 0.0
        return
    }
    set WoglPriv(shininess2) [format %.2f $WoglPriv(shininess2)]
    if { [ scan $WoglPriv(shininess2) %g sh]} {
        if { $WoglPriv(Old,shininess2) != $sh} {
            $WoglPriv(w) makecurrent
            $WoglPriv(w) setcolor shininess $sh
            set WoglPriv(Old,shininess2) $sh
            #set WoglPriv(shininess2)  [format %.2f [ expr pow(10,$sh - 3.0)]]
            set WoglPriv(shininess)  [format %.2f [ expr log10( $WoglPriv(shininess2)) + 3.0]]
            set WoglPriv(Old,shininess) $WoglPriv(shininess)
        }
    }
}

proc WOGLChangeSlideComponent { valor } {
    global WoglPriv

    if { $WoglPriv(SlideComponent) == $WoglPriv(Old,SlideComponent) } { return}

    # WoglPriv(slide,red) configure -variable WoglPriv($WoglPriv(SlideComponent),red)
    # WoglPriv(slide,green) configure -variable WoglPriv($WoglPriv(SlideComponent),green)
    # WoglPriv(slide,blue) configure -variable WoglPriv($WoglPriv(SlideComponent),blue)

    set n [ scan $WoglPriv($WoglPriv(SlideComponent)) #%2x%2x%2x r g b]
    if { $n == 3} {
        $WoglPriv(slide,red) set $r
        $WoglPriv(slide,green) set $g
        $WoglPriv(slide,blue) set $b

        set WoglPriv(Old,SlideComponent) $WoglPriv(SlideComponent)
        foreach id "ambient diffuse specular" {
            if { $WoglPriv(SlideComponent) == "$id"} {
                $WoglPriv($id,radio) configure -text ->                
            } else {
                $WoglPriv($id,radio) configure -text ->               
            }
        }
    }
}

proc WOGLChangeSlideColor { color valor} {
    global WoglPriv

    set comp $WoglPriv(SlideComponent)

    scan $WoglPriv($comp) #%2x%2x%2x r g b

    if { $color == "red"} {
        set r $valor
    }
    if { $color == "green"} {
        set g $valor
    }
    if { $color == "blue"} {
        set b $valor
    }

    set WoglPriv($comp) [ format #%02x%02x%02x $r $g $b]

    $WoglPriv($comp,boton) configure -background $WoglPriv($comp)
    if { $comp == "diffuse"} {
        $WoglPriv(diffuse,botonbasico) configure -background $WoglPriv($comp)
    }
    $WoglPriv(w) makecurrent
    $WoglPriv(w) setcolor $comp $WoglPriv($comp)
}

proc WOGLAcceptColor { } {
    global WoglPriv
    foreach comp "ambient diffuse specular" {
        foreach name $WoglPriv(sets) {
            set type [GetSetTypeName $name]
            GiD_Process escape escape escape escape Utilities ChangeColor $type $name $comp $WoglPriv($comp)
        }
    }
    set comp shininess
    foreach name $WoglPriv(sets) {
        set type [GetSetTypeName $name]
        GiD_Process escape escape escape escape Utilities ChangeColor $type $name $comp [ expr pow(10,$WoglPriv($comp) - 3.0)]
    }
    set comp transparency
    foreach name $WoglPriv(sets) {
        set type [GetSetTypeName $name]
        GiD_Process escape escape escape escape Utilities ChangeColor $type $name $comp $WoglPriv($comp)    
    }
    GiD_Redraw
}

proc WOGLResetColor { } {
    global WoglPriv

    set WoglPriv(ambient) $WoglPriv(Original,ambient)
    set WoglPriv(diffuse) $WoglPriv(Original,diffuse)
    set WoglPriv(specular) $WoglPriv(Original,specular)
    set WoglPriv(shininess) $WoglPriv(Original,shininess)
    set WoglPriv(shininess2) [format %.2f $WoglPriv(Original,shininess2)]
    set WoglPriv(transparency) $WoglPriv(Original,transparency)
    # actualizamos los colores del widget
    set WoglPriv(Old,SlideComponent) ""
    set WoglPriv(SlideComponent) ambient
    WOGLChangeColor
    WOGLChangeSlideComponent ambient
    foreach comp "ambient diffuse specular" {
        $WoglPriv($comp,boton) configure -background $WoglPriv($comp)
        if { $comp == "diffuse"} {
            $WoglPriv(diffuse,botonbasico) configure -background $WoglPriv($comp)
        }
    }
}

proc ReseleccionaTabla { tbl setsel} {
    if { ![winfo exists $tbl] } return
    $tbl selection clear 0 end
    foreach idx $setsel {
        $tbl selection set $idx
        $tbl see $idx
    }
    #WarnWinText "[ $tbl curselection] -> $setsel"
}

proc definePredefinedMaterialList {} {
    # each entry has:
    #    tbl(ColourName) { Order TraducedColourName { ambient{ r, g, b, a} diffuse{ r, g, b, a} specular{r, g, b, a} shininess}}

    array set ::predefinedMaterialList \
        [ list \
              \
              BlackMaterial           [ list  0 [_ "Black material"]          { { 0.2 0.2 0.2 0.5} { 0.1 0.1 0.1 0.5} { 0.7 0.7 0.7 0.5} 0.3}] \
              \
              BrassMaterial           [ list  1 [_ "Brass material"]          { { 0.329412 0.223529 0.027451 0.5} { 0.780392 0.568627 0.113725 0.5} { 0.992157 0.941176 0.807843 0.5} 0.21794872}] \
              ChromeMaterial          [ list  2 [_ "Chrome material"]         { { 0.25     0.25     0.25     0.5} { 0.4      0.4      0.4      0.5} { 0.774597 0.774597 0.774597 0.5} 0.6       }] \
              SilverMaterial          [ list  3 [_ "Silver material"]         { { 0.19225  0.19225  0.19225  0.5} { 0.50754  0.50754  0.50754  0.5} { 0.508273 0.508273 0.508273 0.5} 0.4       }] \
              CopperMaterial          [ list  4 [_ "Copper material"]         { { 0.19125  0.0735   0.0225   0.5} { 0.7038   0.27048  0.0828   0.5} { 0.256777 0.137622 0.086014 0.5} 0.1       }] \
              GoldMaterial            [ list  5 [_ "Gold material"]           { { 0.24725  0.1995   0.0745   0.5} { 0.75164  0.60648  0.22648  0.5} { 0.628281 0.555802 0.366065 0.5} 0.4       }] \
              BronzeMaterial          [ list  6 [_ "Bronze material"]         { { 0.2125   0.1275   0.054    0.5} { 0.714    0.4284   0.18144  0.5} { 0.393548 0.271906 0.166721 0.5} 0.2       }] \
              \
              EmeraldMaterial         [ list  7 [_ "Emerald material"]        { { 0.0215   0.1745   0.0215   0.5} { 0.07568  0.61424  0.07568  0.5} { 0.633    0.727811 0.633    0.5} 0.6       }] \
              JadeMaterial            [ list  8 [_ "Jade material"]           { { 0.135    0.2225   0.1575   0.5} { 0.54     0.89     0.63     0.5} { 0.316228 0.316228 0.316228 0.5} 0.1       }] \
              ObsidianMaterial        [ list  9 [_ "Obsidian material"]       { { 0.05375  0.05     0.06625  0.5} { 0.18275  0.17     0.22525  0.5} { 0.332741 0.328634 0.346435 0.5} 0.3       }] \
              PearlMaterial           [ list 10 [_ "Pearl material"]          { { 0.25     0.20725  0.20725  0.5} { 0.5      0.829    0.829    0.5} { 0.296648 0.296648 0.296648 0.5} 0.088     }] \
              RubyMaterial            [ list 11 [_ "Ruby material"]           { { 0.1745   0.01175  0.01175  0.5} { 0.61424  0.04136  0.04136  0.5} { 0.727811 0.626959 0.626959 0.5} 0.6       }] \
              TurquoiseMaterial       [ list 12 [_ "Turquoise material"]      { { 0.1      0.18725  0.1745   0.5} { 0.396    0.74151  0.69102  0.5} { 0.297254 0.30829  0.306678 0.5} 0.1       }] \
              \
              GreyPlasticMaterial     [ list 13 [_ "Grey plastic material"]   { { 0.1      0.1      0.1      0.5} { 0.3  0.3        0.3        0.5} { 0.50       0.50       0.50       0.5} 0.25}] \
              CyanPlasticMaterial     [ list 14 [_ "Cyan plastic material"]   { { 0.0      0.1      0.06     0.5} { 0.0  0.50980392 0.50980392 0.5} { 0.50196078 0.50196078 0.50196078 0.5} 0.25}] \
              GreenPlasticMaterial    [ list 15 [_ "Green plastic material"]  { { 0.0      0.0      0.0      0.5} { 0.1  0.35       0.1        0.5} { 0.45       0.55       0.45       0.5} 0.25}] \
              RedPlasticMaterial      [ list 16 [_ "Red plastic material"]    { { 0.0      0.0      0.0      0.5} { 0.5  0.0        0.0        0.5} { 0.7        0.6        0.6        0.5} 0.25}] \
              WhitePlasticMaterial    [ list 17 [_ "White plastic material"]  { { 0.0      0.0      0.0      0.5} { 0.55 0.55       0.55       0.5} { 0.70       0.70       0.70       0.5} 0.25}] \
              YellowPlasticMaterial   [ list 18 [_ "Yellow plastic material"] { { 0.0      0.0      0.0      0.5} { 0.5  0.5        0.0        0.5} { 0.60       0.60       0.50       0.5} 0.25}] \
              \
              GreyRubberMaterial      [ list 10 [_ "Grey rubber material"]    { { 0.2  0.2  0.2  0.5} { 0.6  0.6  0.6  0.5} { 0.4  0.4  0.4  0.5} 0.078125}] \
              CyanRubberMaterial      [ list 21 [_ "Cyan rubber material"]    { { 0.0  0.05 0.05 0.5} { 0.4  0.5  0.5  0.5} { 0.04 0.7  0.7  0.5} 0.078125}] \
              GreenRubberMaterial     [ list 22 [_ "Green rubber material"]   { { 0.0  0.05 0.0  0.5} { 0.4  0.5  0.4  0.5} { 0.04 0.7  0.04 0.5} 0.078125}] \
              RedRubberMaterial       [ list 23 [_ "Red rubber material"]     { { 0.05 0.0  0.0  0.5} { 0.5  0.4  0.4  0.5} { 0.7  0.04 0.04 0.5} 0.078125}] \
              WhiteRubberMaterial     [ list 24 [_ "White rubber material"]   { { 0.05 0.05 0.05 0.5} { 0.5  0.5  0.5  0.5} { 0.7  0.7  0.7  0.5} 0.078125}] \
              YellowRubberMaterial    [ list 25 [_ "Yellow rubber material"]  { { 0.05 0.05 0.0  0.5} { 0.5  0.5  0.4  0.5} { 0.7  0.7  0.04 0.5} 0.078125}] \
              \
              Red                     [ list 26 [_ "Red"]                     { { 0.2  0.0  0.0  0.5} { 1.0  0.0  0.0  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              Green                   [ list 27 [_ "Green"]                   { { 0.0  0.2  0.0  0.5} { 0.0  1.0  0.0  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              Blue                    [ list 28 [_ "Blue"]                    { { 0.0  0.0  0.2  0.5} { 0.0  0.0  1.0  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              Yellow                  [ list 29 [_ "Yellow"]                  { { 0.2  0.2  0.0  0.5} { 1.0  1.0  0.0  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              Magenta                 [ list 30 [_ "Magenta"]                 { { 0.2  0.0  0.2  0.5} { 1.0  0.0  1.0  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              Cyan                    [ list 31 [_ "Cyan"]                    { { 0.0  0.2  0.2  0.5} { 0.0  1.0  1.0  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              Orange                  [ list 32 [_ "Orange"]                  { { 0.2  0.1  0.0  0.5} { 1.0  0.67 0.0  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              Lila                    [ list 33 [_ "Lila"]                    { { 0.2  0.1  0.1  0.5} { 0.7  0.2  0.4  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              DarkRed                 [ list 34 [_ "Dark red"]                { { 0.2  0.1  0.1  0.5} { 0.5  0.3  0.3  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              DarkGreen               [ list 35 [_ "Dark green"]              { { 0.1  0.2  0.1  0.5} { 0.3  0.5  0.3  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              DarkBlue                [ list 36 [_ "Dark blue"]               { { 0.1  0.1  0.2  0.5} { 0.3  0.3  0.5  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              MiddleRed               [ list 37 [_ "Middle red"]              { { 0.2  0.1  0.1  0.5} { 1.0  0.3  0.3  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              MiddleGreen             [ list 38 [_ "Middle green"]            { { 0.1  0.2  0.1  0.5} { 0.3  1.0  0.3  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              MiddleBlue              [ list 39 [_ "Middle blue"]             { { 0.1  0.1  0.2  0.5} { 0.3  0.3  1.0  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
              DarkGrey                [ list 40 [_ "Dark grey"]               { { 0.2  0.2  0.2  0.5} { 0.6  0.6  0.6  0.5} { 0.8  0.8  0.8  0.5} 0.5}] \
             ]
}

proc getPredefinedColourInfo { tradName} {
    foreach idx [ array names ::predefinedMaterialList] {
        set ent $::predefinedMaterialList($idx)
        set col_name [ lindex $ent 1]
        set col_set [ lindex $ent 2]
        if { $col_name == $tradName} {
            return $col_set
        }
    }
}

proc clickPredefinedColour { x y tbl} {
    # focus $w
    set cell [ $tbl containingcell $x $y]
    foreach {row col} [ split $cell ,] break
    
    if { $row < 0 || $col < 0 } return

    #if click a unselected row then select only this row (but not if column == 1)
    if { $col != 1 } {
        if { ![ $tbl selection includes $row] } {
            $tbl selection clear 0 end
            $tbl selection set $row
            $tbl see $row
        }
    }

    set colLst [ getPredefinedColourInfo [ $tbl cellcget $row,1 -text]]

    # colLst = { #ambient #diffuse #specular shininess }
    set ::WoglPriv(ambient) [ CCformatFloat2Hex [ lindex $colLst 0]]
    set ::WoglPriv(diffuse) [ CCformatFloat2Hex [ lindex $colLst 1]]
    set ::WoglPriv(specular) [ CCformatFloat2Hex [ lindex $colLst 2]]
    set ::WoglPriv(shininess2) [ lindex $colLst 3]
    WOGLChangeShininess2 a b c
    # actualizamos los colores del widget
    WOGLChangeColor
}

proc CreateTblPredefinedColours { w} {
    package require tablelist_tile

    set vsb $w.vsb1
    set hsb $w.hsb1
    set tbl [ tablelist::tablelist $w.tbl \
                  -exportselection 0 \
                  -columns [list \
                                1 [_ "c#C#Color"] left \
                                0 [_ "Colour name"] left \
                               ] \
                  -stretch 1 \
                  -selectmode single \
                  -labelborderwidth 1 \
                  -labelcommand tablelist::sortByColumn \
                  -showarrow 1 \
                  -showseparators 0 \
                  -xscrollcommand [ list $hsb set] \
                  -yscrollcommand [ list $vsb set] \
                  -resizablecolumns 1 \
                  -stripebackground [ CCColorSombra $::GidPriv(Color,BackgroundListbox)] \
                 ]                 

    # 0 [_ "Id"] left 
    # $tbl columnconfigure 2 -hide 1
    # $tbl configure -labelcommand "tablelist::sortByColumn $tbl 2"

    ttk::scrollbar $vsb -orient vertical   -command [list $tbl yview]
    ttk::scrollbar $hsb -orient horizontal -command [list $tbl xview]

    # bind [$tbl bodytag] <Button-1> "\
    #             foreach {tablelist::W tablelist::x tablelist::y} \
    #             \[tablelist::convEventFields %W %x %y] {}
    # ClickTableListSets \$tablelist::x \$tablelist::y %W $tbl %X %Y"

    bind [$tbl bodytag] <Button-1> "\
                 foreach {tablelist::W tablelist::x tablelist::y} \
                 \[tablelist::convEventFields %W %x %y] {}
     clickPredefinedColour \$tablelist::x \$tablelist::y $tbl"

    bind [$tbl bodytag] <Double-1> "\
                 foreach {tablelist::W tablelist::x tablelist::y} \
                 \[tablelist::convEventFields %W %x %y] {}
     clickPredefinedColour \$tablelist::x \$tablelist::y $tbl ; WOGLAcceptColor"

    grid $tbl $vsb -sticky nsew
    grid configure $vsb -sticky ns
    grid $hsb -sticky ew
    grid remove $vsb $hsb
    bind $tbl <Configure> [list ConfigureListScrollbars $tbl $hsb $vsb]

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    return $w.tbl
}

proc FillTblPredefinedColours { tbl} {
    foreach idx [ array names ::predefinedMaterialList] {
        set ent $::predefinedMaterialList($idx)
        set id [ format "%02d" [ lindex $ent 0]]
        set col_name [ lindex $ent 1]
        set col_set [ lindex $ent 2]
        # col_set = { #ambient #diffuse #specular shininess }
        set cur_col [ CCformatFloat2Hex [ lindex $col_set 1]]
        $tbl insert end [ list $id $col_name]
        $tbl cellconfigure end,0 \
            -background $cur_col -foreground $cur_col \
            -selectbackground $cur_col \
            -selectforeground $cur_col
    }    
    $tbl sortbycolumn 0 -increasing
}

proc PDColorWindow { parent} {
    global WoglPriv tcl_platform
    
    # Get Set values
    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    catch {
        trace vdelete WoglPriv(shininess) w WOGLChangeShininess
        trace vdelete WoglPriv(shininess2) w WOGLChangeShininess2
        trace vdelete WoglPriv(TipoColor) w WOGLChangeTipoColor
        trace vdelete WoglPriv(transparency) w WOGLChangeTransparency
    }

    # si hay varios, hace una media de los colores
    # con el accept imponemos esta media a todos los colores
    
    if { $setsel == {} } {
        WarnWin [_ "Sorry, a set must be selected."]
        return error
    } else {
        #hacemos media de todos los seleccionados:
        set t_amb(r) 0
        set t_amb(g) 0
        set t_amb(b) 0
        set t_dif(r) 0
        set t_dif(g) 0
        set t_dif(b) 0
        set t_spe(r) 0
        set t_spe(g) 0
        set t_spe(b) 0
        set t_shini 0.0
        set t_transp 0.0
        set total 0
        set WoglPriv(sets) ""
        set WoglPriv(transparent) no
        foreach idx $setsel {
            set name [lindex [$tbl get $idx] 1]
            lappend WoglPriv(sets) $name
            # col_set = { #ambient #diffuse #specular shininess }
            set col_set $::GidPriv(PD$name,color)
            #ambient
            set color [ lindex $col_set 0]
            set n [ scan $color \#%2x%2x%2x r g b]
            if { $n == 3} {
                set t_amb(r) [ expr $t_amb(r) + $r]
                set t_amb(g) [ expr $t_amb(g) + $g]
                set t_amb(b) [ expr $t_amb(b) + $b]
            }
            #diffuse
            set color [ lindex $col_set 1]
            set n [ scan $color \#%2x%2x%2x r g b]
            if { $n == 3} {
                set t_dif(r) [ expr $t_dif(r) + $r]
                set t_dif(g) [ expr $t_dif(g) + $g]
                set t_dif(b) [ expr $t_dif(b) + $b]
            }
            #specular
            set color [ lindex $col_set 2]
            set n [ scan $color \#%2x%2x%2x r g b]
            if { $n == 3} {
                set t_spe(r) [ expr $t_spe(r) + $r]
                set t_spe(g) [ expr $t_spe(g) + $g]
                set t_spe(b) [ expr $t_spe(b) + $b]
            }
            if { [ scan [ lindex $col_set 3] %g sh]} {
                set t_shini [ expr $t_shini + $sh]
            }

            incr total

            set WoglPriv(transparent) [GiD_Info postprocess get property transparent $name]
            set tt [GiD_Info postprocess get property transparency $name]
            if { $tt != ""} {
                set t_transp [expr $t_transp + $tt]
            }
                }

        if { $total} {
            set t_amb(r) [ expr int( 0.5 + double( $t_amb(r)) / double( $total))]
            set t_amb(g) [ expr int( 0.5 + double( $t_amb(g)) / double( $total))]
            set t_amb(b) [ expr int( 0.5 + double( $t_amb(b)) / double( $total))]
            set t_dif(r) [ expr int( 0.5 + double( $t_dif(r)) / double( $total))]
            set t_dif(g) [ expr int( 0.5 + double( $t_dif(g)) / double( $total))]
            set t_dif(b) [ expr int( 0.5 + double( $t_dif(b)) / double( $total))]
            set t_spe(r) [ expr int( 0.5 + double( $t_spe(r)) / double( $total))]
            set t_spe(g) [ expr int( 0.5 + double( $t_spe(g)) / double( $total))]
            set t_spe(b) [ expr int( 0.5 + double( $t_spe(b)) / double( $total))]
            set t_shini [ expr double( $t_shini) / double( $total)]
            set t_transp [ expr double( $t_transp) / double( $total)]
        }

        set WoglPriv(ambient) [ format \#%02x%02x%02x $t_amb(r) $t_amb(g) $t_amb(b)]
        set WoglPriv(diffuse) [ format \#%02x%02x%02x $t_dif(r) $t_dif(g) $t_dif(b)]
        set WoglPriv(specular) [ format \#%02x%02x%02x $t_spe(r) $t_spe(g) $t_spe(b)]
        if { $t_shini == 0.0} {
            set t_shini 1e-6
        }
        set WoglPriv(shininess) [ expr log10( $t_shini) + 3.0]
        set WoglPriv(shininess2) [format %.2f $t_shini]
        set WoglPriv(transparency) $t_transp

        set WoglPriv(Original,ambient) $WoglPriv(ambient)
        set WoglPriv(Original,diffuse) $WoglPriv(diffuse)
        set WoglPriv(Original,specular) $WoglPriv(specular)
        set WoglPriv(Original,shininess) $WoglPriv(shininess)
        set WoglPriv(Original,shininess2) $WoglPriv(shininess2)
        set WoglPriv(Original,transparency) $WoglPriv(transparency)

        if { $total != 1} {
            set WoglPriv(transparent) no
        }

    }

    #set WoglPriv(ambient) #543907
    #set WoglPriv(diffuse) #c7911d
    #set WoglPriv(specular) #fdf0ce
    #set WoglPriv(shininess) 0.217949

    set WoglPriv(Old,ambient) $WoglPriv(ambient)
    set WoglPriv(Old,diffuse) $WoglPriv(diffuse)
    set WoglPriv(Old,specular) $WoglPriv(specular)
    set WoglPriv(Old,shininess) $WoglPriv(shininess)
    set WoglPriv(Old,shininess2) $WoglPriv(shininess2)
    set WoglPriv(Old,transparency) $WoglPriv(transparency)


    if { $parent != "."} {
        set w $parent.cw
    } else {
        set w .__pd__cw
    }

    if { [ winfo exists $w] } {
        # wm deiconify $w
        # vamos a ajustar el lugar
        update idletasks
        
        # extrange errors with updates
        if { ![winfo exists $w] } { return 0}
        #set pare [winfo toplevel [winfo parent $w]]
        set pare [winfo toplevel .gid.central.s]
        set x [expr [winfo x $pare]+[winfo width $pare ]/2- [winfo reqwidth $w]/2]
        set y [expr [winfo y $pare]+[winfo height $pare ]/2- [winfo reqheight $w]]
        if { $x < 0 } { set x 0 }
        if { $y < 0 } { set y 0 }
        WmGidGeom $w +$x+$y
        update
        wm deiconify $w

    } else {
        toplevel $w
        if { $::tcl_platform(platform) == "windows" } {
            wm transient $w [winfo toplevel [winfo parent $w]]
            wm attributes $w -toolwindow 1
        }
        wm title $w [_ "Change color window"]
        wm minsize $w 300 200

        set WoglPriv(w) $w.wogl
        if { $::GidPriv(DrawThreeGearsWidget)} {
            if { $::tcl_platform(platform) == "windows" } {            
                gid_togl $w.wogl -width 256 -height 256 -rgba true -double true \
                    -depth true -ident PDColorWindow -privatecmap false -overlay 0 -softrender 1
            } else {
                gid_togl $w.wogl -width 256 -height 256 -rgba true -double true \
                    -depth true -ident PDColorWindow -privatecmap false -overlay 0
            }
        
            bind $w.wogl <ButtonPress-1> { WOGLRotStart %x %y %W}
            bind $w.wogl <B1-Motion> { WOGLRotMove %x %y %W}
        } else {
            # just a dummy procedure to swallow all arguments
            proc ::$w.wogl { args } {
            }
        }

        ttk::frame $w.fcomp -style sunken.TFrame -borderwidth 1

        NoteBook $w.fcomp.nb -internalborderwidth 0


        set pagina_basica [ $w.fcomp.nb insert end ConfigBasic -text [_ "Basic"]]

        # grupo custom colours
        set fCustom [ttk::labelframe $pagina_basica.pers -text [_ "Custom"]]         

        label $fCustom.lc -text [_ "Color"]:

        if { $::tcl_platform(os) != "Darwin"} {
            tk::button $fCustom.color -borderwidth 0 -width 3 -background $WoglPriv(diffuse) \
                -command "WOGLChangeColorBasico $fCustom.color"
        } else {
            LabelButton $fCustom.color -borderwidth 0 -width 3 -background $WoglPriv(diffuse) \
                -command "WOGLChangeColorBasico $fCustom.color"
        }
        set WoglPriv(diffuse,botonbasico) $fCustom.color

        #label $fCustom.ll -text [_ "Look"]:
        set f [ttk::labelframe $fCustom.ll -text [_ "Look"]]        
        ttk::radiobutton $f.rd1 -text [_ "Metallic"] -value metal -variable WoglPriv(TipoColor)
        ttk::radiobutton $f.rd2 -text [_ "Plastic"] -value plastico -variable WoglPriv(TipoColor)
        ttk::radiobutton $f.rd3 -text [_ "Rubber"] -value goma -variable WoglPriv(TipoColor)
        set WoglPriv(TipoColor) plastico

        
        ttk::label $fCustom.l_transparency -text [_ "Transparency"]:
        #entry $fCustom.e_transparency -textvariable WoglPriv(transparency) -width 6
        if { ![info exists WoglPriv(transparency)] } {
            set WoglPriv(transparency) 0
        }
        gidscale $fCustom.ss \
            -variable WoglPriv(transparency) \
            -showbuttons 1 -symbolbuttons "< >" \
            -orient h -from 0.0 -to 1.0 -resolution 0.05

        grid $f.rd1 -sticky news -padx 3 -pady 2 -ipadx 2
        grid $f.rd2 -sticky news -padx 3 -pady 2 -ipadx 2
        grid $f.rd3 -sticky news -padx 3 -pady 2 -ipadx 2

        grid $fCustom.lc $fCustom.color -sticky news -padx 4 -pady 2 -ipadx 2
        grid $fCustom.ll -columnspan 2 -sticky news -padx 3 -pady 2 -ipadx 2

        # grid $fCustom.l_transparency -column 2 -row 0 -sticky news -padx 3 -pady 2 -ipadx 2
        # grid $fCustom.ss -column 2 -row 1 -sticky news -padx 3 -pady 2 -ipadx 2
        grid $fCustom.l_transparency -columnspan 2 -column 0 -row 2 -sticky ws -padx 3 -pady 2 -ipadx 2
        grid $fCustom.ss -column 0 -columnspan 2 -row 3 -sticky news -padx 3 -pady 2 -ipadx 2

        grid columnconfigure $fCustom 0 -weight 1
        grid rowconfigure $fCustom 0 -weight 1
        grid rowconfigure $fCustom 1 -weight 1
        grid rowconfigure $fCustom 2 -weight 1
        grid rowconfigure $fCustom 3 -weight 1

        # grupo predefined colours
        definePredefinedMaterialList

        set fPredef [ttk::labelframe $pagina_basica.predef -text [_ "Predefined"]]

        FillTblPredefinedColours [ CreateTblPredefinedColours $fPredef]
        # grid $fPredef.tbl -sticky news

        # los dos marcos
        grid $pagina_basica.predef $pagina_basica.pers -sticky news -padx 2 -pady 2 -sticky news
        grid rowconfigure $pagina_basica 0 -weight 1
        grid columnconfigure $pagina_basica 0 -weight 1
        grid columnconfigure $pagina_basica 1 -weight 1

        set pagina_avanzada [ $w.fcomp.nb insert end ConfigAvz -text [_ "Advanced"]]
        
        ttk::frame $pagina_avanzada.avz -style flat.TFrame
        ttk::frame $pagina_avanzada.avz.but -style sunken.TFrame -borderwidth 0
       
        ttk::label $pagina_avanzada.avz.but.l -text [_ " Color components "] -style Toolbutton        
        
        grid $pagina_avanzada.avz.but.l -sticky wens -padx 10 -pady 10 -columnspan 3

        foreach comp "Ambient Diffuse Specular" {
            set id [ string tolower $comp]
            ttk::label $pagina_avanzada.avz.but.l_$id -text $comp\:
            set entero WoglPriv($id)
            if { $::tcl_platform(os) != "Darwin"} {
                tk::button $pagina_avanzada.avz.but.b_$id -borderwidth 1 -width 3 -background [ subst $$entero] \
                    -command "WOGLChangeColorComponent $pagina_avanzada.avz.but.b_$id $id" \
                    -padx 8 -pady 3
            } else { 
                LabelButton $pagina_avanzada.avz.but.b_$id -borderwidth 1 -width 3 -background [ subst $$entero] \
                    -command "WOGLChangeColorComponent $pagina_avanzada.avz.but.b_$id $id" \
                    -padx 8 -pady 3
            }
            ttk::radiobutton $pagina_avanzada.avz.but.r_$id -value $id -variable WoglPriv(SlideComponent) \
                    -command "WOGLChangeSlideComponent $id"
            grid $pagina_avanzada.avz.but.l_$id $pagina_avanzada.avz.but.b_$id $pagina_avanzada.avz.but.r_$id \
                    -sticky e -padx 4 -pady 2 -ipadx 2
            set WoglPriv($id,boton) $pagina_avanzada.avz.but.b_$id
            set WoglPriv($id,radio) $pagina_avanzada.avz.but.r_$id
        }
        
        ttk::label $pagina_avanzada.avz.but.l_shininess -text [_ "Shininess"]:
        ttk::entry $pagina_avanzada.avz.but.e_shininess -textvariable WoglPriv(shininess2) -width 6
        if { ![info exists WoglPriv(shininess)] } {
            set WoglPriv(shininess) 0
        }
        gidscale $pagina_avanzada.avz.but.ss \
                -variable WoglPriv(shininess) \
                -orient horizontal -from 0.0 -to 3.0 -resolution 0.05 -showvalue 0
        
        grid $pagina_avanzada.avz.but.l_shininess $pagina_avanzada.avz.but.e_shininess -sticky e -padx 4 -pady 2 -ipadx 2
        grid $pagina_avanzada.avz.but.ss -sticky ew -padx 4 -pady 2 -columnspan 3
        

        ttk::frame $pagina_avanzada.avz.scl -style flat.TFrame
        
        label $pagina_avanzada.avz.scl.lred -text [_ "Red"]
        label $pagina_avanzada.avz.scl.lgreen -text [_ "Green"]
        label $pagina_avanzada.avz.scl.lblue -text [_ "Blue"]
        gidscale $pagina_avanzada.avz.scl.red -orient vertical -from 0 -to 255 -resolution 1 -command "WOGLChangeSlideColor red"
        gidscale $pagina_avanzada.avz.scl.green -orient vertical -from 0 -to 255 -resolution 1 -command "WOGLChangeSlideColor green"
        gidscale $pagina_avanzada.avz.scl.blue -orient vertical -from 0 -to 255 -resolution 1 -command "WOGLChangeSlideColor blue"
        set WoglPriv(slide,red) $pagina_avanzada.avz.scl.red
        set WoglPriv(slide,green) $pagina_avanzada.avz.scl.green
        set WoglPriv(slide,blue) $pagina_avanzada.avz.scl.blue
        
        grid $pagina_avanzada.avz.scl.lred -padx 4 -pady 2 -row 0 -column 0
        grid $pagina_avanzada.avz.scl.lgreen -padx 4 -pady 2 -row 0 -column 1
        grid $pagina_avanzada.avz.scl.lblue -padx 4 -pady 2 -row 0 -column 2
        grid $pagina_avanzada.avz.scl.red -sticky ns -padx 4 -pady 2 -row 1 -column 0
        grid $pagina_avanzada.avz.scl.green -sticky ns -padx 4 -pady 2 -row 1 -column 1
        grid $pagina_avanzada.avz.scl.blue -sticky ns -padx 4 -pady 2 -row 1 -column 2

        grid rowconfigure $pagina_avanzada.avz.scl 1 -weight 1
        grid columnconfigure $pagina_avanzada.avz.scl 0 -weight 1
        grid columnconfigure $pagina_avanzada.avz.scl 1 -weight 1
        grid columnconfigure $pagina_avanzada.avz.scl 2 -weight 1

        ttk::label $pagina_avanzada.avz.l -width 1

        grid $pagina_avanzada.avz.but $pagina_avanzada.avz.scl $pagina_avanzada.avz.l \
                -sticky ewns -padx 1 -pady 1
        grid configure $pagina_avanzada.avz.l -sticky e
        grid rowconfigure $pagina_avanzada.avz 0 -weight 1
        grid columnconfigure $pagina_avanzada.avz 0 -weight 1
        grid columnconfigure $pagina_avanzada.avz 1 -weight 1

        grid $pagina_avanzada.avz -sticky news


        grid $w.fcomp.nb -padx 2 -pady 2 -sticky news
        grid rowconfigure $w.fcomp 0 -weight 1
        grid columnconfigure $w.fcomp 0 -weight 1

        #grid $w.fcomp -sticky news

        #grid rowconfigure $w 0 -weight 1
        #grid columnconfigure $w 0 -weight 1
        #grid columnconfigure $w 1 -weight 1

        #grid $w.fcomp.ftype.rd1 $w.fcomp.ftype.rd2 -sticky ew
        #grid rowconfigure $w.fcomp.ftype 0 -weight 1
        #grid columnconfigure $w.fcomp.ftype 0 -weight 1
        #grid $w.fcomp.ftype -sticky ew

        #grid rowconfigure $w.fcomp 0 -weight 1
        #grid rowconfigure $w.fcomp 1 -weight 1
        #grid columnconfigure $w.fcomp 0 -weight 1
        
        ttk::frame $w.but -style BottomFrame.TFrame        
        
        ttk::button $w.but.accept -text [_ "Apply"] -command "WOGLAcceptColor" \
          -style BottomFrame.TButton
        ttk::button $w.but.reset -text [_ "Reset"] -command "WOGLResetColor" \
          -style BottomFrame.TButton
        ttk::button $w.but.close -text [_ "Close"] -command "wm withdraw $w" \
          -style BottomFrame.TButton
        
        # grid $w.but.accept -sticky ews -padx 4 -pady 3
        # grid $w.but.close -sticky ews -padx 4 -pady 3
        grid $w.but.accept $w.but.reset $w.but.close -in $w.but -sticky ews -padx 4 -pady 10

        if { $::GidPriv(DrawThreeGearsWidget)} {
            grid $w.wogl -sticky news -row 0 -column 0 -rowspan 2
        }
        grid $w.fcomp -sticky news -row 0 -column 1
        grid $w.but -sticky ews -row 1 -column 1
        grid anchor $w.but center
        
        grid columnconfigure $w 0 -weight 1
        grid rowconfigure $w 0 -weight 1
        grid columnconfigure $w 1 -weight 1
        
        
        # vamos a ajustar el lugar
        wm withdraw $w
        update idletasks
        
        # extrange errors with updates
        if { ![winfo exists $w] } { return 0}
        #set pare [winfo toplevel [winfo parent $w]]
        set pare [winfo toplevel .gid.central.s]
        set x [expr [winfo x $pare]+[winfo width $pare ]/2- [winfo reqwidth $w]/2]
        set y [expr [winfo y $pare]+[winfo height $pare ]/2- [winfo reqheight $w]]
        if { $x < 0 } { set x 0 }
        if { $y < 0 } { set y 0 }
        WmGidGeom $w +$x+$y
        $w.fcomp.nb compute_size
        $w.fcomp.nb raise [ $w.fcomp.nb page 0]
        update
        wm deiconify $w




    }

    foreach comp "Ambient Diffuse Specular" {
        set id [ string tolower $comp]
        set entero WoglPriv($id)
        $WoglPriv($id,boton) configure -background [ subst $$entero]
        if { $id == "diffuse"} {
            $WoglPriv(diffuse,botonbasico) configure -background [ subst $$entero]
        }
    }

    # actualizamos los colores del widget
    WOGLResetColor
    trace variable WoglPriv(shininess) w WOGLChangeShininess
    trace variable WoglPriv(shininess2) w WOGLChangeShininess2
    trace variable WoglPriv(TipoColor) w WOGLChangeTipoColor
    trace variable WoglPriv(transparency) w WOGLChangeTransparency
}

proc FillPDInfo {} {
    if { [GidUtils::AreWindowsDisabled]} {
        return
    }
    if { ![info exists ::GidPriv(PostDisplayWindow)] || ![winfo exists $::GidPriv(PostDisplayWindow)] } {
        return 
    }
    if { ![info exists ::GidPriv(PostDisplayDS)] } {
        return 
    }
    if { $::GidPriv(PostDisplayDoingAccept) } { 
        return 
    }
    set var [GiD_Info postprocess get cur_display_style]
    if { $::GidPriv(PostDisplayDS) != $var } {
        set ::GidPriv(PostDisplayDS) $var
        set ::GidPriv(PostDisplayDSOld) $var
    }
    if { $::GidPriv(PostDisplayRender) != [ GiD_Info postprocess get cur_display_render] } {
        set ::GidPriv(PostDisplayRender) [ GiD_Info postprocess get cur_display_render]
    }
    if { $::GidPriv(PostDisplayCulling) != [ GiD_Info postprocess get cur_display_culling] } {
        set ::GidPriv(PostDisplayCulling) [ GiD_Info postprocess get cur_display_culling]
    }
    if { $::GidPriv(PostDisplayConditions) != [ GiD_Info postprocess get cur_show_conditions] } {
        set ::GidPriv(PostDisplayConditions) [ GiD_Info postprocess get cur_show_conditions]
    }
    array set PreModel [ GiD_Info postprocess get cur_pre_model_properties]
    if { $::GidPriv(PostDisplayPreModelShow) != $PreModel(Data) } {
        set ::GidPriv(PostDisplayPreModelShow) $PreModel(Data)
    }
    if { $::GidPriv(PostDisplayPreModelRender) != $PreModel(Render) } {
        set ::GidPriv(PostDisplayPreModelRender) $PreModel(Render)
    }

    set var [ GiD_Info postprocess get cur_display_transparence]
    if { $var == "Transparent"} {
        set ::GidPriv(PostDisplayTransparent) 1
    } else {
        set ::GidPriv(PostDisplayTransparent) 0
    }

    set var [ GiD_Info postprocess get cur_display_body_type]
    if { $var == "Massive"} {
        set ::GidPriv(PostDisplayMassiveBodies) 1
    } else {
        set ::GidPriv(PostDisplayMassiveBodies) 0
    }

    # acabamos de verificar si es estilo es comun
    set estilo_comun ""
    foreach i [ list volumes surfaces cuts] {
        set SetNames [ GiD_Info postprocess get all_${i}ets]
        foreach j $SetNames {
            set estilo [ GiD_Info postprocess get property DisplayStyle $j]
            if { $estilo_comun != ""} {
                if { $estilo_comun != $estilo} {
                    set estilo_comun "Any"
                    break
                }
            } else {
                set estilo_comun $estilo
            }
        }
        if { $estilo_comun == "Any"} {
            break
        }
    }
            
    if { [ info exists ::GidPriv(PostDisplayDS)] } {
        if { $estilo_comun == "Any" || ($estilo_comun != "" && $estilo_comun != $::GidPriv(PostDisplayDS)) } {           
            set ::GidPriv(PostDisplayDS) "Any"
            set ::GidPriv(PostDisplayDSOld) "Any"
        }
    }
    set recreate 1
    set do_update 0
    FillPDListInfo $recreate $do_update
}


proc PDSetCheck { menu state } {
    set i 0
    while { $i == [$menu index $i] } {
        set varname [$menu entrycget $i -variable]
        set $varname $state
        incr i
    }
}

proc PDDeleteCosas {} {
    global GIDDEFAULT

    set w $::GidPriv(PostDisplayWindowList)
    set ::GidPriv(PostDisplayDoingAccept) 1

    set lista_cosas {}

    if { $::GidPriv(WinList_volumes)} {
        set lista_cosas [ concat $lista_cosas volumes]
    }

    if { $::GidPriv(WinList_surfaces)} {
        set lista_cosas [ concat $lista_cosas surfaces]
    }

    if { $::GidPriv(WinList_cuts)} {
        set lista_cosas [ concat $lista_cosas cuts]
    }

    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
        return
    }

    set names [list]
    set types [list]
    foreach idx $setsel {  
        set name [lindex [$tbl get $idx] 1]
        lappend names $name
        set type [GetSetTypeName $name]
        lappend types $type
    }    
    after idle ReseleccionaTabla $tbl [ list $setsel]

    set nice_names $names
    # if { [ llength $names] == 1} {
    #     set nice_names {*}$names
    # }
    set names_to_show [ join [ lrange $nice_names 0 20] "\n"]
    if { [ llength $nice_names] > 20} {
        append names_to_show "\n... ?"
    } else {
        append names_to_show " ?"
    }
    set res [MessageBoxOptionsButtons [_ "Delete Volumes/Surfaces/Cuts"] \
                 [_ "Are you sure you want to delete following sets:\n%s" $names_to_show] \
                 {0 1} [list [_ "Yes"] [_ "No#C#I don't want to do that"]] question ""]
    if { $res == 1 } {
        return
    }

    set oldAutomaticRedraw [ GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1

    GiD_Process escape escape escape escape
    foreach name $names type $types {
        GiD_Process Utilities Delete $type $name Yes escape escape escape escape
    }

    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    GiD_Redraw
    set ::GidPriv(PostDisplayDoingAccept) 0
    FillPDListInfo
}

proc PDAcceptOnOff {} {
    global GIDDEFAULT
    if { $::PD_debug_table_update} {
        W "PDAcceptOnOff"
    }
    set oldAutomaticRedraw [ GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1

    set w $::GidPriv(PostDisplayWindow)
    set ::GidPriv(PostDisplayDoingAccept) 1
    GiD_Process escape escape escape escape
    set process_types {}
    if { $::GidPriv(WinList_volumes)} {
        lappend process_types VolumeSets
    }
    if { $::GidPriv(WinList_surfaces)} {
        lappend process_types SurfaceSets
    }
    if { $::GidPriv(WinList_cuts)} {
        lappend process_types CutSets
    }

    foreach type $process_types {
        set var [ GiD_Info postprocess get cur_$type]
        set names [list]
        foreach name [GiD_Info postprocess get all_$type] {
            if { [lsearch $var $name] != -1 } {
                if { ![ info exists ::GidPriv(PD$name,OnOff)]} {
                    # some changes in the layers and current window has not been actualized
                    # soo actualize it now !
                    after 300 FillPDInfo
                    GiD_Set AutomaticRedraw $oldAutomaticRedraw
                    set ::GidPriv(PostDisplayDoingAccept) 0
                    return
                }

                if { $::GidPriv(PD$name,OnOff) == 0 } {
                    lappend names $name
                }
            } else {
                if { $::GidPriv(PD$name,OnOff) == 1 } {
                    lappend names $name
                }
            }
        }
        if { [llength $names] } {
            GiD_Process Select $type {*}$names escape
        }
    }

    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    GiD_Redraw
    set ::GidPriv(PostDisplayDoingAccept) 0
    set recreate 1
    set do_update 1
    FillPDListInfo $recreate $do_update
    if { $::PD_debug_table_update} {
        W "PDAcceptOnOff done"
    }
}

proc PDAcceptPropiedad { property } {
    global GIDDEFAULT

    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1

    set w $::GidPriv(PostDisplayWindow)
    set ::GidPriv(PostDisplayDoingAccept) 1

    set types {}
    if { $::GidPriv(WinList_volumes)} {
        lappend types VolumeSets
    }
    if { $::GidPriv(WinList_surfaces)} {
        lappend types SurfaceSets
    }
    if { $::GidPriv(WinList_cuts)} {
        lappend types CutSets
    }
    GiD_Process escape escape escape escape
    foreach type $types {
        foreach name [GiD_Info postprocess get all_$type] {
            set current_value [string tolower [string index [GiD_Info postprocess get property $property $name] 0]]
            if { $current_value == "y" } {
                if { $::GidPriv(PD$name,$property) == 0 } {
                    GiD_Process escape escape escape escape Utilities ChangeProperty $type $name $property no
                }
            } else {
                if { $::GidPriv(PD$name,$property) == 1 } {
                    GiD_Process escape escape escape escape Utilities ChangeProperty $type $name $property yes
                }
            }
        }
    }

    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    GiD_Redraw
    set ::GidPriv(PostDisplayDoingAccept) 0
    set recreate 1
    set do_update 1
    FillPDListInfo $recreate $do_update
}

proc PDChangeCullingToWogl { name1 name2 op} {
    global WoglPriv

    # actualizamos las ruedas dentadas
    if { [ info exists WoglPriv(w)] && [ winfo exists $WoglPriv(w)]} {
        $WoglPriv(w) makecurrent
        $WoglPriv(w) setculling $::GidPriv(PostDisplayCulling)
    }
}

proc PDChangeRenderToWogl { name1 name2 op} {
    global WoglPriv

    # actualizamos las ruedas dentadas
    if { [ info exists WoglPriv(w)] && [ winfo exists $WoglPriv(w)]} {
        $WoglPriv(w) makecurrent
        $WoglPriv(w) setrender $::GidPriv(PostDisplayRender)
    }
}

# proc PDChangeTransparentToWogl { name1 name2 op} {
#     global WoglPriv
#
#     # actualizamos las ruedas dentadas
#     if { [ info exists WoglPriv(w)] && [ winfo exists $WoglPriv(w)]} {
#           if { $::GidPriv(PostDisplayTransparent)} {
#               $WoglPriv(w) settransparent yes
#           } else {
#               $WoglPriv(w) settransparent no
#           }
#     }
# }

proc PDChangeTransparentToWogl { transparente} {
    global WoglPriv

    # actualizamos las ruedas dentadas
    if { [ info exists WoglPriv(w)] && [ winfo exists $WoglPriv(w)]} {
        $WoglPriv(w) makecurrent
        $WoglPriv(w) settransparent $transparente
    }
}

proc PDAcceptStyle {} {
    global GIDDEFAULT

    GidUtils::DisableGraphics

    set w $::GidPriv(PostDisplayWindow)
    set ::GidPriv(PostDisplayDoingAccept) 1

    if { $::GidPriv(PostDisplayDS) != "Any" } {
        if { $::GidPriv(PostDisplayDS) != $::GidPriv(PostDisplayDSOld) } {
            GiD_Process escape escape escape escape DisplayStyle $::GidPriv(PostDisplayDS)
        }
    }
    set ::GidPriv(PostDisplayDSOld) $::GidPriv(PostDisplayDS)

    if { ( $::GidPriv(PostDisplayRender) != "") && \
             $::GidPriv(PostDisplayRender) != [ GiD_Info postprocess get cur_display_render] } {
        GiD_Process escape escape escape escape Utilities Render $::GidPriv(PostDisplayRender)
    }

    if { ( $::GidPriv(PostDisplayCulling) != "") && \
             $::GidPriv(PostDisplayCulling) != [ GiD_Info postprocess get cur_display_culling] } {
        GiD_Process escape escape escape escape Utilities Render Culling $::GidPriv(PostDisplayCulling)
        if { [ info exists ::GidPriv(PostDisplayCullBitmap)] && ( $::GidPriv(PostDisplayCullBitmap) != "") } {
            set var [ string tolower $::GidPriv(PostDisplayCulling)]
            $::GidPriv(PostDisplayCullBitmap) configure -image [ gid_themes::GetImage cull$var.png medium_icons]
        }
    }

    if { ( $::GidPriv(PostDisplayConditions) != "") && \
             $::GidPriv(PostDisplayConditions) != [ GiD_Info postprocess get cur_show_conditions] } {
        GiD_Process escape escape escape escape Utilities Show Conditions $::GidPriv(PostDisplayConditions)
    }
    array set PreModel [ GiD_Info postprocess get cur_pre_model_properties]
    if { ( $::GidPriv(PostDisplayPreModelShow) != "") && \
             $::GidPriv(PostDisplayPreModelShow) != $PreModel(Data) } {
        GiD_Process escape escape escape escape Utilities Render $::GidPriv(PostDisplayPreModelShow)
    }
    if { ( $::GidPriv(PostDisplayPreModelRender) != "") && \
             $::GidPriv(PostDisplayPreModelRender) != $PreModel(Render) } {
        GiD_Process escape escape escape escape Utilities Render $::GidPriv(PostDisplayPreModelRender)
    }

    if { [ GiD_Info postprocess get cur_display_transparence] == "Transparent" } {
        set vv 1
    } else {
        set vv 0
    }
    if { $::GidPriv(PostDisplayTransparent) != $vv } {
        if { $::GidPriv(PostDisplayTransparent) == 1} {
            GiD_Process escape escape escape escape Utilities Render Transparent
        } else {
            GiD_Process escape escape escape escape Utilities Render Opaque
        }
    }
    if { [ GiD_Info postprocess get cur_display_body_type] == "Massive" } {
        set vv 1
    } else {
        set vv 0
    }
    if { $::GidPriv(PostDisplayMassiveBodies) != $vv } {
        if { $::GidPriv(PostDisplayMassiveBodies) == 1} {
            GiD_Process escape escape escape escape results options massivebody yes
        } else {
            GiD_Process escape escape escape escape results options massivebody no
        }
    }

    GidUtils::EnableGraphics

    GiD_Redraw
    set ::GidPriv(PostDisplayDoingAccept) 0
    set recreate 1
    set do_update 1
    FillPDListInfo $recreate $do_update
}

####################
# List Window
####################

proc BuscaQueHay { lst_mallas nombre} {
    set ret_txt ""
    foreach linea_org $lst_mallas {
        # regsub -all {_} $linea_org { } linea
        set linea $linea_org
        if { [ regexp {^\+ (.*): (.*)$} $linea dum parte_nombre CuantosElementos]} {
            if { $parte_nombre == $nombre} {
                set ret_txt $CuantosElementos
                break
            }
        }
    }
    return $ret_txt
}

proc EscojeLetrasEstilo { str_estilo} {
    set ret "NA"
    switch "$str_estilo" {
        "Boundaries" {
            set ret "Bou"
        }
        "Hidden_Bound" {
            set ret "HB"
        }
        "All_Lines" {
            set ret "AL"
        }
        "Hidden_Lines" {
            set ret "HL"
        }
        "Body" {
            set ret "Body"
        }
        "Body_Bound" {
            set ret "BB"
        }
        "Body_Lines" {
            set ret "BL"
        }
        "Points" {
            set ret "P"
        }
        "Points_Bound" {
            set ret "PB"
        }
    }
    return $ret
}

proc EscojeIconoEstilo { str_estilo} {
    set ret [ gid_themes::GetImage blank.png small_icons]
    switch "$str_estilo" {
        "Boundaries" {
            set ret [ gid_themes::GetImage boundaries.png small_icons]
        }
        "Hidden_Bound" {
            set ret [ gid_themes::GetImage hiddenbound.png small_icons]
        }
        "All_Lines" {
            set ret [ gid_themes::GetImage alllines.png small_icons]
        }
        "Hidden_Lines" {
            set ret [ gid_themes::GetImage hiddenlines.png small_icons]
        }
        "Body" {
            set ret [ gid_themes::GetImage body.png small_icons]
        }
        "Body_Bound" {
            set ret [ gid_themes::GetImage bodybound.png small_icons]
        }
        "Body_Lines" {
            set ret [ gid_themes::GetImage bodylines.png small_icons]
        }
        "Points" {
            set ret [ gid_themes::GetImage point.png small_icons]
        }
        "Points_Bound" {
            set ret [ gid_themes::GetImage pointsbound.png small_icons]
        }
        "Any" {
            set ret ""
        }
    }
    return $ret
}

proc SelectImageStyle { str_estilo} {
    set ret [ gid_themes::GetImage blank.png medium_icons]
    switch "$str_estilo" {
        "Boundaries" {
            set ret [ gid_themes::GetImage boundaries.png medium_icons]
        }
        "Hidden_Bound" {
            set ret [ gid_themes::GetImage hiddenbound.png medium_icons]
        }
        "All_Lines" {
            set ret [ gid_themes::GetImage alllines.png medium_icons]
        }
        "Hidden_Lines" {
            set ret [ gid_themes::GetImage hiddenlines.png medium_icons]
        }
        "Body" {
            set ret [ gid_themes::GetImage body.png medium_icons]
        }
        "Body_Bound" {
            set ret [ gid_themes::GetImage bodybound.png medium_icons]
        }
        "Body_Lines" {
            set ret [ gid_themes::GetImage bodylines.png medium_icons]
        }
        "Points" {
            set ret [ gid_themes::GetImage point.png medium_icons]
        }
        "Points_Bound" {
            set ret [ gid_themes::GetImage pointsbound.png medium_icons]
        }
    }
    return $ret
}

proc PDCambiaEstiloSet { padre estilo img} {
    global PostDisplay

    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
        return error

    } else {

        set images_menu 1
        if { $::tcl_platform(os) == "Darwin" } {
            set images_menu 0
        }

        if { $images_menu} {
            $padre configure -image $img
        } else {
            $padre configure -text $img
        }

        set oldAutomaticRedraw [ GiD_Set AutomaticRedraw]
        GiD_Set AutomaticRedraw -1
        # to avoid window updates through FillPDInfo
        set ::GidPriv(PostDisplayDoingAccept) 1
        
        GiD_Process escape escape escape escape
        foreach idx $setsel {
            set name [lindex [$tbl get $idx] 1]
            set type [GetSetTypeName $name]
            GiD_Process Utilities ChangeProperty $type $name DisplayStyle $estilo
            GiD_Process escape escape escape escape
        }
        GiD_Set AutomaticRedraw $oldAutomaticRedraw
        GiD_Redraw
        set ::GidPriv(PostDisplayDoingAccept) 0
        set recreate 0
        set do_update 1
        FillPDListInfo $recreate $do_update
        # FillPDListInfo 0
    }

    # PDAcceptPropiedad DisplayStyle

    after idle ReseleccionaTabla $tbl [ list $setsel]
}

proc PDCambiaEstiloSetDesdeTabla { estilo} {
    global PostDisplay

    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
        return error
    } else {

        set oldAutomaticRedraw [ GiD_Set AutomaticRedraw]
        GiD_Set AutomaticRedraw -1
        # to avoid window updates through FillPDInfo
        set ::GidPriv(PostDisplayDoingAccept) 1
        GiD_Process escape escape escape escape
        foreach idx $setsel {
            set name [lindex [$tbl get $idx] 1]
            set type [GetSetTypeName $name]
            GiD_Process Utilities ChangeProperty $type $name DisplayStyle $estilo
            GiD_Process escape escape escape escape
        }
        GiD_Set AutomaticRedraw $oldAutomaticRedraw
        set ::GidPriv(PostDisplayDoingAccept) 0
        GiD_Redraw
        set recreate 0
        set do_update 1
        FillPDListInfo $recreate $do_update
        # FillPDListInfo 0
    }

    # PDAcceptPropiedad DisplayStyle

    after idle ReseleccionaTabla $tbl [ list $setsel]
}

proc PDMenuEstilo { padre col_bg} {
    set images_menu 1
    if { $::tcl_platform(os) == "Darwin" } {
        set images_menu 0
    }

    set w_menu ${padre}.m
    menu $w_menu -tearoff no -background $col_bg -borderwidth 1 -relief raised -activeborderwidth 0
    set display_styles [GiD_Info postprocess get all_display_styles]
    foreach display_style $display_styles {
        if { $images_menu} {
            set img [SelectImageStyle $display_style]
            $w_menu add command -image $img -command [list PDCambiaEstiloSet $padre $display_style $img]
        } else {
            regsub -all {_} $display_style { } txt
            $w_menu add command -label $txt -hidemargin 1 -command [list PDCambiaEstiloSet $padre $display_style [list $txt]]
        }
    }
    return $w_menu
}

proc PDMenuIconosEstilo { padre col_bg} {
    global PostDisplay
    set images_menu 1
    if { $::tcl_platform(os) == "Darwin" } {
        set images_menu 0
    }

    set w_menu ${padre}.m
    set PostDisplay(MenuEstiloTabla) $w_menu
    set PostDisplay(MenuEstiloTabla,Post) 0

    menu $w_menu -tearoff no -background $col_bg -borderwidth 1 -relief raised -activeborderwidth 0
    set display_styles [GiD_Info postprocess get all_display_styles]
    foreach display_style $display_styles {
        if { $images_menu} {
            set img [EscojeIconoEstilo $display_style]
            $w_menu add command -image $img -command "PDUnpostMenuIconosEstilo; PDCambiaEstiloSetDesdeTabla $display_style"
        } else {
            regsub -all {_} $display_style { } txt
            $w_menu add command -label $txt -command "PDUnpostMenuIconosEstilo; PDCambiaEstiloSetDesdeTabla $display_style"
        }
    }
    return $w_menu
}

proc PDPostMenuIconosEstilo { global_x global_y} {
    if { $::PostDisplay(MenuEstiloTabla,Post)} {
        PDUnpostMenuIconosEstilo
    }

    # por si acaso esta abierto el menu, al cabo de un rato se apaga
    set ::PostDisplay(MenuEstiloTabla,Post) 1
    set ::PostDisplay(MenuEstiloTabla,After) [ after 5000 PDUnpostMenuIconosEstilo]
    $::PostDisplay(MenuEstiloTabla) post $global_x $global_y
}

proc PDUnpostMenuIconosEstilo { } {
    set ret 0
    if { $::PostDisplay(MenuEstiloTabla,Post)} {
        if { $::PostDisplay(MenuEstiloTabla,After) != ""} {
            after cancel $::PostDisplay(MenuEstiloTabla,After)
            set ::PostDisplay(MenuEstiloTabla,After) ""
        }
        if { [ winfo exists $::PostDisplay(MenuEstiloTabla)] } {
            $::PostDisplay(MenuEstiloTabla) unpost
        }
        set ::PostDisplay(MenuEstiloTabla,Post) 0
        set ret 1
    }
    # devuelve si se ha apagado
    return $ret
}

proc FillPDListInfo { { recreate 1} {do_update 0}} {
    if { ![info exists ::GidPriv(PostDisplayWindowList)] || \
            ![winfo exists $::GidPriv(PostDisplayWindowList)] } { return }
    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl

    if { $::GidPriv(PostDisplayDoingAccept) } { return }

    if { $::PD_debug_table_update} {
        W "FillPDListInfo recreate=$recreate do_update=$do_update"
        foreach ent [ GidUtils::GetStackTrace] {
            W " ...$ent"
        }
    }
    
    # conseguimos la lista:
    set lista_cosas {}
    if { $::GidPriv(WinList_volumes) == 1 } {
        set lista_cosas [ concat $lista_cosas volumes]
    }
    if { $::GidPriv(WinList_surfaces) == 1} {
        set lista_cosas [ concat $lista_cosas surfaces]
    }
    if { $::GidPriv(WinList_cuts) == 1} {
        set lista_cosas [ concat $lista_cosas cuts]
    }

    if { !$do_update} {
        $tbl delete 0 end
        # W "$tbl delete 0 end"
    }

    # PostStatus calculates lots of things and takes some time
    # we need only the -brief information
    set ResumenMallas [ split [ GiD_Info list_entities PostStatus -brief] \n]

    set tbl_idx_col 0
    foreach i $lista_cosas {
        if { $recreate == 1} {
            set var [ GiD_Info postprocess get cur_${i}ets]
        }
        
        set SetNames [ GiD_Info postprocess get all_${i}ets]
        set colors [ GiD_Info postprocess get all_$i\_colors ]
                
        foreach name $SetNames k $colors {           
            #- ncol_set = { #ambient #diffuse #specular shininess }
            set ::GidPriv(PD$name,color) $k
        }

        if { [info exists ::GidPriv(SetsAlphabetic)] && $::GidPriv(SetsAlphabetic) } {
            set SetNames [lsort -dictionary $SetNames]
        }

        set sets_with_back [list]
        foreach name $SetNames {
            if { [GetIsBackSet $name] } {
                set front_name [GetFrontNameFromBackName $name]
                if { [lsearch $SetNames $front_name] != -1 } {
                    lappend sets_with_back $front_name
                }
            }
        }

        if { $do_update} {
            # may be the table is sorted by column, we need to update the indices used here.
            for { set idx 0 } { $idx < [ $tbl size] } { incr idx } {
                # set name [ lindex [ $tbl get $idx] 1]
                set name [ $tbl getcells ${idx},1]
                set ::GidPriv(PD$name,idx_col) $idx
            }
        }

        foreach name $SetNames {
            if { [GetIsBackSet $name] } {
                if { !$::PostDisplay(debug) } {
                    continue
                }
            }
            set entities_in_back 0
            if { [lsearch $sets_with_back $name] != -1} {
                set entities_in_back 1
            }
            set col_set $::GidPriv(PD$name,color)
            # col_set = { #ambient #diffuse #specular shininess }
            set cur_col [ lindex $col_set 1]
            set num_elementos [ BuscaQueHay $ResumenMallas $name]
            set elem_type_str [ lrange $num_elementos 1 [ llength $num_elementos]]
            set str_elementos [concat [lindex $num_elementos 0] [_ $elem_type_str]]
            set num_elementos [lindex $num_elementos 0]
            # $tbl insert end [ list "" $name "" "" "" "" "" "" "" \
                #         [::GidUtils::AddThousandsSeparator $str_elementos]]
            set my_col $tbl_idx_col
            incr tbl_idx_col
            if { !$do_update} {
                # W "tbl insert $my_col  - $name"
                $tbl insert end [ list " " $name "" "" "" "" "" "" "" $num_elementos $elem_type_str]
                set ::GidPriv(PD$name,idx_col) $my_col
                # W "    --> tbl size = [ $tbl size]"
                set my_col end
            } else {
                # W "get my_col - $name    ,   tbl size = [ $tbl size]"
                # update only the entry
                set my_col $::GidPriv(PD$name,idx_col)
            }
            $tbl cellconfigure ${my_col},0 -background $cur_col -text {} -selectbackground $cur_col
        
            if { $recreate == 1} {
                if { [lsearch $var $name] != -1 } {
                    set ::GidPriv(PD$name,OnOff) 1
                } else {
                    set ::GidPriv(PD$name,OnOff) 0
                }
            }
            if { ![ info exists ::GidPriv(PD$name,OnOff)]} {
                # some changes in the layers and current window has not been actualized
                # soo actualize it now !
                after 300 FillPDInfo
                if { $::PD_debug_table_update} {
                    W "    early return"
                }
                return
            }
            if { $::GidPriv(PD$name,OnOff) == 1} {
                $tbl cellconfigure ${my_col},2 -image [ gid_themes::GetImage layer_on.png small_icons]
            } else {
                $tbl cellconfigure ${my_col},2 -image [ gid_themes::GetImage layer_off.png small_icons]
            }        
            foreach property "transparent massive visualizeresults" {
                if { $recreate == 1} {
                    set current_value [string tolower [string index [GiD_Info postprocess get property $property $name] 0]]
                    if { $current_value == "y"} {
                        set ::GidPriv(PD$name,$property) 1
                    } else {
                        set ::GidPriv(PD$name,$property) 0
                    }
                }
                
            }
            if { $::GidPriv(PD$name,massive) == 1} {
                $tbl cellconfigure ${my_col},5 -image [ gid_themes::GetImage interior.png small_icons]
            } else {
                $tbl cellconfigure ${my_col},5 -image [ gid_themes::GetImage interior_no.png small_icons]
            }
            if { $::GidPriv(PD$name,transparent) == 1} {
                $tbl cellconfigure ${my_col},4 -image [ gid_themes::GetImage transparent_on.png small_icons]
            } else {
                $tbl cellconfigure ${my_col},4 -image [ gid_themes::GetImage transparent_off.png small_icons]
            }            
            $tbl cellconfigure ${my_col},3 -image [EscojeIconoEstilo [GiD_Info postprocess get property DisplayStyle $name]]
            if { $::GidPriv(PD$name,visualizeresults) == 1} {
                $tbl cellconfigure ${my_col},6 -image [ gid_themes::GetImage PostBarContourFill.png small_icons]
            } else {
                $tbl cellconfigure ${my_col},6 -image [ gid_themes::GetImage element.png small_icons]
            }
            $tbl cellconfigure ${my_col},7 -text [GiD_Info postprocess get property EdgeWidth $name]
            if { $entities_in_back } {
                $tbl cellconfigure ${my_col},8 -image [ gid_themes::GetImage bring_to_front.png small_icons]
            } else {
                $tbl cellconfigure ${my_col},8 -image [ gid_themes::GetImage blank.png small_icons] ;#void image
            }
        }
    }

    if { $::PD_debug_table_update} {
        W "FillPDListInfo done"
    }
}

proc PDListOn { { wboton ""}} {
    global PostDisplay

    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
        return error
    } else {
        foreach idx $setsel {
            set name [lindex [$tbl get $idx] 1]          
            set ::GidPriv(PD$name,OnOff) 1
        }
        # FillPDListInfo will be called in PDAcceptOnOff
        # FillPDListInfo 0
        
        # foreach idx $setsel {
        #     $tbl selection set $idx
        #     $tbl see $idx
        # }
    }

    PDAcceptOnOff

    after idle ReseleccionaTabla $tbl [ list $setsel]

    # foreach idx $setsel {
    #         $tbl selection set $idx
    #         $tbl see $idx
    # }

    if { $wboton != ""} {
        $wboton configure -image [ gid_themes::GetImage layer_on.png medium_icons]
    }
}

proc PDCambiaAnchoArista { } {
    global PostDisplay

    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
        return error
    } else {
        set oldAutomaticRedraw [ GiD_Set AutomaticRedraw]
        GiD_Set AutomaticRedraw -1
        # to avoid window updates through FillPDInfo
        set ::GidPriv(PostDisplayDoingAccept) 1
        if { [ llength $setsel] == 1} {
            set name [ lindex [$tbl get $setsel] 1]           
            set lwm [ GiD_Info postprocess get property EdgeWidth $name]
            # MessageBoxEntry { title question type default_answer button_assign image {fill_extra_frame_proc ""} {parent .gid}}
            set parent $::GidPriv(PostDisplayWindow)
            set new_width [ MessageBoxEntry [_ "Changing edge width"] [ format [_ "Enter edge width for '%s': (pixels)"] $name] \
                                real+ $lwm 0 question.png "" $parent]
            if { $new_width != ""} {
                set type [GetSetTypeName $name]
                GiD_Process escape escape escape escape Utilities ChangeProperty $type $name EdgeWidth $new_width
            }
        } else {
            set lwm 0.0
            foreach idx $setsel {
                set name [ lindex [$tbl get $idx] 1]
                set lw_s [ GiD_Info postprocess get property EdgeWidth $name]
                set lwm [ expr $lwm + $lw_s]
            }
            set lwm [ expr $lwm / [ llength $setsel]]
            # MessageBoxEntry { title question type default_answer button_assign image {fill_extra_frame_proc ""} {parent .gid}}
            set parent $::GidPriv(PostDisplayWindow)
            set new_width [ MessageBoxEntry [_ "Changing edge width"] [_ "Enter edge width for the selected sets: (pixels)"] \
                            real+ $lwm 0 question.png "" $parent]
            if { $new_width != ""} {
                foreach idx $setsel {
                    set name [lindex [$tbl get $idx] 1]
                    set type [GetSetTypeName $name]                    
                    GiD_Process escape escape escape escape Utilities ChangeProperty $type $name EdgeWidth $new_width                                   
                }
            }
        }
        GiD_Set AutomaticRedraw $oldAutomaticRedraw
        GiD_Redraw
        set ::GidPriv(PostDisplayDoingAccept) 0
        set recreate 0
        set do_update 1
        FillPDListInfo $recreate $do_update
    }

    after idle ReseleccionaTabla $tbl [ list $setsel]

}

proc PDListPropiedad { property { wboton ""}} {
    global PostDisplay
    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
        return error
    } else {
        foreach idx $setsel {
            set name [ lindex [$tbl get $idx] 1]           
            set ::GidPriv(PD$name,$property) 1         
        }   
    }

    PDAcceptPropiedad $property
    after idle ReseleccionaTabla $tbl [ list $setsel]

    if { $wboton != ""} {
        $wboton configure -image [ gid_themes::GetImage layer_on.png medium_icons]
    }

    if { $property == "transparent"} {
        PDChangeTransparentToWogl yes
    }

}

proc PDChangeColor { } {

    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
    } else {
        if { [ llength $setsel] == 1} {
            set name [lindex [$tbl get $setsel] 1]
            set type [GetSetTypeName $name]                
            GiD_Process escape escape escape escape Utilities ChangeColor $type $name $::GidPriv(PostDisplayColorComponent)
            GiD_Redraw            
        } else {
            # Ambient Diffuse Specular Shininess Default
            switch "$::GidPriv(PostDisplayColorComponent)" {
                "Ambient" {
                    set res [ tk_chooseColor -title [_ "Change ambient color for %s" $setsel ]]
                }
                "Diffuse" {
                    set res [ tk_chooseColor -title [_ "Change diffuse color for %s" $setsel]]
                }
                "Specular" {
                    set res [ tk_chooseColor -title [_ "Change specular color for %s" $setsel]]
                }
                "Shininess" {
                    # MessageBoxEntry { title question type default_answer button_assign image {fill_extra_frame_proc ""} {parent .gid}}
                    set parent $::GidPriv(PostDisplayWindow)
                    set res [MessageBoxEntry [_ "Change Shininess for %s" $setsel ] [_ "Enter shininess value( 0.0 - 1.0)"]: real+ 0.0 0 question.png "" $parent]
                }
                "Default" {
                    set res Default
                }
            }
            if { $res != ""} {
                foreach idx $setsel {
                    set name [lindex [$tbl get $idx] 1]
                    set type [GetSetTypeName $name]                    
                    GiD_Process escape escape escape escape Utilities ChangeColor $type $name $::GidPriv(PostDisplayColorComponent) $res
                }
                GiD_Redraw              
            }
                
        }
        #FillPDListInfo 0
        # foreach idx $setsel {
        #     $tbl selection set $idx
        #     $tbl see $idx
        # }
        after idle ReseleccionaTabla $tbl [ list $setsel]
    }
}

proc PDChangeName { } {
    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
    } else {
        if { [ llength $setsel] == 1} {
            set old_name [lindex [$tbl get $setsel] 1]
            set type [GetSetTypeName $old_name]
            set new_name [ PDDialogGetSetName [_ "Enter new name"]: $old_name]
            if { $new_name != ""} {
                set old_state [ GiD_Project set disable_windows]
                # avoid call from 'GiD_Process ... ChangeName' to FillPDInfo, which will rebuild the table
                # and edit only the cell contents
                GiD_Project set disable_windows 1
                GiD_Process escape escape escape escape Utilities ChangeName $type $old_name $new_name escape escape escape escape
                GiD_Project set disable_windows $old_state
                set tbl_idx $::GidPriv(PD$old_name,idx_col)
                $tbl cellconfigure ${tbl_idx},1 -text $new_name
                set ::GidPriv(PD$new_name,idx_col) $tbl_idx
            } else {
                return
            }
        } else {
            WarnWin [_ "Please select only one Volume/Surface/Cut."]
        }
        #FillPDListInfo 0
        # foreach idx $setsel {
        #     $tbl selection set $idx
        #     $tbl see $idx
        # }
        after idle ReseleccionaTabla $tbl [ list $setsel]
    }
}

proc PDListOff { { wboton ""}} {
    global PostDisplay

    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]

    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
        return error
    } else {
        foreach idx $setsel {
            set name [lindex [$tbl get $idx] 1] 
            set ::GidPriv(PD$name,OnOff) 0
        }
        # FillPDListInfo will be called in PDAcceptOnOff
        # FillPDListInfo 0
        # foreach idx $setsel {
        #     $tbl selection set $idx
        #     $tbl see $idx
        # }
    }

    PDAcceptOnOff

    after idle ReseleccionaTabla $tbl [ list $setsel]

    # foreach idx $setsel {
    #         $tbl selection set $idx
    #         $tbl see $idx
    # }

    if { $wboton != ""} {
        $wboton configure -image [ gid_themes::GetImage layer_off.png medium_icons]
    }
}

proc PDListPropiedadNo { property { wboton ""}} {
    global PostDisplay
    set w $::GidPriv(PostDisplayWindowList)
    set tbl $w.list.f2.tbl
    if { [ $tbl size] == 1} {
        $tbl selection set 0
    }
    set setsel [$tbl curselection]
    if { $setsel == {} } {
        WarnWin [_ "Sorry, no set selected."]
        return error
    } else {
        foreach idx $setsel {
            set name [lindex [$tbl get $idx] 1]
            set ::GidPriv(PD$name,$property) 0
        }  
    }

    PDAcceptPropiedad $property

    after idle ReseleccionaTabla $tbl [ list $setsel]
  
    if { $wboton != ""} {
        $wboton configure -image [ gid_themes::GetImage layer_off.png medium_icons]
    }

    if { $property == "transparent"} {
        PDChangeTransparentToWogl no
    }
}

proc PDListAll {} {
    set w $::GidPriv(PostDisplayWindowList)

    $w.list.f2.tbl selection set 0 end
}

proc PDListNone {} {
    set w $::GidPriv(PostDisplayWindowList)

    $w.list.f2.tbl selection clear 0 end
}

proc RenameSet { x y w tbl} {
    set tablelist::x [expr {$x + [winfo x $w]}]
    set tablelist::y [expr {$y + [winfo y $w]}]
    set cell [$tbl nearestcell $tablelist::x $tablelist::y]
    foreach {row col} [ split $cell ,] break
    $tbl selection set $row
    $tbl see $row

    PDChangeName
}

proc ClickTableListSets { x y w tbl global_x global_y} {
    focus $w
    set cell [$tbl containingcell $x $y]
    foreach {row col} [ split $cell ,] break

    if { $row < 0 || $col < 0 } return

    #if click a unselected row then select only this row (but not if column == 1)
    if { $col != 1 } {
        if { ![$tbl selection includes $row] } {
            $tbl selection clear 0 end
            $tbl selection set $row
            $tbl see $row
        }
    }
    set apagado [PDUnpostMenuIconosEstilo]
    if { $col == 0 } {
        PDColorWindow $::GidPriv(PostDisplayWindowList)
    } elseif { $col == 1 } {
        #PDChangeName
    } elseif { $col == 2 } { # on/off
        if { [lindex [$tbl cellconfigure $row,$col -image] 4] == [ gid_themes::GetImage layer_off.png small_icons] } {
            PDListOn
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage layer_on.png small_icons]
        } else {
            PDListOff
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage layer_off.png small_icons]
        }
    } elseif { $col == 3 } { # estilo        
        if { !$apagado} {
            PDPostMenuIconosEstilo $global_x $global_y
        }
    } elseif { $col == 4 } { # transparencia
        if { [lindex [$tbl cellconfigure $row,$col -image] 4] == [ gid_themes::GetImage transparent_off.png small_icons] } {
            PDListPropiedad transparent
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage transparent_off.png small_icons]
        } else {
            PDListPropiedadNo transparent
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage transparent_on.png small_icons]
        }
    } elseif { $col == 5 } { # interior
        if { [lindex [$tbl cellconfigure $row,$col -image] 4] == [ gid_themes::GetImage interior_no.png small_icons] } {
            PDListPropiedad massive
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage interior_no.png small_icons]
        } else {
            PDListPropiedadNo massive
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage interior.png small_icons]
        }
    } elseif { $col == 6} { # visualize results
        if { [lindex [$tbl cellconfigure $row,$col -image] 4] == [ gid_themes::GetImage element.png small_icons] } {
            PDListPropiedad visualizeresults
        } else {
            PDListPropiedadNo visualizeresults
        }
    } elseif { $col == 7} { # edge width
        PDCambiaAnchoArista
    } elseif { $col == 8 } { # back
        if { [lindex [$tbl cellconfigure $row,$col -image] 4] == [ gid_themes::GetImage bring_to_front.png small_icons] } {
            PDSendToBack $::GidPriv(PostDisplayWindowList).but ToFront
        }
    }

    if { $col != 1 } {
        return -code break
    }
}

proc DoubleClickTableListSets { x y w tbl } {
    set cell [$tbl containingcell $x $y]
    foreach {row col} [ split $cell ,] break

    if { $row < 0 || $col < 0 } return

    $tbl selection set $row
    $tbl see $row
    if { $col == 1 } {
        #PDChangeName
        if { [lindex [$tbl cellconfigure $row,2 -image] 4] == [ gid_themes::GetImage layer_off.png small_icons] } {
            PDListOn
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage layer_on.png small_icons]
        } else {
            PDListOff
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage layer_off.png small_icons]
        }
    }
}

proc InvertSelectionTableListSets { tbl } {
    set newselection {}
    for { set i 0 } { $i < [$tbl size] } { incr i } {
        if { ![$tbl selection includes $i] } {
            lappend newselection $i
        }
    }
    $tbl selection clear 0 end
    foreach i $newselection {
        $tbl selection set $i
    }
}

proc PDSetsCompare { a b} {
    set type string
    if { [ string is double $a] && [ string is double $b]} {
        set type double
        if { $a == ""} {
            set a 0
        }
        if { $b == ""} {
            set b 0
        }
        set result [ expr $a - $b]
        set ret_value 0
        if { $result < 0} {
            set ret_value -1
        } elseif { $result > 0} {
            set ret_value 1
        }
    } else {
        set ret_value [ string compare $a $b]
    }
    W "PDSetsCompare -$a- -$b- -$type- = $ret_value"
    return $ret_value
}

proc PDSetsCreateListWin { w } {
    package require tablelist_tile

    set vsb $w.vsb1
    set hsb $w.hsb1
    set tbl [ tablelist::tablelist $w.tbl \
                  -exportselection 0 \
                  -columns [list \
                                0 [_ "C#C#Color"] left \
                                6 [_ "Name"] left \
                                0 [_ "I/O#C#On/Off"] left \
                                0 [_ "St#C#Style"] left \
                                0 [_ "Tr#C#transparent"] left \
                                0 [_ "Int#C#interior"] left \
                                0 [_ "Res#C#VisualizeResults"] left \
                                3 [_ "Ew#C#Edge width"] left \
                                2 [_ "b#C#back"] left \
                                5 [_ "N#C#NumberOfElements"] right \
                                5 [_ "Type#C#TypeOfElements"] left \
                               ] \
                  -stretch {1 10}\
                  -selectmode extended \
                  -labelborderwidth 1 \
                  -labelcommand tablelist::sortByColumn \
                  -showarrow 1 \
                  -showseparators 0 \
                  -xscrollcommand [list $hsb set] \
                  -yscrollcommand [list $vsb set] \
                  -resizablecolumns 1 \
                  -stripebackground [ CCColorSombra $::GidPriv(Color,BackgroundListbox)] \
                  ]                 

    $tbl columnconfigure 7 -sortmode integer
    # $tbl columnconfigure 9 -sortmode command -sortcommandPDSetsCompare
    $tbl columnconfigure 9 -sortmode integer

    ttk::scrollbar $vsb -orient vertical   -command [list $tbl yview]
    ttk::scrollbar $hsb -orient horizontal -command [list $tbl xview]

    #bind [$tbl bodypath] <Button-1> "ClickTableListSets %x %y %W $tbl"
    bind [$tbl bodytag] <Button-1> "\
            foreach {tablelist::W tablelist::x tablelist::y} \
            \[tablelist::convEventFields %W %x %y] {}
    ClickTableListSets \$tablelist::x \$tablelist::y %W $tbl %X %Y"

    #bind [$tbl bodypath] <Double-Button-1> "DoubleClickTableListSets %x %y %W $tbl"
    bind [$tbl bodytag] <Double-Button-1> "\
            foreach {tablelist::W tablelist::x tablelist::y} \
            \[tablelist::convEventFields %W %x %y] {}
    DoubleClickTableListSets \$tablelist::x \$tablelist::y %W $tbl"


    bind [$tbl bodytag] <Key-Delete> PDDeleteCosas

    # bind [$tbl bodypath] <Alt_L> [list InvertSelectionTableListSets $tbl]
    # bind [$tbl bodypath] <Alt_R> [list InvertSelectionTableListSets $tbl]
    # bind [$tbl bodypath] <Meta_L> [list InvertSelectionTableListSets $tbl]
    # bind [$tbl bodypath] <Meta_R> [list InvertSelectionTableListSets $tbl]

    bind [$tbl bodypath] <F2> "RenameSet %x %y %W $tbl"

    grid $tbl $vsb -sticky nsew
    grid configure $vsb -sticky ns
    grid $hsb -sticky ew
    grid remove $vsb $hsb
    bind $tbl <Configure> [list ConfigureListScrollbars $tbl $hsb $vsb]

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
}




#########################################
# Mesh groups
#########################################

proc MeshGroupTBLFill { } {
    if { ![ info exists ::GidPriv(MeshGroupTBL)] || ![ winfo exists $::GidPriv(MeshGroupTBL)] } { return }
    set tbl $::GidPriv(MeshGroupTBL)

    set all_mg [ GiD_Info postprocess get MeshGroupList all]
    set cur_mg [ GiD_Info postprocess get MeshGroupList current]

    set col_nombres [ $tbl getcolumns 1]
    set de_nuevo 1
    if { [ llength $col_nombres] == [ llength $all_mg]} {
        set n [ llength $col_nombres]
        set ult_idx 0
        for { set i 0} { $i < $n} { incr i} {
            set j [ lindex $all_mg $i]
            regsub -all {_} $j { } txt
            if { ![ string eq [ lindex $col_nombres $i] $txt] } {
                set de_nuevo 1
                break;
            } else {
                if { [lsearch $cur_mg $j] != -1 } {
                    set ::GidPriv(MG$j,OnOff) 1
                } else {
                    set ::GidPriv(MG$j,OnOff) 0
                }
                if { $::GidPriv(MG$j,OnOff) == 1} {
                    $tbl cellconfigure $i,0 -image [ gid_themes::GetImage layer_on.png small_icons]
                    set ult_idx $i
                } else {
                    $tbl cellconfigure $i,0 -image [ gid_themes::GetImage layer_off.png small_icons]
                }
                set de_nuevo 0
            }
        }
        $tbl see ${ult_idx}
    }

    if { $de_nuevo} {
        $tbl delete 0 end
        
        set row 0
        set ult_idx 0
        foreach j $all_mg {
            regsub -all {_} $j { } txt
        
            $tbl insert end [list "" $txt]
            if { [lsearch $cur_mg $j] != -1 } {
                set ::GidPriv(MG$j,OnOff) 1
            } else {
                set ::GidPriv(MG$j,OnOff) 0
            }
            if { $::GidPriv(MG$j,OnOff) == 1} {
                $tbl cellconfigure end,0 -image [ gid_themes::GetImage layer_on.png small_icons]
                set ult_idx $row
            } else {
                $tbl cellconfigure end,0 -image [ gid_themes::GetImage layer_off.png small_icons]
            }
            incr row
        }
        $tbl see ${ult_idx}
    }
}

proc MeshGroupTBLClick { x y w tbl } {
    #de momento nada
    return

    focus $w
    set cell [$tbl containingcell $x $y]
    foreach {row col} [ split $cell ,] break

    if { $row < 0 || $col < 0 } return

    #if click a unselected row then select only this row (but not if column == 1)
    if { $col != 1 } {
        if { ![$tbl selection includes $row] } {
            $tbl selection clear 0 end
            $tbl selection set $row
            $tbl see $row
        }
    }

    if { $col == 0 } {
        if { [lindex [$tbl cellconfigure $row,$col -image] 4] == [ gid_themes::GetImage layer_off.png small_icons] } {
            #PDListOn
            $tbl cellconfigure $row,$col -image [ gid_themes::GetImage layer_on.png small_icons]
        } else {
            #PDListOff
            $tbl cellconfigure $row,$col -image [ gid_themes::GetImage layer_off.png small_icons]
        }
    } elseif { $col == 1 } {
        #PDChangeName
    }

    if { $col != 1 } {
        return -code break
    }
}

proc MeshGroupTBLDoubleClick { x y w tbl } {
    #de momento nada
    return

    set cell [$tbl containingcell $x $y]
    foreach {row col} [ split $cell ,] break

    if { $row < 0 || $col < 0 } return

    $tbl selection set $row
    $tbl see $row
    if { $col == 1 } {
        #PDChangeName
        if { [lindex [$tbl cellconfigure $row,2 -image] 4] == [ gid_themes::GetImage layer_off.png small_icons] } {
            PDListOn
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage layer_on.png small_icons]
        } else {
            PDListOff
            #$tbl cellconfigure $row,$col -image [ gid_themes::GetImage layer_off.png small_icons]
        }
    }
}

proc MeshGroupTBLInvertSelection { tbl } {
    set newselection {}
    for { set i 0 } { $i < [$tbl size] } { incr i } {
        if { ![$tbl selection includes $i] } {
            lappend newselection $i
        }
    }
    $tbl selection clear 0 end
    foreach i $newselection {
        $tbl selection set $i
    }
}

proc PDCreateMeshGroupTBL { w } {
    package require tablelist_tile

    set vsb $w.vsb1
    set hsb $w.hsb1
    set tbl [tablelist::tablelist $w.tbl \
            -exportselection 0 \
            -columns [list \
                0 "" left \
                16 [_ "Mesh group"] left
                ] \
            -stretch 1 \
            -selectmode extended \
            -labelborderwidth 1 \
            -labelcommand tablelist::sortByColumn \
            -showarrow 0 \
            -showseparators 0 \
            -xscrollcommand [list $hsb set] \
            -yscrollcommand [list $vsb set] \
            -resizablecolumns 0]           

    #$tbl columnconfigure 2 -selectbackground $::GidPriv(Color,BackgroundListbox) -selectforeground black

    ttk::scrollbar $vsb -orient vertical   -command [list $tbl yview]
    ttk::scrollbar $hsb -orient horizontal -command [list $tbl xview]

    bind [$tbl bodytag] <Button-1> "\
            foreach {tablelist::W tablelist::x tablelist::y} \
            \[tablelist::convEventFields %W %x %y] {}
    MeshGroupTBLClick \$tablelist::x \$tablelist::y %W $tbl"

    bind [$tbl bodytag] <Double-Button-1> "\
            foreach {tablelist::W tablelist::x tablelist::y} \
            \[tablelist::convEventFields %W %x %y] {}
    MeshGroupTBLDoubleClick \$tablelist::x \$tablelist::y %W $tbl"

    bind [$tbl bodypath] <Alt_L> [list MeshGroupTBLInvertSelection $tbl]
    bind [$tbl bodypath] <Alt_R> [list MeshGroupTBLInvertSelection $tbl]
    bind [$tbl bodypath] <Meta_L> [list MeshGroupTBLInvertSelection $tbl]
    bind [$tbl bodypath] <Meta_R> [list MeshGroupTBLInvertSelection $tbl]

    grid $tbl $vsb -sticky nsew
    grid configure $vsb -sticky ns
    grid $hsb -sticky ew
    grid remove $vsb $hsb
    bind $tbl <Configure> [list ConfigureListScrollbars $tbl $hsb $vsb]

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
}

proc PDLISTMeshGroupsClose { w} {
    destroy $w
}

proc PDListMeshGroups { { parent .gid}} {
    set w $parent.mglw
    InitWindow2 $w -title [_ "Mesh groups list"] \
        -geometryvariable PostMeshGroupListWindowGeom \
        -initcommand PDListMeshGroups -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    #set def_back [ $w cget -background]

    set f [ ttk::frame $w.top -borderwidth 0]
    set ft [ ttk::frame $f.ftest -borderwidth 2 -style flat.TFrame]

    PDCreateMeshGroupTBL $ft
    set ::GidPriv(MeshGroupTBL) $ft.tbl

    grid $f.ftest -sticky news
    grid columnconfigure $f 0 -weight 1
    grid rowconfigure $f 0 -weight 1

    ttk::frame $w.but -style BottomFrame.TFrame
    ttk::button $w.but.close -text [_ "Close"] -command "PDLISTMeshGroupsClose $w" \
    -style BottomFrame.TButton

    grid $w.but.close -sticky ews -padx 5 -pady 6

    grid $w.top -sticky news
    grid $w.but -sticky ews
    grid anchor $w.but center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1


    MeshGroupTBLFill
}

proc PDCreateListWin { { w .gid.wPostDisplayListWin }} {
    global PostDisplay GIDDEFAULT

    set ::GidPriv(PostDisplayWindowList) $w

    if { ![ info exists ::GidPriv(WinList_volumes) ] } {
        set ::GidPriv(WinList_volumes) 1
    }
    if { ![ info exists ::GidPriv(WinList_surfaces) ] } {
        set ::GidPriv(WinList_surfaces) 1
    }
    if { ![ info exists ::GidPriv(WinList_cuts) ] } {
        set ::GidPriv(WinList_cuts) 1
    }

    #wm minsize [ winfo toplevel $w] 250 400

    ttk::frame $w.list -style ridge.TFrame -borderwidth 1
    ttk::frame $w.list.f1 -style sunken.TFrame -borderwidth 1   
    set list_cbs []
    if { !$::GidPriv(HideVolumeLevel) } {
        if { ![info exists ::GidPriv(WinList_volumes)] } { set ::GidPriv(WinList_volumes) 0 }
        ttk::checkbutton $w.list.f1.cb1 -text [_ "Volumes"] -variable ::GidPriv(WinList_volumes) \
            -command "FillPDListInfo 1"
        lappend list_cbs $w.list.f1.cb1        
    }    
    if { !$::GidPriv(HideSurfaceLevel) } {
        if { ![info exists ::GidPriv(WinList_surfaces)] } { set ::GidPriv(WinList_surfaces) 0 }
        ttk::checkbutton $w.list.f1.cb2 -text [_ "Surfaces"] -variable ::GidPriv(WinList_surfaces) \
            -command "FillPDListInfo 1"
        lappend list_cbs $w.list.f1.cb2
    }
    if { !$::GidPriv(HideVolumeLevel) && !$::GidPriv(HideSurfaceLevel)} {
        if { ![info exists ::GidPriv(WinList_cuts)] } { set ::GidPriv(WinList_cuts) 0 }
        ttk::checkbutton $w.list.f1.cb3 -text [_ "Cuts"] -variable ::GidPriv(WinList_cuts) \
            -command "FillPDListInfo 1"
        lappend list_cbs $w.list.f1.cb3
    }
    if { ![info exists ::GidPriv(SetsAlphabetic)] } { set ::GidPriv(SetsAlphabetic) 0 }
    ttk::checkbutton $w.list.f1.sort -text [_ "alphabetic order"] -variable ::GidPriv(SetsAlphabetic) \
        -command FillPDListInfo
    GidHelp "$w.list.f1.sort"  [_ "Sort the list of sets by name."]    
    
    if { [llength $list_cbs] } {
        grid {*}$list_cbs -sticky we -padx 5 -pady 5
    }
    
    grid $w.list.f1.sort -columnspan 3 -sticky w -padx 5

    ttk::frame $w.list.f2 -style sunken.TFrame -borderwidth 1

    PDSetsCreateListWin $w.list.f2

    GidHelp $w.list.f2 [_ "Properties of the listed sets showing:\n\
            Color\n\
            Name\n\
            On/Off\n\
            Style\n\
            Interior elements drawn/not drawn\n\
            Transparent/Opaque\n\
            Edge width\n\
            Visualize results\n\
            Exists background hidden elements\n\
            number of elements\n\
            type of elements."]

    grid $w.list.f1 -row 0 -column 0 -sticky we
    grid $w.list.f2 -row 1 -column 0 -sticky wens
    grid columnconfigure $w.list 0 -weight 1
    grid rowconfigure $w.list 1 -weight 1


    ttk::frame $w.but


    ttk::frame $w.but.but3        
    ttk::button $w.but.but3.cw -text [_ "Color"]... -command "PDColorWindow $w.but.but3.cw" \
        -image [ gid_themes::GetImage color.png medium_icons] -style Toolbutton -takefocus 0       
    
    ttk::menubutton $w.but.but3.ds -text [_ "Style"]... -menu $w.but.but3.ds.m -image [ gid_themes::GetImage alllines.png medium_icons] \
        -style Toolbutton -takefocus 0        
    
    #set menu_estilo [ PDMenuEstilo $w.but.but3.ds [ CCColorSombra $def_back]]
    set menu_estilo [ PDMenuEstilo $w.but.but3.ds [ttk::style lookup $ttk::currentTheme -background]]
    $w.but.but3.ds configure -menu $menu_estilo
    
    # aprovechamos y construimos aqui el menu estilo de la tabla:
    PDMenuIconosEstilo $w.list.f2 [ CCColorSombra [ttk::style lookup $ttk::currentTheme -background]]
    
    if { $::GidPriv(EnableMeshGroupWindow)} {                    
        ttk::button $w.but.but3.mglw -text [_ "Mesh groups list"]... -command "PDListMeshGroups $w" -style Toolbutton -takefocus 0
        $w.but.but3.mglw configure -image [ gid_themes::GetImage PointList.png medium_icons]
    }
    
    
    ttk::button $w.but.but3.edgeWidth -text [_ "Edge width"]... -command PDCambiaAnchoArista -style Toolbutton
    $w.but.but3.edgeWidth configure -image [ gid_themes::GetImage edgewidth.png medium_icons] -takefocus 0

    ttk::button $w.but.but3.listEntities -text [_ "List set entities"]... -command [list Sets::ListEntitiesSelection $w.list.f2.tbl] -style Toolbutton
    $w.but.but3.listEntities configure -image [ gid_themes::GetImage list.png medium_icons] -takefocus 0

    
    ttk::button $w.but.but3.bnombre -text [_ "Rename"] -command PDChangeName -takefocus 0
    ttk::button $w.but.but3.del -text [_ "Delete"] -command PDDeleteCosas -takefocus 0
    
    ttk::button $w.but.but3.on -text [_ "On"] -command PDListOn -style Toolbutton
    $w.but.but3.on configure -image [ gid_themes::GetImage layer_on.png medium_icons] -takefocus 0
    ttk::button $w.but.but3.off -text [_ "Off"] -command PDListOff -style Toolbutton
    $w.but.but3.off configure -image [ gid_themes::GetImage layer_off.png medium_icons] -takefocus 0
    
    ttk::button $w.but.but3.interior -text [_ "Draw interiors"] -command "PDListPropiedad massive" -style Toolbutton
    $w.but.but3.interior configure -image [ gid_themes::GetImage interior.png medium_icons] -takefocus 0
    ttk::button $w.but.but3.hollow -text [_ "Hollow bodies"] -command "PDListPropiedadNo massive" -style Toolbutton
    $w.but.but3.hollow configure -image [ gid_themes::GetImage interior_no.png medium_icons] -takefocus 0
    
    ttk::button $w.but.but3.transp -text [_ "Transparent"] -command "PDListPropiedad transparent" -style Toolbutton 
    $w.but.but3.transp configure -image [ gid_themes::GetImage transparent_on.png medium_icons] -takefocus 0
    ttk::button $w.but.but3.opaco -text [_ "Opaque"] -command "PDListPropiedadNo transparent" -style Toolbutton 
    $w.but.but3.opaco configure -image [ gid_themes::GetImage transparent_off.png medium_icons] 
    
    GidHelp $w.but.but3.on [_ "Turns on the selected sets"].
    GidHelp $w.but.but3.off [_ "Turns off the selected sets"].
    GidHelp $w.but.but3.interior [_ "Draws the interior elements and vectors of sets"].
    GidHelp $w.but.but3.hollow [_ "Does not drawn interior vectors of the selected sets and elements of volume sets"].
    GidHelp $w.but.but3.transp [_ "Turns the selected sets transparent"].
    GidHelp $w.but.but3.opaco [_ "Turns the selected sets opaque"].
    GidHelp $w.but.but3.edgeWidth [_ "Define the width of the edges for the selected sets"].
    GidHelp $w.but.but3.listEntities [_ "List the entities for the selected sets"].
    
    
    grid $w.but.but3.cw $w.but.but3.on $w.but.but3.interior $w.but.but3.transp $w.but.but3.edgeWidth $w.but.but3.bnombre \
        -padx 1 -ipadx 0 -pady 0 -sticky w
    grid configure $w.but.but3.bnombre -padx 5 -sticky e
    
    if { $::GidPriv(EnableMeshGroupWindow)} {
        grid $w.but.but3.ds $w.but.but3.off $w.but.but3.hollow $w.but.but3.opaco $w.but.but3.mglw $w.but.but3.listEntities -padx 1 -ipadx 0 -pady 0 -sticky w
    } else {
        grid $w.but.but3.ds $w.but.but3.off $w.but.but3.hollow $w.but.but3.opaco $w.but.but3.listEntities -padx 1 -ipadx 0 -pady 0 -sticky w
    }
    grid $w.but.but3.del -column 5 -row 1 -padx 5 -ipadx 0 -pady 0 -sticky e
    
    grid $w.but.but3 -sticky ew -padx 0 -ipadx 0 -pady 2    
    
    grid columnconfigure $w.but 0 -weight 1


    grid $w.list -sticky wens
    grid $w.but -sticky we
    grid anchor $w.but center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    # will be done outside, in above's PostDisplayCreateTopFrame
    # FillPDListInfo

     bind [$w.list.f2.tbl bodytag] <Button-$::gid_right_button> "[list Sets::ContextualMenu %W %x %y] ; break"

#     bind [$w.list.f2.tbl bodytag] <Button-$::gid_right_button> {
#         lassign [tablelist::convEventFields %W %x %y] tablelist::tbl tablelist::x tablelist::y            
#         Sets::ContextualMenu $tablelist::tbl $tablelist::x $tablelist::y
#     }

    set column_items {color name visibility style transparency interior edges back num_elements type_elements}
    TableListSelectColumnsVisibility $w.list.f2.tbl Sets $column_items    
}

proc PostDisplayChangeInsideOutside { w { where UNKNOWN}} {
    if { [winfo class $w] == "Toplevel"} {
    } else {
    }

    # set txt Inside
    if { $where == "UNKNOWN"} {        
        if { [info exists ::GidPriv(PostDisplayLocation)] && $::GidPriv(PostDisplayLocation) == "OUTSIDE"} {
            # set txt Outside
            set ::GidPriv(PostDisplayLocation) RIGHT
        } else {
            set ::GidPriv(PostDisplayLocation) OUTSIDE
        }
    } else {
        set ::GidPriv(PostDisplayLocation) $where
    }

    if { $::GidPriv(PostDisplayLocation) == "OUTSIDE"} {
        CloseInsideMainWindow $w
        PostDisplay $w $::GidPriv(PostDisplayLocation)
    } else {
        destroy $w
        PostDisplay $w $::GidPriv(PostDisplayLocation)
    }
    # $w.but.inout configure -text $txt
}

proc PostDisplayClose { w} {
    if { [info exists ::GidPriv(PostDisplayLocation)] && $::GidPriv(PostDisplayLocation) == "OUTSIDE"} {        
        destroy $w        
    } else {
        CloseInsideMainWindow $w
    }
}

proc PostDisplayCreateTopFrame { w } {

    ttk::frame $w -style flat.TFrame

    ttk::frame $w.sel -style ridge.TFrame -borderwidth 2
    ttk::frame $w.dis -style ridge.TFrame -borderwidth 2

    PDCreateListWin $w.sel

    # postprocess global settings frame

    set fpost [ ttk::labelframe $w.dis.fpost -text [_ "Global settings"]]
    ttk::label $fpost.l -text [_ "Style"]:

    # Translation trick, not remove this comment to found this words with ramtranslator
    # [_ "Boundaries"] 
    # [_ "Hidden Bound"]
    # [_ "All Lines"]
    # [_ "Hidden Lines"]
    # [_ "Body"]
    # [_ "Body Bound"]
    # [_ "Body Lines"]
    # [_ "Points"]
    # [_ "Points Bound"]
    # [_ "Any"]
    
    set values {}
    set labels {}
    set images {}
    set all_display_styles [GiD_Info postprocess get all_display_styles]
    # add an extra item "Any"
    lappend all_display_styles Any
    foreach dso $all_display_styles {
        lappend values $dso
        regsub -all {_} $dso { } label
        lappend labels [_ $label]
        lappend images [EscojeIconoEstilo $dso]
    }    
    
    TTKMenubutton $fpost.om -labels $labels -values $values\
            -textvariable ::GidPriv(PostDisplayDS) \
            -modifycmd PDAcceptStyle -images $images
    
    set i 0

    ttk::label $fpost.l2 -text [_ "Render"]:

    ttk::frame $fpost.fr -borderwidth 0

    # Translation trick, not remove this comment to found this words with ramtranslator
    # [_ "Normal#C#render"]
    # [_ "Flat#C#render"]
    # [_ "Smooth#C#render"]    
    set values [GiD_Info postprocess get all_display_renders]
    set labels {}
    foreach item $values {
        lappend labels [_ ${item}\#C\#render]
    }
    TTKMenubutton $fpost.fr.om2 -labels $labels -values $values \
            -textvariable ::GidPriv(PostDisplayRender) \
            -modifycmd PDAcceptStyle

    ttk::button $fpost.fr.b -image [ gid_themes::GetImage lightpos.png medium_icons] \
            -command {GiD_Process View Render ChangeLightVec }

    grid $fpost.fr.om2 $fpost.fr.b -padx 0 -pady 0

    ttk::label $fpost.l3 -text [_ "Culling"]:
 
    set values [GiD_Info postprocess get all_display_culling]
    set labels {}
    set images {}    
    foreach ct $values {
        if { $ct == "FrontFaces" } {
            lappend labels [_ "Front Faces"]
        } elseif { $ct == "BackFaces" } {
            lappend labels [_ "Back Faces"]
        } elseif { $ct == "None" } {
            lappend labels [_ "No#C#Nothing, None"]
        } else {
            #unexpected
            lappend labels [_ $ct]
        }
        lappend images [ gid_themes::GetImage cull[ string tolower $ct].png medium_icons]
    }
    TTKMenubutton $fpost.om3 -labels $labels -values $values \
        -textvariable ::GidPriv(PostDisplayCulling) \
        -modifycmd PDAcceptStyle -images $images

    grid $fpost.l $fpost.om -pady 0 -padx 1 -sticky e
    grid configure $fpost.om -sticky w
    grid $fpost.l2 $fpost.fr -pady 0 -padx 1 -sticky e
    grid configure $fpost.fr -sticky w

    grid $fpost.l3 $fpost.om3 -pady 0 -padx 1 -sticky e
    grid configure $fpost.om3 -sticky w

    # Preprocess info frame

    set fpre [ ttk::labelframe $w.dis.fpre -text [_ "Preprocess information"]]
    
    ttk::label $fpre.l4 -text [_ "Show conditions"]:
    set values [GiD_Info postprocess get all_show_conditions]
    set labels ""
    foreach item $values {
        lappend labels [_ $item]
    }
    TTKMenubutton $fpre.om4 -labels $labels -values $values \
            -textvariable ::GidPriv(PostDisplayConditions) \
            -modifycmd PDAcceptStyle
    array set PreModelOptions [ GiD_Info postprocess get all_pre_model_properties]
    set lst_lbl_show [ list PreNone PreGeometry PreMesh]
    set lst_trad_show [ list [_ "None"] [_ "Geometry"] [_ "Mesh"]]
    set lst_lbl_render [ list PreNormal PreFlat PreSmooth]
    set lst_trad_render [ list [_ "Normal#C#render"] [_ "Flat#C#render"] [_ "Smooth#C#render"]]
    # foreach i [ GiD_Info customrenders] {
    #         lappend lst_lbl_render PreCust$i
    #         lappend lst_trad_render $i
    # }
    foreach lbl $lst_lbl_show trad $lst_trad_show {
        set PreModelOptionsTrad($lbl) $trad
    }
    foreach lbl $lst_lbl_render trad $lst_trad_render {
        set PreModelOptionsTrad($lbl) $trad
    }
    ttk::label $fpre.l5 -text [_ "Draw model"]:
    TTKMenubutton $fpre.om5 -labels $lst_trad_show \
            -values $lst_lbl_show \
            -textvariable ::GidPriv(PostDisplayPreModelShow) \
            -modifycmd PDAcceptStyle
    # TTKComboBox $fpre.om5 -labels $lst_trad_show \
    #         -values $lst_lbl_show \
    #         -textvariable ::GidPriv(PostDisplayPreModelShow) \
    #         -modifycmd PDAcceptStyle \
    #         -state readonly
    ttk::label $fpre.l6 -text [_ "Model render"]:
    TTKMenubutton $fpre.om6 -labels $lst_trad_render \
            -values $lst_lbl_render \
            -textvariable ::GidPriv(PostDisplayPreModelRender) \
            -modifycmd PDAcceptStyle
    # TTKComboBox $fpre.om6 -labels $lst_trad_render \
    #         -values $lst_lbl_render \
    #         -textvariable ::GidPriv(PostDisplayPreModelRender) \
    #         -modifycmd PDAcceptStyle \
    #         -state readonly
    
    
    #ttk::button $fpre.bLayers -text [_ "Open layers window"] -command Layers::ChangeLayers
    ttk::button $fpre.bLayers -text [_ "Open layers window"] -command {Layers::ChangeLayers_New .gid.central.wlay 0} ;#avoid pack layers inside (bug if sets are also packed inside)
    
    grid $fpre.l4 $fpre.om4 -pady 0 -padx 1 -sticky e
    grid configure $fpre.om4 -sticky w
    grid $fpre.l5 $fpre.om5 -pady 0 -padx 1 -sticky e
    grid configure $fpre.om5 -sticky w
    grid $fpre.l6 $fpre.om6 -pady 0 -padx 1 -sticky e
    grid configure $fpre.om6 -sticky w
    grid $fpre.bLayers -columnspan 2


    # ttk::frame $w.dis.fo
    # checkbutton $w.dis.fo.cb -text [_ "Transparent"] \
    #             -variable ::GidPriv(PostDisplayTransparent)
    # 
    # checkbutton $w.dis.fo.cb2 -text [_ "Draw interiors"] \
    #             -variable ::GidPriv(PostDisplayMassiveBodies)

    #set def_back [ $w cget -background]
    # grid columnconf $w 0 -weight 1

    grid $fpost -pady 0 -padx 1 -sticky wens -row 0 -column 0
    grid $fpre -pady 0 -padx 1 -sticky wens -row 0 -column 1

    ### grid $w.dis.fo.cb2 $w.dis.fo.cb -pady 1 -padx 1
    ### grid $w.dis.fo -pady 0 -padx 1
    ###grid $w.dis.but -pady 1 -padx 1 -row 0 -column 2 -rowspan 4 -sticky e
#     grid $w.dis.cb -columnspan 2
#     grid $w.dis.cb2 -columnspan 2

    grid rowconfigure $w.dis 0 -weight 1
    grid rowconfigure $w.dis 1 -weight 1
    grid rowconfigure $w.dis 2 -weight 1
    grid columnconfigure $w.dis 0 -weight 1
    grid columnconfigure $w.dis 1 -weight 1
    grid columnconfigure $w.dis 2 -weight 1
    grid columnconfigure $w.dis 3 -weight 1

    #######    grid $w.dis.fo -pady 0 -row 4 -column 0

    # grid $w.sel -in $w.top -sticky wens
    # grid $w.dis -in $w.top -sticky wens
    # grid columnconfigure $w.top 0 -weight 1
    # grid rowconfigure $w.top 0 -weight 1
    grid $w.sel -in $w -sticky wens
    grid $w.dis -in $w -sticky wens
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    FillPDInfo

    return $w
}

proc WritePostDisplayGeomToVar { w what geomname {InitComm ""}} {
    set trans 1
    #update idletasks
    if { [info exists ::GidPriv(PostDisplayLocation)] && $::GidPriv(PostDisplayLocation) == "RIGHT" } {
        #maintain all dimensions except the new width
        if { [info exists GidPriv($geomname)] } {
            set prevgeom [lindex $::GidPriv($geomname) 1]
            lassign [split $prevgeom x+] width height x y
            set width [winfo width $w]
        } else {
            set width [winfo width $w]
            set height [winfo height $w]
            set x [winfo x $w]
            set y [winfo y $w]
        }
    } else {
        #"OUTSIDE"
        set width [winfo width $w]
        set height [winfo height $w]
        set x [winfo x $w]
        set y [winfo y $w]
    }
    set geom ${width}x${height}+${x}+${y}
    set ::GidPriv($geomname) [list $what $geom $trans $InitComm]
}



proc PostDisplay { { w .gid.wPostDisplay } { location ""} } {
    global GIDDEFAULT
    if { ![info exists ::GidPriv(PostDisplayLocation)] } {
        set ::GidPriv(PostDisplayLocation) RIGHT
    }
    if { ( $location == "RIGHT") || ( $location == "OUTSIDE")} {
        set ::GidPriv(PostDisplayLocation) $location
    }
    set add_sets_window_to_layers_notebook 0
    if { $::GidPriv(PostDisplayLocation) == "OUTSIDE" } {
        InitWindow2 $w -title [_ "Select & Display Style"] -geometryvariable PostDisplayWindowGeom -initcommand PostDisplay
        if { ![winfo exists $w] } {
            return ;# windows disabled || UseMoreWindows == 0
        }
    } else {
        set nb .gid.central.wlay.body.nb
        if { [winfo exists $nb] } {
            #preprocess layers window packed Inside also in postprocess            
            OpenInsideMainWindow $w PostDisplay $::GidPriv(PostDisplayLocation) ;#error recursive PostDisplay
        } else {            
            OpenInsideMainWindow $w PostDisplay $::GidPriv(PostDisplayLocation)
        }
    }

    set ::GidPriv(PostDisplayWindow) $w
    set ::GidPriv(PostDisplayDoingAccept) 0

    if { !$add_sets_window_to_layers_notebook } {
        ttk::frame $w.caption -relief solid -borderwidth 1
        ttk::label $w.caption.title -state disabled -anchor center
        setTooltip $w.caption [_ "Double-click toggle window or inline visualization"]
        if { [ winfo class $w] != "Toplevel" } {
            $w.caption.title configure -text [_ "Post Display"]
            button $w.caption.close -image [ gid_themes::GetImage close17.png] -command [list PostDisplayClose $w] -borderwidth 0
            $w.caption.title configure -text [_ "Double click here to tear off the window"]
        } else {
            $w.caption.title configure -text [_ "Double click here to integrate the window"]
        }
    }
    PostDisplayCreateTopFrame $w.top

    ttk::frame $w.but -style BottomFrame.TFrame
    ttk::frame $w.but.dis -style sunken.TFrame -borderwidth 0

    ttk::menubutton $w.but.back -text [_ "To back"] -menu $w.but.back.m -style BottomFrame.TButton
    GidHelp $w.but.back [_ "Send entities to back/front of a Set (entities in back are not drawn)"]
    menu $w.but.back.m
    $w.but.back.m add checkbutton -label [_ "Opposite"] -variable ::GidPriv(LayersBackOpposite)
    $w.but.back.m add command -label [_ "Elements"] -command [list PDSendToBack $w.but Elements]
    $w.but.back.m add command -label [_ "Bring to front"] -command [list PDSendToBack $w.but ToFront]
    $w.but.back.m add separator
    $w.but.back.m add command -label [_ "Bring ALL to front"] -command [list PDSendToBack $w.but AllToFront]

    $w.but.back.m configure -borderwidth 1 -activeborderwidth 1

    ttk::menubutton $w.but.send -text [_ "Send to"] -menu $w.but.send.m -style BottomFrame.TButton
    GidHelp $w.but.send [_ "Send entities to another set"]
    menu $w.but.send.m
    $w.but.send.m add command -label [_ "Elements"] -command [list PDSendToBack $w.but ToSelected]
    $w.but.send.m add separator
    $w.but.send.m add command -label [_ "New set"] -command [list PDSendToBack $w.but ToNewSet]

    $w.but.send.m configure -borderwidth 1 -activeborderwidth 1

    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton   
    grid $w.but.back $w.but.send $w.but.close -sticky ew -padx 6 -pady 12

    if { !$add_sets_window_to_layers_notebook } {
        if { [ winfo class $w] != "Toplevel" } {
            grid $w.caption.title $w.caption.close -sticky ew
            grid configure $w.caption.close  -sticky w
        } else {
            grid $w.caption.title -sticky ew
        }
        grid columnconfigure $w.caption 0 -weight 1
        grid $w.caption -sticky ew
        bind $w.caption.title <Double-Button-1> "PostDisplayChangeInsideOutside $w"
    }
    
    grid $w.top -sticky news

    grid columnconfigure $w 0 -weight 1
    if { $add_sets_window_to_layers_notebook } {
        grid rowconfigure $w 0 -weight 1
    } else {
        grid rowconfigure $w 1 -weight 1
    }

    grid $w.but -sticky wes
    grid anchor $w.but center

    focus $w.but.close   
}


proc PDSendToBack { frame what } {
    if  { $frame ne "" } { set w [winfo parent $frame] }

    if { $what == "ToSelected" } {
        set tbl $::GidPriv(PostDisplayWindowList).list.f2.tbl
        if { [ $tbl size] == 1} {
            $tbl selection set 0
        }
        set setsel [$tbl curselection]
        if { [llength $setsel] != 1 } {
            set wid [ CreateWarnWinId [_ "One or more sets should be selected"]]
            WarnWin [_ "One set should be selected"] . $wid
            return
        }
        set name [lindex [$tbl get $setsel] 1]     
        GiD_Process 'SelectEntities Elements
        trace add variable ::GidPriv(selection) write [list PDSendToSet $name ""]
        if { $frame ne "" } {
            set SmallWinSelecting [GiD_Set SmallWinSelecting]
            FinishButton $w $frame \
                [_ "Press 'Finish' to end selection"] \
                "" disableall $SmallWinSelecting
        }
    } elseif { $what == "ToNewSet" } {
        GiD_Process 'SelectEntities Elements
        trace add variable ::GidPriv(selection) write [list PDSendToSet "" $what]
        if { $frame ne "" } {
            set SmallWinSelecting [ GiD_Set SmallWinSelecting]
            FinishButton $w $frame \
                [_ "Press 'Finish' to end selection"] \
                "" disableall $SmallWinSelecting
        }
    } elseif { $what == "Elements" } {
        GiD_Process 'SelectEntities Elements
        trace add variable ::GidPriv(selection) write PDSendToBackEnd
        if { $frame ne "" } {
            set SmallWinSelecting [GiD_Set SmallWinSelecting]
            FinishButton $w $frame \
                [_ "Press 'Finish' to end selection"] \
                "" disableall $SmallWinSelecting
        }
    } elseif { $what == "ToFront" } {
        set tbl $::GidPriv(PostDisplayWindowList).list.f2.tbl
        set setsel [$tbl curselection]
        if { $setsel == "" } {
            set wid [ CreateWarnWinId [_ "One or more sets should be selected"]]
            WarnWin [_ "One or more sets should be selected"] . $wid
            return
        }
        set selectedsets ""
        foreach idx $setsel {
            set name [lindex [$tbl get $idx] 1]        
            lappend selectedsets $name
        }
        PdSendToFront $selectedsets
    } else {
        PdSendToFront
    }
}

proc PdSendToFront { { selectedsets "" } } {
    if { !$::PostDisplay(debug) } {
        GidUtils::DisableGraphics       
    }
    foreach type {VolumeSets SurfaceSets CutSets} {
        set currents [GiD_Info postprocess get cur_$type]
        if { $currents != "" } {
            GiD_Process escape escape escape escape select $type no_$type escape
        }
        foreach name [GiD_Info postprocess get all_$type] {
            if { [GetIsBackSet $name] } {
                set front_name [GetFrontNameFromBackName $name]
                if { $selectedsets == "" || [lsearch $selectedsets $front_name] != -1 } {
                    GiD_Process escape escape escape escape Select $type $name escape
                    GiD_Process escape escape escape escape Select Elements 1:end escape
                    GiD_Process MoveToOldSet $front_name
                    GiD_Process escape escape escape escape Utilities Delete $type $name yes
                }
            }
        }
        if { $currents != "" } {
            GiD_Process select $type
            foreach name $currents {
                GiD_Process $name
            }
            GiD_Process escape
        }
    }
    if { !$::PostDisplay(debug) } {
        GidUtils::EnableGraphics        
    }
    GidUtils::UpdateWindow SETS
    GiD_Redraw
}

proc PDSendToBackEnd { name1 name2 op } {
    trace remove variable ::GidPriv(selection) write PDSendToBackEnd   
    # it is supposed that word: Elements is at the beginning
    if { [string length $::GidPriv(selection)] <= 10 } {
        return
    }
    if { !$::PostDisplay(debug) } {
        GidUtils::DisableGraphics
    }
    GiD_Process escape escape escape escape Select Elements  
    if { $::GidPriv(LayersBackOpposite) } {                    
        #added extra escape after each selection to break PostSelectEntities loop
        GiD_Process 1:end escape SwapSelection             
    }
    GiD_Process {*}[string range $::GidPriv(selection) 10 end-1] escape MoveToNewSet ***** escape        
    #after: dark trick to allow finish the pending tasks
    after 0 PDSendToBackEnd2    
}

proc PDSendToBackEnd2 { } {    
    if { !$::PostDisplay(debug) } {
        GidUtils::EnableGraphics       
    }
    GidUtils::UpdateWindow SETS
    GiD_Redraw   
}

# PDDialogGetSetName checks also if it exists
proc PDDialogGetSetName { msg {old_name ""}} {
    set new_name ""
    while { $new_name == "" } {
        # MessageBoxEntry { title question type default_answer button_assign image {fill_extra_frame_proc ""} {parent .gid}}
        set parent $::GidPriv(PostDisplayWindow)
        # changed type 'word' to 'string' to allow spaces in names
        set new_name [ MessageBoxEntry [_ "Enter set name"] $msg string $old_name 0 question.png "" $parent]
        if { $new_name == "" } {
            return ""
        }
        if { [GetSetExists $new_name] } {
            set msg [ concat [_ "Set %s already exists.\n" $new_name] $msg ]
            set new_name ""
        }
    }
    return $new_name
}

proc PDSendToSet { SetName what name1 name2 op } {
    trace remove variable ::GidPriv(selection) write [list PDSendToSet $SetName $what]

    # it is supposed that word: Elements is at the beginning
    if { [string length $::GidPriv(selection)] <= 10 } {
        return
    }

    set DisableWarnLine 0
    set DisableGraphics 0
    set DisableWindows 0
    
    # set ::GidPriv(PostDisplayDoingAccept) 1

    if { !$::PostDisplay(debug) } {
        set DisableWarnLine [GiD_Project set disable_warnline]
        GiD_Project set disable_warnline 1
        set DisableGraphics [GiD_Project set disable_graphics]
        GiD_Project set disable_graphics 1
        set DisableWindows [GiD_Project set disable_windows]
        GiD_Project set disable_windows 1
    }

    GiD_Process escape escape escape escape Select Elements {*}[string range $::GidPriv(selection) 10 end-1] escape
    if { $SetName != "" } {
        GiD_Process MoveToOldSet $SetName escape escape escape
    } else {
        set old_name ""
        set msg [_ "Enter new set name"]:
        # PDDialogGetSetName checks also if it exists
        set new_name [ PDDialogGetSetName $msg $old_name]
        if { $new_name != "" } {
            GiD_Process MoveToNewSet $new_name escape
        }
    }
    if { !$::PostDisplay(debug) } {
        if { !$DisableWarnLine } { GiD_Project set disable_warnline 0 }
        if { !$DisableGraphics } { GiD_Project set disable_graphics 0 }
        # we need to ignore the call to FillPDInfo from within 'GiD_Process ... MoveToNewSet'
        # and do it afterwards (i.e. after all other calls)
        # to avoid some mangling on the info update, 
        # if { !$DisableWindows } { GiD_Project set disable_windows 0 }
    }
    # need to to 'GiD_Redraw' to clear red selected elements
    after 1000 "GiD_Project set disable_windows $DisableWindows; GiD_Redraw; FillPDInfo"
}

namespace eval Sets {
}

proc Sets::SelectColumnsWindow { } {
    variable SelectColumn ;#local temporary value
    
    set category Sets
    set tree $::GidPriv(PostDisplayWindowList).list.f2.tbl
    set column_items {color name visibility style transparency interior edges back num_elements type_elements}
    set column_labels [list [_ "Color"] [_ "Name"] [_ "Visibility"]  [_ "Style"]  [_ "Transparency"] [_ "Interior"] [_ "Edges"] [_ "Back"] [_ "Num"] [_ "Type"]]
    set w .gid.selectcolumns
    InitWindow2 $w -title [_ "Select %s columns" [_ $category]] \
        -geometryvariable PostSelect${category}ColumnsWindowGeom \
        -initcommand Select${category}ColumnsWindow -ontop
    set c [CreateScrolledCanvas $w.body]
    grid $w.body -sticky nsew
    set f [ttk::frame $c.f]   
    foreach item $column_items text $column_labels {
        if { ![info exists ::GidPriv(ColumnVisible,$category,$item)] } {
            set ::GidPriv(ColumnVisible,$category,$item) 1
        }
        set SelectColumn($item) $::GidPriv(ColumnVisible,$category,$item)
        ttk::checkbutton $f.$item -text $text -variable ${category}::SelectColumn($item)
        grid $f.$item -sticky w
    }
    AddToScrolledCanvas $w.body $f
    
    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 0 -weight 1
    CreateLowerButtonsApplyClose $w [list ${category}::SelectColumnsWindowOnApply $tree $category $column_items]
}

proc Sets::SelectColumnsWindowOnApply { tree category column_items } {   
    variable SelectColumn
    set changes 0
    foreach item $column_items {
        if { $::GidPriv(ColumnVisible,$category,$item) != $SelectColumn($item) } {
            set ::GidPriv(ColumnVisible,$category,$item) $SelectColumn($item)         
            set changes 1   
        } 
    }
    if { $changes } {
        TableListSelectColumnsVisibility $tree $category $column_items
    }
}

proc Sets::ContextualMenu { T x y } {
    lassign [tablelist::convEventFields $T $x $y] T x y
    set w $T.menucontextual
    if { [winfo exists $w] } {
        destroy $w
    }
    menu $w    
    set state normal
    $w add command -label [_ "Rename"] -command [list PDChangeName] -state $state \
        -image [ gid_themes::GetImage rename.png small_icons] -compound left
    $w add command -label [_ "Delete"] -command [list PDDeleteCosas] -state $state \
        -image [ gid_themes::GetImage delete.png small_icons] -compound left
    $w add separator
    $w add command -label [_ "Color"]... -command [list PDColorWindow $::GidPriv(PostDisplayWindowList)] -state $state \
        -image [ gid_themes::GetImage color.png small_icons] -compound left
    $w add command -label [_ "On#C#verb"] -command [list PDListOn] -state $state \
        -image [ gid_themes::GetImage layer_on.png small_icons] -compound left
    $w add command -label [_ "Off#C#verb"] -command [list PDListOff] -state $state \
        -image [ gid_themes::GetImage layer_off.png small_icons] -compound left
    $w add command -label [_ "Opaque#C#verb"] -command [list PDListPropiedadNo transparent] -state $state \
        -image [ gid_themes::GetImage transparent_off.png small_icons] -compound left
    $w add command -label [_ "Transparent#C#verb"] -command [list PDListPropiedad transparent] -state $state \
        -image [ gid_themes::GetImage transparent_on.png small_icons] -compound left
    $w add command -label [_ "Draw results#C#verb"] -command [list PDListPropiedad visualizeresults] -state $state \
        -image [ gid_themes::GetImage PostBarContourFill.png small_icons] -compound left
    $w add command -label [_ "Hide results#C#verb"] -command [list PDListPropiedadNo visualizeresults] -state $state \
        -image [ gid_themes::GetImage element.png small_icons] -compound left
    $w add separator
    $w add cascade -label [_ "Send to"] -menu $w.sendto -state $state \
        -image [ gid_themes::GetImage sendto.png small_icons] -compound left
    menu $w.sendto
    $w.sendto add command -label [_ "Elements"] -command [list PDSendToBack $::GidPriv(PostDisplayWindowList).but ToSelected]
    $w.sendto add separator
    $w.sendto add command -label [_ "New set"] -command [list PDSendToBack $::GidPriv(PostDisplayWindowList).but ToNewSet]
    $w add cascade -label [_ "To back"] -menu $w.back \
        -image [ gid_themes::GetImage send_to_back.png small_icons] -compound left
    menu $w.back
    $w.back add checkbutton -label [_ "Opposite"] -variable ::GidPriv(LayersBackOpposite)
    $w.back add command -label [_ "Elements"] -command [list PDSendToBack $::GidPriv(PostDisplayWindowList).but Elements]
    $w.back add command -label [_ "Bring to front"] -command [list PDSendToBack $::GidPriv(PostDisplayWindowList).but ToFront]
    $w.back add separator
    $w.back add command -label [_ "Bring ALL to front"] -command [list PDSendToBack $::GidPriv(PostDisplayWindowList).but AllToFront]
    $w add command -label [_ "List set entities"] -command [list Sets::ListEntitiesSelection $T] -state normal \
        -image [gid_themes::GetImage list.png small_icons] -compound left
    $w add separator
    $w add command -label [_ "Select columns"]... -command [list Sets::SelectColumnsWindow]
    set x [expr [winfo rootx $T]+$x+2]
    set y [expr [winfo rooty $T]+$y]
    GiD_PopupMenu $w $x $y
}

proc Sets::IfNothingSelectedSelectAll { T } {
    set sel [$T curselection]
    if { $sel == "" } {
        $T selection set 0 end
        set sel [$T curselection]
    }
    return $sel
}

proc Sets::GetSelectedNames { T } {
    if { ![winfo exists $T] } { return }
    set set_names ""
    set sel [$T curselection]
    foreach item $sel {
        lappend set_names [lindex [$T get $item] 1]
    }
    set set_names [lsort -unique -dictionary $set_names]
    return $set_names
}

proc Sets::ListEntities { set_names } {
    set text ""
    set overs [list nodes elements]
    set types [list [_ "Nodes"] [_ "Elements"]]
    foreach fullname $set_names {
        set has_entities 0
        foreach over $overs type $types {
            set num_entities [GiD_EntitiesSets get $fullname $over -count]
            if { $num_entities > 0 } {
                set has_entities 1
                break
            }
        }
        append text "$fullname:\n"
        if { $has_entities } {
            foreach over $overs type $types {
                set type_data [GiD_EntitiesSets get $fullname $over]
                if { [llength $type_data] > 0 } {
                    if { $over == "elements" } {
                        set count [llength $type_data]
                        if { [string length $type_data] > 43000} {
                            #long lines >=43684 characters are not visible in current Tk text widget!!
                            set type_data [string range $type_data 0 43000]...
                        }
                        if { 0 } {
                            #we are in post, must not ask for mesh of pre, there are alternatives like parse the ugly "GiD_Info list_entities PostStatus -brief"
                            #show also the number of types of the elements
                            unset -nocomplain num_element_type
                            foreach element_id $type_data {
                                
                                incr num_element_type([lindex [GiD_Mesh get element $element_id] 1])
                            }
                            set element_names ""
                            foreach element_type [lsort -dictionary [array names num_element_type]] {
                                lappend element_names [list $num_element_type($element_type) [_ $element_type]]
                            }
                            set more "([join $element_names {, }])"
                            append text "  $count $type $more: $type_data\n"
                        } else {
                            append text "  $count $type: $type_data\n"
                        }

                    } else {
                        set count [llength $type_data]
                        if { [string length $type_data] > 43000} {
                            #long lines >=43684 characters are not visible in current Tk text widget!!
                            set type_data [string range $type_data 0 43000]...
                        }
                        append text "  $count $type: $type_data\n"
                    }
                }
            }
            append text "\n"
        } else {
            append text "\n"
        }
    }
    return $text
}

proc Sets::ListEntitiesSelection { T } {
    Sets::IfNothingSelectedSelectAll $T
    set set_names [Sets::GetSelectedNames $T]
    set text [Sets::ListEntities $set_names]
    W $text [_ "Set's entities"]
}

set ::PostDisplay(debug) 0
