trace add variable ::GidPriv(ShowProcessCommands) write "GidUtils::ShowProcessCommandsOnChangeVariable ;#"
set ::GidPriv(ShowProcessCommands) 0 ;#1 for developers to know the process syntax of the GiD actions for scripting
set ::GidPriv(ShowProcessCommandsViewFuntions) 0 ;#o to hide visual commands like rotation, pan, etc.

set ::GidPriv(ProfileTcl) 0 ;#1 for developers to start profiling Tcl
trace add variable ::GidPriv(ProfileTcl) write "GidUtils::ProfileTclOnChangeVariable ;#"


set ::GidPriv(AllowHideMeshOptions) 1 ;#if 0 preferences and menus are not hidden based on cartesian or non-cartesian

# tclfile -*- TCL -*- Created: ramsan Aug-1996

proc QuitFullScreen {} {
    
    # preference windows send comands on GiD_Process in closing event, we must close the window before closing GiD
    #if { [GidUtils::ExistsWindow PREFERENCES] } {
    #    GidUtils::CloseWindow PREFERENCES
    #}
    
    # ensure only one does Quit, in Mac OS X
    # this function is called from ::tk::mac::Quit and from the Tk's binding ...
    if { [info exists ::DoingQuitFullScreen] && ( $::DoingQuitFullScreen != 0)} {
        return
    }
    
    # Mac Os X, when pressing Command-q, needs some time to post/unpost the global menubar
    # otherwise, Tk gets blocked
    if { $::tcl_platform(os) == "Darwin"} {
        update idletasks
        update
        set ::DoingQuitFullScreen [after 100 DoQuit]
    } else {
        set ::DoingQuitFullScreen 1
        DoQuit
    }
}


proc AcceleratorShift { M key} {
    set acc_combination $M-[string toupper $key]
    if { $::tcl_platform(os) == "Darwin"} {
        set acc_combination $M-Shift-[string tolower $key]
    }
    return $acc_combination
}

proc SetMenusVariables {} {
    global MenuNames MenuEntries MenuCommands MenuAcceler MenuIcons
    global tcl_platform GIDDEFAULT
    global GidPriv
    
    unset -nocomplain MenuNames MenuEntries MenuCommands MenuAcceler MenuIcons
    
    if { [tk windowingsystem] eq "aqua"} {
        set M Command
    } else {
        set M Control
    }
    
    set MenuNames [list [_ "Files#C#menu"] [_ "View#C#menu,verb"] [_ "Geometry#C#menu"] [_ "Utilities#C#menu"] \
            [_ "Data#C#menu"] [_ "Mesh#C#menu"] \
            [_ "Calculate#C#menu"] [_ "Help#C#menu"] ]
    
    #---------------

    set MenuEntries(0) [list [_ "New#C#menu"] [_ "Open#C#menu"]... [_ "Recent projects#C#menu"] [_ "Save#C#menu"] [_ "Save as#C#menu"]... ---\
            [_ "Import#C#menu"] [_ "Export#C#menu"] --- [_ "Postprocess#C#menu"] [_ "Recent post files#C#menu"] ---\
            [_ "Print to file#C#menu"] [_ "Page and capture settings#C#menu"]... [_ "Print#C#menu"]... \
            --- [_ "Quit#C#menu"]]
    
    set MenuCommands(0) {{-np- DoFilesNew ASK} {-np- DoFilesRead} {-np- AddEntitiesToMenuRecentProjects %W} \
        {-np- DoProjectSave} {-np- DoProjectSaveAs} "" "" "" \
            "" {-np- DoPostprocess} {-np- AddEntitiesToMenuRecentPostFiles %W}  "" "" {-np- PageSetup} {-np- HardcopyToPrint} \
            "" {-np- QuitFullScreen}}

    set MenuAcceler(0) [list $M-n $M-o "" $M-s [AcceleratorShift $M s] "" "" "" "" "" "" "" "" "" "" "" $M-q]
    set MenuIcons(0) {"new.png" "open.png" "" "save.png" "saveas.png" "" "" "" "" \
        "PostBarContourFill.png" "" "" "camera.png" "" "print.png" "" "exit.png"}

    set MenuEntries(0,2) ""
    
    # hide [_ "Vtk voxels#C#menu"]...
    # [list -np- DoFilesImport VTKVoxels [_ "VTK voxels"] {.vtk} 0 0 [list [_ "Reconstruction options"] BrowserExtraCreateReadVtkVoxels BrowserExtraGetReadVtkVoxels]]
    set MenuEntries(0,6) [list IGES... STEP... DXF... Parasolid... ACIS... \
            VDA... Rhinoceros... IFC... "OpenCascade..." Shapefile... [_ "XYZ points#C#menu"]... ---  [_ "%s mesh#C#menu" VTK]... [_ "%s mesh#C#menu" NASTRAN]... \
            [_ "%s mesh#C#menu" STL]... [_ "%s mesh#C#menu" VRML]... [_ "%s mesh#C#menu" 3DStudio]... [_ "%s mesh#C#menu" CGNS]...\
            [_ "%s mesh#C#menu" GiDML]... [_ "%s mesh#C#menu" GiD]... [_ "Surface mesh#C#menu"]... [_ "%s mesh#C#menu" Ply]... [_ "%s mesh#C#menu" "OBJ Wavefront"]... [_ "XYZ nodes#C#menu"]... \
            ---  [_ "Batch file#C#menu"]... [_ "Insert GiD model#C#menu"]...]
    
    set MenuCommands(0,6) [list \
            [list -np- DoFilesImport IGES IGES {.igs .iges} 0 0 [list [_ "Import options"] BrowserExtraCreateOptionsImportGeom BrowserExtraGetOptionsImportGeom]] \
            [list -np- DoFilesImport STEP STEP {.stp .step} 0 0 [list [_ "Import options"] BrowserExtraCreateImportSTEP BrowserExtraGetImportSTEP]] \
            [list -np- DoFilesImport DXF AutoCAD {.dxf} 0 0 [list [_ "Import options"] BrowserExtraCreateOptionsImportGeom BrowserExtraGetOptionsImportGeom]] \
            [list -np- DoFilesImport Parasolid Parasolid {.x_t .x_b} 0 0 [list [_ "Import options"] BrowserExtraCreateOptionsImportGeom BrowserExtraGetOptionsImportGeom]] \
            [list -np- DoFilesImport ACIS ACIS {.sat .sab} 0 0 [list [_ "Import options"] BrowserExtraCreateOptionsImportGeom BrowserExtraGetOptionsImportGeom]] \
            [list -np- DoFilesImport VDA VDA {.vda} 0 0 [list [_ "Import options"] BrowserExtraCreateOptionsImportGeom BrowserExtraGetOptionsImportGeom]] \
            [list -np- DoFilesImport Rhino Rhinoceros {.3dm} 0 0 [list]] \
            [list -np- DoFilesImport IFC IFC {.ifc} 0 0 [list]] \
            [list -np- DoFilesImport OpenCascade OpenCascade {.brep} 0 0 [list]] \
            [list -np- DoFilesImport Shapefile Shapefile {.shp} 0 0 [list [_ "Import options"] BrowserExtraCreateImportShapefile BrowserExtraGetImportShapefile]] \
            [list -np- DoFilesImport XYZ_ToPoints [_ "XYZ to points"] {.xyz .txt .dat .asc} 1 1 [list [_ "Import options"] BrowserExtraCreateImportXYZ BrowserExtraGetImportXYZ]] \
            {} \
            [list -np- DoFilesImport VTK VTK {.vtk .vtu .vtp .vts .vtr .vti .pvd .pvtu} 1 0 [list [_ "Mesh options"] BrowserExtraCreateImportVTK BrowserExtraGetImportVTK]] \
            [list -np- DoFilesImport NASTRAN NASTRAN {.nas .nid .dat .bdf .d} 0 0 [list [_ "Mesh options"] BrowserExtraCreateImportMeshCommon BrowserExtraGetOptionsImportMeshCommon]] \
            [list -np- DoFilesImport STL STL {.stl} 0 0 [list [_ "Mesh options"] BrowserExtraCreateImportMeshCommon BrowserExtraGetOptionsImportMeshCommon]] \
            [list -np- DoFilesImport Vrml VRML {.wrl .vrml} 0 0 [list]] \
            [list -np- DoFilesImport 3DStudio [_ "3DStudio mesh"] {.3ds} 0 0 [list [_ "Mesh options"] BrowserExtraCreateImportMeshCommon BrowserExtraGetOptionsImportMeshCommon]] \
            [list -np- DoFilesImport CGNS CGNS {.cgns} 0 0 [list]] \
            [list -np- DoFilesImport GiDML [_ "GiDML mesh"] {.gidml} 0 0 [list [_ "Mesh options"] BrowserExtraCreateImportMeshCommon BrowserExtraGetOptionsImportMeshCommon]] \
            [list -np- DoFilesImport Mesh [_ "GiD ASCII mesh"] {.msh} 0 0 [list [_ "GiD mesh read options"] BrowserExtraCreateGIDMeshReadOptions BrowserExtraGetGIDMeshReadOptions]] \
            [list -np- DoFilesImport SurfMeshes [_ "Surface mesh"] {.stl .msh} 0 0 [list]] \
            [list -np- DoFilesImport Ply [_ "PLY Standford mesh"] {.ply} 0 0 [list]] \
            [list -np- DoFilesImport OBJ [_ "Wavefront OBJect mesh"] {.obj} 0 0 [list]] \
            [list -np- DoFilesImport XYZ_ToNodes [_ "XYZ to nodes"] {.xyz .txt .dat .asc} 1 1 [list [_ "Import options"] BrowserExtraCreateImportXYZ BrowserExtraGetImportXYZ]] \
            {} \
            [list -np- DoFilesImport BatchFile [_ "GiD batch"] {.bch} 0 0 [list]] \
            [list -np- DoFilesImport InsertProject [_ "GiD project"] {.gid} 0 0 [list [_ "Import options"] BrowserExtraCreateInsertProject BrowserExtraGetInsertProject]] \
            ]
    
    set MenuAcceler(0,6) [list $M-i "" $M-d "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" $M-b ""]
    set MenuIcons(0,6) {"" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" ""}
    
    
    set MenuEntries(0,7) [list IGES... STEP... DXF... ACIS... Rhinoceros... \
            ---  [_ "%s mesh#C#menu" VTK]... [_ "%s mesh#C#menu" $::GidPriv(ProgName)]... [_ "Nodes->Raster"]... --- \
            [_ "Text data report#C#menu"]...  --- \
            [_ "Calculation file#C#menu"]... [_ "Using template .bas (only mesh)#C#menu"]]
    
    set MenuCommands(0,7) [list \
        [list -np- DoFilesExport IGES {.igs .iges} [list]] \
        [list -np- DoFilesExport STEP {.stp .step} [list]] \
        [list -np- DoFilesExport DXF .dxf [list]] \
        [list -np- DoFilesExport ACIS .sat [list]] \
        [list -np- DoFilesExport Rhino .3dm [list]] \
        {} \
        [list -np- DoFilesExport VTK {.vtk .vtu .vtp} [list [_ "Export options"] BrowserExtraCreateExportVTK BrowserExtraGetExportVTK]] \
        [list -np- DoFilesExport GID_MESH .msh [list [_ "Export mesh options"] BrowserExtraCreateExportMesh BrowserExtraGetExportMesh]] \
        [list -np- DoFilesExport RASTER .asc [list]] \
        {} \
        [list -np- DoFilesExport GID_REPORT .txt [list]] \
        {} \
        [list -np- DoFilesExportCalculationFile] \
        [list -np- AddEntitiesToMenuTemplates %W] \
        ]
    
    set MenuAcceler(0,7) [list "" "" "" "" "" "" "" "" "" "" "" "" "$M-x $M-c" ""]
    
    set MenuIcons(0,7) {"" "" "" "" "" "" "" "" "" "" "" "" "" "" }
    
    set MenuEntries(0,7,13) ""
    
    set MenuEntries(0,10) ""
    
    set MenuEntries(0,12) [list [_ "PS/EPS/PDF Screen#C#menu"]... [_ "PS/EPS/PDF Vectorial#C#menu"]... --- \
            [_ "BMP#C#menu"]... [_ "GIF#C#menu"]... [_ "JPEG#C#menu"]... [_ "PNG#C#menu"]... \
            [_ "TGA#C#menu"]... [_ "TIFF#C#menu"]... \
            [_ "VRML#C#menu"]... [_ "STL#C#menu"]... [_ "OBJ#C#menu"]... \
            [_ "SVG#C#menu"]... [_ "PGF#C#menu"]...]
    
    set MenuCommands(0,12) [list "" "" "" \
            {-np- DoPrintToFile BMP .bmp} \
            {-np- DoPrintToFile GIF .gif} \
            {-np- DoPrintToFile JPEG {.jpg .jpeg}} \
            {-np- DoPrintToFile PNG .png} \
            {-np- DoPrintToFile TGA .tga} \
            {-np- DoPrintToFile TIFF {.tif .tiff}} \
            {-np- DoPrintToFile VRML {.wrl .vrml}} \
            {-np- DoPrintToFile STL .stl} \
            {-np- DoPrintToFile OBJ .obj} \
            {-np- DoPrintToFile SVG .svg} \
            {-np- DoPrintToFile PGF .pgf}]
    
    set MenuEntries(0,12,0) [list [_ "PS#C#menu"]... [_ "EPS#C#menu"]... [_ "PDF#C#menu"]...]
    set MenuCommands(0,12,0) { {-np- DoPrintToFile PS .ps 0} \
        {-np- DoPrintToFile EPS .eps 0} \
        {-np- DoPrintToFile PDF .pdf 0}}
    
    set MenuEntries(0,12,1) [list [_ "PS#C#menu"]... [_ "EPS#C#menu"]... [_ "PDF#C#menu"]...]
    set MenuCommands(0,12,1) { {-np- DoPrintToFile PS .ps 1} \
        {-np- DoPrintToFile EPS .eps 1} \
        {-np- DoPrintToFile PDF .pdf 1}}
    
    #--------------
    
    #copyclipboard only available for windows and macOs
    if { $::tcl_platform(platform) == "windows" || $::tcl_platform(os) == "Darwin" } {
        set MenuEntries(1) [list [_ "Zoom#C#menu"] [_ "Rotate#C#menu"] [_ "Pan#C#menu"] --- \
                [_ "Redraw#C#menu"] [_ "Render#C#menu"] [_ "Perspective#C#menu"]... \
                [_ "Clip planes#C#menu"]... [_ "Advanced viewing settings#C#menu"]... --- \
                [_ "Label#C#menu"] [_ "Normals#C#menu"] [_ "Higher entities#C#menu"] \
                [_ "Curvatures#C#menu"] --- \
                [_ "View#C#menu,noun"] [_ "Recent view files#C#menu"] --- \
                [_ "Background image#C#menu"] \
                [_ "Image to clipboard#C#menu"] \
                [_ "Multiple windows#C#menu"] \
                --- [_ "Mode#C#menu"] [_ "Full screen"]]
        set MenuCommands(1) [list "" "" "" "" \
                {-ne- 'Redraw} {-np- AddEntitiesToMenuRender %W} {-np- PerspectiveW} \
                {-np- ClipPlanes} {-np- StereoW} "" \
                "" {-np- AddEntitiesToMenuDrawNormals %W} {-np- AddEntitiesToMenuDrawHigherentities %W} \
                "" "" \
                "" {-np- AddEntitiesToMenuRecentViewFiles %W} "" \
                {-np- AddEntitiesToMenuBackgroundImage %W} \
                {-ne- 'HardCopy CopyClipboard} \
                "" \
                "" [list -np- AddEntitiesToMenuViewMode %W] {-np- SwitchFullScreen}]
        # on macOS Catalina accelerator key F11 is displayed as F1, ?may be due to accelerator restrictions?
        # in macOS Catalina F11 is used to clear/show the desktop
        # on macOS Catalina full screen accelerator usually is Shift+Command+F
        set MenuAcceler(1) { "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "F11" }
        set MenuIcons(1) { "" "" "" "" "redraw.png" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "FullScreen.png" }
        set idxMultipleWindows 20
        set idxViewMode 22       
    } else {
        set MenuEntries(1) [list [_ "Zoom#C#menu"] [_ "Rotate#C#menu"] [_ "Pan#C#menu"] --- \
                [_ "Redraw#C#menu"] [_ "Render#C#menu"] [_ "Perspective#C#menu"]... \
                [_ "Clip planes#C#menu"]... [_ "Advanced viewing settings#C#menu"]... --- \
                [_ "Label#C#menu"] [_ "Normals#C#menu"] [_ "Higher entities#C#menu"] \
                [_ "Curvatures#C#menu"] --- \
                [_ "View#C#menu,noun"] [_ "Recent view files#C#menu"] --- \
                [_ "Background image#C#menu"] \
                [_ "Multiple windows#C#menu"] \
                --- [_ "Mode#C#menu"] [_ "Full screen"]]
        set MenuCommands(1) [list "" "" "" "" \
                {-ne- 'Redraw} {-np- AddEntitiesToMenuRender %W} {-np- PerspectiveW} \
                {-np- ClipPlanes} {-np- StereoW} "" \
                "" {-np- AddEntitiesToMenuDrawNormals %W} {-np- AddEntitiesToMenuDrawHigherentities %W} \
                "" "" \
                "" {-np- AddEntitiesToMenuRecentViewFiles %W} "" \
                {-np- AddEntitiesToMenuBackgroundImage %W} \
                "" "" \
                [list -np- AddEntitiesToMenuViewMode %W] {-np- SwitchFullScreen}]
        # on macOS Catalina accelerator key F11 is displayed as F1, ?may be due to accelerator restrictions?
        # in macOS Catalina F11 is used to clear/show the desktop
        # on macOS Catalina full screen accelerator usually is Shift+Command+F
        set MenuAcceler(1) { "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "F11"}
        set MenuIcons(1) { "" "" "" "" "redraw.png" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "FullScreen.png" }
        set idxMultipleWindows 19
        set idxViewMode 21
    }
    
    set MenuEntries(1,0) [list [_ "In#C#menu"] [_ "Out#C#menu"] --- [_ "Dynamic#C#menu"] [_ "Previous#C#menu"] \
            [_ "Next#C#menu"] --- [_ "Frame#C#menu"]]
    set MenuCommands(1,0) { {-np- DoZoom In} {-np- DoZoom Out} "" {-np- DoZoom Dynamic} {-np- DoZoom Previous} {-np- DoZoom Next} "" {-np- DoZoom Frame} }
    set MenuIcons(1,0) { "zoomin.png" "zoomout.png" "" "" "" "" "" "zframe.png"}
    
    set MenuEntries(1,1) [list [_ "Trackball#C#menu"] [_ "Screen axes#C#menu"] [_ "Object axes#C#menu"] \
            [_ "Center#C#menu"] --- [_ "Plane XY (Original)#C#menu"] [_ "Plane XZ#C#menu"] [_ "Plane YZ#C#menu"] \
            [_ "Isometric X#C#menu"] [_ "Isometric Y#C#menu"] [_ "Isometric Z#C#menu"] ]
    set MenuCommands(1,1) { {-ne- 'Rotate Trackball} {-ne- 'Rotate ScrAxes} \
        {-ne- 'Rotate ObjAxes}  {-ne- 'Rotate Center FJoin} \
        "" {-np- GidRotateView::PlaneXY} {-np- GidRotateView::PlaneXZ} {-np- GidRotateView::PlaneYZ} \
        {-np- GidRotateView::IsometricX} {-np- GidRotateView::IsometricY} {-np- GidRotateView::IsometricZ} \
    }
    set MenuIcons(1,1) { "rotate.png" "" "" "" "" "view_rotate_xy.png" "view_rotate_xz.png" "view_rotate_yz.png" "isometric.png" "" ""}
    set MenuAcceler(1,1) [list "" "" "" "" "" $M-1 $M-2 $M-3 $M-4 "" ""]
    
    set MenuEntries(1,2) [list [_ "Two point#C#menu"] [_ "Dynamic#C#menu"]]
    set MenuCommands(1,2) { {-ne- 'Pan} {-ne- 'DynamicPan} }
    set MenuIcons(1,2) { "" "pan.png" }
    
    set MenuEntries(1,5) ""
    
    set MenuEntries(1,10) [list [_ "All on#C#menu"] [_ "All on in#C#menu"] [_ "Select on#C#menu"] --- [_ "All off#C#menu"] [_ "All off in#C#menu"] [_ "Select off#C#menu"]]
    set MenuCommands(1,10) { {-ne- 'Label All} \
        {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOn}} \
        {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOn Select}} \
            {} \
        {-ne- 'Label Off} \
            {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOff}} \
        {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOff Select}} \
        }
    foreach i {1 2 5 6} {
        set MenuEntries(1,10,$i) {}
    }
    
    set MenuEntries(1,11) ""
    
    set MenuEntries(1,12) ""
    
    set MenuEntries(1,13) [list [_ "Lines"] [_ "Surfaces"]...]
    set MenuCommands(1,13) [list {Mescape Utilities DrawCurvature Lines} {-np- CurvatureWindow}]
    set MenuIcons(1,13) { "line.png" "surface.png" }
    #set MenuEntries(1,13,1) ""
        
    set MenuEntries(1,15) [list [_ "Read#C#menu"]... [_ "Save#C#menu"]...]
    set MenuCommands(1,15) { {Mescape View ReadView} {Mescape View SaveView} }
    
    set MenuEntries(1,16) ""
    
    set MenuEntries(1,18) ""
    
    set MenuEntries(1,$idxMultipleWindows) {}
    set MenuIcons(1,$idxMultipleWindows) {}
    set MenuCommands(1,$idxMultipleWindows) {}
    foreach mw [list 1 2LR 2UD 3L 3U 3R 3D 4 EXT] {
        lappend MenuEntries(1,$idxMultipleWindows) ""
        lappend MenuIcons(1,$idxMultipleWindows) mwindows_${mw}.png
        lappend MenuCommands(1,$idxMultipleWindows) [list -np- GiD_Project set windows_layout $mw]
    }
    
    #view mode
    set MenuEntries(1,$idxViewMode) {}
    set MenuIcons(1,$idxViewMode) {}
    set MenuCommands(1,$idxViewMode) {}
    
    #-----------
    
    set MenuEntries(2) [list [_ "Create#C#menu"] [_ "Delete#C#menu"] [_ "Edit#C#menu"]]
    set MenuCommands(2) { "" {-np- AddBitmapsDeleteMenu %W small_icons} ""}
    set MenuAcceler(2) { "" "" "" }
    set MenuIcons(2) { "" "delete.png" "" }
    
    set MenuEntries(2,0) [list [_ "Point#C#menu"] --- \
            [_ "Straight line#C#menu"] [_ "NURBS line#C#menu"] [_ "Parametric line#C#menu"]... \
            [_ "Polyline#C#menu"] [_ "Arc#C#menu"] --- \
            [_ "NURBS surface#C#menu"] [_ "Parametric surface#C#menu"]... \
            [_ "Surface mesh#C#menu"] --- \
            [_ "Volume#C#menu"] --- [_ "Contact#C#menu"] --- [_ "Geometry from mesh#C#menu"] [_ "Object#C#menu"]]
    set MenuCommands(2,0) "{Geometry Create Point} {} \
        {Geometry Create Line} {Geometry Create NurbsLine} {-np- ParametricLine} \
        {Geometry Create Polyline} {} {} \
        {} {-np- ParametricSurface} \
        {Geometry Create SurfMesh SelectMesh} {} \
        {} {} {} {} {} {}"
    set MenuIcons(2,0) { "point.png" "" "line.png" "spline.png" "" "poly.png" "arc.png" "" \
        "surface.png" "" "" "" "volume.png" "" "" "" "" "object.png" }
    
    set MenuEntries(2,0,6) [list [_ "By 3 points#C#menu"] [_ "Fillet curves#C#menu"]]
    set MenuCommands(2,0,6) "{Geometry Create Arc} {Geometry Create Arc ByTangents}"
    
    set MenuEntries(2,0,8) [list [_ "By contour#C#menu"] [_ "Automatic#C#menu"] [_ "Trimmed#C#menu"] [_ "Untrimmed#C#menu"]\
            [_ "Parallel Lines#C#menu"] [_ "By Points#C#menu"] [_ "By LinePoints#C#menu"] [_ "Search#C#menu"] ]
    set MenuCommands(2,0,8) { {Geometry Create NurbsSurface} \
        {-np- DoGeometryCreateNURBSSurfaceAutomatic} \
        {Geometry Create TrimmedNurb} {Geometry Create UntrimSurf} \
        {Geometry Create NurbsSurface ParallelLines} \
            {Geometry Create NurbsSurface ByPoints} \
        {Geometry Create NurbsSurface ByLinePoints} \
        {Geometry Create NurbsSurface Search} }       
    
    set MenuEntries(2,0,12) [list [_ "By contour#C#menu"] [_ "Automatic 6-sided volumes#C#menu"] [_ "Search#C#menu"] [_ "Search all#C#menu"]]
    set MenuCommands(2,0,12) { {Geometry Create Volume} {Geometry Create Volume AutomaticStruct} {Geometry Create Volume Search} {Geometry Create Volume SearchAll} }
    
    set MenuEntries(2,0,14) [list [_ "Surface#C#menu"] [_ "Automatic surfaces#C#menu"] --- \
            [_ "Volume#C#menu"] [_ "Separated volume#C#menu"] [_ "Automatic volumes#C#menu"]]
    set MenuCommands(2,0,14) { {Geometry Create Contact Surface} {Geometry Create Contact AutomaticSurfaces} "" \
        {Geometry Create Contact Volume} {Geometry Create Contact SeparatedVolume} {Geometry Create Contact AutomaticVolumes}}
    
    set MenuEntries(2,0,16) [list [_ "One node-one point#C#menu"] --- [_ "One element-one line#C#menu"] --- [_ "NURBS patches#C#menu"] [_ "One element-one surface#C#menu"] \
            --- [_  "One element-one volume#C#menu"] \
            --- [_ "Nodes->grid surfaces"] [_ "Triangles->grid surfaces"] ]
    set MenuCommands(2,0,16) { {Geometry Create PointsFromNodes} "" {Geometry Edit ReConstruction OneLineForEachElement} \
        "" {Geometry Edit ReConstruction Meshes 1:end Escape Otherwise Yes Escape} \
        {Geometry Edit ReConstruction OneSurfForEachElement} \
        "" {Geometry Edit ReConstruction OneVolumeForEachElement} \
        "" {-np- DoGeometryCreateGeometryFromMeshNodesToGridSurfaces geometry} {-np- DoGeometryCreateGeometryFromMeshTrianglesToGridSurfaces geometry}}
    
    set MenuEntries(2,0,17) [list [_ "Rectangle#C#menu"] [_ "Polygon#C#menu"] [_ "Circle#C#menu"] --- \
            [_ "Sphere#C#menu"] [_ "Cylinder#C#menu"] [_ "Cone#C#menu"] [_ "Prism#C#menu"] [_ "Torus#C#menu"] ]
    set MenuCommands(2,0,17) { {-np- DoCreateObjectRectangle} \
        {-np- DoCreateObjectPolygon} \
        {-np- DoCreateObjectCircle} "" {-np- DoCreateObjectSphere} \
            {-np- DoCreateObjectCylinder} {-np- DoCreateObjectCone} \
        {-np- DoCreateObjectPrism} {-np- DoCreateObjectTorus} }
    
    set MenuIcons(2,0,17) { "rectangle.png" "polygonPNR.png" "CirclePNR.png" "" "sphere.png" "cylinder.png" "cone.png" "Prism.png" "tori.png" }
    
    #set MenuEntries(2,1) [list [_ "Points#C#menu"] [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"] \
        --- [_ "All types#C#menu"]]
    #set MenuCommands(2,1) { {-np- DoGeometryDelete Point} {-np- DoGeometryDelete Line} {-np- DoGeometryDelete Surface} {-np- DoGeometryDelete Volume} "" {-np- DoGeometryDelete AllTypes} }
    #set MenuIcons(2,1) { "point.png" "line.png" "surface.png" "volume.png" "" "alltypes.png"}
    set MenuEntries(2,1) ""
    
    
    set MenuEntries(2,2) [list [_ "Move#C#menu"] [_ "Divide#C#menu"] [_ "Join#C#menu"] [_ "Lines operations#C#menu"] \
            [_ "Swap arc#C#menu"] [_ "Polyline#C#menu"] [_ "SurfMesh#C#menu"] \
            --- [_ "Rebuild surface by boundary#C#menu"] [_ "Edit NURBS#C#menu"] [_ "Convert to NURBS#C#menu"] [_ "Simplify NURBS#C#menu"] \
            [_ "Hole surface#C#menu"] --- [_ "Hole volume#C#menu"] --- [_ "Collapse#C#menu"] [_ "Uncollapse#C#menu"] [_ "Snap to plane"] --- \
            [_ "Intersection#C#menu"] [_ "Surface boolean op.#C#menu"] [_ "Volume boolean op.#C#menu"]]
    set MenuCommands(2,2) { "" "" "" "" \
        {Geometry Edit SwapArc} "" {Geometry Edit EditSurfMeshes} \
        "" {Geometry Edit JoinSurfaces EachOneAlone QuickJoin} "" "" "" \
        "" "" {Geometry Create Volume hole} "" "" "" {Geometry Edit SnapToPlane} "" \
        "" "" ""}
    
    set MenuEntries(2,2,0) [list [_ "Move point#C#menu"] [_ "Move Lines z raster#C#menu"]]
    set MenuCommands(2,2,0) { {Geometry Edit MovePoint} {-np- DoGeometryEditMoveLinesToZRaster}}
    set MenuIcons(2,2,0) { "point.png" "line.png" }

    set MenuEntries(2,2,1) [list [_ "Lines#C#menu"] [_ "Polylines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(2,2,1) { "" {Geometry Edit DivideLine Multiple PolyLine} "" "" }
    set MenuIcons(2,2,1) { "line.png" "poly.png" "surface.png" "volume.png" }
    
    set MenuEntries(2,2,1,0) [list [_ "Num divisions#C#menu"] [_ "Projecting point#C#menu"] [_ "Parameter#C#menu"] [_ "Relative Length#C#menu"] [_ "Length#C#menu"]]
    set MenuCommands(2,2,1,0) { {Geometry Edit DivideLine Multiple NumDivisions} \
        {Geometry Edit DivideLine Multiple Point} \
        {Geometry Edit DivideLine Multiple Parameter} \
            {Geometry Edit DivideLine Multiple RelativeLength} \
            {Geometry Edit DivideLine Multiple Measure} }
    
    set MenuEntries(2,2,1,2) [list [_ "Num divisions#C#menu"] [_ "Projecting point#C#menu"] [_ "Parameter#C#menu"] [_ "Split#C#menu"]]
    set MenuCommands(2,2,1,2) { {-np- DoDivideSurfaceNumDivisions} {Geometry Edit DivideSurf Point} {Geometry Edit DivideSurf Parameter} {Geometry Edit SplitSurf} }
    
    set MenuEntries(2,2,1,3) [list [_ "Split#C#menu"]]
    set MenuCommands(2,2,1,3) { {Geometry Edit SplitVolume} }
    
    set MenuEntries(2,2,2) [list [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(2,2,2) { {Geometry Edit JoinLines} ""  {Geometry Edit JoinVolumes} }
    set MenuIcons(2,2,2) { "line.png" "surface.png" "volume.png" }
    
    set MenuEntries(2,2,2,1) [list [_ "Rebuild by boundary#C#menu"] [_ "Join only coplanars#C#menu"]]
    set MenuCommands(2,2,2,1) { {Geometry Edit JoinSurfaces NoEachOneAlone QuickJoin} {Geometry Edit JoinSurfaces NoEachOneAlone JoinCoplanary} }
    
    set MenuEntries(2,2,3) [list [_ "Join lines end points#C#menu"] [_ "Force to be tangent#C#menu"]]
    set MenuCommands(2,2,3) { {Geometry Edit JoinLinesExt} {Geometry Edit TangentNurbsL} }
    
    set MenuEntries(2,2,5) [list [_ "Explode polyline#C#menu"] [_ "Edit polyline#C#menu"]]
    set MenuCommands(2,2,5) { {Geometry Edit ExplodePoly} {Geometry Edit EdPoly} }
    
    set MenuEntries(2,2,9) [list [_ "Line#C#menu"]... [_ "Surface#C#menu"]... ]
    set MenuCommands(2,2,9) { {-np- EditNURBS Line} {-np- EditNURBS Surface} }
    
    set MenuEntries(2,2,10) [list [_ "Line#C#menu"] [_ "Surface#C#menu"]]
    set MenuCommands(2,2,10) { {Geometry Edit ConvToNurbsL} {Geometry Edit ConvToNurbsS} }
    
    set MenuEntries(2,2,11) [list [_ "Model#C#menu"] --- [_ "Line#C#menu"] [_ "Surface#C#menu"]]
    set MenuCommands(2,2,11) { {Geometry Edit SimplifyNurbsS All escape escape escape Geometry Edit SimplifyNurbsL All} "" \
        {Geometry Edit SimplifyNurbsL} {Geometry Edit SimplifyNurbsS} }
    
    set MenuEntries(2,2,12) [list [_ "With lines#C#menu"] [_ "With surfaces#C#menu"]]
    set MenuCommands(2,2,12) { {Geometry Edit HoleNurb WithLines} {Geometry Edit HoleNurb WithSurfaces} }
    
    set MenuEntries(2,2,16) [list [_ "Model#C#menu"] --- [_ "Points#C#menu"] [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(2,2,16) { {Utilities Collapse model} "" {Utilities Collapse points} \
        {Utilities Collapse Lines} {Utilities Collapse Surfaces} {Utilities Collapse Volumes} }
    set MenuIcons(2,2,16) { "" "" "point.png" "line.png" "surface.png" "volume.png" }
    
    set MenuEntries(2,2,17) [list [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(2,2,17) { {Utilities Uncollapse Lines} {Utilities Uncollapse Surfaces} {Utilities Uncollapse Volumes} }
    set MenuIcons(2,2,17) { "line.png" "surface.png" "volume.png" }
    
    
    set MenuEntries(2,2,20) [list [_ "Lines#C#menu"] --- [_ "Surface-2 points#C#menu"] [_ "Surface-lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volume-surfaces#C#menu"] ]
    set MenuCommands(2,2,20) { {Geometry Create IntMultLines} "" {Geometry Create IntSurfPnts} {Geometry Create IntSurfLine} {Geometry Create IntMultSurfs} {Geometry Create IntVolSurfs} }
    
    set MenuEntries(2,2,21) [list [_ "Union#C#menu"] [_ "Intersection#C#menu"] [_ "Substraction#C#menu"] [_ "Substract and intersect#C#menu"]]
    set MenuCommands(2,2,21) "{Geometry Create IntSolid2D Union} {Geometry Create IntSolid2D Intersect} \
        {Geometry Create IntSolid2D Substract} {Geometry Create IntSolid2D SubstractAndIntersect}"
    
    set MenuEntries(2,2,22) [list [_ "Union#C#menu"] [_ "Intersection#C#menu"] [_ "Substraction#C#menu"] [_ "Substract and intersect#C#menu"]]
    set MenuCommands(2,2,22) "{Geometry Create IntSolid3D Union} {Geometry Create IntSolid3D Intersect} \
        {Geometry Create IntSolid3D Substract} {Geometry Create IntSolid3D SubstractAndIntersect}"
    #--------------
    
    set MenuEntries(3) [list]
    set MenuCommands(3) [list]
    set MenuAcceler(3) [list]
    set MenuIcons(3) [list]
    set num_undo_items 0
    if { !$::GidPriv(HideUndo) } {
        set MenuEntries(3) [list [_ "Undo#C#menu"] [_ "Redo#C#menu"]  [_ "Undo multiple#C#menu"]... [_ "Redo multiple#C#menu"]... ---]
        set MenuCommands(3) { {-np- Undo::DoUndoLast} {-np- Undo::DoRedoLast}  {-np- Undo::UndoWindow} {-np- Undo::RedoWindow} "" }
        set MenuAcceler(3) [list $M-z $M-y $M-u $M-r ""]
        set MenuIcons(3) {"" "" "" "" ""}
        set num_undo_items [llength $MenuEntries(3)]
    }

    lappend MenuEntries(3) {*}[list [_ "Preferences#C#menu"]... [_ "Layers and groups#C#menu"]... --- \
            [_ "Tools#C#menu"] --- [_ "Copy#C#menu"]... [_ "Move#C#menu"]... \
            --- [_ "Status#C#menu"]... [_ "List#C#menu"] [_  "Mass#C#menu"] [_ "Renumber#C#menu"] [_ "Id#C#menu"] \
            [_ "Signal#C#menu"] --- [_ "Swap normals#C#menu"] [_ "Distance#C#menu"] \
            [_ "Dimension#C#menu"] --- [_ "Repair model#C#menu"]]
    
    lappend MenuCommands(3) {*}{ {-np- PreferencesWindow } {-np- Layers::ChangeLayers} "" "" "" {-np- CopyMove Copy} \
        {-np- CopyMove Move} "" {-np- ListEntities status} \
            {-np- AddEntitiesToMenuCommonEntities %W DoList 0} \
        {-np- AddEntitiesToMenuCommonEntities %W DoListMass 0} \
            {Utilities Renumber} {Utilities Id} \
        {-np- AddEntitiesToMenuSignalEntities %W} \
            "" {-np- AddEntitiesToMenuSwapNormals %W} {Utilities Dist} "" "" {-np- DoUtilitiesRepair}}
    
    lappend MenuAcceler(3) {*}[list $M-p $M-l "" "" "" [AcceleratorShift $M c] [AcceleratorShift $M v] \
            "" "" "" "" "" "" "" "" "" "" "" "" ""]
    lappend MenuIcons(3) {*}{"prefs.png" "layers.png" "" "" "" "copy.png" "" \
        "" "" "list.png" "" "" "" "" "" "" "" ""}
    set pos [expr $num_undo_items+3]
    set MenuEntries(3,$pos) [list [_ "Toolbars#C#menu"]... --- \
            [_ "Move screen objects#C#menu"] --- \
            [_ "Coordinates window#C#menu"]... [_ "Read batch window#C#menu"]... [_ "Comments#C#menu"]... \
            [_ "Animation controls#C#menu"]... [_ "Animation script#C#menu"]... \
            [_ "Macros#C#menu"]... [_ "Selection window#C#menu"]... --- [_ "Calculator#C#menu"]... [_ "Report#C#menu"]... \
            [_ "Notes#C#menu"]...]
    set MenuAcceler(3,$pos) {"" "" "" "" "" "" "" "" "" "" "" "" "" "" ""}
    set MenuIcons(3,$pos) {"" "" "" "" "" "" "" "tool-animator.png" "" "edit_file.png" "" "" "" "Report.png" "note.png"}
    set MenuCommands(3,$pos) { {-np- TOBegin} "" \
        {-ne- 'MoveScrObj} "" {-np- SetCoord} \
        {-np- ReadBatch} {-np- CommentsW} \
            {-np- PostAnimateControlsWindow} {-np- ::AutoAnimate::Create} \
            {-np- toolbarmacros::MacrosWindow} {-np- make_win_filter} \
        "" {-np- CalculatorV} {-np- GIDReport::Create} {-np- GidUtils::OpenWindow NOTES}}

    if { ![info exists GidPriv(DevelopMenuState)] } {
        set GidPriv(DevelopMenuState) 1
    }
    if { $GidPriv(DevelopMenuState) } {
        lappend MenuEntries(3,$pos) [_ "Develop#C#menu"]
        lappend MenuAcceler(3,$pos) ""
        lappend MenuIcons(3,$pos) ""
        lappend  MenuCommands(3,$pos) ""
        set MenuEntries(3,$pos,15) [list [_ "Debugger"]... [_ "Console Tcl#C#menu"]... [_ "Console Python#C#menu"]... \
            [list -CB2- ProfileTcl [_ "Profile Tcl"]...] \
            [list -CB2- ShowProcessCommands [_ "Show process commands"]] \
            [list -CB2- ShowProcessCommandsViewFuntions [_ "Show process commands view"]]]
        set MenuAcceler(3,$pos,15) {F12 "" "" "" "" ""}
        set MenuIcons(3,$pos,15) {"" "console.png" "console.png" "" "eye.png" "eye.png"}
        set MenuCommands(3,$pos,15) {{-np- package require RamDebugger} {-np- GidUtils::OpenWindow CONSOLE} {-np- GidUtils::OpenWindow CONSOLE_PYTHON} {} {} {}}
    }
        
    set MenuEntries(3,[expr $num_undo_items+9]) ""
    set MenuEntries(3,[expr $num_undo_items+10]) ""
    set MenuEntries(3,[expr $num_undo_items+13]) ""
    set MenuEntries(3,[expr $num_undo_items+15]) ""
    
    set pos [expr $num_undo_items+17]
    set MenuEntries(3,$pos) [list [_ "Create#C#menu"] [_ "Delete#C#menu"] [_ "Edit#C#menu"] [_ "ShowBox#C#menu"] ]
    set MenuCommands(3,$pos) { "" {Utilities Dimension Delete} {Utilities Dimension Edit} "" }
    
    set MenuEntries(3,$pos,0) [list [_ "Vertex#C#menu"] [_ "Distance#C#menu"] [_ "Angle#C#menu"] [_ "Radius#C#menu"] [_ "Text#C#menu"] ]
    set MenuCommands(3,$pos,0) { {Utilities Dimension Create Vertex} {Utilities Dimension Create Distance} \
        {Utilities Dimension Create Angle} {Utilities Dimension Create Radius} \
        {Utilities Dimension Create Text} }
    
    set MenuEntries(3,$pos,3) [list [_ "On#C#menu"] [_ "Off#C#menu"] ]
    set MenuCommands(3,$pos,3) { {Utilities Dimension ShowBox} {Utilities Dimension HideBox} }
    
    
    #---------------
    
    set MenuEntries(4) ""
    set MenuCommands(4) {-np- FillMenuData %W}
    set MenuAcceler(4) ""
    set MenuIcons(4) ""
    
    #---------------
    
    set MenuEntries(5) [list [_ "Unstructured#C#menu"] [_ "Structured#C#menu"] \
            [_ "Semi-structured#C#menu"] [_ "Assign cartesian size#C#menu"] --- [_ "Boundary layer#C#menu"] --- \
            [_ "Quadratic type#C#menu"] [_ "Element type#C#menu"]\
            [_ "Mesh criteria#C#menu"] [_ "Reset mesh data#C#menu"] [_ "Draw#C#menu"] --- \
            [_ "Preview line mesh"]... \
            [_ "Generate mesh#C#menu"]... [_ "Erase mesh#C#menu"] [_ "Edit mesh#C#menu"] \
            [_ "Show errors#C#menu"]... --- \
            [_ "View mesh boundary#C#menu"] [_ "Create boundary mesh#C#menu"] --- [_ "Mesh quality#C#menu"]... \
            --- [_ "Mesh options from model#C#menu"] ]
    
    set MenuAcceler(5) [list "" "" "" "" "" "" "" "" "" "" "" "" "" "" $M-g "" "" "" "" "" "" "" "" "" ""]
    set MenuIcons(5) { "" "" "" "" "" "" "" "" "" "" "" "" "" "" "view_geom_mesh.png" "" "" "" "" "" "" "" "" "" ""}
    
    set MenuCommands(5) { "" "" "" "" "" "" "" {-np- AddEntitiesToMenuQuadratic %W} "" ""\
        {Meshing reset} "" "" {-np- PreviewLineMesh} {-np- DoMeshingGenerate} {Meshing CancelMesh PreserveFrozen} "" {-np- GidUtils::OpenWindow MESHERRORS} ""\
        {Meshing Boundaries} {Meshing CreateBoundary} "" {-np- MeshQuality} "" {-np- SetMeshOptionsFromStatus} }
    
    set MenuEntries(5,0) [list [_ "Assign sizes on points#C#menu"] [_ "Assign sizes on lines#C#menu"] \
            [_ "Assign sizes on surfaces#C#menu"] [_ "Assign sizes on volumes#C#menu"] --- \
            [_ "Sizes by chordal error#C#menu"]... [_ "Sizes by background mesh#C#menu"]... \
            [_ "Correct sizes#C#menu"]... --- [_ "Assign entities#C#menu"] --- [_ "Surface mesher#C#menu"] [_ "Volume mesher#C#menu"]]
    set MenuCommands(5,0) { {Meshing AssignSizes Points} \
        {Meshing AssignSizes Lines} {Meshing AssignSizes Surfaces} \
        {Meshing AssignSizes Volumes} "" {-np- CEBegin} \
            {Meshing AssignSizes BackgMesh} {-np- CEBeginCorrectSizes} "" "" "" "" ""}
    set MenuIcons(5,0) { "point.png" "line.png" "surface.png" "volume.png" \
        "" "" "" "" "" "" "" "" ""}
    
    set MenuEntries(5,0,9) [list [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(5,0,9) { {Meshing AssignSizes Lines 0.0} \
        {Meshing AssignSizes Surfaces 0.0} {Meshing AssignSizes Volumes 0.0} }
    set MenuIcons(5,0,9) {"line.png" "surface.png" "volume.png" }        
    
    set MenuEntries(5,0,11) [list [_ "Default#C#menu"] [_ "RFast#C#menu"] [_ "RSurf#C#menu"] [_ "MinElem#C#menu"]]
    set MenuCommands(5,0,11) { {Meshing AssignMesher Surface Default} {Meshing AssignMesher Surface RFast} {Meshing AssignMesher Surface RSurf} {Meshing AssignMesher Surface MinElem} }
    
    set MenuEntries(5,0,12) [list [_ "Default#C#menu"] [_ "Advancing front#C#menu"] [_ "Tetgen#C#menu"] [_ "Octree#C#menu"]]
    set MenuCommands(5,0,12) { {Meshing AssignMesher Volume Default} {Meshing AssignMesher Volume AdvancingFront} {Meshing AssignMesher Volume Tetgen} {Meshing AssignMesher Volume Octree} }
    
    set MenuEntries(5,1) [list [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(5,1) { "" "" "" }
    set MenuIcons(5,1) { line.png surface.png volume.png }
    
    set MenuEntries(5,1,0) [list [_ "Assign number of divisions#C#menu"] [_ "Assign size#C#menu"] \
            --- [_ "Concentrate elements#C#menu"]]
    set MenuCommands(5,1,0) {{Meshing Structured Lines} {Meshing Structured Lines Size} "" {Meshing StructConcentr} }
    
    set MenuEntries(5,1,1) [list [_ "Assign number of divisions to surface lines#C#menu"] [_ "Assign size to surface lines#C#menu"] \
            --- [_ "Center structured#C#menu"] [_ "Set center#C#menu"]]
    set MenuCommands(5,1,1) { {Meshing Structured Surfaces} {Meshing Structured Surfaces Size} \
        "" {-np- CenterStructured Modeless} {Meshing CenterStruct SetCenter} }
    
    set MenuEntries(5,1,2) [list [_ "Assign number of divisions to volume lines#C#menu"] [_ "Assign size to volume lines#C#menu"]]
    set MenuCommands(5,1,2) {{Meshing Structured Only6FacedVols Volumes} {Meshing Structured Only6FacedVols Volumes Size} }
    
    set MenuEntries(5,2) [list [_ "Volumes#C#menu"]]
    set MenuCommands(5,2) { "" }
    set MenuIcons(5,2) { volume.png }
    
    set MenuEntries(5,2,0) [list [_ "Assign number of divisions in structured direction"] --- [_ "Set master surface#C#menu"] [_ "Set structured direction#C#menu"]]
    set MenuCommands(5,2,0) { {Meshing SemiStructured Volumes} "" {Meshing SemiStructured SetMaster} {Meshing SemiStructured SetDirection}}    
    
    set MenuEntries(5,3) [list [_ "Points#C#menu"] [_ "Lines#C#menu"] \
            [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"] --- [_ "Cartesian grid"]...]
    set MenuCommands(5,3) { {Meshing Cartesian Points} {Meshing Cartesian Lines} \
        {Meshing Cartesian Surfaces} {Meshing Cartesian Volumes} "" {-np- CartesianGrid::CartesianGridWin} }
    set MenuIcons(5,3) { point.png line.png surface.png volume.png "" ""}
    
    set MenuEntries(5,5) [list [_ "2D#C#menu"] [_ "3D#C#menu"] \
            --- [_ "Reset#C#menu"]]
    set MenuCommands(5,5)  { "" "" "" {Meshing BoundaryLayerMesh reset all}}
    
    set MenuEntries(5,5,0) [list [_ "Assign#C#menu"] [_ "Unassign#C#menu"]]
    set MenuCommands(5,5,0) {{Meshing BoundaryLayerMesh 2d} {Meshing BoundaryLayerMesh reset 2d} }
    
    set MenuEntries(5,5,1) [list [_ "Assign#C#menu"] [_ "Unassign#C#menu"]]
    set MenuCommands(5,5,1) {{Meshing BoundaryLayerMesh 3d} {Meshing BoundaryLayerMesh reset 3d} }
    
    set MenuEntries(5,7) ""
    set MenuCommands(5,7) ""
    
    set MenuEntries(5,8) [list [_ "Default#C#menu"] [_ "Linear#C#menu"] --- \
            [_ "Triangle#C#menu"] [_ "Quadrilateral#C#menu"] [_ "Circle#C#menu"] --- \
            [_ "Tetrahedra#C#menu"] [_ "Hexahedra#C#menu"] \
            [_ "Prism#C#menu"] [_ "Sphere#C#menu"] [_ "Points#C#menu"]]
    set MenuCommands(5,8) { "" "" "" \
        {-np- ChooseElemType Triangle} {-np- ChooseElemType Quadrilateral} {-np- ChooseElemType Circle Surfaces} "" \
        {-np- ChooseElemType Tetrahedra} {-np- ChooseElemType Hexahedra} \
        {-np- ChooseElemType Prism} {-np- ChooseElemType Sphere Volumes} {-np- ChooseElemType Points} }
    
    set MenuEntries(5,8,0) [list [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(5,8,0) {{-np- ChooseElemType Default Surfaces} \
        {-np- ChooseElemType Default Volumes}}
    set MenuIcons(5,8,0) { "surface.png" "volume.png" }
    
    set MenuEntries(5,8,1) [list [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(5,8,1) {{-np- ChooseElemType Linear Surfaces} \
        {-np- ChooseElemType Linear Volumes}}
    set MenuIcons(5,8,1) { "surface.png" "volume.png" }
    
    set MenuEntries(5,9) [list [_ "Default#C#menu"] --- [_ "Mesh#C#menu,verb"] [_ "No mesh#C#menu,verb"] [_ "Default mesh#C#menu,verb" ] --- \
            [_ "Skip#C#menu"] [_ "No skip#C#menu"] [_ "Automatic skip#C#menu"] [_ "Skip by...#C#menu"] --- \
            [_ "Force points to#C#menu"] [_ "No force points to#C#menu"] --- [_ "Duplicate#C#menu"] [_ "No Duplicate#C#menu"]]
    set MenuCommands(5,9) { "" "" "" "" "" "" "" "" "" {-np- RJBegin} "" "" {Meshing MeshCriteria NoForcePointsTo} "" "" ""}
    
    set MenuEntries(5,9,0) [list [_ "Points#C#menu"] [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(5,9,0) {{Meshing MeshCriteria DefaultAll Points} \
        {Meshing MeshCriteria DefaultAll Lines} \
        {Meshing MeshCriteria DefaultAll Surfaces} \
        {Meshing MeshCriteria DefaultAll Volumes} }
    set MenuIcons(5,9,0) { "point.png" "line.png" "surface.png" "volume.png" }
    
    set MenuEntries(5,9,2) [list [_ "Points#C#menu"] [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(5,9,2) {{Meshing MeshCriteria Mesh Points} \
        {Meshing MeshCriteria Mesh Lines} \
        {Meshing MeshCriteria Mesh Surfaces} \
        {Meshing MeshCriteria Mesh Volumes} }
    set MenuIcons(5,9,2) { "point.png" "line.png" "surface.png" "volume.png" }
    
    set MenuEntries(5,9,3) [list [_ "Points#C#menu"] [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(5,9,3) {{Meshing MeshCriteria NoMesh Points} \
        {Meshing MeshCriteria NoMesh Lines} \
        {Meshing MeshCriteria NoMesh Surfaces} \
        {Meshing MeshCriteria NoMesh Volumes} }
    set MenuIcons(5,9,3) { "point.png" "line.png" "surface.png" "volume.png" }
    
    set MenuEntries(5,9,4) [list [_ "Points#C#menu"] [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    set MenuCommands(5,9,4) {{Meshing MeshCriteria DefaultMesh Points} \
        {Meshing MeshCriteria DefaultMesh Lines} \
        {Meshing MeshCriteria DefaultMesh Surfaces} \
        {Meshing MeshCriteria DefaultMesh Volumes} }
    set MenuIcons(5,9,4) { "point.png" "line.png" "surface.png" "volume.png" }
    
    set MenuEntries(5,9,6) [list [_ "Points#C#menu"] [_ "Lines#C#menu"] ]
    set MenuCommands(5,9,6) {{Meshing MeshCriteria Skip Points} {Meshing MeshCriteria Skip Lines} }
    set MenuIcons(5,9,6) { "point.png" "line.png" }
    
    set MenuEntries(5,9,7) [list [_ "Points#C#menu"] [_ "Lines#C#menu"] ]
    set MenuCommands(5,9,7) {{Meshing MeshCriteria NoSkip Points} {Meshing MeshCriteria NoSkip Lines} }
    set MenuIcons(5,9,7) { "point.png" "line.png" }
    
    set MenuEntries(5,9,8) [list [_ "Points#C#menu"] [_ "Lines#C#menu"] ]
    set MenuCommands(5,9,8) {{Meshing MeshCriteria DefaultSkip Points} {Meshing MeshCriteria DefaultSkip Lines} }
    set MenuIcons(5,9,8) { "point.png" "line.png" }
    
    set MenuEntries(5,9,11) [list [_ "Surface mesh#C#menu"] [_ "Volume mesh#C#menu"] ]
    set MenuCommands(5,9,11) {{Meshing MeshCriteria ForcePointsTo SurfaceMesh} {Meshing MeshCriteria ForcePointsTo VolumeMesh} }   
    
    set MenuEntries(5,9,14) [list [_ "Lines#C#menu"] [_ "Surfaces#C#menu"]]
    set MenuCommands(5,9,14) { {Meshing MeshCriteria DuplicateNodes Lines} {Meshing MeshCriteria DuplicateNodes Surfaces}}
    set MenuIcons(5,9,14) { "line.png" "surface.png" }
    
    set MenuEntries(5,9,15) [list [_ "Lines#C#menu"] [_ "Surfaces#C#menu"]]
    set MenuCommands(5,9,15) { {Meshing MeshCriteria NoDuplicateNodes Lines} {Meshing MeshCriteria NoDuplicateNodes Surfaces}}
    set MenuIcons(5,9,15) { "line.png" "surface.png" }
    
    set MenuEntries(5,11) [list [_ "Num of divisions#C#menu"] [_ "Sizes#C#menu"] \
            [_ "Element type#C#menu"] [_ "Mesh / No mesh#C#menu,verb"] \
            [_ "Structured type#C#menu"] [_ "Skip entities#C#menu"] [_ "Duplicate#C#menu"] \
            [_ "Force points to#C#menu"] [_ "Boundary layer#C#menu"] [_ "Unstructured mesher#C#menu"]]
    
    set MenuCommands(5,11) {{Meshing DrawNumOfDivisions Lines} {-np- AddEntitiesToMenuDrawSize %W} \
        {-np- AddEntitiesToMenuDrawElementType %W} {-np- AddEntitiesToMenuDrawMeshNoMesh %W} {-np- AddEntitiesToMenuDrawStructuredType %W} \
        {Meshing DrawRjumpSkip} {Meshing DrawDuplicate} {-np- AddEntitiesToMenuDrawForcePointsToMesh %W} \
            {Meshing DrawBoundaryLayerMesh Automatic} {Meshing DrawMesher}}
    
    set MenuEntries(5,11,1) ""
    set MenuEntries(5,11,2) ""   
    set MenuEntries(5,11,3) ""
    set MenuEntries(5,11,4) ""    
    set MenuEntries(5,11,7) "" 
    
    set MenuEntries(5,16) [list [_ "Create node#C#menu"] [_ "Move node#C#menu"] [_ "Move nodes z raster#C#menu"] ---  \
            [_ "Create element#C#menu"] [_ "Split elements#C#menu"] [_ "Smooth elements#C#menu"] [_ "Cut plane"] --- \
            [_ "Collapse#C#menu"] [_ "Delete#C#menu"] \
            --- [_ "Nodes->grid quadrilaterals"] [_ "Triangles->grid quadrilaterals"] --- [_ "Detach from geometry"]]
    set MenuCommands(5,16) { {Meshing EditMesh CreateNode} {Meshing EditMesh MoveNode} {-np- DoMeshEditMeshMoveNodesToZRaster} "" \
        {-np- AddEntitiesToMenuCreateElement %W} "" {Meshing EditMesh Smoothing} {Meshing EditMesh CutPlane} ""  \
        ""  {-np- AddBitmapsDeleteMenu %W small_icons MESHUSE} \
        "" {-np- DoGeometryCreateGeometryFromMeshNodesToGridSurfaces mesh} {-np- DoGeometryCreateGeometryFromMeshTrianglesToGridSurfaces mesh} \
        "" {Meshing EditMesh DetachFromGeometry}}
    
    set MenuEntries(5,16,4) ""
    set MenuEntries(5,16,5) [list \
            [_ "Triangle#C#menu"]->[_ "Triangle#C#menu"] \
            [_ "Quadrilateral#C#menu"]->[_ "Triangle#C#menu"] \
            --- \
            [_ "Tetrahedra#C#menu"]->[_ "Tetrahedra#C#menu"] \
            [_ "Hexahedra#C#menu"]->[_ "Tetrahedra#C#menu"] \
            [_ "Prism#C#menu"]->[_ "Tetrahedra#C#menu"] ]
    set MenuCommands(5,16,5) [list \
            {Meshing EditMesh SplitElems TriaToTria} \
            {Meshing EditMesh SplitElems QuadToTriangle} \
            {} \
            {Meshing EditMesh SplitElems TetraToTetra} \
            {Meshing EditMesh SplitElems HexaToTetra} \
            {Meshing EditMesh SplitElems PrismToTetra} \
            ]
    set MenuEntries(5,16,9) [list [_ "Mesh#C#menu"] --- [_ "Edges#C#menu"] [_ "Nodes#C#menu"] [_ "Elements#C#menu"] ]
    set MenuCommands(5,16,9) { {Utilities Collapse mesh} "" {Utilities Collapse edges} \
        {Utilities Collapse nodes} {Utilities Collapse elements} }
    
    set MenuEntries(5,16,10) ""
    
    #---------------

    set MenuEntries(6) [list  [_ "Calculate#C#menu"]]
    set MenuCommands(6) {{Utilities Calculate}}
    set MenuAcceler(6) {"F5"}
    set MenuIcons(6) {"calc.png"}
    if { ![GiD_Set CalculateRemote(Hide)] } {
        lappend MenuEntries(6) [_ "Calculate remote#C#menu"]
        lappend MenuCommands(6) {Utilities RemoteCalc}
        lappend MenuAcceler(6) ""
        lappend MenuIcons(6) ""
    }
    lappend MenuEntries(6) --- [_ "Cancel process#C#menu"] [_ "View process info#C#menu"]... [_ "Calculate window#C#menu"]...
    lappend MenuCommands(6) "" {Utilities CancelProcess} "-np- PWViewOutput" "-np- RunWin "
    lappend MenuAcceler(6) {"" "" "" ""}
    lappend MenuIcons(6) {"" "" "info.png" ""}

    #----------------
    
    #warning: don't remove this special comments, are to translate also this deprecated strings [_ "Visit %s web"] [_ "About %s"]
    
    set MenuEntries(7) [list [_ "Help#C#menu"]... [_ "Customization help#C#menu"]... [_ "Tutorials#C#menu"]... \
            [_ "What is new#C#menu"]... [_ "FAQ#C#menu"]... [_ "Courses#C#menu"]... [_ "Visit GiD forum#C#menu"]... \
            --- [_ "Register GiD#C#menu"] [_ "Register problem type#C#menu"]... \
            [_ "Register from file#C#menu"]...  --- [_ "Visit GiD web#C#menu"]...]
    set MenuCommands(7) [list {-np- GiDHelpWindow -type REFERENCE -start GRM} \
            {-np- GiDHelpWindow -type REFERENCE -start  GCM} \
            {-np- GiDHelpWindow -type REFERENCE -start GUM} \
            {-np- GiDHelpWindow -type REFERENCE -start GWN} \
            {-np- GiDHelpWindow -type REFERENCE -start  SD} \
            {-np- GiDHelpWindow -type REFERENCE -start  GCS} \
            [list -np- VisitWeb $GidPriv(WebForum)] \
            "" "" "" {-np- Register::RegisterFromFileWindow} \
            "" [list -np- VisitWeb $GidPriv(ProgWeb)]]
    set MenuAcceler(7) { F1 "" "" "" "" "" "" "" "" "" "" ""}
    set MenuIcons(7) {"help.png" "" "" "" "" "" "" "" "" "" "" ""}
    
    set MenuEntries(7,8) [list [_ "Local"]... [_ "USB"]... [_ "Floating"]...]
    set MenuCommands(7,8) "{-np- Register::GiD_Local 0} {-np- Register::GiD_Usb 0} {-np- Register::GiD_Floating 0}"
    set MenuAcceler(7,8) {"" "" ""}
    set MenuIcons(7,8) {"" "" ""}
    if { [info exists ::GID_LOGIN] && !$::GID_LOGIN_HIDE } {
        lappend MenuEntries(7,8) [_ "Named user"]...
        lappend MenuCommands(7,8) {-np- Login::Window}
        lappend  MenuAcceler(7,8) ""
        lappend MenuIcons(7,8) ""
    }
    
    set MenuEntries(7,9) [list [_ "Local"]... [_ "USB"]... [_ "Floating"]...]
    set MenuCommands(7,9) "{-np- Register::GiD_Local 1} {-np- Register::GiD_Usb 1} {-np- Register::GiD_Floating 1}"
    set MenuAcceler(7,9) {"" "" ""}
    set MenuIcons(7,9) {"" "" ""}
    
    if { [GiD_Set ShowCheckNewVersion] } {
        lappend MenuEntries(7) [_ "Check for updates#C#menu"]...
        lappend MenuCommands(7) {-np- PopupCheckNewVersion %X %Y}
        lappend MenuAcceler(7) ""
        lappend MenuIcons(7) ""
    } else {
        set new_server 1
        lassign [GetNewVersionUrlVariables $new_server] server gid_ftp_dir prefix extension os2look
        lappend MenuEntries(7) [_ "Visit GiD downloads#C#menu"]...
        set version_url $GidPriv(WebDownloadsDirect)\#$gid_ftp_dir/
        lappend MenuCommands(7) [list -np- VisitWeb $version_url]
        lappend MenuAcceler(7) ""
        lappend MenuIcons(7) ""
    }
    lappend MenuEntries(7) [_ "About#C#menu"]...
    lappend MenuCommands(7) {-np- CreateWelcomeWin}
    lappend MenuAcceler(7) ""
    lappend MenuIcons(7) ""
    
}
#-----------------------------------------------------------

proc SetBitmapNames {} {
    global BitMapsNames BitMapsShortNames BitMapsCommands BitmapsHelp GidPriv
    
    unset -nocomplain BitMapsNames BitMapsShortNames BitMapsCommands BitmapsHelp
    
    set BitMapsNames(0) { zoomin.png zframe.png \
        rotate.png pan.png --- line.png arc.png spline.png \
            --- surface.png volume.png object.png --- delete.png \
            list.png --- view_geom_mesh.png }
    
    set BitMapsShortNames(0) [list [_ "Zoom in"] [_ "Zoom frame"] \
            [_ "Rotate"] [_ "Pan"] "" [_ "Line"] [_ "Arc"] [_ "Spline"] \
            "" [_ "Surface"] [_ "Volume"] [_ "Objects"] "" [_ "Erase"] \
            [_ "List"] "" [_ "Switch geom-mesh"]]
    
    set BitMapsCommands(0) { {-np- DoZoom In} {-np- DoZoom Frame} \
        {-ne- 'Rotate trackball} {-ne- 'DynamicPan} "" \
            {Geometry Create Line} \
            {Geometry Create Arc} {Geometry Create NurbsLine} "" \
            {Geometry Create NurbsSurface} {Geometry Create volume} "" "" \
            {-np- AddBitmapsDeleteMenu %W toolbar} \
            {-np- AddEntitiesToMenuCommonEntities %W DoList 0} \
            "" {-np- ToggleGeomMesh} }
    
    set BitmapsHelp(0) [list [_ "Zoom in"] [_ "Zoom frame"] \
            [_ "Rotate trackball"] [_ "Pan dynamic"] "" [_ "Create line"] [_ "Create arc"] \
            [_ "Create nurbs line"] "" \
            [_ "Create NURBS surface"] [_ "Create volume"] \
            [_ "Create Object:\n  Rectangle\n Polygon\n  Circle\n  Sphere\n  Cylinder\n  Cone\n  Prism\n Thorus"]\
            "" [_ "Delete"] [_ "List entities"] "" [_ "Toggle geometry-mesh view"]]
    
    set BitMapsNames(0,11) { rectangle.png polygonPNR.png CirclePNR.png \
        sphere.png cylinder.png cone.png Prism.png tori.png }
    
    set BitMapsCommands(0,11) { {-np- DoCreateObjectRectangle} \
        {-np- DoCreateObjectPolygon} \
            {-np- DoCreateObjectCircle} {-np- DoCreateObjectSphere} \
            {-np- DoCreateObjectCylinder} {-np- DoCreateObjectCone} \
            {-np- DoCreateObjectPrism} {-np- DoCreateObjectTorus} }
    
    set BitMapsNames(0,13) {}
    set BitMapsCommands(0,13) {}
    
    set BitMapsNames(0,14) {}
    set BitMapsCommands(0,14) {}
}


#-----------------------------------------------------------

proc Set3dButtonVariables { } {
    global 3dButtonNames 3dButtonCommands 3dButtonIcons 3dButtonAcceler
    unset -nocomplain 3dButtonNames 3dButtonCommands 3dButtonIcons 3dButtonAcceler
    
    set what [GetCurrentPrePostMode]    
    if { $what == "POST" } {
        set lay_txt [_ "Mesh#C#menu"]
    } else {
        set lay_txt [_ "Layer#C#menu"]
    }

    if { [tk windowingsystem] eq "aqua"} {
        set M Command
    } else {
        set M Control
    }
    
    set 3dButtonNames(0) [list [_ "Contextual#C#menu"] --- [_ "Zoom#C#menu"] [_ "Rotate#C#menu"] [_ "Pan#C#menu"] \
            [_ "Redraw#C#menu"] [_ "Render#C#menu"] [_ "Label#C#menu"] $lay_txt \
            [_ "Switch full screen"]]        
    set 3dButtonCommands(0) { {-np- ContextualSubMenu %W} "" "" "" "" {-ne- 'Redraw } \
        {-np- AddEntitiesToMenuRender %W} "" "" {-np- SwitchFullScreen}}
    set 3dButtonIcons(0) { "" "" "" "" "" "redraw.png" "" "" "" "FullScreen.png" }   
    # on macOS Catalina accelerator key F11 is displayed as F1, ?may be due to accelerator restrictions?
    # in macOS Catalina F11 is used to clear/show the desktop
    # on macOS Catalina full screen accelerator usually is Shift+Command+F
    set 3dButtonAcceler(0) { "" "" "" "" "" "" "" "" "" "F11" }  
    
    if { $::tcl_platform(platform) == "windows" || $::tcl_platform(os) == "Darwin" } {
        lappend 3dButtonNames(0) --- [_ "Image to clipboard#C#menu"]       
        lappend 3dButtonCommands(0) "" {-np- after 100 { GiD_Process 'Hardcopy CopyClipboard}}
        lappend 3dButtonIcons(0) "" ""
    }
    
    set 3dButtonNames(0,0) {}
    set 3dButtonCommands(0,0) {}
    
    set 3dButtonNames(0,2) [list [_ "In#C#menu"] [_ "Out#C#menu"] --- [_ "Dynamic#C#menu"] [_ "Previous#C#menu"] [_ "Next#C#menu"] \
            --- [_ "Frame#C#menu"]]
    set 3dButtonCommands(0,2) { {-np- DoZoom In} {-np- DoZoom Out} "" {-np- DoZoom Dynamic} \
        {-np- DoZoom Previous} {-np- DoZoom Next} "" {-np- DoZoom Frame} }
    set 3dButtonIcons(0,2) { "zoomin.png" "zoomout.png" "" "" "" "" "" "zframe.png"}
    
    set 3dButtonNames(0,3) [list [_ "Trackball#C#menu"] [_ "Screen axes#C#menu"] [_ "Object axes#C#menu"] \
            [_ "Center#C#menu"] --- [_ "Plane XY (Original)#C#menu"] [_ "Plane XZ#C#menu"] [_ "Plane YZ#C#menu"] \
            [_ "Isometric X#C#menu"] [_ "Isometric Y#C#menu"] [_ "Isometric Z#C#menu"] ]
    set 3dButtonCommands(0,3) { {-ne- 'Rotate Trackball} {-ne- 'Rotate ScrAxes} \
        {-ne- 'Rotate ObjAxes}  {-ne- 'Rotate Center FJoin} \
        "" {-np- GidRotateView::PlaneXY} {-np- GidRotateView::PlaneXZ} {-np- GidRotateView::PlaneYZ} \
        {-np- GidRotateView::IsometricX} {-np- GidRotateView::IsometricY} {-np- GidRotateView::IsometricZ} \
    }
    set 3dButtonIcons(0,3) { "rotate.png" "" "" "" "" "view_rotate_xy.png" "view_rotate_xz.png" "view_rotate_yz.png" "isometric.png" "" ""}
    set 3dButtonAcceler(0,3) [list "" "" "" "" "" $M-1 $M-2 $M-3 $M-4 "" ""]
    
    
    set 3dButtonNames(0,4) [list [_ "Two point#C#menu"] [_ "Dynamic#C#menu"]]
    set 3dButtonCommands(0,4) { {-ne- 'Pan} {-ne- 'DynamicPan} }
    set 3dButtonIcons(0,4) { "" "pan.png" }
    
    set 3dButtonNames(0,6) {}
    set 3dButtonCommands(0,6) {}   
    set 3dButtonNames(0,7) [list [_ "All on#C#menu"] [_ "All on in#C#menu"] [_ "Select on#C#menu"] --- \
            [_ "All off#C#menu"] [_ "All off in#C#menu"] [_ "Select off#C#menu"] --- \
            [list -CB2- DrawOverwrittenLabels [_ "Draw overwritten"]]]
    proc ::ToggleDrawOverwrittenLabels { } {
        set ::GidPriv(DrawOverwrittenLabels) [GiD_Set DrawOverwrittenLabels [expr abs( [GiD_Set DrawOverwrittenLabels] - 1)]]
        GiD_Process 'Redraw
    }
    set 3dButtonCommands(0,7) { {-ne- 'Label All} \
        {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOn}} \
            {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOn Select}} \
            {} \
            {-ne- 'Label Off} \
            {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOff}} \
            {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOff Select}} \
            {} {-np- ::ToggleDrawOverwrittenLabels} \
        }
    #set 3dButtonCommands(0,7,8) { set ::GidPriv(DrawOverwrittenLabels) [GiD_Set DrawOverwrittenLabels [expr abs( [GiD_Set DrawOverwrittenLabels] - 1)]]}
    set ::GidPriv(DrawOverwrittenLabels) [GiD_Set DrawOverwrittenLabels]
    foreach i {1 2 5 6} {
        set 3dButtonNames(0,7,$i) {}
        set 3dButtonCommands(0,7,$i) {}
    }    
    
    if { "$what" == "PRE"} {
        set 3dButtonNames(0,8) [list [_ "New#C#menu"] [_ "On#C#menu"] [_ "Off#C#menu"] [_ "To use#C#menu"] [_ "Send#C#menu"] [_ "Window#C#menu"]]
        set 3dButtonCommands(0,8) { {-np- Layers::CreateNewLayer} \
            {-np- AddLayerOnOff ON %W {GiD_Process 'Layers On}} \
            {-np- AddLayerOnOff OFF %W {GiD_Process 'Layers Off}} \
                {-np- AddLayerOnOff TOUSE %W {GiD_Process 'Layers ToUse}} \
            {-np- LayerEntities %W} {-np- Layers::ChangeLayers} }
        set 3dButtonIcons(0,8) { "" "" "" "" "" "layers.png" }
        
        set 3dButtonNames(0,8,1) {}
        set 3dButtonNames(0,8,2) {}
        set 3dButtonNames(0,8,3) {}
        set 3dButtonNames(0,8,4) {}
        
        set 3dButtonCommands(0,8,1) {}
        set 3dButtonCommands(0,8,2) {}
        set 3dButtonCommands(0,8,3) {}
        set 3dButtonCommands(0,8,4) {}
    } else {
        # "$what" == POST
        set 3dButtonNames(0,8) [list "" "" "" [_ "Send#C#menu"] [_ "Window#C#menu"]]
        set 3dButtonCommands(0,8) { \
            {-np- AddBitmapsToMeshSetCut %W { GiD_Process Mescape Select} volumesets} \
            {-np- AddBitmapsToMeshSetCut %W { GiD_Process Mescape Select} surfacesets} \
                {-np- AddBitmapsToMeshSetCut %W { GiD_Process Mescape Select} cutsets} \
            { Select Elements} {-np- PostDisplay} }
        set 3dButtonIcons(0,8) { "meshes.png" "surfacesets.png" "cuts.png" "" "layers.png" }
        
        set 3dButtonNames(0,8,0) ""
        set 3dButtonNames(0,8,1) ""
        set 3dButtonNames(0,8,2) ""
        
        set 3dButtonCommands(0,8,0) ""
        set 3dButtonCommands(0,8,1) ""
        set 3dButtonCommands(0,8,2) ""
    }
}

#
proc Set3dButtonVariablesGraph { } {
    global 3dButtonNamesGraph 3dButtonCommandsGraph 3dButtonIconsGraph 3dButtonAccelerGraph
    unset -nocomplain 3dButtonNamesGraph 3dButtonCommandsGraph 3dButtonIconsGraph 3dButtonAccelerGraph    
    
    set 3dButtonNamesGraph(0) [list [_ "Contextual#C#menu"] --- [_ "Zoom#C#menu"] [_ "Pan#C#menu"] [_ "Redraw#C#menu"] \
            [_ "Label#C#menu"] [_ "Import graph#C#menu"]... [_ "Export graph#C#menu"] [_ "Clipboard copy graph#C#menu"]] 
    
    set 3dButtonCommandsGraph(0) { {-np- ContextualSubMenu %W} "" ""  "" {-ne- 'Redraw } \
        "" {results graphs readgraph} {-np- AddGraphSetsToMenu %W ExportGraphSet 1} {-np- AddGraphSetsToMenu %W ClipboardCopyGraphSet 1} }
    set 3dButtonIconsGraph(0) { "" "" "" "" "redraw.png" "" "" "" }
    set 3dButtonAccelerGraph(0) { "" "" "" "" "" "" "" "" }
    
    if { $::tcl_platform(platform) == "windows" || $::tcl_platform(os) == "Darwin" } {
        lappend 3dButtonNamesGraph(0) --- [_ "Image to clipboard#C#menu"]
        lappend 3dButtonCommandsGraph(0) "" {-ne- 'Hardcopy CopyClipboard}
        lappend 3dButtonIconsGraph(0) "" ""
    }       
    
    set 3dButtonNamesGraph(0,0) {}
    set 3dButtonCommandsGraph(0,0) {}
    
    set 3dButtonNamesGraph(0,2) [list [_ "In#C#menu"] [_ "Out#C#menu"] --- [_ "Dynamic#C#menu"] [_ "Previous#C#menu"] [_ "Next#C#menu"] \
            --- [_ "Frame#C#menu"]]
    set 3dButtonCommandsGraph(0,2) { {-np- DoZoom In} {-np- DoZoom Out} "" {-np- DoZoom Dynamic} \
        {-np- DoZoom Previous} {-np- DoZoom Next} "" {-np- DoZoom Frame}}
    set 3dButtonIconsGraph(0,2) { "zoomin.png" "zoomout.png" "" "" "" "" "" "zframe.png"}    
    
    set 3dButtonNamesGraph(0,3) [list [_ "Two point#C#menu"] [_ "Dynamic#C#menu"]]
    set 3dButtonCommandsGraph(0,3) { {-ne- 'Pan} {-ne- 'DynamicPan} }
    set 3dButtonIconsGraph(0,3) { "" "pan.png" }
    
    set 3dButtonNamesGraph(0,5) [list [_ "All on#C#menu"] [_ "All on in#C#menu"] [_ "Select on#C#menu"] --- [_ "All off#C#menu"] [_ "Select off#C#menu"]]
    set 3dButtonCommandsGraph(0,5) { {-ne- 'Label All} \
        {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOn}} \
        {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOn Select}} \
            {} \
        {-ne- 'Label Off} \
            {-ne- 'Label SetToOff Select Nodes} \
    }
    foreach i {1 2} {
        set 3dButtonNamesGraph(0,5,$i) {}
        set 3dButtonCommandsGraph(0,5,$i) {}
    }
    
    set 3dButtonNamesGraph(0,7) ""    
    set 3dButtonCommandsGraph(0,7) ""
    set 3dButtonNamesGraph(0,8) ""
    set 3dButtonCommandsGraph(0,8) ""
}

#------------------------------------------------------------------------

proc SetMenusVariablesP {} {
    global MenuNamesP MenuEntriesP MenuCommandsP MenuAccelerP MenuIconsP
    global tcl_platform GidPriv GIDDEFAULT
    
    unset -nocomplain MenuNamesP MenuEntriesP MenuCommandsP MenuAccelerP MenuIconsP
    
    if {[tk windowingsystem] eq "aqua"} {
        set M Command
    } else {
        set M Control
    }
    
    
    set MenuNamesP [list [_ "Files#C#menu"] [_ "View#C#menu,verb"] [_ "Geometry#C#menu"] [_ "Utilities#C#menu"] \
            [_ "View results#C#menu"] [_ "Window#C#menu"] [_ "Help#C#menu"]]
    
    #-----------------
    set MenuEntriesP(0) [list [_ "New#C#menu"] [_ "Open#C#menu"]... [_ "Open multiple#C#menu"]... [_ "Merge#C#menu"]... \
            [_ "Recent post files#C#menu"] [_ "Save as..."] --- \
            [_ "Import#C#menu"] [_ "Export#C#menu"] --- [_ "Preprocess#C#menu"] [_ "Recent projects#C#menu"] --- \
            [_ "Print to file#C#menu"] [_ "Page and capture settings#C#menu"]... [_ "Print#C#menu"] --- \
            [_ "Quit#C#menu"] ]
    set MenuCommandsP(0) { {-np- DoFilesNew ASK} {-np- FilesOpenPostAllFormatsWin} {-np- FilesOpenPostMultipleWin} {Files Add} \
                               {-np- AddEntitiesToMenuRecentPostFiles %W} {Files SaveAll HDF5GidPost} \
                               "" "" "" \
                               "" {-np- DoPreprocess} {-np- AddEntitiesToMenuRecentProjects %W} "" \
                               "" {-np- PageSetup} {-np- HardcopyToPrint} "" \
                               {-np- QuitFullScreen} }
    
    set MenuAccelerP(0) [list $M-n $M-o "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" $M-q]
    set MenuIconsP(0) { "new.png" "open.png" "openMultiple.png" "" "" "saveas.png" "" "" "" "" "surface.png" "" "" \
                            "camera.png" "" "print.png" "" "exit.png" }

    set MenuEntriesP(0,4) ""
    
    set MenuEntriesP(0,7) [list VTK... [_ "%s mesh#C#menu" NASTRAN]... FEMAP... \
            "TECPLOT..." "3D Studio..." \
            "CGNS..." \
            [_ "XYZ nodes#C#menu"]... --- \
            [_ "Cut#C#menu"]...  [_ "Graph#C#menu"]... \
            [_ "Stream lines"]... --- \
            [_ "Plugins#C#menu"]...]
    
    set MenuCommandsP(0,7) { {Files VTKRead} {Files ReadNASTRAN} {Files ReadFEMAP} \
        {Files ReadTECPLOT} {Files Read3DStudio} \
        {Files ReadCGNS} \
        {Files ReadXYZascii} "" \
        {Files ReadCut} {Results Graphs ReadGraph}  \
        {Results Options StreamRead} "" \
        {-np- AddPostImportPluginsToMenuLazy %W} }
    
    set MenuEntriesP(0,7,12) ""
    
    set MenuEntriesP(0,8) [list [_ "Post information#C#menu"] [_ "Cut#C#menu"] [_ "Graph#C#menu"] \
            [_ "Cover mesh#C#menu"]... \
            VTK... \
            [_ "Visible surfaces to STL"]... [_ "Visible surfaces to PLY"]... ]
    
    set MenuCommandsP(0,8) { "" \
        {-np- AddCutsToMenu %W { GiD_Process Mescape Files SaveCut}} \
        {-np- AddGraphSetsToMenu %W ExportGraphSet 1} \
        {Files savecovermesh} {Files VTKWrite} \
        {Files SaveSTLSurfaces} {Files SavePLYSurfaces} \
        }    
    
    set MenuEntriesP(0,8,0) [list [_ "ASCII files#C#menu"]... [_ "Binary (whole model)#C#menu"]... \
            [_ "Binary (only results)#C#menu"]... [_ "ASCII boundaries#C#menu"]... \
            [_ "Stream lines"]... ]
    
    set MenuCommandsP(0,8,0) { {Files SaveAll AllMeshesSets} {Files SaveAll BinMeshesSets} \
        {Files SaveAll BinRes} {Files SaveAll Boundaries} \
            {Results Options StreamSave}}
    
    set MenuEntriesP(0,8,1) ""
    set MenuCommandsP(0,8,1) ""
    
    set MenuEntriesP(0,8,2) ""
    set MenuCommandsP(0,8,2) ""
    
    set MenuEntriesP(0,11) ""
    set MenuCommandsP(0,11) ""
    
    set MenuEntriesP(0,13) [list [_ "PS/EPS/PDF screen#C#menu"]... [_ "PS/EPS/PDF vectorial#C#menu"]... --- \
            [_ "BMP#C#menu"]... [_ "GIF#C#menu"]... [_ "JPEG#C#menu"]... [_ "PNG#C#menu"]... \
            [_ "TGA#C#menu"]... [_ "TIFF#C#menu"]... \
            [_ "VRML#C#menu"]... [_ "STL#C#menu"]... [_ "OBJ#C#menu"]... \
            [_ "SVG#C#menu"]... [_ "PGF#C#menu"]...]
    
    set MenuCommandsP(0,13) [list "" "" "" \
            {-np- DoPrintToFile BMP .bmp} \
            {-np- DoPrintToFile GIF .gif} \
            {-np- DoPrintToFile JPEG {.jpg .jpeg}} \
            {-np- DoPrintToFile PNG .png} \
            {-np- DoPrintToFile TGA .tga} \
            {-np- DoPrintToFile TIFF {.tif .tiff}} \
            {-np- DoPrintToFile VRML {.wrl .vrml}} \
            {-np- DoPrintToFile STL .stl} \
            {-np- DoPrintToFile OBJ .obj} \
            {-np- DoPrintToFile SVG .svg} \
            {-np- DoPrintToFile PGF .pgf}]
    
    set MenuEntriesP(0,13,0) [list [_ "PS#C#menu"]... [_ "EPS#C#menu"]... [_ "PDF#C#menu"]...]
    set MenuCommandsP(0,13,0) { {-np- DoPrintToFile PS .ps 0} \
        {-np- DoPrintToFile EPS .eps 0} \
        {-np- DoPrintToFile PDF .pdf 0}}
    
    set MenuEntriesP(0,13,1) [list [_ "PS#C#menu"]... [_ "EPS#C#menu"]... [_ "PDF#C#menu"]...]
    set MenuCommandsP(0,13,1) { {-np- DoPrintToFile PS .ps 1} \
        {-np- DoPrintToFile EPS .eps 1} \
        {-np- DoPrintToFile PDF .pdf 1}}
    
    #-----------------
    
    #copyclipboard only available for windows and macOs
    if { $::tcl_platform(platform) == "windows" || $::tcl_platform(os) == "Darwin" } {
        set MenuEntriesP(1) [list [_ "Zoom#C#menu"] [_ "Rotate#C#menu"] [_ "Pan#C#menu"] --- \
                [_ "Redraw#C#menu"] [_ "Render#C#menu"] [_ "Perspective#C#menu"]... \
                [_ "Clip planes#C#menu"]... [_ "Advanced viewing settings#C#menu"]... \
                --- [_ "Reference axes#C#menu"]... --- [_ "Label#C#menu"] [_ "View#C#menu,noun"] \
                [_ "Recent view files#C#menu"] --- [_ "Background image#C#menu"] \
                [_ "Image to clipboard#C#menu"] \
                [_ "Multiple windows#C#menu"]... --- \
                [_ "Mode#C#menu"] [_ "Full screen"]]
        set MenuCommandsP(1) [list "" "" "" "" \
                {-ne- 'Redraw } {-np- AddEntitiesToMenuRender %W} {-np- PerspectiveW} \
                {-np- ClipPlanes} {-np- StereoW} "" \
                {-np- GlobalAxis::ChangeAxis} "" "" "" {-np- AddEntitiesToMenuRecentViewFiles %W} "" \
                {-np- AddEntitiesToMenuBackgroundImage %W} {-ne- 'HardCopy CopyClipboard} \
                ""  "" [list -np- AddEntitiesToMenuViewMode %W] {-np- SwitchFullScreen}]       
        set MenuAccelerP(1) { "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "F11"}
        set MenuIconsP(1) { "" "" "" "" "redraw.png" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "FullScreen.png"}
        set idxMultipleWindows 18
        set idxViewMode 20
    } else {
        set MenuEntriesP(1) [list [_ "Zoom#C#menu"] [_ "Rotate#C#menu"] [_ "Pan#C#menu"] --- \
                [_ "Redraw#C#menu"] [_ "Render#C#menu"] [_ "Perspective#C#menu"]... \
                [_ "Clip planes#C#menu"]... [_ "Advanced viewing settings#C#menu"]... \
                --- [_ "Reference axes#C#menu"]... --- [_ "Label#C#menu"] [_ "View#C#menu,noun"] \
                [_ "Recent view files#C#menu"] --- [_ "Background image#C#menu"] \
                [_ "Multiple windows#C#menu"]... --- \
                [_ "Mode#C#menu"] [_ "Full screen"]]
        set MenuCommandsP(1) [list "" "" "" "" \
                {-ne- 'Redraw } {-np- AddEntitiesToMenuRender %W} {-np- PerspectiveW} \
                {-np- ClipPlanes} {-np- StereoW} "" \
                {-np- GlobalAxis::ChangeAxis} "" "" "" {-np- AddEntitiesToMenuRecentViewFiles %W} "" \
                {-np- AddEntitiesToMenuBackgroundImage %W} "" "" \
                [list -np- AddEntitiesToMenuViewMode %W] {-np- SwitchFullScreen}]       
        set MenuAccelerP(1) { "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "F11"}
        set MenuIconsP(1) { "" "" "" "" "redraw.png" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "FullScreen.png"}
        set idxMultipleWindows 16
        set idxViewMode 18
    }
    
    set MenuEntriesP(1,0) [list [_ "In#C#menu"] [_ "Out#C#menu"] --- [_ "Dynamic#C#menu"] [_ "Previous#C#menu"] \
            [_ "Next#C#menu"] --- [_ "Frame#C#menu"] ]
    set MenuCommandsP(1,0) { {-np- DoZoom In} {-np- DoZoom Out} "" {-np- DoZoom Dynamic} {-np- DoZoom Previous} {-np- DoZoom Next} "" {-np- DoZoom Frame} }
    set MenuIconsP(1,0) { "zoomin.png" "zoomout.png" "" "" "" "" "" "zframe.png"}
    
    set MenuEntriesP(1,1) [list [_ "Trackball#C#menu"] [_ "Screen axes#C#menu"] [_ "Object axes#C#menu"] \
            [_ "Center#C#menu"] --- [_ "Plane XY (Original)#C#menu"] [_ "Plane XZ#C#menu"] \
            [_ "Plane YZ#C#menu"] \
            [_ "Isometric X#C#menu"] [_ "Isometric Y#C#menu"] [_ "Isometric Z#C#menu"] ]
    
    set MenuCommandsP(1,1) { {-ne- 'Rotate Trackball} {-ne- 'Rotate ScrAxes} \
        {-ne- 'Rotate ObjAxes}  {-ne- 'Rotate Center FJoin} \
        "" {-np- GidRotateView::PlaneXY} {-np- GidRotateView::PlaneXZ} {-np- GidRotateView::PlaneYZ} \
        {-np- GidRotateView::IsometricX} {-np- GidRotateView::IsometricY} {-np- GidRotateView::IsometricZ} \
        }
    set MenuIconsP(1,1) { "rotate.png" "" "" "" "view_rotate_xy.png" "view_rotate_xz.png" "view_rotate_yz.png" "isometric.png" "" ""}
    
    set MenuEntriesP(1,2) [list [_ "Two point#C#menu"] [_ "Dynamic#C#menu"]]
    set MenuCommandsP(1,2) { {-ne- 'Pan} {-ne- 'DynamicPan} }
    set MenuIconsP(1,2) { "" "pan.png" }
    
    set MenuEntriesP(1,5) ""
    set MenuCommandsP(1,5) ""
    
    set MenuEntriesP(1,12) [list [_ "All on#C#menu"] [_ "All on in#C#menu"] [_ "Select on#C#menu"] --- [_ "All off#C#menu"] [_ "All off in#C#menu"]  [_ "Select off#C#menu"]]
    set MenuCommandsP(1,12) { {-ne- 'Label All} \
        {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOn}} \
        {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOn Select}} \
            {} \
        {-ne- 'Label Off} \
            {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOff}} \
        {-np- AddEntitiesToMenuCommonEntities %W {GiD_Process 'Label SetToOff Select}} \
        }    
    foreach i {1 2 5 6} {
        set MenuEntriesP(1,12,$i) {}
        set MenuCommandsP(1,12,$i) {}
    }    
    
    set MenuEntriesP(1,13) [list [_ "Read#C#menu"]... [_ "Save#C#menu"]...]
    set MenuCommandsP(1,13) { {escape escape escape escape escape escape View ReadView} \
        {escape escape escape escape escape escape View SaveView} }
    
    set MenuEntriesP(1,14) {}
    set MenuCommandsP(1,14) {}
    
    set MenuEntriesP(1,16) [list [_ "Fit screen#C#menu"]... [_ "Real size#C#menu"]... [_ "Default#C#menu"] ]
    set MenuCommandsP(1,16) { { Utilities BackgroundImg BackgroundImg} \
        { Utilities BackgroundImg RealSizeImg} { Utilities BackgroundImg Default} }
    
    set MenuEntriesP(1,$idxMultipleWindows) {}
    set MenuIconsP(1,$idxMultipleWindows) {}
    set MenuCommandsP(1,$idxMultipleWindows) {}
    foreach mw [list 1 2LR 2UD 3L 3U 3R 3D 4 EXT] {
        lappend MenuEntriesP(1,$idxMultipleWindows) ""
        lappend MenuIconsP(1,$idxMultipleWindows) mwindows_${mw}.png
        lappend MenuCommandsP(1,$idxMultipleWindows) [list -np- GiD_Project set windows_layout $mw]
    }
    
    # view mode
    set MenuEntriesP(1,$idxViewMode) ""
    set MenuIconsP(1,$idxViewMode) ""
    set MenuCommandsP(1,idxViewMode) ""
    
    #-----------------
    
    # set MenuEntriesP(2) [list [_ "Cut plane#C#menu"] [_ "Cut 2D polygonal#C#menu"] [_ "Cut sphere#C#menu"] \
    #         [_ "Divide#C#menu"] [_ "Join#C#menu"] --- \
    #         [_ "Covering mesh#C#menu"] [_ "Create delaunay meshes#C#menu"] [_ "Extract boundaries#C#menu"] \
    #         [_ "Separate connected components#C#menu"] [_ "Swap orientation of visible surface meshes#C#menu"] \
    #         [_ "Collapse nodes#C#menu"] --- [_ "Convert#C#menu"]] 
    # set MenuCommandsP(2) {  ""  { DoCut CutWire} \
    #     { DoCut CutShape Sphere} "" "" "" {Results Options ShowCoverMesh} "" \
    #     {Results Options ExtractBoundaries} \
    #         {Results Options SeparateConnectedComponents} {Results Options SwapOrientation} {Utilities Collapse} "" ""}
    set MenuEntriesP(2) [list [_ "Cut plane#C#menu"] [_ "Cut 2D polygonal#C#menu"] [_ "Cut sphere#C#menu"] \
            [_ "Divide#C#menu"] [_ "Join#C#menu"] --- \
            [_ "Covering mesh#C#menu"] [_ "Create delaunay meshes#C#menu"] [_ "Extract boundaries#C#menu"] \
            [_ "Separate connected components#C#menu"] [_ "Swap orientation of visible surface meshes#C#menu"] \
            --- [_ "Convert#C#menu"]] 
    set MenuCommandsP(2) {  ""  { DoCut CutWire} \
        { DoCut CutShape Sphere} "" "" "" {Results Options ShowCoverMesh} "" \
        {Results Options ExtractBoundaries} \
            {Results Options SeparateConnectedComponents} {Results Options SwapOrientation} "" ""}
    set MenuAccelerP(2) {"" "" "" "" "" "" "" "" "" "" "" "" ""}
    set MenuIconsP(2) {"docut.png" "" "" "" "" "" "" "" "" "" "" "" "" ""}
    
    set MenuEntriesP(2,0) [list [_ "2 points#C#menu"] [_ "3 points#C#menu"] [_ "Succesion#C#menu"]]
    set MenuCommandsP(2,0) { { DoCut CutPlane} { DoCut CutPlane ThreePoints} { DoCut Succesion}}
    set MenuIconsP(2,0) {"cut2p.png" "cut3p.png" "cut_succesion.png"}
    
    set MenuEntriesP(2,3) [list [_ "Volume sets#C#menu"] [_ "Surface sets#C#menu"] [_ "Lines#C#menu"] ]
    set MenuCommandsP(2,3) ""
    
    set MenuEntriesP(2,3,0) [list [_ "2 points#C#menu"] [_ "3 points#C#menu"] ]
    set MenuCommandsP(2,3,0) { { DoCut DivideMesh} { DoCut DivideMesh ThreePoints} }
    
    set MenuEntriesP(2,3,1) [list [_ "2 points#C#menu"] [_ "3 points#C#menu"] ]
    set MenuCommandsP(2,3,1) { { DoCut DivideSets} { DoCut DivideSets ThreePoints} }
    
    set MenuEntriesP(2,3,2) [list [_ "2 points#C#menu"] [_ "3 points#C#menu"] ]
    set MenuCommandsP(2,3,2) { { DoCut DivideLines} { DoCut DivideLines ThreePoints} }
    
    set MenuEntriesP(2,4) [list [_ "Volume sets#C#menu"] [_ "Surface sets#C#menu"] ]
    set MenuCommandsP(2,4) { { Utilities Join Meshes} { Utilities Join Sets} }
    
    set MenuEntriesP(2,7) [list [_ "One for each visible mesh"] [_ "Single mesh for all visible meshes"] \
            [_ "Single mesh for all points"] [_ "Force triangles"]]
    
    set MenuCommandsP(2,7) {{Results Options ShowDelaunayMesh VisibleMeshes} \
        {Results Options ShowDelaunayMesh AllVisibleMeshes} \
        {Results Options ShowDelaunayMesh AllPoints} ""}
    
    set MenuEntriesP(2,7,3) [list [_ "One for each visible mesh"] \
            [_ "Single mesh for all visible meshes"] \
            [_ "Single mesh for all points"]]
    
    set MenuCommandsP(2,7,3) {{Results Options ShowDelaunayMesh ForceTriangles VisibleMeshes} \
        {Results Options ShowDelaunayMesh ForceTriangles AllVisibleMeshes} \
        {Results Options ShowDelaunayMesh ForceTriangles AllPoints}}
    
    set MenuEntriesP(2,12) [list [_ "Cuts to sets (creates all results)#C#menu"] \
            [_ "Iso surfaces (all) to cuts (interpolates results on demand)#C#menu"] \
            [_ "Iso surfaces (visible) to cuts (interpolates results on demand)#C#menu"] \
            [_ "Iso surfaces to sets (creates all results)#C#menu"] \
            ]
    set MenuCommandsP(2,12) { {DoCut ConvertToSets ALL_CUTSETS} \
        {Mescape Results isosurfaces TurnIntoCuts Mescape Results Geometry NoResults } \
        {Mescape Results isosurfaces TurnVisibleIntoCuts Mescape Results Geometry NoResults } \
        {-np- PostIsoSurfacesToSets}}
    
    
    #-----------------
    
    set MenuEntriesP(3) [list  [_ "Preferences#C#menu"]... --- \
            [_ "Tools#C#menu"] --- [_ "Copy#C#menu"] [_ "Status#C#menu"]... [_ "List#C#menu"] \
            [_ "Id#C#menu"] [_ "Signal#C#menu"] [_ "Distance#C#menu"] [_ "Dimension#C#menu"] --- \
            [_ "Scale result view#C#menu"] [_ "Set contour limits#C#menu"] --- \
            [_ "Texture#C#menu"]]
    set MenuCommandsP(3) { {-np- PreferencesWindow} "" "" "" {-np- CopyMove Copy} \
        {-np- ListEntities status} "" {Utilities Id}  \
        {-np- AddEntitiesToMenuSignalEntities %W} \
            {Utilities dist} "" "" {-np- PostScaleResultMenu %W} "" "" ""}
    set MenuAccelerP(3) [list $M-p "" "" "" [AcceleratorShift $M c] "" "" "" "" "" "" "" "" "" "" ""]
    set MenuIconsP(3) { "prefs.png" "" "" "" "copy.png" "" \
        "list.png" "" "" "" "" "" "" "" "" ""}
    
    set MenuEntriesP(3,2) [list [_ "Toolbars#C#menu"]... ---  \
            [_ "Move screen objects#C#menu"] --- \
            [_ "Read batch window#C#menu"]... \
            [_ "Comments#C#menu"]... [_ "Change legend title#C#menu"] \
            [_ "Animation controls#C#menu"]... [_ "Animation script#C#menu"]... \
            [_ "Macros#C#menu"]... --- [_ "Calculator#C#menu"]... [_ "Report#C#menu"]... \
            [_ "Notes#C#menu"]...]
    set MenuCommandsP(3,2) { {-np- TOBegin} \
        "" {-ne- 'MoveScrObj} "" \
        {-np- ReadBatch} {-np- CommentsW} {Results ContOptions ChangeTitleLeg}\
            {-np- PostAnimateControlsWindow} {-np- ::AutoAnimate::Create} {-np- toolbarmacros::MacrosWindow} \
        "" {-np- CalculatorV} {-np- GIDReport::Create} {-np- GidUtils::OpenWindow NOTES}}
    set MenuAccelerP(3,2) { "" "" "" "" "" "" "" "" "" "" ""  "" "" ""}
    set MenuIconsP(3,2) {"" "" "" "" "" "" "" "tool-animator.png" "" "edit_file.png" "" "" "Report.png" "note.png"}

    if { ![info exists GidPriv(DevelopMenuState)] } {
        set GidPriv(DevelopMenuState) 1
    }
    if { $GidPriv(DevelopMenuState) } {
        set pos 2
        lappend MenuEntriesP(3,$pos) [_ "Develop#C#menu"]
        lappend MenuAccelerP(3,$pos) ""
        lappend MenuIconsP(3,$pos) ""
        lappend  MenuCommandsP(3,$pos) ""
        set MenuEntriesP(3,$pos,14) [list [_ "Debugger"]... [_ "Console Tcl#C#menu"]... [_ "Console Python#C#menu"]... \
            [list -CB2- ProfileTcl [_ "Profile Tcl"]...] \
            [list -CB2- ShowProcessCommands [_ "Show process commands"]] \
            [list -CB2- ShowProcessCommandsViewFuntions [_ "Show process commands view"]]]
        set MenuAccelerP(3,$pos,14) {F12 "" "" "" "" ""}
        set MenuIconsP(3,$pos,14) {"" "console.png" "console.png" "" "eye.png" "eye.png"}
        set MenuCommandsP(3,$pos,14) {{-np- package require RamDebugger} {-np- GidUtils::OpenWindow CONSOLE} {-np- GidUtils::OpenWindow CONSOLE_PYTHON} {} {} {}}
    }
    
    set MenuEntriesP(3,6)  [list [_ "Nodes#C#menu"] [_ "Elements#C#menu"]]
    set MenuCommandsP(3,6) { {-np- DoList Nodes} {-np- DoList Elements} }
    set MenuIconsP(3,6) {node.png element.png }
    
    set MenuEntriesP(3,8) ""
    
    #set MenuEntriesP(3,4) [list [_ "Nodes in Sets#C#menu"] ]
    #set MenuCommandsP(3,4) { { Utilities collapse nodesinsets} }
    
    set MenuEntriesP(3,10) [list [_ "Create#C#menu"] [_ "Delete#C#menu"] [_ "Edit#C#menu"] [_ "ShowBox#C#menu"] ]
    set MenuCommandsP(3,10) { "" {Utilities Dimension Delete} \
        {Utilities Dimension Edit} "" }
    
    set MenuEntriesP(3,10,0) [list [_ "Vertex#C#menu"] [_ "Distance#C#menu"] [_ "Angle#C#menu"] [_ "Radius#C#menu"] [_ "Text#C#menu"] ]
    set MenuCommandsP(3,10,0) { {Utilities Dimension Create Vertex} {Utilities Dimension Create Distance} \
        {Utilities Dimension Create Angle} {Utilities Dimension Create Radius} \
        {Utilities Dimension Create Text} }
    
    set MenuEntriesP(3,10,3) [list [_ "On#C#menu"] [_ "Off#C#menu"] ]
    set MenuCommandsP(3,10,3) { {Utilities Dimension ShowBox} {Utilities Dimension HideBox} }
    
    set MenuEntriesP(3,12) ""
    set MenuCommandsP(3,12) ""
    
    set MenuEntriesP(3,13) [list [_ "Define limits#C#menu"]... [_ "Reset limits#C#menu"] ]
    set MenuCommandsP(3,13) { {-np- PostContLimitsWin } \
        { Mescape Results ContOptions SetMaxOptions ResetValue escape \
            Mescape Results ContOptions SetMinOptions ResetValue escape \
                Mescape Utilities Redisplay escape } \
    }
    
    
    
    #                                  { Results ContOptions FixAnalysisLim escape escape escape escape Utilities Redisplay }
    #                                  { Results ContOptions FixAbsLimits escape escape escape escape Utilities Redisplay }
    
    set MenuEntriesP(3,15) [list [_ "View#C#menu"] [_ "Add#C#menu"] [_ "Change#C#menu"]]
    set MenuCommandsP(3,15) { "" "" "" }
    
    set MenuEntriesP(3,15,0) [list [_ "No#C#menu,nothing, None#C#menu"] [_ "Fast#C#menu"] [_ "Nice#C#menu"] ]
    set MenuCommandsP(3,15,0) { { Utilities Texture lit} { Utilities Texture FastTexture} { Utilities Texture NiceTexture}}
    
    set MenuEntriesP(3,15,1) [list [_ "Screen map#C#menu"]... [_ "To 4 sided set#C#menu"]... [_ "BoundImg to boundSet#C#menu"]... ]
    set MenuCommandsP(3,15,1) { { Utilities Texture AddTexture} { Utilities Texture AddTo4Sided} { Utilities Texture Addbtob}}
    
    set MenuEntriesP(3,15,2) [list [_ "Flip horiz.#C#menu"] [_ "Flip vert.#C#menu"] ]
    set MenuCommandsP(3,15,2) { { Utilities Texture FlipS} { Utilities Texture FlipT}}  
    
    #----------------
    
    set MenuEntriesP(4) [list [_ "No results#C#menu"] [_ "Delete#C#menu"] --- [_ "Default analysis/step#C#menu"] --- \
            [_ "Contour fill#C#menu"] [_ "Contour lines#C#menu"] \
            [_ "Contour ranges#C#menu"] [_ "Show min max#C#menu"] \
            [_ "Display vectors#C#menu"] [_ "Iso surfaces#C#menu"] [_ "Stream lines#C#menu"] \
            [_ "Node trace"] [_ "Graphs#C#menu"] [_ "Result surface#C#menu"] \
            [_ "Deformation#C#menu"] [_ "Line diagram#C#menu"] [_ "Line thickness#C#menu"] \
            [_ "Integrate"] [_ "Distribution"]...]
    # AddResultsToMenu inside Contour_Fill / Contour_Lines also adds a submenu for Smooth_Contour_Fill and Smooth_Contour_lines
    set MenuCommandsP(4) { {-np- PostNoResults} "" \
        ""  {-npm- AddAnalysisStepsToMenu %W} "" \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results ContourFill} Contour_Fill} \
            {-npm- AddResultsToMenu %W {GiD_Process Mescape Results ContourLines} Contour_Lines} \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results ContourRanges} Contour_Ranges} \
            ""
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results DisplayVectors} Display_Vectors} \
        "" \
            "" \
        {Mescape Results NodeTrace followNodes} \
            "" \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results ResultSurface} Result_Surface} \
            {-npm- AddResultsToMenu %W {GiD_Process Mescape Results Geometry Deformation} Deformation} \
        "" \
            {-npm- AddResultsToMenu %W {GiD_Process Mescape Results LineThickness} Line_Thickness} \
        "" {-np- PostResultQuality} }
    #  {-npm- AddResultsToMenu %W {GiD_Process Mescape Results NodeTrace} Node_Trace} \
        
    set MenuAccelerP(4) {"" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" ""}
    set MenuIconsP(4) {element.png "" "" PostBarAnalysisStep.png "" PostBarContourFill.png PostBarContourLines.png \
        "" PostBarShMinMax.png PostBarVectors.png PostBarIsoSurfaces.png PostBarStreamLines.png \
        "" graphs.png PostBarResultSurface.png PostBarDeformation.png "" PostBarLineThickness.png \
            PostBarGraphIntegrate.png ""}
    
    set MenuEntriesP(4,1) [list [_ "Stream lines#C#menu"] [_ "Node trace#C#menu"]]
    set MenuCommandsP(4,1) ""
    set MenuEntriesP(4,1,0) [list [_ "Select#C#menu"] [_ "All#C#menu"]]
    set MenuCommandsP(4,1,0) { {Results Options StreamDelete} {Results Options StreamDelete All}}
    set MenuEntriesP(4,1,1) [list [_ "Select#C#menu"] [_ "All#C#menu"]]
    set MenuCommandsP(4,1,1) { {Results NodeTrace Delete} {Results NodeTrace Delete All}}
    
    
    set MenuEntriesP(4,3) { "" }
    set MenuCommandsP(4,3) { "" }
    
    set MenuEntriesP(4,5) { "" }
    set MenuCommandsP(4,5) { "" }
    
    set MenuEntriesP(4,6) { "" }
    set MenuCommandsP(4,6) { "" }
    
    set MenuEntriesP(4,7) { "" }
    set MenuCommandsP(4,7) { "" }
    
    set MenuEntriesP(4,8) [list [_ "Show minimum#C#menu"] [_ "Show maximum#C#menu"] [_ "Show both#C#menu"]]
    set MenuCommandsP(4,8) { \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results ShMin} Sh_Min_Max} \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results ShMax} Sh_Min_Max} \
            {-npm- AddResultsToMenu %W {GiD_Process Mescape Results ShMinMax} Sh_Min_Max} \
    }
    set MenuIconsP(4,8) [list PostBarShMin.png PostBarShMax.png PostBarShMinMax.png]
    
    set MenuEntriesP(4,8,0) { "" }
    set MenuCommandsP(4,8,0) { "" }
    
    set MenuEntriesP(4,8,1) { "" }
    set MenuCommandsP(4,8,1) { "" }
    
    set MenuEntriesP(4,8,2) { "" }
    set MenuCommandsP(4,8,2) { "" }
    
    set MenuEntriesP(4,9) { "" }
    set MenuCommandsP(4,9) { "" }
    
    set MenuEntriesP(4,10) [list [_ "Exact#C#menu"] [_ "Automatic#C#menu"] [_ "Automatic width#C#menu"]]
    set MenuCommandsP(4,10) { \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results IsoSurfaces Exact} Iso_Surfaces 1} \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results IsoSurfaces Automatic} Iso_Surfaces 2} \
            {-npm- AddResultsToMenu %W {GiD_Process Mescape Results IsoSurfaces AutomaticWidth} Iso_Surfaces 3}}
    
    set MenuEntriesP(4,10,0) { "" }
    set MenuCommandsP(4,10,0) { "" }
    
    set MenuEntriesP(4,10,1) { "" }
    set MenuCommandsP(4,10,1) { "" }
    
    set MenuEntriesP(4,10,2) { "" }
    set MenuCommandsP(4,10,2) { "" }
    
    set MenuEntriesP(4,11) [list [_ "Single point#C#menu"] [_ "Along line#C#menu"] [_ "In a quad#C#menu"] [_ "Set initial increment"]]
    set MenuCommandsP(4,11) { \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results StreamLines} Stream_Lines 1} \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results StreamLines AlongLine} Stream_Lines 2} \
            {-npm- AddResultsToMenu %W {GiD_Process Mescape Results StreamLines InAQuad} Stream_Lines 3} \
        {-np- GiD_Process Mescape Results Options StreamIniStep}}
    
    set MenuEntriesP(4,11,0) { "" }
    set MenuCommandsP(4,11,0) { "" }
    
    set MenuEntriesP(4,11,1) { "" }
    set MenuCommandsP(4,11,1) { "" }
    
    set MenuEntriesP(4,11,2) { "" }
    set MenuCommandsP(4,11,2) { "" }
    
    # set MenuEntriesP(4,12) { "" }
    # set MenuCommandsP(4,12) { "" }
    
    set MenuEntriesP(4,13) [list [_ "Clear#C#menu"] [_ "Point evolution#C#menu"] [_ "Point graph#C#menu"] \
            [_ "Border graph#C#menu"] [_ "Line graph#C#menu"] [_ "Integrate#C#menu"] ]
    set MenuCommandsP(4,13) { \
        { Results Graphs OptionsGraph ClearGraphs} \
        {-npm- AddGraphsResultsToMenu %W {GiD_Process Mescape Results Graphs PointEvolution} Point_Evolution } \
            {-npm- AddGraphsXYResultsToMenu %W {GiD_Process Mescape Results Graphs PointGraph} Point_Graph } \
        {-npm- AddGraphsXYResultsToMenu %W {GiD_Process Mescape Results Graphs BorderGraph} Border_Graph } \
            {-npm- AddGraphsResultsToMenu %W {GiD_Process Mescape Results Graphs LineGraph} Line_Graph } \
        "" \
        }
    
    set MenuIconsP(4,13) [list PostBarGraphClear.png PostBarGraphPointEvolution.png PostBarGraphPointGraph.png \
            PostBarGraphBorder.png PostBarGraphLine.png PostBarGraphIntegrate.png ]
    
    set MenuEntriesP(4,13,1) { ""}
    set MenuCommandsP(4,13,1) { ""}
    
    set MenuEntriesP(4,13,2) { ""}
    set MenuCommandsP(4,13,2) { ""}
    
    set MenuEntriesP(4,13,3) { ""}
    set MenuCommandsP(4,13,3) { ""}
    
    set MenuEntriesP(4,13,4) { ""}
    set MenuCommandsP(4,13,4) { ""}
    
    # set MenuEntriesP(4,13,5) { ""}
    # set MenuCommandsP(4,13,5) { ""}
    
    if { ![info exists ::GidPriv(PostSpaceDimension)] } {
        set ::GidPriv(PostSpaceDimension) 3D
        #used for example if 2D do to integrals on lines in  the XY space 
        #e.g for triangle meshes with z but results XY only like IBER, to do
        #  -integral along cutting line 
        #  -streamlines in z=0 (else the streamline go outside the triangle/quads 3D domain)
    }
    
    set MenuEntriesP(4,13,5) [list [_ "Scalar result"] [_ "Vector result (normal)"] [_ "Vector result (tangential)"] ]
    set which_step AllSteps
    set cmd [list GiD_Process Mescape Results Graphs Integrate $::GidPriv(PostSpaceDimension) $which_step]
    set MenuCommandsP(4,13,5) [list \
            [list -npm- AddGraphsResultsToMenu %W "$cmd ScalarResult" Integrate_Scalar] \
            [list -npm- AddGraphsResultsToMenu %W "$cmd NormalIntegration VectorResult" Integrate_Vector_Normal] \
            [list -npm- AddGraphsResultsToMenu %W "$cmd TangentialIntegration VectorResult" Integrate_Vector_Tangential] \
            ]
    set MenuEntriesP(4,13,5,0) { ""}
    set MenuCommandsP(4,13,5,0) { ""}
    set MenuEntriesP(4,13,5,1) { ""}
    set MenuCommandsP(4,13,5,1) { ""}
    set MenuEntriesP(4,13,5,2) { ""}
    set MenuCommandsP(4,13,5,2) { ""}    
    
    
    set MenuEntriesP(4,13,6) { ""}
    set MenuCommandsP(4,13,6) { ""}
    
    set MenuEntriesP(4,14) { "" }
    set MenuCommandsP(4,14) { "" }
    
    set MenuEntriesP(4,15) { "" }
    set MenuCommandsP(4,15) { "" }
    
    set MenuEntriesP(4,16) [list [_ "Scalar#C#menu"] [_ "Vector#C#menu"] ]
    set MenuCommandsP(4,16) { \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results LineDiagram ScalarDiagram} Scalar_Line_Diagram} \
        {-npm- AddResultsToMenu %W {GiD_Process Mescape Results LineDiagram VectorDiagram} Vector_Line_Diagram} \
        }
    
    set MenuEntriesP(4,16,0) { ""}
    set MenuCommandsP(4,16,0) { ""}
    
    set MenuEntriesP(4,16,1) { ""}
    set MenuCommandsP(4,16,1) { ""}
    
    set MenuEntriesP(4,17) { ""}
    set MenuCommandsP(4,17) { ""}
    
    set MenuEntriesP(4,18) [list [_ "This step#C#menu"] [_ "All steps#C#menu"]]
    set MenuCommandsP(4,18) { "" ""}
    
    foreach i {0 1} which_step {ThisStep AllSteps} {
        set cmd [list GiD_Process Mescape Results Graphs Integrate $::GidPriv(PostSpaceDimension) $which_step]
        set MenuEntriesP(4,18,$i) [list [_ "Scalar result"] [_ "Vector result (normal)"] [_ "Vector result (tangential)"]]
        set MenuCommandsP(4,18,$i) [list \
                [list -npm- AddGraphsResultsToMenu %W "$cmd ScalarResult" Integrate_Scalar] \
                [list -npm- AddGraphsResultsToMenu %W "$cmd NormalIntegration VectorResult" Integrate_Vector_Normal] \
                [list -npm- AddGraphsResultsToMenu %W "$cmd TangentialIntegration VectorResult" Integrate_Vector_Tangential] \
                ]
        set MenuEntriesP(4,18,$i,0) { ""}
        set MenuCommandsP(4,18,$i,0) { ""}
        set MenuEntriesP(4,18,$i,1) { ""}
        set MenuCommandsP(4,18,$i,1) { ""}
        set MenuEntriesP(4,18,$i,2) { ""}
        set MenuCommandsP(4,18,$i,2) { ""}
    }
    
    
    if { [info exists ::GidPriv(EnableVolumeRendering)] && $::GidPriv(EnableVolumeRendering)} {
        lappend MenuEntriesP(4) [_ "Volume Render"]
        set last [expr [llength $MenuEntriesP(4)] - 1]
        lappend MenuCommandsP(4) {-np- AddResultsToMenu %W {GiD_Process Mescape Results VolumeRender}  Volume_Render}
        lappend MenuAccelerP(4) ""
        lappend MenuIconsP(4) VolumeRender.png
        set MenuEntriesP(4,$last) { "" }
        set MenuCommandsP(4,$last) { "" }
    }
    
    #----------------
    
    set MenuEntriesP(5) [list [_ "View style#C#menu"]... [_ "View results#C#menu"]... [_ "Animate#C#menu"]... \
            [_ "View graphs#C#menu"]... --- [_ "Several results#C#menu"]... \
            [_ "Results ranges table#C#menu"]... \
            [_ "Create result"]... [_ "Create statistical result"]... [_ "Create graphs"]...  \
            ]
    #[_ "Create Result 2"]...
    set MenuCommandsP(5) { {-np- PostDisplay} {-np- PostGeom::Create}
        {-np- PostAnimateWindowCheckingModel} {-np- PostGraphs::Create} {} {-np- PostMultipleResults}
        {-np- PostRangesTable::Create} 
        {-np- PostCreateResult} {-np- ::PostStatisticalResult::StatisticalScalarResult} 
        {-np- PostCreateGraphs}}
    # {-np- PCreateResult::Create}
    #PostGraphs::Create instead PostGraphResultsWindow
    
    set MenuAccelerP(5) [list $M-s $M-d $M-m $M-g "" "" "" "" "" ""]
    # ""
    set MenuIconsP(5) { "layers.png" "WindowResults.png" "WinResAnim.png" "WindowGraphs.png" "" "" "" "" "" ""}
    # ""
    
    #----------------
    
    set MenuEntriesP(6) [list [_ "Help#C#menu"]... [_ "Customization help#C#menu"]... [_ "Tutorials#C#menu"]... \
            [_ "What is new#C#menu"]... [_ "FAQ#C#menu"]... [_ "Courses#C#menu"]... [_ "Visit GiD forum#C#menu"]... \
            --- [_ "Register GiD#C#menu"] [_ "Register problem type#C#menu"]... \
            [_ "Register from file#C#menu"]... --- [_ "Visit GiD web#C#menu"]...]
    
    set MenuCommandsP(6) [list {-np- GiDHelpWindow -type REFERENCE -start GRM} \
            {-np- GiDHelpWindow -type REFERENCE -start  GCM} \
            {-np- GiDHelpWindow -type REFERENCE -start GUM} \
            {-np- GiDHelpWindow -type REFERENCE -start GWN} \
            {-np- GiDHelpWindow -type REFERENCE -start  SD} \
            {-np- GiDHelpWindow -type REFERENCE -start  GCS} \
            [list -np- VisitWeb $GidPriv(WebForum)] \
            "" "" "" {-np- Register::RegisterFromFileWindow} \
            "" [list -np- VisitWeb $GidPriv(ProgWeb)]]
    
    set MenuAccelerP(6) {F1 "" "" "" "" "" "" "" "" ""}
    set MenuIconsP(6) {"help.png" "" "" "" "" "" "" "" "" ""}
    
    if { [GiD_Set ShowCheckNewVersion] } {
        lappend MenuEntriesP(6) [_ "Check for updates#C#menu"]...
        lappend MenuCommandsP(6) {-np- PopupCheckNewVersion %X %Y}
        lappend MenuAccelerP(6) ""
        lappend MenuIconsP(6) ""
    }
    lappend MenuEntriesP(6) [_ "About#C#menu"]...
    lappend MenuCommandsP(6) {-np- CreateWelcomeWin}
    lappend MenuAccelerP(6) ""
    lappend MenuIconsP(6) ""
    
    set MenuEntriesP(6,8) [list [_ "Local"]... [_ "USB"]... [_ "Floating"]...]
    set MenuCommandsP(6,8) "{-np- Register::GiD_Local 0} {-np- Register::GiD_Usb 0} {-np- Register::GiD_Floating 0}"
    set MenuAccelerP(6,8) {"" "" ""}
    set MenuIconsP(6,8) {"" "" ""}
    if { [info exists ::GID_LOGIN] && !$::GID_LOGIN_HIDE } {
        lappend MenuEntriesP(6,8) [_ "Named user"]...
        lappend MenuCommandsP(6,8) {-np- Login::Window}
        lappend  MenuAccelerP(6,8) ""
        lappend MenuIconsP(6,8) ""
    }
    
    set MenuEntriesP(6,9) [list [_ "Local"]... [_ "USB"]... [_ "Floating"]...]
    set MenuCommandsP(6,9) "{-np- Register::GiD_Local 1} {-np- Register::GiD_Usb 1} {-np- Register::GiD_Floating 1}"
    set MenuAccelerP(6,9) {"" "" ""}
    set MenuIconsP(6,9) {"" "" ""}
    
}

#-----------------------------------------------------------

proc SetBitmapNamesP {} {
    global BitMapsNamesP BitMapsShortNamesP BitMapsCommandsP BitmapsHelpP GidPriv
    unset -nocomplain BitMapsNamesP BitMapsShortNamesP BitMapsCommandsP BitmapsHelpP
    
    set BitMapsNamesP(0) [list zoomin.png zframe.png \
        rotate.png pan.png --- \
            bodybound.png cullfrontfaces.png --- meshes.png \
            surfacesets.png cuts.png --- docut.png \
            --- usermax.png usermin.png ContOptions.png \
            list.png]
    
    

    set BitMapsShortNamesP(0) [list [_ "Zoom in"] [_ "Zoom frame"] \
            [_ "Rotate"] [_ "Pan"] "" \
            [_ "Style"] [_ "Culling"] "" [_ "Volumes"] \
            [_ "Surfaces"] [_ "Cuts"] "" [_ "Do cut"]\
            "" [_ "Set max"] [_ "Set min"] [_ "C.fill options"] \
            [_ "List"]]
    
    set BitMapsCommandsP(0) { {-np- DoZoom In} {-np- DoZoom Frame} \
        {-ne- 'Rotate Trackball} {-ne- 'Dynamicpan} "" \
            {-np- AddBitmapsToDisplayStyle %W {GiD_Process Mescape DisplayStyle}} \
            {-np- AddBitmapsToCullStyle %W {GiD_Process Mescape Utilities Render Culling}} \
            "" {-np- AddBitmapsToMeshSetCut %W {GiD_Process Mescape Select} volumesets} \
            {-np- AddBitmapsToMeshSetCut %W {GiD_Process Mescape Select} surfacesets} \
            {-np- AddBitmapsToMeshSetCut %W {GiD_Process Mescape Select} cutsets} \
            "" {-np- AddBitmapsToCutDivide %W {GiD_Process Mescape DoCut} CutPlane} \
            "" {-np- PostContLimitsMaxEntry %W} \
            {-np- PostContLimitsMinEntry %W}\
            "" \
            {-np- AddEntitiesToMenuCommonEntities %W DoList 0}
    }
    
    set BitmapsHelpP(0) [list [_ "Zoom in#C#menu"] [_ "Zoom frame#C#menu"] \
            [_ "Rotate trackball#C#menu"] [_ "Pan#C#menu"] "" \
            [_ "Display style#C#menu"] [_ "Culling style#C#menu"] \
            "" [_ "Switch volume sets on/off#C#menu"] \
            [_ "Switch surface sets on/off#C#menu"] [_ "Switch cut set on/off#C#menu"] \
            "" [_ "Cut volume/surface sets with 2/3 points, succesion#C#menu"] "" \
            [_ "Set maximum value#C#menu"] [_ "Set minimum value#C#menu"] \
            [_ "Contour options#C#menu" ] \
            [_ "List entities#C#menu"] ]
    
    set BitMapsNamesP(0,5) { boundaries.png hiddenbound.png alllines.png hiddenlines.png body.png bodybound.png bodylines.png point.png pointsbound.png }
    set BitMapsCommandsP(0,5) { Boundaries Hidden_Bound All_Lines Hidden_Lines Body Body_Bound Body_Lines Points Points_Bound}
    
    set BitMapsNamesP(0,6) { cullnone.png cullfrontfaces.png cullbackfaces.png}
    set BitMapsCommandsP(0,6) { none frontfaces backfaces}
    
    set BitMapsNamesP(0,8) { volumesets.png}
    set BitMapsCommandsP(0,8) { volumesets}
    
    set BitMapsNamesP(0,9) { surfacesets.png}
    set BitMapsCommandsP(0,9) { surfacesets}
    
    set BitMapsNamesP(0,10) { cuts.png}
    set BitMapsCommandsP(0,10) { cutsets}
    
    set BitMapsNamesP(0,12) { cut2p.png cut3p.png}
    set BitMapsCommandsP(0,12) { cut2p cut3p}
    
    set BitMapsNamesP(0,16) { ContLog.png ContMultFactor.png ContAddFactor.png resetminmax.png}
    set BitMapsCommandsP(0,16) { {-np- PostContLogSwitch %W %I } \
        {-np- PostContFactorEntry %W ScaleMultiplier} \
            {-np- PostContFactorEntry %W ScaleAdder} \
            { Results ContOptions SetMaxOptions ResetValue Mescape \
            Results ContOptions SetMinOptions ResetValue Mescape \
                Utilities Redisplay }  \
        }
    # set BitmapsHelpP(0,16) [list [_ "Set logarithmic view#C#menu" ] [_ "Set multiplier factor#C#menu" ] \
        #                               [_ "Set adder factor#C#menu" ] [_ "Reset Contour Limit Values#C#menu"] \
        #                              ]
    
    set BitMapsNamesP(0,17) { }
    set BitMapsCommandsP(0,17) { }
    
}

#user procedures that modify menu variables could be registered to be automatically called
#procname is a procedure without any argument
#GiD_RegisterPluginAddedMenuProc <procname>
#GiD_UnRegisterPluginAddedMenuProc <procname> 

proc GiD_RegisterPluginAddedMenuProc { procname } {
    if { [info procs $procname] != "" && [llength [info args $procname]] != 0 } {
        return -code error [_ "Wrong procedure prototype, must be '%s'." "proc procname {} body"]
    }
    
    if { ![info exists ::GidPriv(RegisteredPluginMenuProcs)] } {
        set pos -1
    } else {
        set pos [lsearch $::GidPriv(RegisteredPluginMenuProcs) $procname] 
    }
    if { $pos == -1 } {
        lappend ::GidPriv(RegisteredPluginMenuProcs) $procname
    }
}

proc GiD_UnRegisterPluginAddedMenuProc { procname } {
    if { ![info exists ::GidPriv(RegisteredPluginMenuProcs)] } {
        return 1
    } 
    set pos [lsearch $::GidPriv(RegisteredPluginMenuProcs) $procname]     
    if { $pos != -1 } {
        set ::GidPriv(RegisteredPluginMenuProcs) [lreplace $::GidPriv(RegisteredPluginMenuProcs) $pos $pos]
    }
}

proc EvalPluginAddedMenuProcs { } {
    if { ![info exists ::GidPriv(RegisteredPluginMenuProcs)] } {
        return
    }
    foreach procname $::GidPriv(RegisteredPluginMenuProcs) {
        Eval_GenericProc $procname
    }
}


proc SetAllMenusVariables {} {
    global GidPriv
    
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    
    SetMenusVariables
    SetBitmapNames
    Set3dButtonVariables
    Set3dButtonVariablesGraph
    SetMenusVariablesP
    SetBitmapNamesP
    #DWInitUserDataOptions    
    RestorePreferences
    
    if { $::GidPriv(HideSurfaceLevel)==1 } {
        HideSurfaceFromMenus        
        HideSurfaceFromPreferences
        HideSurfaceFromToolbars
        HideSurfaceFromFromMacrosToolbars  
        #HideSurfaceFromViewResultsBarBitmaps       
    } else {
        #RestoreSurfaceFromPreferences -> RestorePreferences        
        RestoreSurfaceFromMacrosToolbars
    }
    if { $::GidPriv(HideVolumeLevel)==1 } {
        HideVolumeFromMenus        
        HideVolumeFromPreferences
        HideVolumeFromToolbars
        HideVolumeFromFromMacrosToolbars
        #HideVolumeFromViewResultsBarBitmaps
    } else {
        #RestoreVolumeFromPreferences -> RestorePreferences
        RestoreVolumeFromMacrosToolbars
    }
    
    if { $::GidPriv(AllowHideMeshOptions) } {
        if { [GiD_Set MeshType]==0 } {
            #Body-fitted
            HideCartesianFromMenus
            HideCartesianFromPreferences                    
            HideEmbeddedFromMenus
            HideEmbeddedFromPreferences
        } elseif { [GiD_Set MeshType]==1 } {      
            #Cartesian
            HideBodyFittedFromMenus
            HideBodyFittedFromPreferences
            #HideBodyFittedFromToolbars
            #HideBodyFittedFromFromMacrosToolbars
            #HideBodyFittedFromViewResultsBarBitmaps
            HideEmbeddedFromMenus
            HideEmbeddedFromPreferences
            GiDMenu::RemoveOption Mesh [list "Preview line mesh"] PRE
        } elseif { [GiD_Set MeshType]==2} {
            #Embedded
            HideCartesianFromMenus
            HideCartesianFromPreferences
            #do not hide the Body-fitted options, they have also sense in embedded case            
            GiDMenu::RemoveOption Mesh [list "Preview line mesh"] PRE
        } else {
            W "SetAllMenusVariables: unexpected MeshType=[GiD_Set MeshType]"
        }    
        
        if { $::GidPriv(HideQuadraticTypeLevel) == 7 } {
            #hide all 1==linear + 2==quadratic + 4==quadratic9
            HideQuadraticTypeLevelFromMenus
        }
        HideQuadraticTypeLevelFromPreferences
    }
    
    
    #to modify menus with plugin defined procedures
    EvalPluginAddedMenuProcs
}

proc ClearMenu { w } {
    set lastentry [$w index last]
    if { $lastentry == "none" } {
        return
    }
    for { set i 0 } { $i <= $lastentry } { incr i } {
        if { [$w type $i] == "cascade" } {
            set wchild [$w entrycget $i -menu]
            if { $wchild != "" && [winfo exists $wchild] } {
                ClearMenu $wchild
                destroy $wchild
            }
        }
    }
    $w delete 0 last
}

proc StdBitmaps { { what "DEFAULT" }} {
    #WarnWinText "StdBitmaps"
    global StdBitmapsNames StdBitmapsShortNames StdBitmapsCommands StdBitmapsHelp GIDDEFAULT
    global GidPriv
    
    unset -nocomplain StdBitmapsNames
    unset -nocomplain StdBitmapsShortNames
    unset -nocomplain StdBitmapsCommands
    unset -nocomplain StdBitmapsHelp
    
    if { [GetCurrentPrePostMode] == "PRE" } {    
        set StdBitmapsNames(0) [list new.png open.png save.png --- \
                viewprev.png viewnext.png viewlist.png --- \
                camera.png --- \
                copy.png layers.png --- \
                prefs.png \
                pre_post.png --- $GidPriv(InfoGiDBitmapName) ]
        set StdBitmapsShortNames(0) [list \
                [_ "New"] [_ "Open"] [_ "Save"] ""\
                [_ "Prev view"] [_ "Next view"] [_ "Views"] "" \
                [_ "Snapshot"] ""\
                [_ "Copy"] [_ "Layers and groups"] "" \
                [_ "Preferences"] \
                [_ "Switch pre-post"] "" ""]    
        
        set StdBitmapsCommands(0) [list {-np- DoFilesNew ASK} {-np- DoFilesRead} {-np- DoProjectSave} "" \
                {-np- DoZoom Previous} {-np- DoZoom Next} {-np- AddRecentViewFiles2IconBar %W} \
                "" {-np- TakeSnapshot} "" \
                {-np- GidUtils::ToggleWindow COPY} {-np- GidUtils::ToggleWindow LAYER} "" \
                {-np- GidUtils::ToggleWindow PREFERENCES} \
                {-np- TogglePrePost} "" [list -np- $GidPriv(InfoGiDProc)]]     
        
        set StdBitmapsHelp(0) [list [_ "New %s project" $::GidPriv(ProgName)] [_ "Open %s project" $::GidPriv(ProgName)] \
                [_ "Save %s project" $::GidPriv(ProgName)] \
                "" [_ "Previous view"] [_ "Next view"] [_ "List of views"] \
                "" \
                [_ "Take a snapshot"] "" \
                [_ "Copy/Transform"] \
                [_ "Layers and groups"] "" [_ "Preferences"] \
                [_ "Toggle between pre and postprocess"] "" [_ "Information about the current program"]]
        
        set idxViews 6
        set idxHardcopy 9
    } else {
        #postprocess
        # openMultiple.png 
        if { $::GidPriv(EnableAnimationInIconBar)} {
            set TogglePlayPauseIcon [list play.png]
            set TogglePlayPauseName [list [_ "Animate"]]
            set TogglePlayPauseCmd  [list {-np- PostAnimateIconBarTogglePlayPause %W}]
            set TogglePlayPauseHelp [list [_ "Animate current results view"]]
        } else {
            set TogglePlayPauseIcon ""
            set TogglePlayPauseName ""
            set TogglePlayPauseCmd  ""
            set TogglePlayPauseHelp ""
        }
        
        set StdBitmapsNames(0) [list new.png open.png reload.png save.png --- \
                viewprev.png viewnext.png viewlist.png fastmode_on.png \
                --- camera.png --- \
                copy.png layers.png \
                WindowResults.png WindowGraphs.png WinResAnim.png tool-animator.png \
                {*}$TogglePlayPauseIcon --- \
                prefs.png \
                post_pre.png --- $GidPriv(InfoGiDBitmapName)]
        
        set StdBitmapsShortNames(0) [list \
                [_ "New"] [_ "Open (multiple)"] [_ "Reload"] [_ "Save"] "" \
                [_ "Prev view"] [_ "Next view"] [_ "Views"] [_ "Fast mode"] \
                "" [_ "Snapshot"] ""\
                [_ "Copy"] [_ "Mesh view style"] \
                [_ "Results window"] [_ "Graphs window"] \
                [_ "Result animation window"] [_ "Animation controls window"] \
                {*}$TogglePlayPauseName "" \
                [_ "Preferences"] \
                [_ "Switch pre-post"] "" ""]
        
        set StdBitmapsCommands(0) [list {-np- DoFilesNew ASK} {-np- FilesOpenPostMultipleWin} \
                {-np- FilesReloadPostprocess} {Files SaveAll HDF5GidPost} "" \
                {-np- DoZoom Previous} {-np- DoZoom Next} {-np- AddRecentViewFiles2IconBar %W} \
                {-np- SwitchFastDraw %W} "" \
                {-np- TakeSnapshot} "" \
                {-np- GidUtils::ToggleWindow COPY} {-np- GidUtils::ToggleWindow SETS} \
                {-np- PostGeom::Create} {-np- PostGraphs::Create} \
                {-np- PostAnimateWindowCheckingModel} {-np- PostAnimateControlsWindow} \
                {*}$TogglePlayPauseCmd \
                "" \
                {-np- GidUtils::ToggleWindow PREFERENCES} \
                {-np- TogglePrePost} "" [list -np- $GidPriv(InfoGiDProc)]]
        
        set StdBitmapsHelp(0) [list [_ "Clean postprocess"] [_ "Open Postprocess (multiple) files"] \
                [_ "Reload postprocess file(s) and \nsets results visualization to last step"] \
                [_ "Export binary postprocess"] "" \
                [_ "Previous view"] [_ "Next view"] [_ "List of views"] \
                [_ "Fast draw mode"] \
                "" [_ "Take a snapshot"] "" \
                [_ "Copy/Transform"] [_ "View style"] \
                [_ "Results window"] [_ "Graphs window"] \
                [_ "Result animation window"] [_ "Animation controls window"] \
                {*}$TogglePlayPauseHelp "" \
                [_ "Preferences"] \
                [_ "Toggle between pre and postprocess"] "" [_ "Information about the current program"] ]        
        # with open and openMultiple
        # set idxViews 8
        # set idxHardcopy 11
        set idxViews 7
        set idxHardcopy 10
    }
    
    if { [info exists ::GID_LOGIN] && !$::GID_LOGIN_HIDE } {
        # Cloud button to go to the model manager (left to the login button)
        # lappend StdBitmapsNames(0) cloud.png
        lappend StdBitmapsNames(0) folder-cloud-filled-goto.png
        lappend StdBitmapsShortNames(0) [_ "Go to model manager"]
        lappend StdBitmapsCommands(0) {-np- GidDataManager::NavigateToGiDModelManager}
        lappend StdBitmapsHelp(0) [_ "Navigate to the GiD Model Manager"] 

        # Login button
        set is_logged [GiD_Login is_logged]
        if { $is_logged } {
            set image_name logout.png
        } else {
            set image_name login.png
        } 

        lappend StdBitmapsNames(0) $image_name
        lappend StdBitmapsShortNames(0) [_ "Sign in"]
        lappend StdBitmapsCommands(0) {-np- Login::Window}
        lappend StdBitmapsHelp(0) [_ "Sign in with your e-mail and password"]

    }
    
    set StdBitmapsNames(0,$idxViews) {}
    set StdBitmapsCommands(0,$idxViews) {}
    
    # set StdBitmapsNames(0,$idxHardcopy) { eps.png ps.png bmp.png gif.png jpeg.png png.png tga.png tiff.png vrml.png}
    # set StdBitmapsCommands(0,$idxHardcopy) { eps ps bmp gif jpeg png tga tiff vrml}
    
    CreateOtherBitmaps StdBar [_ "Standard Bar"] StdBitmapsNames StdBitmapsCommands \
        StdBitmapsHelp GiD_image_folder StdBitmaps $what PrePost \
        StdBitmapsShortNames
    AddNewToolbar "Standard bar" PrePostStdBarWindowGeom StdBitmaps [_ "Standard bar"]
    
}

proc ToogleShowCFillInfo {} {
    set act_disp_coord [GiD_Set DisplayCoordinates]
    set act_disp_cfill_info [GiD_Set DisplayCFillInfo]
    if { ![info exists ::ToogleShowCFillInfo(old_disp_coord)]} {
        set ::ToogleShowCFillInfo(old_disp_coord) $act_disp_coord
        set ::ToogleShowCFillInfo(old_cursor) [.gid.central.s cget -cursor]
        set ::ToogleShowCFillInfo(old_bind_central) [bind .gid.central.s <$::gid_central_button>]
        set ::ToogleShowCFillInfo(old_bind_escape) [bind .gid <Escape>]
    }
    if { !$act_disp_cfill_info} {
        set ::ToogleShowCFillInfo(old_disp_coord) $act_disp_coord
        set new_disp_cfill_info 1
        # needed to display th e cfill info, uses same area
        set new_disp_coord 1
        set ::ToogleShowCFillInfo(old_cursor) [.gid.central.s cget -cursor]
        set ::ToogleShowCFillInfo(old_bind_central) [bind .gid.central.s <$::gid_central_button>]
        # .gid.central.s configure -cursor crosshair
        .gid.central.s configure -cursor center_ptr
        bind .gid.central.s <$::gid_central_button> ToogleShowCFillInfo
        bind .gid <Escape> ToogleShowCFillInfo
    } else {
        set new_disp_cfill_info 0
        set new_disp_coord $::ToogleShowCFillInfo(old_disp_coord)
        .gid.central.s configure -cursor $::ToogleShowCFillInfo(old_cursor)
        bind .gid.central.s <$::gid_central_button> $::ToogleShowCFillInfo(old_bind_central)
        bind .gid <Escape> $::ToogleShowCFillInfo(old_bind_escape)
    }
    GiD_Set DisplayCoordinates $new_disp_coord
    GiD_Set DisplayCFillInfo $new_disp_cfill_info
    UpdateCoordFrameView $new_disp_coord
    if { $new_disp_cfill_info} {
        GiD_Redraw
    }
}

proc ViewResultsBarBitmaps { { what "DEFAULT"}} {
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    global ViewResultsBarBitmapsNames ViewResultsBarBitmapsCommands ViewResultsBarBitmapsHelp GIDDEFAULT
    global GidPriv
    set ViewResultsBarBitmapsNames(0) [list \
            element.png --- PostBarAnalysisStep.png \
            --- PostBarContourFill.png PostBarContourFillInfo.png PostBarContourLines.png \
            PostBarShMinMax.png \
            PostBarVectors.png PostBarIsoSurfaces.png PostBarStreamLines.png \
            PostBarResultSurface.png PostBarLineThickness.png \
            PostBarDeformation.png --- graphs.png --- PostFilling.png \
            ]
    
    set ::ViewResultsBarBitmapsShortNames(0) [list \
            [_ "No results"] "" [_ "Sel. step"] \
            "" [_ "Contour fill"] [_ "Toogle showing contour fill info"] [_ "Contour lines"] \
            [_ "Show min max"] \
            [_ "Show vectors"] [_ "Isosurfaces"] [_ "Stream lines"] \
            [_ "Result surface"] [_ "Line thickness"] \
            [_ "Deformation"] "" [_ "Graphs"] "" [_ "Fill view"] ]
    
    if { [GetCurrentPrePostMode] == "POST" } {  
        set ::ViewResultsBarShMinMaxImages [list \
                PostBarShMin.png \
                PostBarShMax.png \
                PostBarShMinMax.png \
                ]
        set ::ViewResultsBarShMinMaxCommands [list \
                {-npm- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results ShMin} Sh_Min_Max} \
                {-npm- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results ShMax} Sh_Min_Max} \
                {-npm- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results ShMinMax} Sh_Min_Max} \
                ]
        
        #postprocess
        set ::ViewResultsBarGraphsImages [list \
                PostBarGraphPointEvolution.png PostBarGraphLine.png \
                PostBarGraphPointGraph.png PostBarGraphBorder.png \
                PostBarGraphIntegrate.png PostBarGraphPointComplexEvolution.png \
                PostBarGraphClear.png \
                ]
        
        # -npm- --> means there is a cascaded submenu
        # -np- --> is only a tcl command
        set ::ViewResultsBarGraphsCommands [list \
                {-npm- AddGraphsResultsToMenu %W {GiD_Process MEscape Results Graphs PointEvolution} Point_Evolution} \
                {-npm- AddGraphsResultsToMenu %W {GiD_Process MEscape Results Graphs LineGraph} Line_Graph} \
                {-npm- AddGraphsXYResultsToMenu %W {GiD_Process MEscape Results Graphs PointGraph} Point_Graph} \
                {-npm- AddGraphsXYResultsToMenu %W {GiD_Process MEscape Results Graphs BorderGraph} Border_Graph} \
                {-npm- AddIntegrateGraphOptions %W} \
                {-npm- AddGraphsResultsToMenu %W {GiD_Process MEscape Results Graphs PointComplexEvolution} Point_Complex_Evolution} \
                { Results Graphs OptionsGraph ClearGraphs} \
                ]
        
        set ::ViewResultsBarGraphsHelp [list [_ "Point evolution#C#menu"] [_ "Line graph#C#menu"] \
                [_ "Point graph#C#menu"] [_ "Border graph#C#menu"] \
                [_ "Graph of an integrated result over a mesh"] \
                [_ "Point evolution of a complex result#C#menu"] \
                [_ "Clear graphs#C#menu"] \
                ]
        
        set ViewResultsBarBitmapsCommands(0) [list \
                {-np- PostNoResults} \
                {} \
                {-np- AddAnalysisStepsToMenu %W} \
                {} \
                {-np- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results ContourFill} Contour_Fill} \
                {-np- ToogleShowCFillInfo} \
                {-np- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results ContourLines} Contour_Lines} \
                [list -np- AddImageSubmenu %W ::ViewResultsBarShMinMaxImages ::ViewResultsBarShMinMaxCommands] \
                {-np- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results DisplayVectors} Display_Vectors} \
                {-np- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results IsoSurfaces Exact} Iso_Surfaces 1} \
                {-np- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results StreamLines} Stream_Lines} \
                {-np- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results ResultSurface} Result_Surface} \
                {-np- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results LineThickness} Line_Thickness} \
                {-np- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results Geometry Deformation} Deformation} \
                {} \
                [list -np- AddImageSubmenu %W ::ViewResultsBarGraphsImages ::ViewResultsBarGraphsCommands ::ViewResultsBarGraphsHelp] \
                {} \
                {-np- PostFillView} \
                ]
        
        set ViewResultsBarBitmapsHelp(0) [list [_ "No results#C#menu"] {} \
                [_ "Default Analysis/Step#C#menu"] {} \
                [_ "Contour fill#C#menu"] \
                [_ "Enable or disable showing the contour fill range under the cursor"] \
                [_ "Contour lines#C#menu"] \
                [_ "Show min max#C#menu"] \
                [_ "Display vectors#C#menu"] [_ "Iso surfaces#C#menu"] [_ "Stream lines#C#menu"] \
                [_ "Result surface#C#menu"] [_ "Line thickness#C#menu"] [_ "Deformation#C#menu"] {} \
                [_ "Several graphs#C#menu"] {} [_ "Result fill view"] \
                ]
        
        set ViewResultsBarBitmapsNames(0,2) ""
        set ViewResultsBarBitmapsCommands(0,2) ""
        set ViewResultsBarBitmapsNames(0,4) ""
        set ViewResultsBarBitmapsCommands(0,4) ""
        set ViewResultsBarBitmapsNames(0,6) ""
        set ViewResultsBarBitmapsCommands(0,6) ""
        
        # shminmax
        set ViewResultsBarBitmapsNames(0,7) ""
        set ViewResultsBarBitmapsCommands(0,7) ""
        set ViewResultsBarBitmapsNames(0,7,0) ""
        set ViewResultsBarBitmapsCommands(0,7,0) ""
        set ViewResultsBarBitmapsNames(0,7,1) ""
        set ViewResultsBarBitmapsCommands(0,7,1) ""
        set ViewResultsBarBitmapsNames(0,7,2) ""
        set ViewResultsBarBitmapsCommands(0,7,2) ""
        
        set ViewResultsBarBitmapsNames(0,8) ""
        set ViewResultsBarBitmapsCommands(0,8) ""
        set ViewResultsBarBitmapsNames(0,9) ""
        set ViewResultsBarBitmapsCommands(0,9) ""
        set ViewResultsBarBitmapsNames(0,10) ""
        set ViewResultsBarBitmapsCommands(0,10) ""
        set ViewResultsBarBitmapsNames(0,11) ""
        set ViewResultsBarBitmapsCommands(0,11) ""
        set ViewResultsBarBitmapsNames(0,12) ""
        set ViewResultsBarBitmapsCommands(0,12) ""
        set ViewResultsBarBitmapsNames(0,13) ""
        set ViewResultsBarBitmapsCommands(0,13) ""
        
        set ViewResultsBarBitmapsNames(0,15) ""
        set ViewResultsBarBitmapsCommands(0,15) ""
        
        set ViewResultsBarBitmapsNames(0,15,0) ""
        set ViewResultsBarBitmapsCommands(0,15,0) ""
        set ViewResultsBarBitmapsNames(0,15,1) ""
        set ViewResultsBarBitmapsCommands(0,15,1) ""
        set ViewResultsBarBitmapsNames(0,15,2) ""
        set ViewResultsBarBitmapsCommands(0,15,2) ""
        set ViewResultsBarBitmapsNames(0,15,3) ""
        set ViewResultsBarBitmapsCommands(0,15,3) ""
        set ViewResultsBarBitmapsNames(0,15,4) ""
        set ViewResultsBarBitmapsCommands(0,15,4) ""
        set ViewResultsBarBitmapsNames(0,15,5) ""
        set ViewResultsBarBitmapsCommands(0,15,5) ""
        set ViewResultsBarBitmapsNames(0,15,6) ""
        set ViewResultsBarBitmapsCommands(0,15,6) ""
        
        if { [info exists ::GidPriv(EnableVolumeRendering)] && $::GidPriv(EnableVolumeRendering)} {
            lappend ViewResultsBarBitmapsNames(0) VolumeRender.png
            lappend ::ViewResultsBarBitmapsShortNames(0) [_ "Volume render"]
            lappend ViewResultsBarBitmapsCommands(0) {-np- AddResultsToMenu %W {GiD_Process escape escape escape escape escape Results VolumeRender} Volume_Render}
            lappend ViewResultsBarBitmapsHelp(0) [_ "Volume rendering"]
            set ViewResultsBarBitmapsNames(0,18) ""
            set ViewResultsBarBitmapsCommands(0,18) ""
        }
        
        if { $::GidPriv(HideSurfaceLevel)==1 } {
            HideSurfaceFromViewResultsBarBitmaps
        }
        if { $::GidPriv(HideVolumeLevel)==1 } {
            HideVolumeFromViewResultsBarBitmaps
        }
    }
    
    CreateOtherBitmaps ViewResultsBar [_ "View Results bar"] ViewResultsBarBitmapsNames \
        ViewResultsBarBitmapsCommands ViewResultsBarBitmapsHelp GiD_image_folder ViewResultsBarBitmaps $what Post \
        ViewResultsBarBitmapsShortNames
    AddNewToolbar "View results bar" PostViewResultsBarWindowGeom ViewResultsBarBitmaps [_ "View results bar"]
}



proc RestorePreferences { } {
    CreateWidgetsFromXml::ClearCachePreferences
    CreateWidgetsFromXml::ReadXmlFile Preferences.xml {} {PreferencesWindow} 0
}

#invoked in SetAllMenusVariables to remove from menus all relative to volumes
proc HideSurfaceFromMenus { } {
    #### PRE
    
    #GiDMenu::RemoveOption "View" [list "Normals" "Surfaces"] PRE ;#this menu is created at runtime
    #GiDMenu::RemoveOption "View" [list "Higher entities" "Surfaces"] PRE ;#this menu is created at runtime
    GiDMenu::RemoveOption "View" [list "Curvatures" "Surfaces"] PRE
    
    GiDMenu::RemoveOption "Geometry" [list "Create" "NURBS surface"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Create" "Parametric surface"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Create" "Contact surface"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Create" "Surface mesh"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Create" "Geometry form mesh"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Create" "Object"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Create" "---2"] PRE
    GiDMenu::RemoveOption "Geometry" [list "Delete" "Surfaces"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Divide" "Surfaces"] PRE  
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Join"] PRE  
    GiDMenu::RemoveOption "Geometry" [list "Edit" "SurfMesh"] PRE  
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Rebuild surface by boundary"] PRE  
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Edit NURBS" "Surface"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Convert to NURBS" "Surface"] PRE
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Simplify NURBS" "Surface"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Hole NURBS surface"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Edit" "---0"] PRE
    
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Collapse" "Surfaces"] PRE
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Uncollapse" "Surfaces"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Intersection" "Surface-2 points"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Intersection" "Surface-lines"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Intersection" "Surfaces"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Intersection" "---0"] PRE 
    GiDMenu::RemoveOption "Geometry" [list "Edit" "Surface boolean op."] PRE   
    
    GiDMenu::RemoveOption "Utilities" [list "Signal" "Surfaces"] PRE 
    #GiDMenu::RemoveOption "Utilities" [list "Swap normals" "Surfaces"] PRE ;#this menu is created at runtime
    
    GiDMenu::RemoveOption "Mesh" [list "Unstructured" "Assign sizes on surfaces"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "Unstructured" "Assign entities" "Surfaces"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "Unstructured" "Surface mesher"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "Structured" "Surfaces"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "Assign cartesian size" "Surfaces"] PRE
    #GiDMenu::RemoveOption "Mesh" [list "Quadratic type" "Quadratic9"] PRE ;#this menu is created at runtime
    GiDMenu::RemoveOption "Mesh" [list "Boundary layer"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "---0"] PRE
    GiDMenu::RemoveOption "Mesh" [list "Element type"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "Default" "Surfaces"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "Mesh" "Surfaces"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "No mesh" "Surfaces"] PRE   
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "Default mesh" "Surfaces"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "Skip" "Lines"] PRE
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "No skip" "Lines"] PRE
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "Automatic skip" "Lines"] PRE
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "Skip by"] PRE
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "Force points to"] PRE 
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "Duplicate"] PRE ;#is for lines embedded in surface
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "No Duplicate"] PRE ;#is for lines embedded in surface
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "---3"] PRE ;
    GiDMenu::RemoveOption "Mesh" [list "Mesh criteria" "---2"] PRE ;
    GiDMenu::RemoveOption "Mesh" [list "Draw" "Sizes" "Surfaces"] PRE  
    GiDMenu::RemoveOption "Mesh" [list "Draw" "Element type" "Surfaces"] PRE  
    GiDMenu::RemoveOption "Mesh" [list "Draw" "Mesh/No mesh" "Surfaces"] PRE  
    GiDMenu::RemoveOption "Mesh" [list "Draw" "Structured type" "Surfaces"] PRE   
    GiDMenu::RemoveOption "Mesh" [list "Draw" "Duplicate"] PRE  
    GiDMenu::RemoveOption "Mesh" [list "Draw" "Force points to"] PRE  
    GiDMenu::RemoveOption "Mesh" [list "Draw" "Boundary layer"] PRE  
    GiDMenu::RemoveOption "Mesh" [list "Edit mesh" "Split elements"] PRE
    GiDMenu::RemoveOption "Mesh" [list "Edit mesh" "Smooth elements"] PRE
    GiDMenu::RemoveOption "Mesh" [list "Edit mesh" "Collapse" "Edges"] PRE
    GiDMenu::RemoveOption "Mesh" [list "Create boundary mesh"] PRE
    
    GiDMenu::RemoveOption "Mesh" [list "View mesh boundary"] PRE
    GiDMenu::RemoveOption "Mesh" [list "Create mesh boundary"] PRE
    GiDMenu::RemoveOption "Mesh" [list "---2"] PRE
    
    #### POST  
    foreach item { {Import {Stream lines}} {Export {Post information} {Stream lines}} {Export Cut} {Export {Cover mesh}} 
        {Export {Visible surfaces to STL}} {Export {Visible surfaces to PLY}} } {
        GiDMenu::RemoveOption Files $item POST
    }
    
    foreach item {{"Cut plane"} {"Cut 2D polygonal"} {Divide "Surface sets"} Join
        {"Covering mesh"} {"Create delaunay meshes"} {"Extract boundaries"} {"Separate connected components"}
        {"Swap orientation of visible surface meshes"} {"Collapse nodes"} {"Convert to sets"} ---1 ---0} {
        GiDMenu::RemoveOption Geometry $item POST
    }
    foreach item { {Texture} {---3} } {
        GiDMenu::RemoveOption Utilities $item POST
    }    
    foreach item {{"Contour lines"} {"Iso surfaces"} {"Stream lines"} {"Result surface"}} {
        GiDMenu::RemoveOption "View results" $item POST
    }   
}

proc HideSurfaceFromToolbars {} {
    #hacer esto bien, no tan a saco...     
    foreach button {surface.png object.png ---1} {
        if { [string range $button 0 2] == "---" } {
            set nseparator [string range $button 3 end]
            if { $nseparator == "" } {
                set nseparator 0
            }
            set button "---"           
        }
        if {$button == "---" } {
            set p [lindex [lsearch -all $::BitMapsNames(0) "---"] $nseparator]
            if { $p == "" } {
                set p -1
            }
        } else {
            set p [lsearch $::BitMapsNames(0) $button]
        }
        if { $p != -1 } {            
            set ::BitMapsNames(0)  [lreplace $::BitMapsNames(0) $p $p]
            set ::BitMapsCommands(0) [lreplace $::BitMapsCommands(0) $p $p]
            set ::BitmapsHelp(0) [lreplace $::BitmapsHelp(0) $p $p]
            foreach index [lsort [array names ::BitMapsNames 0,*]] {
                set position [lindex [split $index ,] end]
                if { $position > $p } {
                    set position_prev [expr $position-1]
                    set ::BitMapsNames(0,$position_prev) $::BitMapsNames(0,$position)
                    set ::BitMapsCommands(0,$position_prev) $::BitMapsCommands(0,$position)
                    if { [info exists ::BitmapsHelp(0,$position)] } {
                        set ::BitmapsHelp(0,$position_prev) $::BitmapsHelp(0,$position)
                    }
                    unset ::BitMapsNames(0,$position)
                    unset ::BitMapsCommands(0,$position)
                    unset -nocomplain ::BitmapsHelp(0,$position)
                }
            }            
        }
    }    
    #delete.png {surface.png}
    #and
    #list.png {surface.png}
    #are created at runtime
    
    #POST
    foreach button {cullfrontfaces.png surfacesets.png cuts.png ---2 ---1 docut.png} {
        if { [string range $button 0 2] == "---" } {
            set nseparator [string range $button 3 end]
            if { $nseparator == "" } {
                set nseparator 0
            }
            set button "---"           
        }
        if {$button == "---" } {
            set p [lindex [lsearch -all $::BitMapsNamesP(0) "---"] $nseparator]
            if { $p == "" } {
                set p -1
            }
        } else {
            set p [lsearch $::BitMapsNamesP(0) $button]
        }
        if { $p != -1 } {
            set ::BitMapsNamesP(0)  [lreplace $::BitMapsNamesP(0) $p $p]
            set ::BitMapsCommandsP(0) [lreplace $::BitMapsCommandsP(0) $p $p]
            set ::BitmapsHelpP(0) [lreplace $::BitmapsHelpP(0) $p $p]
            foreach index [lsort [array names ::BitMapsNamesP 0,*]] {
                set position [lindex [split $index ,] end]
                if { $position > $p } {
                    set position_prev [expr $position-1]
                    set ::BitMapsNamesP(0,$position_prev) $::BitMapsNamesP(0,$position)
                    set ::BitMapsCommandsP(0,$position_prev) $::BitMapsCommandsP(0,$position)
                    if { [info exists ::BitmapsHelpP(0,$position)] } {
                        set ::BitmapsHelpP(0,$position_prev) $::BitmapsHelpP(0,$position)
                    }
                    unset ::BitMapsNamesP(0,$position)
                    unset ::BitMapsCommandsP(0,$position)
                    unset -nocomplain ::BitmapsHelpP(0,$position)
                }
            }
        }
    }        
}

proc HideSurfaceFromFromMacrosToolbars { } {
    global macros_surface_hidden_in_toolbar
    if { [info exists macros_surface_hidden_in_toolbar] && [llength $macros_surface_hidden_in_toolbar] } {
        return 1
    }
    if { ![info exists ::toolbarmacros::macrospace::macrosdata] } {
        return 1
    } 
    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    set names { "Trimmed surface" "Hole surface" "Surfaces from parallel lines" 
        "Divide surface" "Split surface" "Intersect surface lines" "Intersect surfaces" "Split Big Triangles" 
        "Collapse Small Triangles" "Draw normals surfaces color" "Higherentities lines"}
    set macros_surface_hidden_in_toolbar [list]
    foreach name $names {
        if { [info exists macrosdata($name,InToolbar)] && $macrosdata($name,InToolbar) } {
            lappend macros_surface_hidden_in_toolbar $name
        }
    }
    toolbarmacros::Activate_deactivate_intoolbar no_intoolbar $macros_surface_hidden_in_toolbar 0
    return 0
}

proc RestoreSurfaceFromMacrosToolbars { } {
    global macros_surface_hidden_in_toolbar
    if { [info exists macros_surface_hidden_in_toolbar] && [llength $macros_surface_hidden_in_toolbar] } {
        toolbarmacros::Activate_deactivate_intoolbar intoolbar $macros_surface_hidden_in_toolbar 0
        set macros_surface_hidden_in_toolbar [list]
    }
    return 0
}

proc HideSurfaceFromViewResultsBarBitmaps { } {
    #this already doesn't work...
    foreach button {PostBarContourLines.png PostBarStreamLines.png PostBarResultSurface.png} {
        if { [string range $button 0 2] == "---" } {
            set nseparator [string range $button 3 end]
            if { $nseparator == "" } {
                set nseparator 0
            }
            set button "---"           
        }
        if {$button == "---" } {
            set p [lindex [lsearch -all $::ViewResultsBarBitmapsNames(0) "---"] $nseparator]
            if { $p == "" } {
                set p -1
            }
        } else {
            set p [lsearch $::ViewResultsBarBitmapsNames(0) $button]
        }        
        if { $p != -1 } {
            set ::ViewResultsBarBitmapsNames(0)  [lreplace $::ViewResultsBarBitmapsNames(0) $p $p]
            set ::ViewResultsBarBitmapsShortNames(0) [lreplace $::ViewResultsBarBitmapsShortNames(0) $p $p]            
            set ::ViewResultsBarBitmapsCommands(0) [lreplace $::ViewResultsBarBitmapsCommands(0) $p $p]
            set ::ViewResultsBarBitmapsHelp(0) [lreplace $::ViewResultsBarBitmapsHelp(0) $p $p]
            foreach index [lsort [array names ::ViewResultsBarBitmapsNames 0,*]] {
                set position [lindex [split $index ,] end]
                if { $position > $p } {
                    set position_prev [expr $position-1]
                    set ::ViewResultsBarBitmapsNames(0,$position_prev) $::ViewResultsBarBitmapsNames(0,$position)
                    if { [info exists ::ViewResultsBarBitmapsShortNames(0,$position)] } {
                        set ::ViewResultsBarBitmapsShortNames(0,$position_prev) $::ViewResultsBarBitmapsShortNames(0,$position)
                    }
                    set ::ViewResultsBarBitmapsCommands(0,$position_prev) $::ViewResultsBarBitmapsCommands(0,$position)
                    if { [info exists ::ViewResultsBarBitmapsHelp(0,$position)] } {
                        set ::ViewResultsBarBitmapsHelp(0,$position_prev) $::ViewResultsBarBitmapsHelp(0,$position)
                    }
                    unset ::ViewResultsBarBitmapsNames(0,$position)
                    unset -nocomplain ::ViewResultsBarBitmapsShortNames(0,$position)
                    unset ::ViewResultsBarBitmapsCommands(0,$position)
                    unset -nocomplain ::ViewResultsBarBitmapsHelp(0,$position)
                }
            }
        }
    }
    return 0
}

proc HideSurfaceFromPreferences { } {
    set root [CreateWidgetsFromXml::GetPreferencesXml]
    foreach variable_name { AllowQuadTriMeshes AvoidElementsInBoundary BoundaryWeightedTransition ChordalError(ApplyChordalErrorToModel) 
        Color(Surfaces) Color(SurfsIsoparametric) DrawSurfaceMode FastRotation(Surfaces) ForceMesh(Surfaces) HighQualitySmoothing 
        SphereDetailMode SurfaceMesher } {
        CreateWidgetsFromXml::TakeOutVariable $root $variable_name
    }
    foreach name { boundary_meshing mesh_options postprocess_iso-surfaces postprocess_result_surface 
        postprocess_simplified postprocess_streamlines sphere_element_options sphere_options structured } {
        set findnode [$root find "name" $name]
        if { $findnode != "" } {
            #check if exists because removing other blocks some items won't exist
            CreateWidgetsFromXml::TakeOutName $root $name
        }        
    }    
    
    #this is a wrong non-general solution, a plugin is not known a priori by GiD!!
    #if { [info procs Spheres::UnRegisterPlugin] != "" } {
        #    Spheres::UnRegisterPlugin   
        #}
}

#invoked in SetAllMenusVariables to remove from menus all relative to volumes
proc HideVolumeFromMenus { } {
    ### PRE
    GiDMenu::RemoveOption Geometry [list "Create" "Volume"] PRE 
    GiDMenu::RemoveOption Geometry [list "Create" "---2"] PRE
    GiDMenu::RemoveOption Geometry [list "Create" "---3"] PRE
    GiDMenu::RemoveOption Geometry [list "Create" "Contact"] PRE 
    GiDMenu::RemoveOption Geometry [list "Create" "Object" "---0"] PRE
    GiDMenu::RemoveOption Geometry [list "Create" "Object" "Sphere"] PRE 
    GiDMenu::RemoveOption Geometry [list "Create" "Object" "Cylinder"] PRE 
    GiDMenu::RemoveOption Geometry [list "Create" "Object" "Cone"] PRE 
    GiDMenu::RemoveOption Geometry [list "Create" "Object" "Prism"] PRE 
    GiDMenu::RemoveOption Geometry [list "Create" "Object" "Torus"] PRE 
    GiDMenu::RemoveOption Geometry [list "Delete" "Volumes"] PRE 
    GiDMenu::RemoveOption Geometry [list "Edit" "Divide" "Volumes"] PRE  
    GiDMenu::RemoveOption Geometry [list "Edit" "Join" "Volumes"] PRE 
    GiDMenu::RemoveOption Geometry [list "Edit" "Hole volume"] PRE 
    GiDMenu::RemoveOption Geometry [list "Edit" "---1"] PRE
    
    GiDMenu::RemoveOption Geometry [list "Edit" "Collapse" "Volumes"] PRE 
    GiDMenu::RemoveOption Geometry [list "Edit" "Uncollapse" "Volumes"] PRE 
    GiDMenu::RemoveOption Geometry [list "Edit" "Volume boolean op."] PRE   
    
    GiDMenu::RemoveOption Utilities [list "Signal" "Volumes"] PRE 
    
    GiDMenu::RemoveOption Mesh [list "Unstructured" "Assign sizes on volumes"] PRE 
    GiDMenu::RemoveOption Mesh [list "Unstructured" "Assign entities" "Volumes"] PRE 
    GiDMenu::RemoveOption Mesh [list "Unstructured" "Volume mesher"] PRE
    GiDMenu::RemoveOption Mesh [list "Structured" "Volumes"] PRE 
    GiDMenu::RemoveOption Mesh [list "Semi-structured"] PRE
    GiDMenu::RemoveOption Mesh [list "Assign cartesian size" "Volumes"] PRE
    GiDMenu::RemoveOption Mesh [list "Boundary layer" "3D"] PRE 
    GiDMenu::RemoveOption Mesh [list "Element type" "Default" "Volumes"] PRE 
    GiDMenu::RemoveOption Mesh [list "Element type" "Linear" "Volumes"] PRE 
    GiDMenu::RemoveOption Mesh [list "Element type" ---1] PRE 
    GiDMenu::RemoveOption Mesh [list "Element type" "Tetrahedra"] PRE 
    GiDMenu::RemoveOption Mesh [list "Element type" "Hexahedra"] PRE 
    GiDMenu::RemoveOption Mesh [list "Element type" "Prism"] PRE 
    GiDMenu::RemoveOption Mesh [list "Element type" "Sphere"] PRE 
    GiDMenu::RemoveOption Mesh [list "Element type" "Only points"] PRE 
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Default" "Volumes"] PRE 
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Mesh" "Volumes"] PRE 
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "No mesh" "Volumes"] PRE   
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Default mesh" "Volumes"] PRE 
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Force points to" "Volume mesh"] PRE 
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Duplicate" "Surfaces"] PRE ;#is for surfaces embedded in volume
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "No Duplicate" "Surfaces"] PRE ;#is for surfaces embedded in volume
    
    GiDMenu::RemoveOption Mesh [list "Draw" "Sizes" "Volumes"] PRE  
    GiDMenu::RemoveOption Mesh [list "Draw" "Element type" "Volumes"] PRE  
    GiDMenu::RemoveOption Mesh [list "Draw" "Mesh/No mesh" "Volumes"] PRE  
    GiDMenu::RemoveOption Mesh [list "Draw" "Structured type" "Volumes"] PRE   
    GiDMenu::RemoveOption Mesh [list "Draw" "Force points to" "Volume mesh"] PRE  
    
    #GiDMenu::RemoveOption Mesh [list "Edit mesh" "Create element" "Tetrahedra"] PRE
    #GiDMenu::RemoveOption Mesh [list "Edit mesh" "Create element" "Hexahedra"] PRE
    #GiDMenu::RemoveOption Mesh [list "Edit mesh" "Create element" "Prism"] PRE
    #GiDMenu::RemoveOption Mesh [list "Edit mesh" "Create element" "Sphere"] PRE
    
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Split elements" "---0"] PRE  
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Split elements" "Tetrahedra->Tetrahedra"] PRE
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Split elements" "Hexahedra->Tetrahedra"] PRE  
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Split elements" "Prism->Tetrahedra"] PRE      
    ### POST
    foreach item { {"Cut sphere"} {Divide "Volume sets"} {Join "Volume sets"} } {
        GiDMenu::RemoveOption "Geometry" $item POST
    }
    return 0
}

proc HideVolumeFromToolbars {} {
    #hacer esto bien, no tan a saco...
    
    foreach button {volume.png} {
        if { [string range $button 0 2] == "---" } {
            set nseparator [string range $button 3 end]
            if { $nseparator == "" } {
                set nseparator 0
            }
            set button "---"           
        }
        if {$button == "---" } {
            set p [lindex [lsearch -all $::BitMapsNames(0) "---"] $nseparator]
            if { $p == "" } {
                set p -1
            }
        } else {
            set p [lsearch $::BitMapsNames(0) $button]
        }
        if { $p != -1 } {
            set ::BitMapsNames(0)  [lreplace $::BitMapsNames(0) $p $p]
            set ::BitMapsCommands(0) [lreplace $::BitMapsCommands(0) $p $p]
            set ::BitmapsHelp(0) [lreplace $::BitmapsHelp(0) $p $p]
            foreach index [lsort [array names ::BitMapsNames 0,*]] {
                set position [lindex [split $index ,] end]
                if { $position > $p } {
                    set position_prev [expr $position-1]
                    set ::BitMapsNames(0,$position_prev) $::BitMapsNames(0,$position)
                    set ::BitMapsCommands(0,$position_prev) $::BitMapsCommands(0,$position)
                    if { [info exists ::BitmapsHelp(0,$position)] } {
                        set ::BitmapsHelp(0,$position_prev) $::BitmapsHelp(0,$position)
                    }
                    unset ::BitMapsNames(0,$position)
                    unset ::BitMapsCommands(0,$position)
                    unset -nocomplain ::BitmapsHelp(0,$position)
                }
            }
        }
    }
    
    set button object.png
    set subbuttons {sphere.png cylinder.png cone.png Prism.png tori.png}
    set p [lsearch $::BitMapsNames(0) $button]
    if { $p != -1 } {
        lset ::BitmapsHelp(0) $p [_ "Create Object:\n Rectangle\n Polygon\n Circle"]
        set index 0,$p
        foreach item $subbuttons {
            set position [lsearch $::BitMapsNames($index) $item]
            if { $position != -1 } {
                set ::BitMapsNames($index)  [lreplace $::BitMapsNames($index) $position $position]
                set ::BitMapsCommands($index)  [lreplace $::BitMapsCommands($index) $position $position]
                if { [info exists ::BitmapsHelp($index)] } {
                    set ::BitmapsHelp($index) [lreplace $::BitmapsHelp($index) $position $position]
                }
            }
        }
    }
    #delete.png {volume.png}
    #and
    #list.png {volume.png}
    #are created at runtime
    
    #POST
    foreach button {meshes.png} {
        if { [string range $button 0 2] == "---" } {
            set nseparator [string range $button 3 end]
            if { $nseparator == "" } {
                set nseparator 0
            }
            set button "---"           
        }
        if {$button == "---" } {
            set p [lindex [lsearch -all $::BitMapsNamesP(0) "---"] $nseparator]
            if { $p == "" } {
                set p -1
            }
        } else {
            set p [lsearch $::BitMapsNamesP(0) $button]
        }        
        if { $p != -1 } {
            set ::BitMapsNamesP(0)  [lreplace $::BitMapsNamesP(0) $p $p]
            set ::BitMapsCommandsP(0) [lreplace $::BitMapsCommandsP(0) $p $p]
            set ::BitmapsHelpP(0) [lreplace $::BitmapsHelpP(0) $p $p]
            foreach index [lsort [array names ::BitMapsNamesP 0,*]] {
                set position [lindex [split $index ,] end]
                if { $position > $p } {
                    set position_prev [expr $position-1]
                    set ::BitMapsNamesP(0,$position_prev) $::BitMapsNamesP(0,$position)
                    set ::BitMapsCommandsP(0,$position_prev) $::BitMapsCommandsP(0,$position)
                    if { [info exists ::BitmapsHelpP(0,$position)] } {
                        set ::BitmapsHelpP(0,$position_prev) $::BitmapsHelpP(0,$position)
                    }
                    unset ::BitMapsNamesP(0,$position)
                    unset ::BitMapsCommandsP(0,$position)
                    unset -nocomplain ::BitmapsHelpP(0,$position)
                }
            }
        }
    }    
}


proc HideVolumeFromViewResultsBarBitmaps { } {
    #this already doesn't work...
    foreach button {PostBarIsoSurfaces.png ---3 PostFilling.png} {
        if { [string range $button 0 2] == "---" } {
            set nseparator [string range $button 3 end]
            if { $nseparator == "" } {
                set nseparator 0
            }
            set button "---"           
        }
        if {$button == "---" } {
            set p [lindex [lsearch -all $::ViewResultsBarBitmapsNames(0) "---"] $nseparator]
            if { $p == "" } {
                set p -1
            }
        } else {
            set p [lsearch $::ViewResultsBarBitmapsNames(0) $button]
        }        
        if { $p != -1 } {
            set ::ViewResultsBarBitmapsNames(0)  [lreplace $::ViewResultsBarBitmapsNames(0) $p $p]
            set ::ViewResultsBarBitmapsShortNames(0) [lreplace $::ViewResultsBarBitmapsShortNames(0) $p $p]            
            set ::ViewResultsBarBitmapsCommands(0) [lreplace $::ViewResultsBarBitmapsCommands(0) $p $p]
            set ::ViewResultsBarBitmapsHelp(0) [lreplace $::ViewResultsBarBitmapsHelp(0) $p $p]
            foreach index [lsort [array names ::ViewResultsBarBitmapsNames 0,*]] {
                set position [lindex [split $index ,] end]
                if { $position > $p } {
                    set position_prev [expr $position-1]
                    set ::ViewResultsBarBitmapsNames(0,$position_prev) $::ViewResultsBarBitmapsNames(0,$position)
                    if { [info exists ::ViewResultsBarBitmapsShortNames(0,$position)] } {
                        set ::ViewResultsBarBitmapsShortNames(0,$position_prev) $::ViewResultsBarBitmapsShortNames(0,$position)
                    }
                    set ::ViewResultsBarBitmapsCommands(0,$position_prev) $::ViewResultsBarBitmapsCommands(0,$position)
                    if { [info exists ::ViewResultsBarBitmapsHelp(0,$position)] } {
                        set ::ViewResultsBarBitmapsHelp(0,$position_prev) $::ViewResultsBarBitmapsHelp(0,$position)
                    }
                    unset ::ViewResultsBarBitmapsNames(0,$position)
                    unset -nocomplain ::ViewResultsBarBitmapsShortNames(0,$position)
                    unset ::ViewResultsBarBitmapsCommands(0,$position)
                    unset -nocomplain ::ViewResultsBarBitmapsHelp(0,$position)
                }
            }
        }
    }        
}

proc HideVolumeFromPreferences { } {
    set root [CreateWidgetsFromXml::GetPreferencesXml]
    foreach variable_name { Color(Volumes) FastRotation(Volumes) VolumeMesher OctreeMesher(ForInnerPartOfVolumes) 
        SphereMesher SymmetricalStructuredTetrahedra } {
        set findnode [$root find "variable" $variable_name]
        if { $findnode != "" } {
            #check if exists because removing other blocks with HideSurfaceFromPreferences some items won't exist
            CreateWidgetsFromXml::TakeOutVariable $root $variable_name
        }
    }  
    foreach name { } {
        set findnode [$root find "name" $name]
        if { $findnode != "" } {
            #check if exists because removing other blocks some items won't exist
            CreateWidgetsFromXml::TakeOutName $root $name
        }        
    }
}

proc HideVolumeFromFromMacrosToolbars { } {
    global macros_volume_hidden_in_toolbar
    if { [info exists macros_volume_hidden_in_toolbar] && [llength $macros_volume_hidden_in_toolbar] } {
        return 1
    }
    if { ![info exists ::toolbarmacros::macrospace::macrosdata] } {
        return 1
    } 
    upvar #0 toolbarmacros::macrospace::macrosdata macrosdata
    set names { "CreateLayersFromGeometryVolumes"}
    set macros_volume_hidden_in_toolbar [list]
    foreach name $names {
        if { [info exists macrosdata($name,InToolbar)] && $macrosdata($name,InToolbar) } {
            lappend macros_volume_hidden_in_toolbar $name
        }
    }
    toolbarmacros::Activate_deactivate_intoolbar no_intoolbar $macros_volume_hidden_in_toolbar 0
    return 0
}

proc RestoreVolumeFromMacrosToolbars { } {
    global macros_volume_hidden_in_toolbar
    if { [info exists macros_volume_hidden_in_toolbar] && [llength $macros_volume_hidden_in_toolbar] } {
        toolbarmacros::Activate_deactivate_intoolbar intoolbar $macros_volume_hidden_in_toolbar 0
        set macros_volume_hidden_in_toolbar [list]
    }
    return 0
}

proc HideQuadraticTypeLevelFromMenus { } {
    ### PRE    
    GiDMenu::RemoveOption Mesh [list "Quadratic type"] PRE
    ### POST    
    return 0
}

proc HideQuadraticTypeLevelFromPreferences { } {       
    set root [CreateWidgetsFromXml::GetPreferencesXml]
    if { $::GidPriv(HideQuadraticTypeLevel) == 7 } {
        #hide all 1==linear + 2==quadratic + 4==quadratic9
        foreach name { prepost_geometry quadratic_type } {
            set findnode [$root find "name" $name]
            if { $findnode != "" } {
                #check if exists because removing other blocks some items won't exist
                CreateWidgetsFromXml::TakeOutName $root $name
            }
        }        
    } else {
        foreach i {1 2 4} name {degree_linear degree_quadratic_serendipit degree_quadratic_lagrangian} {
            if { [expr {$::GidPriv(HideQuadraticTypeLevel) & $i}] } {
                set findnode [$root find "name" $name]
                if { $findnode != "" } {
                    #check if exists because removing other blocks some items won't exist
                    CreateWidgetsFromXml::TakeOutName $root $name
                }
            }
        }
        if { [expr {$::GidPriv(HideQuadraticTypeLevel) & 2}] && [expr {$::GidPriv(HideQuadraticTypeLevel) & 4}] } {
            #only linear case allowed, hide it
            foreach name { prepost_geometry } {
                set findnode [$root find "name" $name]
                if { $findnode != "" } {
                    #check if exists because removing other blocks some items won't exist
                    CreateWidgetsFromXml::TakeOutName $root $name
                }
            }
        }
    }
}


#invoked in SetAllMenusVariables to remove from menus all relative to volumes
proc HideBodyFittedFromMenus { } {
    ### PRE    
    GiDMenu::RemoveOption Mesh [list "Unstructured"] PRE   
    GiDMenu::RemoveOption Mesh [list "Structured"] PRE
    GiDMenu::RemoveOption Mesh [list "Semi-structured"] PRE
    GiDMenu::RemoveOption Mesh [list "Boundary layer"] PRE
    GiDMenu::RemoveOption Mesh [list "Quadratic type"] PRE
    GiDMenu::RemoveOption Mesh [list "Element type"] PRE
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Skip"] PRE
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "No skip"] PRE
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Automatic skip"] PRE
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Skip by..."] PRE
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Force points to"] PRE
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "Duplicate" "Surfaces"] PRE ;#is for surfaces embedded in volume
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" "No Duplicate" "Surfaces"] PRE ;#is for surfaces embedded in volume
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" ---3] PRE
    GiDMenu::RemoveOption Mesh [list "Mesh criteria" ---2] PRE
    GiDMenu::RemoveOption Mesh [list ---1] PRE
    GiDMenu::RemoveOption Mesh [list ---0] PRE
    
    GiDMenu::RemoveOption Mesh [list "Draw" "Num of divisions"] PRE
    GiDMenu::RemoveOption Mesh [list "Draw" "Element type"] PRE
    GiDMenu::RemoveOption Mesh [list "Draw" "Structured type"] PRE
    GiDMenu::RemoveOption Mesh [list "Draw" "Skip entities"] PRE
    GiDMenu::RemoveOption Mesh [list "Draw" "Duplicate"] PRE
    GiDMenu::RemoveOption Mesh [list "Draw" "Force points to"] PRE
    GiDMenu::RemoveOption Mesh [list "Draw" "Boundary layer"] PRE
    GiDMenu::RemoveOption Mesh [list "Draw" "Unstructured mesher"] PRE
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Move node"] PRE    
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Split elements"] PRE  
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Smooth elements"] PRE  
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Collapse" "Edges"] PRE  
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Collapse" "Elements"] PRE  
    GiDMenu::RemoveOption Mesh [list "Edit mesh" ---2] PRE  
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Nodes->grid quadrilaterals"] PRE
    GiDMenu::RemoveOption Mesh [list "Edit mesh" "Triangles->grid quadrilaterals"] PRE  
    
    ### POST
    foreach item { {"Covering mesh"} {"Create delaunay meshes"} } {
        GiDMenu::RemoveOption "Geometry" $item POST
    }
    return 0
}

proc HideBodyFittedFromPreferences { } {
    set root [CreateWidgetsFromXml::GetPreferencesXml]
    foreach variable_name { DrawQuadraticElements SphereDetailMode PointDetailMode \
        BoundaryWeightedTransition } {
        set findnode [$root find "variable" $variable_name]
        if { $findnode != "" } {
            #check if exists because removing other blocks some items won't exist
            CreateWidgetsFromXml::TakeOutVariable $root $variable_name
        }
    }      
    foreach name { postprocess_simplified structured_type chordal_error boundary_meshing \
        sphere_options quadratic_type others } {
        set findnode [$root find "name" $name]
        if { $findnode != "" } {
            #check if exists because removing other blocks some items won't exist
            CreateWidgetsFromXml::TakeOutName $root $name
        }
    }
}

proc HideEmbeddedFromMenus { } {
    ### PRE
    ### POST
    return 0
}

proc HideEmbeddedFromPreferences { } {
    set root [CreateWidgetsFromXml::GetPreferencesXml]
    foreach variable_name { EmbeddedMesh(GetOuterElements) } {
        set findnode [$root find "variable" $variable_name]
        if { $findnode != "" } {
            #check if exists because removing other blocks some items won't exist
            CreateWidgetsFromXml::TakeOutVariable $root $variable_name
        }
    }
    foreach name { } {
        set findnode [$root find "name" $name]
        if { $findnode != "" } {
            #check if exists because removing other blocks some items won't exist
            CreateWidgetsFromXml::TakeOutName $root $name
        }
    }
}

proc HideCartesianFromMenus { } {
    ### PRE    
    GiDMenu::RemoveOption Mesh [list "Assign cartesian size"] PRE
    ### POST    
    return 0
}

proc HideCartesianFromPreferences { } {
    set root [CreateWidgetsFromXml::GetPreferencesXml]
    foreach variable_name { } {
        set findnode [$root find "variable" $variable_name]
        if { $findnode != "" } {
            #check if exists because removing other blocks some items won't exist
            CreateWidgetsFromXml::TakeOutVariable $root $variable_name
        }
    }      
    foreach name { cartesian_meshing } {
        set findnode [$root find "name" $name]
        if { $findnode != "" } {
            #check if exists because removing other blocks some items won't exist
            CreateWidgetsFromXml::TakeOutName $root $name
        }
    }
}

#really do not modify only menus, SetAllMenusVariables modify also preferences window
proc UpdateMenus {} {
    SetAllMenusVariables
    GiDMenu::UpdateMenus
}

proc UpdateMenusAndToolbars {} {
    UpdateMenus   
    UpdateToolbarGeometryAndView
    ViewResultsBarBitmaps
}

trace add variable ::GidPriv(HideVolumeLevel) write "UpdateMenusAndToolbars ;#" ;#to update menus and toolbars and preferences
trace add variable ::GidPriv(HideSurfaceLevel) write "UpdateMenusAndToolbars ;#" ;#to update menus and toolbars and preferences
trace add variable ::GidPriv(HideQuadraticTypeLevel) write "UpdateMenusAndToolbars ;#" ;#to update menus and toolbars and preferences
trace add variable ::GidPriv(PostSpaceDimension) write "UpdateMenus ;#" ;#to update menus
trace add variable ::GidPriv(ShowGroupsTab) write "Layers::UpdateGroupsTab ;#" ;#to show/hide the groups tab if layers window was open
trace add variable ::GidPriv(AllowHideMeshOptions) write "UpdateMenus ;#" ;#to update menus
trace add variable ::GidPriv(HideUndo) write "UpdateMenus ;#" ;#to update menus
