
namespace eval ContextualEntity {
    variable selectedentity
    variable selectactive
    variable LastLabel ""
    variable UserDataCommand ""
}

proc ContextualEntity::RegisterUserDataCommand { command } {
    variable UserDataCommand
    set UserDataCommand $command
}

proc ContextualEntity::UnRegisterUserDataCommand {} {
    variable UserDataCommand
    set UserDataCommand ""
}

proc ContextualEntity::Activate { w x y } {
    if { [catch {
        ActivateDo $w $x $y
    }] } {
        WarnWinText $::errorInfo
    }
}

proc ContextualEntity::ActivateDo { togl x y } {
    variable selectedentity
    variable selectactive

    # if togl is .gid.central.s it crashes on Ubuntu
    #set togl ""

    set whatuse [GiD_Info Project ViewMode]
    if { $whatuse == "POSTUSE" } {
        set type Elements
    } else {
        set type AllTypes
    }
    set niceword(Points) [_ "Point"]
    set niceword(Lines) [_ "Line"]
    set niceword(Surfaces) [_ "Surface"]
    set niceword(Volumes) [_ "Volume"]
    set niceword(Nodes) [_ "Node"]
    set niceword(Elements) [_ "Element"]

    set entities [GidUtils::Pick $togl $type multiple $x $y]
    set boxed 0
    if { [llength $entities] < 2 } {
        #open a selection box with corner in x y and set second corner releasing button and then finish selection
        GiD_Process 'SelectEntities $type
        $togl button 1 $x $y
        set save_bind [bind $togl <ButtonRelease-1>]
        bind $togl <ButtonRelease-1> "$save_bind ; GiD_Process escape"
        vwait ::GidPriv(selection)
        bind $togl <ButtonRelease-1> $save_bind
        if { $type == "AllTypes" } {
            set entities [lrange [lindex $::GidPriv(selection) 0] 1 end]
        } else {
            set entities [lindex $::GidPriv(selection) 0]
        }
        unset ::GidPriv(selection)
        set boxed 1
    }
    if { [llength $entities] < 2 } {        
        return
    }
    set numentities 0
    foreach i $entities {
        if { [string is integer -strict $i] } {
            incr numentities
        } elseif { [scan $i %d:%d n1 n2] == 2 } {
            incr numentities [expr {$n2-$n1+1}]
        }
    }
    if { $numentities > 1 && $numentities < 15 && !$boxed } {
        set selectedentity -1
        set selectactive 0
        catch { destroy $togl.contextualentity }
        set menu [menu $togl.contextualentity]
        set current_type ""
        foreach i $entities {
            if { [string is integer -strict $i] } {
                $menu add command -label [concat $niceword($current_type) $i] -command [list set ContextualEntity::selectedentity [list $current_type $i]]
            } elseif { [scan $i %d:%d n1 n2] == 2 } {
                for { set j $n1 } { $j <= $n2 } { incr j } {
                    $menu add command -label [concat $niceword($current_type) $j] -command [list set ContextualEntity::selectedentity [list $current_type $j]]
                }
            } else { 
                set current_type $i
            }
        }
        $menu add separator
        $menu add command -label [_ "All selected entities"] -command [list set ContextualEntity::selectedentity AllTypes]

        bind $menu <<MenuSelect>> "ContextualEntity::SelectingInMenu $menu"
        tk_popup $menu [winfo pointerx .gid]  [winfo pointery .gid]
        if { $::tcl_platform(platform) != "windows" } {
            bind $menu <Unmap> "set ::pp done"
            vwait ::pp
        }

        if { $selectactive } {
             GiD_Process escape
        }
        update
        if { $selectedentity == -1 } {
            return
        }
        if { $selectedentity != "AllTypes" } {
            set numentities 1
            set entities "$selectedentity"
        }
    }

    set menu [CreateFinalMenu $togl $whatuse $numentities $entities]

    GidUtils::Disable warnline
    GiD_Process 'SelectEntities AllTypes {*}$entities
    set selectactive 1
    GidUtils::Enable warnline
    append text [_ "Selected %s %s. Choose operation" $niceword([lindex $entities 0]) [lindex $entities 1]]

    GidUtils::SetWarnLine $text
    PostFinalMenu $menu
}


proc ContextualEntity::SelectingInMenu { menu } {
    variable selectactive

    set comm [$menu entrycget active -command]
    set type ""
    foreach {type entity} [lindex $comm 2] break
    if { $type == "" } { return }

    if { $selectactive } {
        GiD_Process escape
    }
    GiD_Process 'SelectEntities $type $entity
    set selectactive 1
}

proc ContextualEntity::AddToMenu { menu label command } {
    variable LastLabel
    variable LastIndex
    variable mainmenu

    append command "; [list set ContextualEntity::LastLabel $label]"
    append command "; GiD_Process escape"
    $menu add command -label $label -command $command
    if { $menu == $mainmenu && $label == $LastLabel } {
        set LastIndex [$menu index end]
    }
}

proc ContextualEntity::CreateFinalMenu { w whatuse numentities entities } {
    variable LastIndex
    variable mainmenu
    variable UserDataCommand

    set LastIndex 0

    catch { destroy $w.contextualentity }
    set menu [menu $w.contextualentity]
    set mainmenu $menu

    if { $whatuse == "GEOMETRYUSE" } {
        $menu add checkbutton -label [_ "Copy"] -variable ContextualEntity::CopyMoveIsCopy -command [list ContextualEntity::PostFinalMenu $menu]    
        $menu add separator
        AddToMenu $menu [_ "Move#C#geometry"] [list ContextualEntity::CopyMove $entities translation]
        $menu add cascade -label [_ "More"]... -menu $menu.m1
        menu $menu.m1
        $menu.m1 add command -label [_ "Align"] -command [list ContextualEntity::CopyMove $entities align]
        $menu.m1 add command -label [_ "Rotate"] -command [list ContextualEntity::CopyMove $entities rotation]
        $menu.m1 add checkbutton -label [_ "Do extrude"] -variable ContextualEntity::DoExtrude -command [list ContextualEntity::PostFinalMenu $menu]        
        $menu add separator
    }

    if { $whatuse != "POSTUSE" && $numentities == 1 } {
        if { $UserDataCommand == "" } {
            eval AddDataItemsToMenu $menu $whatuse $entities
        } else {
            uplevel #0 $UserDataCommand $menu $whatuse $entities
        }
    }

    if { $whatuse != "POSTUSE" } {
        set layer [_ "layer"]
        set layers [_ "layers"]
        set backcmd ContextualEntity::SendToBackPre
        set layerscmd ContextualEntity::LayersPre
    } else {
        set layer [_ "set"]
        set layers [_ "sets"]
        set backcmd ContextualEntity::SendToBackPost
        set layerscmd ContextualEntity::LayersPost
    }

    AddToMenu $menu [_ "List entity"] [list ContextualEntity::ListEntities $entities]

    $menu add separator

    AddToMenu $menu [_ "Send to back"] [list $backcmd $entities this]
    AddToMenu $menu [_ "Send others to back"] [list $backcmd $entities other]
    AddToMenu $menu [_ "Bring %s to front" $layer] [list $backcmd $entities thistofront]
    AddToMenu $menu [_ "Bring all to front"] [list $backcmd $entities front]

    $menu add separator

    AddToMenu $menu [_ "Other %s off" $layers] [list $layerscmd $entities otheroff]
    AddToMenu $menu [_ "This %s off" $layer] [list $layerscmd $entities thisoff]
    AddToMenu $menu [_ "All %s on" $layers] [list $layerscmd $entities allon]
    AddToMenu $menu [_ "Change 'layer to use'" $layers] [list $layerscmd $entities touse]
    return $menu
}

proc ContextualEntity::PostFinalMenu { menu } {
    variable LastIndex

    tk_popup $menu [winfo pointerx .gid] [winfo pointery .gid] $LastIndex
    if { $::tcl_platform(platform) != "windows" } {
        bind $menu <Unmap> "set ::pp done"
        vwait ::pp
    }
    GiD_Process escape
}

proc ContextualEntity::CreateSubmenu { menu } {
    set j 1
    while { [winfo exists $menu.m$j] } { 
        incr j 
    }
    set submenu [menu $menu.m$j]
    return $submenu
}

proc ContextualEntity::OpenGroups { group_name } {
    if { $::GidPriv(ShowGroupsTab) } {
        set ::GidPriv(LayersOrGroupsCurrentTab) 1
        GidUtils::OpenWindow LAYER
    } else {
        GidUtils::OpenWindow GROUPS     
    }
    Groups::SelectGroup $group_name    
}

proc ContextualEntity::OpenLocalAxes { } {
    package require customLib
    gid_groups_conds::local_axes_window
}

proc ContextualEntity::OpenConditions { book } {
    if { [GroupsXmlDocExists] } {
        #show the customLib tree
        gid_groups_conds::open_conditions menu
    } else {
        GidOpenConditions $book
    }
}

proc ContextualEntity::ConditionIsLocalAxis { condition_name } {
    if { [string range $condition_name end-10 end] == "_Local_axes" } {
        set is_local_axis 1
    } else {
        set is_local_axis 0
    }
    return $is_local_axis
}

proc ContextualEntity::ConditionIsGroup { condition_name } {
    if { [string range $condition_name end-6 end] == "_groups" } {
        set is_group 1
    } else {
        set is_group 0
    }
    return $is_group
}


proc ContextualEntity::AddDataItemsToMenu { menu whatuse type entity } {
    
    set entity_groups [GiD_EntitiesGroups entity_groups [string tolower $type] $entity]
    if { [llength $entity_groups] } {
        set text [_ "Groups"]
        set submenu [ContextualEntity::CreateSubmenu $menu]
        $menu add cascade -label $text -menu $submenu
        foreach group_name $entity_groups {
            AddToMenu $submenu $group_name [list ContextualEntity::OpenGroups $group_name]
        }
    }
    
    switch $type Points { set ov over_point } Lines { set ov over_line } Surfaces { set ov over_surface } \
        Volumes { set ov over_volume } Nodes { set ov over_point } Elements { set ov [list over_line over_surface over_volume] }

    switch $type Points - Lines - Surfaces - Volumes { set where geometry } Nodes - \
        Elements { set where mesh }

    set books ""
    foreach "book -" [GiD_Info Conditions BOOKS] {
        lappend books $book
    }
    array unset conds
    foreach ovi $ov {
        foreach cnd [GiD_Info Conditions $ovi] {
            set book [GiD_Info Conditions $cnd BOOK]
            lappend conds($book) $cnd
            if { [lsearch $books $book] == -1 } {
                lappend books $book
            }
        }
    }

    set NotUsedBooks ""
    set needsseparator 0
    foreach book $books {
        if { ![info exists conds($book)] } { 
            continue
        }
        set submenu ""
        set some_conds_is_local_axis 0
        set all_conds_are_local_axes 1
        foreach cnd $conds($book) {
            if { [ContextualEntity::ConditionIsLocalAxis $cnd] } {
                set some_conds_is_local_axis 1
            } else {
                set all_conds_are_local_axes 0
            }
            if { $::CUSTOM_LIB_USE_NATIVE_GROUPS && [ContextualEntity::ConditionIsGroup $cnd] } {
                #ignore it here like it was not defined in the .cnd
                continue
            }
            set vals [lindex [GiD_Info Conditions $cnd $where $entity] 0]
            if { ![llength $vals] || ([lindex $vals 0] == 0 && [lindex $vals 1] == "-") } { 
                continue 
            }
            if { $submenu == "" } {
                set submenu [ContextualEntity::CreateSubmenu $menu]
                set text $book
                if { $text == "Default" } { 
                    set text [_ "Conditions"]
                }
                $menu add cascade -label $text -menu $submenu
                set needsseparator 1
            }
            set text "$cnd -> [lrange $vals 3 end]"
            if { [string length $text] > 50 } {
                set text "[string range $text 0 45] ..."
            }
            if { $whatuse == "POSTUSE" } {
                set command [list ContextualEntity::ErrorDataPost] 
            } else { 
                set command [list ContextualEntity::ViewCondition $book $cnd $vals]           
            }
            AddToMenu $submenu $text $command
        }
        if { $submenu == "" } {
            lappend NotUsedBooks $book
        } elseif { $whatuse != "POSTUSE" } {
            $submenu add separator            
            if { $some_conds_is_local_axis } {
                AddToMenu $submenu [_ "Open local axes"]... ContextualEntity::OpenLocalAxes
            }
            if { !$all_conds_are_local_axes } {               
                AddToMenu $submenu [_ "Open"]... [list GidOpenConditions $book]
            }
        }
    }
    if { [llength $NotUsedBooks] > 0 && $whatuse != "POSTUSE" } {
        set submenu [ContextualEntity::CreateSubmenu $menu]
        $menu add cascade -label [_ "Conditions"] -menu $submenu                
        set needsseparator 1
        if { $some_conds_is_local_axis } {
            AddToMenu $submenu [_ "Open local axes"]... ContextualEntity::OpenLocalAxes
        }
        if { !$all_conds_are_local_axes } {         
            foreach book $NotUsedBooks {
                set text $book
                if { $text == "Default" } { 
                    set text "" 
                }            
                AddToMenu $submenu [_ "Open %s" $text]... [list GidOpenConditions $book]
            }
        }
    }
    if { $needsseparator } {
        $menu add separator
    }

    set needsseparator 0
    set books ""
    foreach "book -" [GiD_Info Materials BOOKS] {
        lappend books $book
    }
    set mats [GiD_Info Materials]
    if { $mats != "" } {
        if { $books == "" } {
            set books Materials
        }
        set list_ent [GiD_Info list_entities $type $entity]
        regexp {material:\s+([0-9]+)} $list_ent {} mat_num
        if { $mat_num != 0 } {
            set matname [lindex $mats [expr $mat_num-1]]
            set entbook [GiD_Info Materials $matname BOOK]
            if { $entbook == "Default" } {
                set entbook Materials 
            }
        } else { 
            set entbook ""
        }

        foreach i $books {
            if { $i != $entbook && $whatuse == "POSTUSE" } {
                continue
            }
            set submenu [ContextualEntity::CreateSubmenu $menu]
            $menu add cascade -label $i -menu $submenu
            set needsseparator 1
            if { $i == $entbook } {
                if { $whatuse != "POSTUSE" } {
                    set command [list ContextualEntity::ViewMaterial $i $matname]
                } else { 
                    set command [list ContextualEntity::ErrorDataPost]
                }
                AddToMenu $submenu $matname $command
            }
            set book $i
            if { $i == "Materials" } { 
                set book Default 
            }
            if { $whatuse != "POSTUSE" } {
                AddToMenu $submenu "Open..." [list GidOpenMaterials $book]
            }
        }
    }
    if { $needsseparator } {
        $menu add separator
    }
}

proc ContextualEntity::ErrorDataPost {} {
    WarnWin [_ "This function is only usable in the preprocessing part"]
}

proc ContextualEntity::ViewMaterial { book mat } {

    if { $book == "Materials" } { set book Default }
    set GDN [GidOpenMaterials $book]
    global $GDN
    upvar \#0 $GDN GidData
    set _mat $mat
    set _mat [DWUnder2Space $_mat]
    set GidData(MAT,matname) $_mat
}
proc ContextualEntity::ViewCondition { book cnd vals } {

    set ov [lindex [GiD_Info Conditions $cnd] 0]

    set GDN [GidOpenConditions $book]

    global $GDN
    upvar \#0 $GDN GidData

    array set PatternNames {
        over_point  POINT
        over_line LINE
        over_surface SURFACE
        over_volume  VOLUME
        over_layer LAYER
        over_group GROUP
        ovpnt  POINT
        ovline LINE
        ovsurf SURFACE
        ovvol  VOLUME
        ovlayer LAYER
        ovgroup GROUP
    }
    set _cnd $cnd
    regexp -nocase ^$PatternNames($ov)_(.+) $_cnd {} _cnd
    set _cnd [DWUnder2Space $_cnd]
#     set GidData(CND,level) $ov
#     set GidData(CND,condname) $_cnd
    DWUpdateConds $GDN $vals $ov $cnd
}

proc ContextualEntity::LayersPre { entities what } {
    GidUtils::Disable graphics

    if { $what == "otheroff" || $what == "thisoff" } {
        set layerslist ""
        foreach j $entities {
            switch [scan $j %d:%d n1 n2] {
                0 {
                    set type $j
                    continue
                }
                1 { set n2 $n1 }
            }
            for { set k $n1 } { $k <= $n2 } { incr k } {
                set list_ent [GiD_Info list_entities $type $k]
                if { [regexp {LAYER:\s+(\S+)} $list_ent {} layer] } {
                    if { [lsearch $layerslist $layer] == -1 } {
                        lappend layerslist $layer
                    }
                }
            }
        }
        GiD_Process 'Layers
        foreach i [GiD_Layers list] {
            set ipos [lsearch $layerslist $i]
            if { $ipos == -1 && $what == "otheroff" } {
                GiD_Process Off $i
            } elseif { $ipos != -1 && $what == "thisoff" } {
                GiD_Process Off $i
            }
        }
        GiD_Process escape
    } elseif { $what == "allon" } {
        foreach i [GiD_Layers list] {
            GiD_Process 'Layers On $i
        }
        GiD_Process escape
    } elseif { $what == "touse" } {
        set found 0
        foreach j $entities {
            switch [scan $j %d:%d n1 n2] {
                0 {
                    set type $j
                    continue
                }
                1 { set n2 $n1 }
            }
            for { set k $n1 } { $k <= $n2 } { incr k } {
                set list_ent [GiD_Info list_entities $type $k]
                if { [regexp {LAYER:\s+([^\n]+)} $list_ent {} layer] } {
                    set found 1
                    break
                }
            }
            if { $found } { break }
        }
        GiD_Process 'Layers Touse $layer escape
    }
    GidUtils::Enable graphics
    GiD_Redraw
    Layers::FillInfo
}

proc ContextualEntity::LayersPost { entities what } {

    if { $what == "otheroff" || $what == "thisoff" } {
        set setslist ""
        foreach j $entities {
            switch [scan $j %d:%d n1 n2] {
                0 {
                    set type $j
                    continue
                }
                1 { set n2 $n1 }
            }
            for { set k $n1 } { $k <= $n2 } { incr k } {
                set ent_set [lindex [GiD_Info list_entities Elements $k] 5]
                if { [lsearch $setslist $ent_set] == -1 } {
                    lappend setslist ent_set
                }
            }
        }

        foreach j {volumesets surfacesets cutsets} {
            GiD_Process escape escape escape escape select $j
            set currents [GiD_Info postprocess get cur_$j]
            foreach i [GiD_Info postprocess get all_$j] {
                if {  $what == "otheroff" && [lsearch $currents $i] != -1 &&
                      [lsearch $setslist $i] == -1 } {
                    GiD_Process $i
                } elseif {  $what == "thisoff" && [lsearch $currents $i] != -1 &&
                            [lsearch $setslist $i] != -1 } {
                    GiD_Process $i
                }
            }
            GiD_Process escape
        }
    } else {
        foreach j {volumesets surfacesets cutsets} {
            GiD_Process escape escape escape escape select $j
            set currents [GiD_Info postprocess get cur_$j]
            foreach i [GiD_Info postprocess get all_$j] {
                if { [lsearch $currents $i] == -1 } {
                    GiD_Process $i
                }
            }
            GiD_Process escape
        }
    }
}

proc ContextualEntity::SendToBackPre { entities what } {
    if { $what == "this" || $what == "other" } {
        set command 'Layers
        if { $what == "this" } {
            lappend command SendToBack
        } elseif { $what == "other" } {
            lappend command SendToBackOpposite
        }
        if { [GiD_Set LayersAlsoLower] } {
            lappend command LowerEntities
        }
        if { [GiD_Set LayersAlsoHigher] } {
            lappend command HigherEntities
        }
        lappend command All {*}$entities escape
        GiD_Process {*}$command
    } elseif { $what == "thistofront" } {
        set layerslist ""
        foreach j $entities {
            switch [scan $j %d:%d n1 n2] {
                0 {
                    set type $j
                    continue
                }
                1 { set n2 $n1 }
            }
            for { set k $n1 } { $k <= $n2 } { incr k } {
                set list_ent [GiD_Info list_entities $type $k]
                if { [regexp {LAYER:\s+(\S+)} $list_ent {} layer] } {
                    if { [lsearch $layerslist $layer] == -1 } {
                        lappend layerslist $layer
                    }
                }
            }
        }        
        foreach i $layerslist {
            GiD_Process 'Layers BringToFront $i
        }
        GiD_Process escape
    } else {
        GiD_Process 'Layers BringToFrontAll escape
    }
    Layers::FillInfo
}

proc ContextualEntity::SendToBackPost { entities what } {

    if { $what == "other" } {
        set DisableWarnLine [GiD_Project set disable_warnline]
        GiD_Project set disable_warnline 1
        set DisableGraphics [GiD_Project set disable_graphics]
        GiD_Project set disable_graphics 1

        GiD_Process escape escape escape escape Select Elements
        GiD_Process 1:
        GiD_Process SwapSelection
        GiD_Process {*}[lrange $entities 1 end]
        GiD_Process escape MoveToNewSet ***** escape escape escape
        
        after 0 PDSendToBackEnd2 $DisableWarnLine $DisableGraphics

    } elseif { $what == "this" } {
        set DisableWarnLine [GiD_Project set disable_warnline]
        GiD_Project set disable_warnline 1
        set DisableGraphics [GiD_Project set disable_graphics]
        GiD_Project set disable_graphics 1
        GiD_Process escape escape escape escape Select Elements
        GiD_Process {*}[lrange $entities 1 end]
        GiD_Process escape MoveToNewSet ***** escape escape escape
        
        after 0 PDSendToBackEnd2 $DisableWarnLine $DisableGraphics

    } elseif { $what == "thistofront" } {
        set setslist ""
        foreach j $entities {
            switch [scan $j %d:%d n1 n2] {
                0 {
                    set type $j
                    continue
                }
                1 { set n2 $n1 }
            }
            for { set k $n1 } { $k <= $n2 } { incr k } {
                set ent_set [lindex [GiD_Info list_entities Elements $entity] 5]
                if { [lsearch $setslist $ent_set] == -1 } {
                    lappend setslist ent_set
                }
            }
        }
        PdSendToFront $setslist
    } else {
        PdSendToFront
    }
}

proc ContextualEntity::CopyMove { entities movement } {
    variable CopyMoveIsCopy
    variable DoExtrude

    switch $movement {
        translation {
            set lst [list [_ "Pick first point"] [_ "Pick second point"]]
        }
        align {
            set lst [list [_ "Pick first source point"] [_ "Pick first destination point"] \
                         [_ "Pick second source point"] [_ "Pick second destination point"] \
                         [_ "Pick third source point"] [_ "Pick third destination point"]]
        }
        rotation {
            set lst [list [_ "Pick vertex point"] [_ "Pick first point"] [_ "Pick second point"]]
        }
    }
    set inum 1
    foreach i $lst {
        set p($inum) [::GidUtils::GetCoordinates $i NoJoin]
        if { $p($inum) == "" } {
            GiD_Process Mescape
            return
        }
        incr inum
    }

    if { $movement == "rotation" } {
        set v1 [MathUtils::VectorDiff $p(2) $p(1)]
        set modul1 [MathUtils::VectorModulus $v1]
        if { $modul1<$MathUtils::EPSILON } return ""
        
        set v2 [MathUtils::VectorDiff $p(3) $p(1)]
        set modul2 [MathUtils::VectorModulus $v2]
        if { $modul2<$MathUtils::EPSILON } return ""
        
        set cosangle [expr [MathUtils::VectorDotProd $v1 $v2]/($modul1*$modul2)]
        set angle [expr $MathUtils::DEGREE_TO_RAD*acos($cosangle)]
        if { abs($angle) < $MathUtils::EPSILON } return ""
        set axe [MathUtils::VectorVectorialProd $v1 $v2]
        set axe1 $p(1)
        set axe2 [MathUtils::VectorSum $p(1) $axe]
        array unset p
        foreach "p(1) p(2) p(3)" [list $axe1 $axe2 $angle] break
    }

    foreach i [list Points Lines Surfaces Volumes] {
        set validentities($i) ""
    }
    set type ""
    foreach i $entities {
        if { [scan $i %d:%d n1 n2] >= 1 } {
            lappend validentities($type) $i
        } elseif { $type == "" } {
            set type $i
        } else { set type AllTypes }
    }
    foreach i [list Volumes Surfaces Lines Points] {
        if { [llength $validentities($i)] } {
            set type $i
            break
        }
    }
    switch $CopyMoveIsCopy {
        1 { set what Copy }
        0 { set what Move }
    }

    set comm [list Mescape Utilities $what AllTypes]
    if { $DoExtrude && $what eq "Copy" } {
        lappend comm DoExtrude Volumes
    }
    lappend comm $movement
    foreach i [lsort -integer [array names p]] {
        if { [llength $p($i)] > 1 } {
            lappend comm FNoJoin [join $p($i) ,]
        } else { lappend comm $p($i) }
    }
    after idle GiD_Process {*}$comm {*}$entities escape
}

proc ContextualEntity::ListEntities { entities } {  
    #without after idle will reenter multiple times in this procedure !!
    after idle [list ListEntities $entities]   
}
